<?php
session_start();
 ini_set('display_errors', 1);
error_reporting(E_ALL);

// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// เชื่อมต่อฐานข้อมูล
require_once 'includes/db_con.php';

// ข้อมูลผู้ใช้
$username = isset($_SESSION['username']) ? $_SESSION['username'] : 'ผู้ใช้';

// จัดการการส่งฟอร์ม
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // การลบข้อมูล
    if (isset($_POST['action']) && $_POST['action'] == 'delete') {
        $id = intval($_POST['id']);
        
        if (empty($id)) {
            echo json_encode(['success' => false, 'message' => 'ລະຫັດລາຍລະອຽດບໍ່ຖືກຕ້ອງ']);
            exit();
        }
        
        try {
            // ตรวจสอบว่ามีการใช้งานใน orders หรือ products หรือไม่
            $check_orders = $conn->prepare("SELECT COUNT(*) as count FROM orders WHERE detail_product_id = (SELECT detail_product_id FROM detail_product WHERE id = ?)");
            $check_orders->bind_param("i", $id);
            $check_orders->execute();
            $result_orders = $check_orders->get_result()->fetch_assoc();

            $check_products = $conn->prepare("SELECT COUNT(*) as count FROM products WHERE detail_product_id = (SELECT detail_product_id FROM detail_product WHERE id = ?)");
            $check_products->bind_param("i", $id);
            $check_products->execute();
            $result_products = $check_products->get_result()->fetch_assoc();
            
            if ($result_orders['count'] > 0 || $result_products['count'] > 0) {
                echo json_encode(['success' => false, 'message' => 'ບໍ່ສາມາດລຶບລາຍລະອຽດນີ້ໄດ້ ເພາະມີການນຳໃຊ້ໃນລະບົບ']);
                exit();
            }
            
            // ลบข้อมูล
            $delete_stmt = $conn->prepare("DELETE FROM detail_product WHERE id = ?");
            $delete_stmt->bind_param("i", $id);
            
            if ($delete_stmt->execute()) {
                echo json_encode(['success' => true, 'message' => 'ລຶບລາຍລະອຽດສຳເລັດແລ້ວ']);
            } else {
                echo json_encode(['success' => false, 'message' => 'ເກີດຂໍ້ຜິດພາດໃນການລຶບ']);
            }
            $delete_stmt->close();
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage()]);
        }
        exit();
    }
    
    // การแก้ไขข้อมูล
    if (isset($_POST['action']) && $_POST['action'] == 'edit') {
        $id = intval($_POST['id']);
        $detail_text = trim($_POST['detail_text']);
        
        if (empty($id) || empty($detail_text)) {
            $message = 'ກະລຸນາໃສ່ຂໍ້ມູນໃຫ້ຄົບຖ້ວນ';
            $message_type = 'error';
        } else {
            try {
                // ตรวจสอบชื่อซ้ำ (ยกเว้น ID ปัจจุบัน)
                $check_stmt = $conn->prepare("SELECT id FROM detail_product WHERE detail_text = ? AND id != ?");
                $check_stmt->bind_param("si", $detail_text, $id);
                $check_stmt->execute();
                
                if ($check_stmt->get_result()->num_rows > 0) {
                    $message = 'ມີລາຍລະອຽດນີ້ໃນລະບົບແລ້ວ';
                    $message_type = 'error';
                } else {
                    // อัปเดตข้อมูล
                    $update_stmt = $conn->prepare("UPDATE detail_product SET detail_text = ? WHERE id = ?");
                    $update_stmt->bind_param("si", $detail_text, $id);
                    
                    if ($update_stmt->execute()) {
                        $message = 'ແກ້ໄຂລາຍລະອຽດສຳເລັດແລ້ວ';
                        $message_type = 'success';
                    } else {
                        $message = 'ເກີດຂໍ້ຜິດພາດໃນການແກ້ໄຂ';
                        $message_type = 'error';
                    }
                    $update_stmt->close();
                }
                $check_stmt->close();
            } catch (Exception $e) {
                $message = 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage();
                $message_type = 'error';
            }
        }
    }
    // การเพิ่มข้อมูลใหม่
    else {
        $detail_text = trim($_POST['detail_text']);
        
        if (empty($detail_text)) {
            $message = 'ກະລຸນາໃສ່ເນື້ອຫາລາຍລະອຽດ';
            $message_type = 'error';
        } else {
            try {
                // ตรวจสอบว่ามี detail นี้แล้วหรือไม่
                $check_stmt = $conn->prepare("SELECT id FROM detail_product WHERE detail_text = ?");
                $check_stmt->bind_param("s", $detail_text);
                $check_stmt->execute();
                
                if ($check_stmt->get_result()->num_rows > 0) {
                    $message = 'ມີລາຍລະອຽດນີ້ໃນລະບົບແລ້ວ';
                    $message_type = 'error';
                } else {
                    // เพิ่ม detail ใหม่ (detail_product_id จะถูก auto-generate โดย trigger)
                    $insert_stmt = $conn->prepare("INSERT INTO detail_product (detail_text) VALUES (?)");
                    $insert_stmt->bind_param("s", $detail_text);
                    
                    if ($insert_stmt->execute()) {
                        $message = 'ເພີ່ມລາຍລະອຽດສຳເລັດແລ້ວ';
                        $message_type = 'success';
                        
                        // ล้างข้อมูลในฟอร์ม
                        $_POST = [];
                    } else {
                        $message = 'ເກີດຂໍ້ຜິດພາດໃນການເພີ່ມລາຍລະອຽດ';
                        $message_type = 'error';
                    }
                    $insert_stmt->close();
                }
                $check_stmt->close();
            } catch (Exception $e) {
                $message = 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage();
                $message_type = 'error';
            }
        }
    }
}

// ดึงข้อมูล detail_product ทั้งหมด
$detail_query = "SELECT * FROM detail_product ORDER BY detail_text";
$detail_result = $conn->query($detail_query);

// นับจำนวนการใช้งานใน orders และ products
$usage_count_query = "
    SELECT r.detail_product_id, 
           (SELECT COUNT(*) FROM orders o WHERE o.detail_product_id = r.detail_product_id) + 
           (SELECT COUNT(*) FROM products p WHERE p.detail_product_id = r.detail_product_id) as usage_count
    FROM detail_product r
";
$usage_count_result = $conn->query($usage_count_query);
$usage_data = [];
if ($usage_count_result->num_rows > 0) {
    while ($row = $usage_count_result->fetch_assoc()) {
        $usage_data[$row['detail_product_id']] = $row['usage_count'];
    }
}
?>

<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sokxay Bill - ເພີ່ມລາຍລະອຽດສິນຄ້າ</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="/sokxay/wayha.png">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/forms.css">
    
    <style>
        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            overflow: auto;
        }
        
        .modal-content {
            background-color: #fff;
            margin: 5% auto;
            padding: 0;
            border-radius: 8px;
            width: 90%;
            max-width: 600px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
            animation: modalSlideIn 0.3s ease;
        }
        
        @keyframes modalSlideIn {
            from { opacity: 0; transform: translateY(-50px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .modal-header {
            background: var(--primary-color);
            color: white;
            padding: 20px;
            border-radius: 8px 8px 0 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .modal-header h2 {
            margin: 0;
            font-size: 20px;
        }
        
        .close {
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            opacity: 0.7;
            transition: opacity 0.3s;
        }
        
        .close:hover {
            opacity: 1;
        }
        
        .modal-body {
            padding: 20px;
        }
        
        .modal-footer {
            background: #f8f9fa;
            padding: 15px 20px;
            border-radius: 0 0 8px 8px;
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }
        
        .type-code {
            background: #e3f2fd;
            color: #1976d2;
            padding: 4px 8px;
            border-radius: 4px;
            font-family: monospace;
            font-weight: 600;
        }
        
        .type-info {
            display: flex;
            flex-direction: column;
        }
        
        .type-name {
            font-weight: 600;
            color: var(--text-color);
        }
        
        .product-count {
            color: #6c757d;
            font-size: 14px;
        }
        
        .product-count i {
            margin-right: 5px;
            color: #28a745;
        }
        
        .btn-action:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        
        .full-width {
            flex: 1 1 100%;
        }
        
        /* Button States Fix */
        .btn-primary:active,
        .btn-primary:focus,
        .btn-primary.active {
            background: var(--primary-color) !important;
            color: white !important;
            border-color: var(--primary-color) !important;
            box-shadow: 0 0 0 3px rgba(13, 110, 253, 0.25) !important;
        }
        
        .btn-secondary:active,
        .btn-secondary:focus,
        .btn-secondary.active {
            background: #6c757d !important;
            color: white !important;
            border-color: #6c757d !important;
            box-shadow: 0 0 0 3px rgba(108, 117, 125, 0.25) !important;
        }
        
        button:focus {
            outline: none !important;
        }

        /* Search Styles */
        .search-container {
            position: relative;
            display: inline-block;
            margin-right: 10px;
        }

        .search-container input {
            padding: 8px 12px 8px 35px;
            border: 1px solid #ddd;
            border-radius: 4px;
            width: 250px;
        }

        .search-container i {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            color: #999;
        }
    </style>
</head>
<body>
    <div class="app-container">
        <?php include 'includes/sidebar.php'; ?>

        <!-- Main Content Area -->
        <main class="main-content">
            <!-- Header -->
            <header class="content-header">
                <div class="header-left">
                    <h1 class="page-title">ລາຍລະອຽດສິນຄ້າ</h1>
                    <p class="page-subtitle">ຈັດການລາຍລະອຽດສິນຄ້າໃນລະບົບ</p>
                </div>
                
                <div class="header-right">
                    <div class="search-container">
                        <i class="fas fa-search"></i>
                        <input type="text" id="searchInput" placeholder="ຄົ້ນຫາລາຍລະອຽດສິນຄ້າ...">
                    </div>
                    <button class="btn-primary" onclick="openAddModal()">
                        <i class="fas fa-plus"></i>
                        ເພີ່ມລາຍລະອຽດ
                    </button>
                </div>
            </header>

            <!-- Content Body -->
            <div class="content-body">
                <div class="list-container">
                    <!-- Detail Product List -->
                    <div class="list-card">
                        <div class="list-header">
                            <h3><i class="fas fa-list"></i> ລາຍການລາຍລະອຽດສິນຄ້າ</h3>
                        </div>
                        
                        <div class="table-container">
                            <?php if ($detail_result->num_rows > 0): ?>
                                <table class="data-table">
                                    <thead>
                                        <tr>
                                            <th>ລະຫັດ</th>
                                            <th>ເນື້ອຫາລາຍລະອຽດ</th>
                                            <th>ການນຳໃຊ້</th>
                                            <th>ການກະທຳ</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        while ($detail = $detail_result->fetch_assoc()): 
                                            $usage_count = $usage_data[$detail['detail_product_id']] ?? 0;
                                        ?>
                                            <tr>
                                                <td>
                                                    <span class="type-code"><?php echo htmlspecialchars($detail['detail_product_id']); ?></span>
                                                </td>
                                                <td>
                                                    <div class="type-info">
                                                        <span class="type-name"><?php echo htmlspecialchars($detail['detail_text']); ?></span>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="product-count">
                                                        <i class="fas fa-link"></i>
                                                        <?php echo $usage_count; ?> ລາຍການ
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="action-buttons">
                                                        <button class="btn-action btn-edit" onclick="editDetail(<?php echo $detail['id']; ?>)">
                                                            <i class="fas fa-edit"></i>
                                                        </button>
                                                        <button class="btn-action btn-delete" 
                                                                onclick="deleteDetail(<?php echo $detail['id']; ?>, <?php echo $usage_count; ?>)"
                                                                <?php echo $usage_count > 0 ? 'disabled title="ບໍ່ສາມາດລຶບລາຍລະອຽດທີ່ມີການນຳໃຊ້ຢູ່"' : ''; ?>>
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            <?php else: ?>
                                <div class="no-data">
                                    <i class="fas fa-list-alt"></i>
                                    <p>ຍັງບໍ່ມີລາຍລະອຽດສິນຄ້າໃນລະບົບ</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Add Detail Modal -->
    <div id="addModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2><i class="fas fa-plus-circle"></i> ເພີ່ມລາຍລະອຽດສິນຄ້າໃໝ່</h2>
                <span class="close" onclick="closeAddModal()">&times;</span>
            </div>
            
            <div class="modal-body">
                <form id="addForm" method="POST" class="data-form">
                    <div class="form-row">
                        <div class="form-group full-width">
                            <label for="modal_detail_text">
                                <i class="fas fa-pen"></i>
                                ເນື້ອຫາລາຍລະອຽດ <span class="required">*</span>
                            </label>
                            <textarea 
                                   id="modal_detail_text" 
                                   name="detail_text" 
                                   rows="3"
                                   placeholder="ໃສ່ເນື້ອຫາລາຍລະອຽດ..."
                                   required></textarea>
                            <small>ໃສ່ຂໍ້ຄວາມລາຍລະອຽດ - ລະຫັດຈະຖືກສ້າງອັດຕະໂນມັດ</small>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group full-width">
                            <div style="background: #e8f4fd; border: 1px solid #bee5eb; padding: 15px; border-radius: 8px;">
                                <h4 style="margin: 0 0 10px 0; color: #0c5460; font-size: 14px;">
                                    <i class="fas fa-info-circle"></i> ຂໍ້ມູນການໃຊ້ງານ
                                </h4>
                                <ul style="margin: 0; padding-left: 20px; color: #0c5460; font-size: 13px;">
                                    <li>ລະຫັດລາຍລະອຽດ (Detail Product ID) ຈະຖືກສ້າງອັດຕະໂນມັດ</li>
                                    <li>ຮູບແບບ: DP_1, DP_2, DP_3, ...</li>
                                    <li>ສາມາດນຳໄປໃຊ້ໃນການອອກບິນ ຫຼື ເພີ່ມສິນຄ້າໄດ້</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn-secondary" onclick="closeAddModal()">
                    <i class="fas fa-times"></i>
                    ຍົກເລີກ
                </button>
                <button type="button" class="btn-primary" onclick="submitForm()">
                    <i class="fas fa-save"></i>
                    ບັນທຶກ
                </button>
            </div>
        </div>
    </div>

    <!-- Edit Detail Modal -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2><i class="fas fa-edit"></i> ແກ້ໄຂລາຍລະອຽດສິນຄ້າ</h2>
                <span class="close" onclick="closeEditModal()">&times;</span>
            </div>
            
            <div class="modal-body">
                <form id="editForm" method="POST" class="data-form">
                    <input type="hidden" name="action" value="edit">
                    <input type="hidden" id="edit_id" name="id">
                    
                    <div class="form-row">
                        <div class="form-group full-width">
                            <label for="edit_detail_text">
                                <i class="fas fa-pen"></i>
                                ເນື້ອຫາລາຍລະອຽດ <span class="required">*</span>
                            </label>
                            <textarea 
                                   id="edit_detail_text" 
                                   name="detail_text" 
                                   rows="3"
                                   placeholder="ໃສ່ເນື້ອຫາລາຍລະອຽດ..."
                                   required></textarea>
                            <small>ແກ້ໄຂເນື້ອຫາລາຍລະອຽດ - ລະຫັດຈະບໍ່ມີການປ່ຽນແປງ</small>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group full-width">
                            <div style="background: #fff3cd; border: 1px solid #ffeaa7; padding: 15px; border-radius: 8px;">
                                <h4 style="margin: 0 0 10px 0; color: #856404; font-size: 14px;">
                                    <i class="fas fa-exclamation-triangle"></i> ຂໍ້ມູນການແກ້ໄຂ
                                </h4>
                                <ul style="margin: 0; padding-left: 20px; color: #856404; font-size: 13px;">
                                    <li>ລະຫັດລາຍລະອຽດ (Detail Product ID) ບໍ່ສາມາດແກ້ໄຂໄດ້</li>
                                    <li>ການແກ້ໄຂຈະມີຜົນກັບທຸກລາຍການທີ່ໃຊ້ລາຍລະອຽດນີ້</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn-secondary" onclick="closeEditModal()">
                    <i class="fas fa-times"></i>
                    ຍົກເລີກ
                </button>
                <button type="button" class="btn-primary" onclick="submitEditForm()">
                    <i class="fas fa-save"></i>
                    ບັນທຶກການແກ້ໄຂ
                </button>
            </div>
        </div>
    </div>

    <!-- Sweet Alert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Sidebar JavaScript -->
    <script src="js/sidebar.js"></script>
    
    <script>
        // Search Functionality
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            const table = document.querySelector('.data-table');
            if (searchInput && table) {
                searchInput.addEventListener('keyup', function() {
                    const filter = this.value.toLowerCase();
                    const rows = table.querySelectorAll('tbody tr');
                    rows.forEach(row => {
                        const textCell = row.cells[1];
                        const text = textCell.textContent.toLowerCase();
                        row.style.display = text.includes(filter) ? '' : 'none';
                    });
                });
            }
        });

        // Modal Functions
        function openAddModal() {
            document.getElementById('addModal').style.display = 'block';
            document.getElementById('addForm').reset();
        }
        
        function closeAddModal() {
            document.getElementById('addModal').style.display = 'none';
        }
        
        function submitForm() {
            const form = document.getElementById('addForm');
            const formData = new FormData(form);
            
            fetch(window.location.href, {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(html => {
                if (html.includes('ເພີ່ມລາຍລະອຽດສຳເລັດແລ້ວ')) {
                    Swal.fire({
                        icon: 'success',
                        title: 'ສຳເລັດ!',
                        text: 'ເພີ່ມລາຍລະອຽດສຳເລັດແລ້ວ',
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    const tempDiv = document.createElement('div');
                    tempDiv.innerHTML = html;
                    const alertDiv = tempDiv.querySelector('.alert-error');
                    const errorMessage = alertDiv ? alertDiv.textContent.trim() : 'ເກີດຂໍ້ຜິດພາດ';
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'ຜິດພາດ',
                        text: errorMessage
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'ຜິດພາດ',
                    text: 'ເກີດຂໍ້ຜິດພາດໃນການສົ່ງຂໍ້ມູນ'
                });
            });
        }
        
        // Close modal when clicking outside
        window.addEventListener('click', function(event) {
            const addModal = document.getElementById('addModal');
            const editModal = document.getElementById('editModal');
            
            if (event.target === addModal) {
                closeAddModal();
            }
            if (event.target === editModal) {
                closeEditModal();
            }
        });

        // Edit Detail Function
        function editDetail(id) {
            // ดึงข้อมูลจาก server
            fetch('get_detail_product_data.php?id=' + id)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // ใส่ข้อมูลในฟอร์ม
                        document.getElementById('edit_id').value = data.detail.id;
                        document.getElementById('edit_detail_text').value = data.detail.detail_text;
                        
                        // เปิด modal
                        document.getElementById('editModal').style.display = 'block';
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'ຜິດພາດ',
                            text: 'ບໍ່ສາມາດດຶງຂໍ້ມູນລາຍລະອຽດໄດ້'
                        });
                    }
                })
                .catch(error => {
                    // Fallback: ดึงข้อมูลจากตารางเพื่อใส่ในฟอร์มแก้ไข
                    const row = document.querySelector(`button[onclick="editDetail(${id})"]`).closest('tr');
                    const cells = row.querySelectorAll('td');
                    const detailText = cells[1].querySelector('.type-name').textContent.trim();
                    
                    // ใส่ข้อมูลในฟอร์ม
                    document.getElementById('edit_id').value = id;
                    document.getElementById('edit_detail_text').value = detailText;
                    
                    // เปิด modal
                    document.getElementById('editModal').style.display = 'block';
                });
        }
        
        // Close Edit Modal
        function closeEditModal() {
            document.getElementById('editModal').style.display = 'none';
        }
        
        // Submit Edit Form
        function submitEditForm() {
            const form = document.getElementById('editForm');
            const formData = new FormData(form);
            
            fetch(window.location.href, {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(html => {
                if (html.includes('ແກ້ໄຂລາຍລະອຽດສຳເລັດແລ້ວ')) {
                    Swal.fire({
                        icon: 'success',
                        title: 'ສຳເລັດ!',
                        text: 'ແກ້ໄຂລາຍລະອຽດສຳເລັດແລ້ວ',
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    const tempDiv = document.createElement('div');
                    tempDiv.innerHTML = html;
                    const alertDiv = tempDiv.querySelector('.alert-error');
                    const errorMessage = alertDiv ? alertDiv.textContent.trim() : 'ເກີດຂໍ້ຜິດພາດ';
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'ຜິດພາດ',
                        text: errorMessage
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'ຜິດພາດ',
                    text: 'ເກີດຂໍ້ຜິດພາດໃນການສົ່ງຂໍ້ມູນ'
                });
            });
        }
        
        // Delete Detail Function
        function deleteDetail(id, usageCount) {
            if (usageCount > 0) {
                Swal.fire({
                    title: 'ບໍ່ສາມາດລຶບໄດ້',
                    text: 'ລາຍລະອຽດນີ້ມີການນຳໃຊ້ ' + usageCount + ' ລາຍການ ກະລຸນາລຶບການນຳໃຊ້ກ່ອນ',
                    icon: 'warning',
                    confirmButtonText: 'ຕົກລົງ'
                });
                return;
            }

            Swal.fire({
                title: 'ຢືນຢັນການລຶບ',
                text: "ຕ້ອງການລຶບລາຍລະອຽດນີ້ບໍ່?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'ລຶບ',
                cancelButtonText: 'ຍົກເລີກ'
            }).then((result) => {
                if (result.isConfirmed) {
                    // ส่งคำขอลบ
                    const formData = new FormData();
                    formData.append('action', 'delete');
                    formData.append('id', id);
                    
                    fetch(window.location.href, {
                        method: 'POST',
                        body: formData
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'ສຳເລັດ!',
                                text: data.message,
                                timer: 2000,
                                showConfirmButton: false
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'ຜິດພາດ',
                                text: data.message
                            });
                        }
                    })
                    .catch(error => {
                        Swal.fire({
                            icon: 'error',
                            title: 'ຜິດພາດ',
                            text: 'ເກີດຂໍ້ຜິດພາດໃນການສົ່ງຂໍ້ມູນ'
                        });
                    });
                }
            });
        }

        // Show success message if exists
        <?php if ($message_type === 'success'): ?>
            Swal.fire({
                icon: 'success',
                title: 'ສຳເລັດ!',
                text: '<?php echo $message; ?>',
                timer: 3000,
                showConfirmButton: false
            });
        <?php elseif ($message_type === 'error'): ?>
            Swal.fire({
                icon: 'error',
                title: 'ຜິດພາດ',
                text: '<?php echo $message; ?>'
            });
        <?php endif; ?>
    </script>
</body>
</html>