<?php
$page_title = 'ຂໍ້ມູນຮ້ານຄ້າ';
require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;

if (!$shop_id) {
    echo '<div class="empty-state"><i class="fas fa-store-slash"></i><h4>ກະລຸນາເລືອກຮ້ານກ່ອນ</h4></div>';
    require_once 'includes/footer.php';
    exit;
}

$stmt = $conn->prepare("SELECT * FROM shops WHERE id = ?");
$stmt->bind_param("i", $shop_id);
$stmt->execute();
$shop = $stmt->get_result()->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $conn->prepare("UPDATE shops SET shop_name = ?, phone = ?, email = ?, address = ?, province = ?, facebook = ?, facebook_url = ?, line_id = ?, tiktok = ?, instagram = ?, website = ?, description = ? WHERE id = ?");
    $stmt->bind_param("ssssssssssssi", $_POST['shop_name'], $_POST['phone'], $_POST['email'], $_POST['address'], $_POST['province'], $_POST['facebook'], $_POST['facebook_url'], $_POST['line_id'], $_POST['tiktok'], $_POST['instagram'], $_POST['website'], $_POST['description'], $shop_id);

    if ($stmt->execute()) {
        header('Location: shop_info.php?saved=1');
        exit;
    }
}
?>

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px
    }

    .page-header h1 {
        font-size: 24px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 12px;
        margin: 0
    }

    .page-header h1 i {
        color: var(--accent)
    }

    .shop-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 20px;
        overflow: hidden
    }

    .shop-header {
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff;
        padding: 40px;
        text-align: center
    }

    .shop-logo {
        width: 100px;
        height: 100px;
        border-radius: 50%;
        background: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 20px;
        font-size: 40px;
        color: var(--accent)
    }

    .shop-header h2 {
        margin: 0 0 8px;
        font-size: 28px
    }

    .shop-header p {
        margin: 0;
        opacity: .8
    }

    .shop-body {
        padding: 32px
    }

    .form-section {
        margin-bottom: 32px
    }

    .form-section h4 {
        margin: 0 0 20px;
        color: var(--text-secondary);
        font-size: 14px;
        text-transform: uppercase;
        letter-spacing: 1px;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .form-section h4 i {
        color: var(--accent)
    }

    .form-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 20px
    }

    .form-pro-group {
        margin-bottom: 0
    }

    .form-pro-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 500;
        color: var(--text-secondary);
        font-size: 13px
    }

    .form-pro-input {
        width: 100%;
        padding: 14px 16px;
        border: 2px solid var(--border-color);
        border-radius: 12px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 15px;
        transition: all .2s
    }

    .form-pro-input:focus {
        outline: none;
        border-color: var(--accent);
        box-shadow: 0 0 0 4px rgba(74, 144, 217, .1)
    }

    .form-pro-input:disabled {
        opacity: .6;
        cursor: not-allowed
    }

    .btn-pro {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 14px 28px;
        border-radius: 12px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        font-size: 15px;
        transition: all .3s
    }

    .btn-pro.primary {
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff;
        box-shadow: 0 4px 20px rgba(74, 144, 217, .3)
    }

    .btn-pro.primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 25px rgba(74, 144, 217, .4)
    }

    .btn-actions {
        display: flex;
        gap: 16px;
        justify-content: flex-end;
        padding-top: 24px;
        border-top: 1px solid var(--border-color);
        margin-top: 32px
    }

    @media(max-width:768px) {
        .form-grid {
            grid-template-columns: 1fr
        }

        .btn-actions {
            flex-direction: column
        }
    }
</style>

<div class="page-header">
    <h1><i class="fas fa-store"></i> ຂໍ້ມູນຮ້ານຄ້າ</h1>
</div>

<?php if (isset($_GET['saved'])): ?>
    <script>Swal.fire({ icon: 'success', title: 'ບັນທຶກສຳເລັດ!', timer: 2000, showConfirmButton: false })</script>
<?php endif; ?>

<div class="shop-card">
    <div class="shop-header">
        <div class="shop-logo"><i class="fas fa-store"></i></div>
        <h2><?= htmlspecialchars($shop['shop_name']) ?></h2>
        <p><?= $shop['SH_id'] ?></p>
    </div>

    <div class="shop-body">
        <form method="POST">
            <div class="form-section">
                <h4><i class="fas fa-info-circle"></i> ຂໍ້ມູນພື້ນຖານ</h4>
                <div class="form-grid">
                    <div class="form-pro-group"><label>ຊື່ຮ້ານ</label><input type="text" name="shop_name"
                            class="form-pro-input" value="<?= htmlspecialchars($shop['shop_name']) ?>" required></div>
                    <div class="form-pro-group"><label>ລະຫັດຮ້ານ</label><input type="text" class="form-pro-input"
                            value="<?= $shop['SH_id'] ?>" disabled></div>
                    <div class="form-pro-group"><label>ເບີໂທ</label><input type="text" name="phone"
                            class="form-pro-input" value="<?= htmlspecialchars($shop['phone'] ?? '') ?>"></div>
                    <div class="form-pro-group"><label>ອີເມວ</label><input type="email" name="email"
                            class="form-pro-input" value="<?= htmlspecialchars($shop['email'] ?? '') ?>"></div>
                    <div class="form-pro-group"><label>ແຂວງ</label><input type="text" name="province"
                            class="form-pro-input" value="<?= htmlspecialchars($shop['province'] ?? '') ?>"></div>
                    <div class="form-pro-group"><label>ທີ່ຢູ່</label><input type="text" name="address"
                            class="form-pro-input" value="<?= htmlspecialchars($shop['address'] ?? '') ?>"></div>
                </div>
            </div>

            <div class="form-section">
                <h4><i class="fas fa-share-alt"></i> ເຄືອຂ່າຍສັງຄົມ</h4>
                <div class="form-grid">
                    <div class="form-pro-group"><label>Facebook</label><input type="text" name="facebook"
                            class="form-pro-input" value="<?= htmlspecialchars($shop['facebook'] ?? '') ?>"></div>
                    <div class="form-pro-group"><label>Facebook URL</label><input type="url" name="facebook_url"
                            class="form-pro-input" value="<?= htmlspecialchars($shop['facebook_url'] ?? '') ?>"></div>
                    <div class="form-pro-group"><label>Line ID</label><input type="text" name="line_id"
                            class="form-pro-input" value="<?= htmlspecialchars($shop['line_id'] ?? '') ?>"></div>
                    <div class="form-pro-group"><label>TikTok</label><input type="text" name="tiktok"
                            class="form-pro-input" value="<?= htmlspecialchars($shop['tiktok'] ?? '') ?>"></div>
                    <div class="form-pro-group"><label>Instagram</label><input type="text" name="instagram"
                            class="form-pro-input" value="<?= htmlspecialchars($shop['instagram'] ?? '') ?>"></div>
                    <div class="form-pro-group"><label>Website</label><input type="url" name="website"
                            class="form-pro-input" value="<?= htmlspecialchars($shop['website'] ?? '') ?>"></div>
                </div>
            </div>

            <div class="form-section">
                <h4><i class="fas fa-file-alt"></i> ລາຍລະອຽດ</h4>
                <div class="form-pro-group"><textarea name="description" class="form-pro-input" rows="4"
                        placeholder="ລາຍລະອຽດກ່ຽວກັບຮ້ານຄ້າ..."><?= htmlspecialchars($shop['description'] ?? '') ?></textarea>
                </div>
            </div>

            <div class="btn-actions">
                <button type="submit" class="btn-pro primary"><i class="fas fa-save"></i> ບັນທຶກການປ່ຽນແປງ</button>
            </div>
        </form>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>