<?php
$page_title = 'ປະຫວັດການຂາຍ';
require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;

// Get filter values
$search_query = isset($_GET['search']) ? trim($_GET['search']) : '';

// When searching, allow empty dates to search all dates
// Only default to today's date when no search is provided
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : (!empty($search_query) ? '' : date('Y-m-d'));
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : (!empty($search_query) ? '' : date('Y-m-d'));
$page = isset($_GET['page']) && is_numeric($_GET['page']) && $_GET['page'] > 0 ? intval($_GET['page']) : 1;
?>

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px
    }

    .page-header h1 {
        font-size: 24px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 12px;
        margin: 0
    }

    .page-header h1 i {
        color: var(--accent)
    }

    /* Search & Filter */
    .filter-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        padding: 20px;
        margin-bottom: 20px
    }

    .filter-row {
        display: flex;
        gap: 16px;
        flex-wrap: wrap;
        align-items: center
    }

    .search-box {
        display: flex;
        align-items: center;
        gap: 8px;
        background: var(--input-bg);
        border: 1px solid var(--border-color);
        border-radius: 10px;
        padding: 12px 16px;
        flex: 1;
        min-width: 250px
    }

    .search-box input {
        border: none;
        background: transparent;
        outline: none;
        color: var(--text-primary);
        width: 100%;
        font-size: 16px
    }

    .date-input {
        padding: 12px 16px;
        border: 1px solid var(--border-color);
        border-radius: 10px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 16px
    }

    .btn-pro {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 14px 24px;
        border-radius: 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        transition: all .3s;
        font-size: 16px
    }

    .btn-pro.primary {
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff;
        box-shadow: 0 4px 15px rgba(74, 144, 217, .3)
    }

    .btn-pro.primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(74, 144, 217, .4)
    }

    .btn-pro.secondary {
        background: var(--border-color);
        color: var(--text-primary)
    }

    .btn-pro.success {
        background: linear-gradient(135deg, #28a745, #20c997);
        color: #fff
    }

    .btn-reset {
        background: #6c757d;
        color: #fff;
        padding: 12px 20px;
        border-radius: 10px;
        border: none;
        font-weight: 500;
        cursor: pointer;
        text-decoration: none;
        font-size: 14px;
        display: inline-flex;
        align-items: center;
        gap: 8px
    }

    /* Data Card */
    .data-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        overflow: hidden
    }

    .data-card-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 16px
    }

    .data-card-header h3 {
        margin: 0;
        font-size: 18px;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .data-card-header h3 i {
        color: var(--accent)
    }

    .bulk-actions {
        display: none;
        gap: 10px
    }

    /* Pro Table */
    .pro-table {
        width: 100%;
        border-collapse: collapse
    }

    .pro-table th {
        background: rgba(var(--accent-rgb), 0.1);
        padding: 16px 14px;
        text-align: left;
        font-weight: 600;
        font-size: 15px;
        text-transform: uppercase;
        color: var(--text-secondary);
        white-space: nowrap;
        border-bottom: 2px solid var(--accent)
    }

    .pro-table td {
        padding: 16px 14px;
        border-bottom: 1px solid var(--border-color);
        vertical-align: middle;
        font-size: 16px
    }

    .pro-table tbody tr:hover {
        background: rgba(var(--accent-rgb), 0.05)
    }

    .pro-table tbody tr:last-child td {
        border-bottom: none
    }

    /* Order ID Styling */
    .order-id-cell {
        font-family: 'JetBrains Mono', monospace;
        font-size: 14px;
        color: var(--accent)
    }

    /* Badges */
    .badge {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 8px 14px;
        border-radius: 20px;
        font-size: 14px;
        font-weight: 600
    }

    .badge::before {
        content: '';
        width: 6px;
        height: 6px;
        border-radius: 50%
    }

    .badge.type-pos {
        background: rgba(255, 152, 0, .15);
        color: #ff9800
    }

    .badge.type-pos::before {
        background: #ff9800
    }

    .badge.type-online {
        background: rgba(33, 150, 243, .15);
        color: #2196f3
    }

    .badge.type-online::before {
        background: #2196f3
    }

    .badge.type-wholesale {
        background: rgba(156, 39, 176, .15);
        color: #9c27b0
    }

    .badge.type-wholesale::before {
        background: #9c27b0
    }

    .badge.status-paid {
        background: rgba(40, 167, 69, .15);
        color: #28a745
    }

    .badge.status-paid::before {
        background: #28a745
    }

    .badge.status-partial {
        background: rgba(23, 162, 184, .15);
        color: #17a2b8
    }

    .badge.status-partial::before {
        background: #17a2b8
    }

    .badge.status-pending {
        background: rgba(255, 193, 7, .15);
        color: #ffc107
    }

    .badge.status-pending::before {
        background: #ffc107
    }

    .badge.status-refunded {
        background: rgba(220, 53, 69, .15);
        color: #dc3545
    }

    .badge.status-refunded::before {
        background: #dc3545
    }

    /* Amount */
    .amount-cell {
        font-weight: 700;
        font-size: 17px;
        color: #28a745
    }

    /* Action Buttons */
    .action-btns {
        display: flex;
        gap: 6px
    }

    .btn-icon {
        width: 38px;
        height: 38px;
        border-radius: 8px;
        border: none;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all .2s;
        font-size: 15px
    }

    .btn-icon.view {
        background: rgba(74, 144, 217, .15);
        color: var(--accent)
    }

    .btn-icon.view:hover {
        background: var(--accent);
        color: #fff
    }

    .btn-icon.edit {
        background: rgba(255, 193, 7, .15);
        color: #ffc107
    }

    .btn-icon.edit:hover {
        background: #ffc107;
        color: #000
    }

    .btn-icon.delete {
        background: rgba(220, 53, 69, .15);
        color: #dc3545
    }

    .btn-icon.delete:hover {
        background: #dc3545;
        color: #fff
    }

    /* Pagination */
    .pagination-container {
        padding: 20px;
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 20px;
        flex-wrap: wrap;
        border-top: 1px solid var(--border-color)
    }

    .pagination-info {
        color: var(--text-secondary);
        font-size: 16px
    }

    .pagination-buttons {
        display: flex;
        gap: 6px;
        flex-wrap: wrap
    }

    .page-btn {
        min-width: 42px;
        height: 42px;
        padding: 0 14px;
        border: 1px solid var(--border-color);
        border-radius: 8px;
        background: var(--card-bg);
        color: var(--text-primary);
        font-size: 16px;
        cursor: pointer;
        transition: all .2s;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 6px
    }

    .page-btn:hover {
        border-color: var(--accent);
        color: var(--accent)
    }

    .page-btn.active {
        background: var(--accent);
        border-color: var(--accent);
        color: #fff
    }

    /* Empty & Loading */
    .empty-state,
    .loading-state {
        text-align: center;
        padding: 60px 20px;
        color: var(--text-secondary)
    }

    .empty-state i,
    .loading-state i {
        font-size: 48px;
        opacity: .4;
        margin-bottom: 16px;
        display: block
    }

    /* Modal - Pro Style */
    .pro-modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, .6);
        backdrop-filter: blur(4px);
        z-index: 9999;
        align-items: center;
        justify-content: center;
        padding: 20px
    }

    .pro-modal.show {
        display: flex
    }

    .pro-modal-content {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 20px;
        width: 100%;
        max-height: 90vh;
        overflow-y: auto;
        animation: modalSlide .3s ease
    }

    .pro-modal-content.large {
        max-width: 900px
    }

    .pro-modal-content.small {
        max-width: 420px
    }

    @keyframes modalSlide {
        from {
            opacity: 0;
            transform: translateY(-20px) scale(.95)
        }

        to {
            opacity: 1;
            transform: translateY(0) scale(1)
        }
    }

    .pro-modal-header {
        padding: 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center
    }

    .pro-modal-header h3 {
        margin: 0;
        font-size: 20px;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .pro-modal-header h3 i {
        color: var(--accent)
    }

    .pro-modal-close {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        border: none;
        background: rgba(255, 255, 255, .1);
        color: var(--text-secondary);
        cursor: pointer;
        font-size: 20px;
        transition: all .2s
    }

    .pro-modal-close:hover {
        background: #dc3545;
        color: #fff
    }

    .pro-modal-body {
        padding: 24px
    }

    .pro-modal-footer {
        padding: 20px 24px;
        border-top: 1px solid var(--border-color);
        display: flex;
        gap: 12px;
        justify-content: flex-end
    }

    /* Order Info Grid */
    .info-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 16px;
        margin-bottom: 24px
    }

    .info-box {
        background: var(--input-bg);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        padding: 16px;
        border-left: 3px solid var(--accent)
    }

    .info-box h4 {
        font-size: 12px;
        color: var(--accent);
        margin: 0 0 12px 0;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        display: flex;
        align-items: center;
        gap: 8px
    }

    .info-box p {
        margin: 10px 0;
        font-size: 16px;
        display: flex;
        justify-content: space-between
    }

    .info-box p strong {
        color: var(--text-secondary)
    }

    /* Items Table in Modal */
    .items-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 16px
    }

    .items-table th {
        background: var(--accent);
        color: #fff;
        padding: 14px;
        text-align: left;
        font-size: 15px
    }

    .items-table td {
        padding: 14px;
        border-bottom: 1px solid var(--border-color);
        font-size: 16px
    }

    .items-table tbody tr:nth-child(even) {
        background: var(--input-bg)
    }

    /* Summary */
    .order-summary {
        margin-top: 20px;
        padding: 20px;
        background: var(--input-bg);
        border-radius: 12px
    }

    .summary-row {
        display: flex;
        justify-content: space-between;
        padding: 8px 0;
        border-bottom: 1px dashed var(--border-color)
    }

    .summary-row:last-child {
        border-bottom: none
    }

    .summary-row.total {
        border-top: 2px solid var(--accent);
        border-bottom: none;
        padding-top: 12px;
        margin-top: 8px;
        font-size: 18px;
        font-weight: 700;
        color: var(--accent)
    }

    /* Delete Modal */
    .delete-warning {
        text-align: center;
        padding: 20px 0
    }

    .delete-warning i {
        font-size: 48px;
        color: #dc3545;
        margin-bottom: 16px
    }

    .delete-warning h4 {
        margin: 0 0 12px 0;
        font-size: 20px
    }

    .delete-warning p {
        color: var(--text-secondary);
        margin-bottom: 20px
    }

    .form-pro-input {
        width: 100%;
        padding: 14px 16px;
        border: 2px solid var(--border-color);
        border-radius: 10px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 15px
    }

    .form-pro-input:focus {
        outline: none;
        border-color: var(--accent)
    }

    .form-group {
        margin-bottom: 16px
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 500;
        font-size: 14px;
        color: var(--text-secondary)
    }

    .error-msg {
        color: #dc3545;
        font-size: 14px;
        margin-top: 12px;
        text-align: center
    }

    /* Checkbox */
    .bulk-checkbox {
        display: none
    }

    .bulk-checkbox.show {
        display: table-cell
    }

    @media(max-width:768px) {
        .filter-row {
            flex-direction: column
        }

        .search-box {
            width: 100%
        }

        .data-card-header {
            flex-direction: column;
            align-items: stretch
        }
    }
</style>

<?php if (!$shop_id): ?>
    <div class="empty-state">
        <i class="fas fa-store-slash"></i>
        <h4>ກະລຸນາເລືອກຮ້ານກ່ອນ</h4>
    </div>
<?php else: ?>

    <div class="page-header">
        <h1><i class="fas fa-history"></i> ປະຫວັດການຂາຍ</h1>
    </div>

    <!-- Filter Card -->
    <div class="filter-card">
        <form method="GET" action="sales_history.php" id="filter-form">
            <div class="filter-row">
                <div class="search-box">
                    <i class="fas fa-search"></i>
                    <input type="text" name="search" id="search-input" placeholder="ຄົ້ນຫາໃບບິນ, ລູກຄ້າ, ເບີໂທ..."
                        value="<?= htmlspecialchars($search_query) ?>">
                </div>
                <input type="date" name="date_from" class="date-input" value="<?= $date_from ?>">
                <span style="color:var(--text-secondary)">ຫາ</span>
                <input type="date" name="date_to" class="date-input" value="<?= $date_to ?>">
                <button type="submit" class="btn-pro primary">
                    <i class="fas fa-filter"></i> ກັ່ນຕອງ
                </button>
                <?php if (!empty($search_query) || $date_from !== date('Y-m-d') || $date_to !== date('Y-m-d')): ?>
                    <a href="sales_history.php" class="btn-reset">
                        <i class="fas fa-undo"></i> ລ້າງ
                    </a>
                <?php endif; ?>
            </div>
        </form>
    </div>

    <!-- Data Card -->
    <div class="data-card">
        <div class="data-card-header">
            <h3><i class="fas fa-table"></i> ຕາຕະລາງການຂາຍ</h3>
            <div style="display:flex;gap:10px;align-items:center">
                <button type="button" id="toggle-bulk-select" class="btn-pro secondary">
                    <i class="fas fa-check-square"></i> ເລືອກຫຼາຍລາຍການ
                </button>
                <div class="bulk-actions" id="bulk-actions">
                    <button id="print-selected" class="btn-pro success" disabled>
                        <i class="fas fa-print"></i> ພິມທີ່ເລືອກ
                    </button>
                    <button id="cancel-selection" class="btn-pro secondary">
                        <i class="fas fa-times"></i> ຍົກເລີກ
                    </button>
                </div>
            </div>
        </div>

        <div style="overflow-x:auto">
            <table class="pro-table">
                <thead>
                    <tr>
                        <th class="bulk-checkbox" id="bulk-header"><input type="checkbox" id="select-all"></th>
                        <th>ລຳດັບ</th>
                        <th>ປະເພດ</th>
                        <th>ເລກທີໃບບິນ</th>
                        <th>ວັນທີ</th>
                        <th>ລູກຄ້າ</th>
                        <th>ເບີໂທ</th>
                        <th>ບໍລິສັດຂົນສົ່ງ</th>
                        <th>ສາຂາຂົນສົ່ງ</th>
                        <th>ສະຖານະ</th>
                        <th>Print</th>
                        <th>ຍອດລວມ</th>
                        <th>ຈັດການ</th>
                    </tr>
                </thead>
                <tbody id="sales-table-body">
                    <tr>
                        <td colspan="14" class="loading-state">
                            <i class="fas fa-spinner fa-spin"></i>
                            <p>ກຳລັງໂຫຼດຂໍ້ມູນ...</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div id="pagination"></div>
    </div>

    <!-- View Order Modal -->
    <div class="pro-modal" id="order-modal">
        <div class="pro-modal-content large">
            <div class="pro-modal-header">
                <h3><i class="fas fa-file-invoice"></i> <span id="modal-title">ລາຍລະອຽດໃບບິນ</span></h3>
                <button class="pro-modal-close" onclick="closeOrderModal()">&times;</button>
            </div>
            <div class="pro-modal-body" id="order-details">
                <div class="loading-state">
                    <i class="fas fa-spinner fa-spin"></i>
                    <p>ກຳລັງໂຫຼດຂໍ້ມູນ...</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="pro-modal" id="delete-modal">
        <div class="pro-modal-content small">
            <div class="pro-modal-header">
                <h3 style="color:#dc3545"><i class="fas fa-exclamation-triangle"></i> ຢືນຢັນການລົບ</h3>
                <button class="pro-modal-close" onclick="closeDeleteModal()">&times;</button>
            </div>
            <div class="pro-modal-body">
                <div class="delete-warning">
                    <i class="fas fa-trash-alt"></i>
                    <h4>ລຶບໃບບິນນີ້?</h4>
                    <p>ກະລຸນາປ້ອນລະຫັດຜ່ານເພື່ອຢືນຢັນ</p>
                    <input type="password" id="delete-password" class="form-pro-input" placeholder="ລະຫັດຜ່ານ">
                    <input type="hidden" id="delete-order-id">
                    <div id="delete-error-msg" class="error-msg"></div>
                </div>
            </div>
            <div class="pro-modal-footer">
                <button type="button" class="btn-pro secondary" onclick="closeDeleteModal()">ຍົກເລີກ</button>
                <button type="button" id="confirm-delete-btn" class="btn-pro" style="background:#dc3545;color:#fff">
                    <i class="fas fa-trash-alt"></i> ລົບ
                </button>
            </div>
        </div>
    </div>

    <!-- Edit Order Modal -->
    <div class="pro-modal" id="edit-modal">
        <div class="pro-modal-content large">
            <div class="pro-modal-header">
                <h3><i class="fas fa-edit"></i> <span id="edit-modal-title">ແກ້ໄຂໃບບິນ</span></h3>
                <button class="pro-modal-close" onclick="closeEditModal()">&times;</button>
            </div>
            <form id="edit-order-form">
                <input type="hidden" id="edit-order-id" name="order_id">
                <div class="pro-modal-body">
                    <div class="info-grid">
                        <div class="info-box">
                            <h4><i class="fas fa-money-bill-wave"></i> ສະຖານະການຈ່າຍເງິນ</h4>
                            <div class="form-group">
                                <label>ສະຖານະ <span style="color:#dc3545">*</span></label>
                                <select id="edit-payment-status" name="payment_status" class="form-pro-input" required>
                                    <option value="pending">ຍັງບໍ່ຈ່າຍ</option>
                                    <option value="partial">ມັດຈຳ</option>
                                    <option value="paid">ຈ່າຍແລ້ວ</option>
                                    <option value="refunded">ຄືນເງິນ</option>
                                </select>
                            </div>
                            <div class="form-group" id="deposit-group" style="display:none">
                                <label>ຈຳນວນມັດຈຳ</label>
                                <input type="number" id="edit-deposit-amount" name="deposit_amount" class="form-pro-input"
                                    placeholder="0">
                            </div>
                        </div>
                        <div class="info-box">
                            <h4><i class="fas fa-user"></i> ຂໍ້ມູນລູກຄ້າ</h4>
                            <div class="form-group">
                                <label>ຊື່ລູກຄ້າ</label>
                                <input type="text" id="edit-customer-name" class="form-pro-input" readonly
                                    style="opacity:0.7">
                            </div>
                            <div class="form-group">
                                <label>ເບີໂທ</label>
                                <input type="text" id="edit-customer-phone" class="form-pro-input" readonly
                                    style="opacity:0.7">
                            </div>
                        </div>
                        <div class="info-box">
                            <h4><i class="fas fa-truck"></i> ຂໍ້ມູນການຂົນສົ່ງ</h4>
                            <div class="form-group">
                                <label>ເລກ Tracking</label>
                                <input type="text" id="edit-shipping-code" name="shipping_code" class="form-pro-input"
                                    placeholder="ເລກ Tracking">
                            </div>
                            <div class="form-group">
                                <label>ໝາຍເຫດ</label>
                                <textarea id="edit-notes" name="notes" class="form-pro-input" rows="3"
                                    placeholder="ໝາຍເຫດ"></textarea>
                            </div>
                        </div>
                    </div>
                    <div id="edit-error-msg" class="error-msg"></div>
                </div>
                <div class="pro-modal-footer">
                    <button type="button" class="btn-pro secondary" onclick="closeEditModal()">ຍົກເລີກ</button>
                    <button type="submit" id="save-edit-btn" class="btn-pro primary">
                        <i class="fas fa-save"></i> ບັນທຶກ
                    </button>
                </div>
            </form>
        </div>
    </div>

<?php endif; ?>

<?php require_once 'includes/footer.php'; ?>

<?php if ($shop_id): ?>
    <script>
        // Config
        const SALES_HISTORY_CONFIG = {
            currentPage: <?= $page ?>,
            searchQuery: '<?= addslashes($search_query) ?>',
            dateFrom: '<?= $date_from ?>',
            dateTo: '<?= $date_to ?>'
        };

        let bulkSelectActive = false;

        // Initialize
        document.addEventListener('DOMContentLoaded', function () {
            loadTablePage(SALES_HISTORY_CONFIG.currentPage);
            initBulkSelection();
            initDeleteModal();
        });

        // ============ AJAX Table Loading ============
        function loadTablePage(page) {
            const params = new URLSearchParams();
            params.set('page', page);
            params.set('search', SALES_HISTORY_CONFIG.searchQuery);
            params.set('date_from', SALES_HISTORY_CONFIG.dateFrom);
            params.set('date_to', SALES_HISTORY_CONFIG.dateTo);

            document.getElementById('sales-table-body').innerHTML = `
            <tr><td colspan="14" class="loading-state">
                <i class="fas fa-spinner fa-spin"></i><p>ກຳລັງໂຫຼດຂໍ້ມູນ...</p>
            </td></tr>
        `;

            fetch('sales_history_table.php?' + params.toString())
                .then(response => response.text())
                .then(html => {
                    document.getElementById('sales-table-body').innerHTML = html;
                    if (bulkSelectActive) toggleCheckboxVisibility(true);
                })
                .catch(error => {
                    document.getElementById('sales-table-body').innerHTML = `
                    <tr><td colspan="14" class="empty-state">
                        <i class="fas fa-exclamation-circle"></i><p>ເກີດຂໍ້ຜິດພາດ</p>
                    </td></tr>
                `;
                });

            fetch('sales_history_pagination.php?' + params.toString())
                .then(response => response.text())
                .then(html => {
                    document.getElementById('pagination').innerHTML = html;
                });

            const newUrl = new URL(window.location.href);
            newUrl.searchParams.set('page', page);
            window.history.replaceState({}, '', newUrl.toString());
        }

        // ============ View Order Modal ============
        function viewOrder(orderId) {
            document.getElementById('modal-title').textContent = 'ລາຍລະອຽດໃບບິນ: ' + orderId;
            document.getElementById('order-modal').classList.add('show');
            document.getElementById('order-details').innerHTML = `
            <div class="loading-state"><i class="fas fa-spinner fa-spin"></i><p>ກຳລັງໂຫຼດຂໍ້ມູນ...</p></div>
        `;

            fetch('api/get_order_details.php?order_id=' + encodeURIComponent(orderId))
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        renderOrderDetails(data);
                    } else {
                        document.getElementById('order-details').innerHTML = `
                        <div class="empty-state"><i class="fas fa-exclamation-circle"></i><p>${data.message || 'ເກີດຂໍ້ຜິດພາດ'}</p></div>
                    `;
                    }
                })
                .catch(error => {
                    document.getElementById('order-details').innerHTML = `
                    <div class="empty-state"><i class="fas fa-exclamation-circle"></i><p>ເກີດຂໍ້ຜິດພາດ</p></div>
                `;
                });
        }

        function renderOrderDetails(data) {
            const order = data.order;
            const items = data.items;
            const s = order.currency_symbol || '₭';
            const cid = order.currencys_id || 'CUR_1';

            let itemsHtml = '';
            items.forEach((item, i) => {
                const imgHtml = item.product_image
                    ? `<img src="${escapeHtml(item.product_image)}" alt="" style="width:40px;height:40px;object-fit:cover;border-radius:6px;">`
                    : `<div style="width:40px;height:40px;background:var(--border-color);border-radius:6px;display:flex;align-items:center;justify-content:center;"><i class="fas fa-image" style="opacity:0.3;"></i></div>`;
                itemsHtml += `<tr>
                <td>${i + 1}</td>
                <td>${imgHtml}</td>
                <td>${escapeHtml(item.product_name)}</td>
                <td>${s}${formatNumber(item.unit_price, cid)}</td>
                <td>${item.quantity}</td>
                <td>${s}${formatNumber(item.discount, cid)}</td>
                <td>${s}${formatNumber(item.total, cid)}</td>
            </tr>`;
            });

            document.getElementById('order-details').innerHTML = `
            <div class="info-grid">
                <div class="info-box">
                    <h4><i class="fas fa-info-circle"></i> ຂໍ້ມູນໃບບິນ</h4>
                    <p><strong>ປະເພດ:</strong> <span>${escapeHtml(order.order_type_text)}</span></p>
                    <p><strong>ວັນທີ:</strong> <span>${escapeHtml(order.order_date)}</span></p>
                    <p><strong>ສະຖານະ:</strong> <span>${escapeHtml(order.payment_status_text)}</span></p>
                </div>
                <div class="info-box">
                    <h4><i class="fas fa-user"></i> ຂໍ້ມູນລູກຄ້າ</h4>
                    <p><strong>ຊື່:</strong> <span>${escapeHtml(order.customer_name)}</span></p>
                    <p><strong>ເບີໂທ:</strong> <span>${escapeHtml(order.customer_phone)}</span></p>
                    <p><strong>ທີ່ຢູ່:</strong> <span>${escapeHtml(order.customer_address)}</span></p>
                </div>
                <div class="info-box">
                    <h4><i class="fas fa-truck"></i> ຂໍ້ມູນການຂົນສົ່ງ</h4>
                    <p><strong>ບໍລິສັດ:</strong> <span>${escapeHtml(order.shipping_company)}</span></p>
                    <p><strong>ສາຂາ:</strong> <span>${escapeHtml(order.shipping_branch)}</span></p>
                    <p><strong>ເລກ Tracking:</strong> <span>${escapeHtml(order.shipping_code)}</span></p>
                </div>
            </div>

            <h4 style="margin-bottom:12px"><i class="fas fa-shopping-cart"></i> ລາຍການສິນຄ້າ</h4>
            <table class="items-table">
                <thead><tr><th>ລຳດັບ</th><th>ຮູບ</th><th>ສິນຄ້າ</th><th>ລາຄາ</th><th>ຈຳນວນ</th><th>ສ່ວນຫຼຸດ</th><th>ລວມ</th></tr></thead>
                <tbody>${itemsHtml || '<tr><td colspan="7" class="empty-state">ບໍ່ພົບລາຍການສິນຄ້າ</td></tr>'}</tbody>
            </table>

            <div class="order-summary">
                <div class="summary-row"><span>ລວມເງິນ:</span><span>${s}${formatNumber(order.subtotal, cid)}</span></div>
                <div class="summary-row"><span>ສ່ວນຫຼຸດ:</span><span>${s}${formatNumber(order.discount_amount, cid)}</span></div>
                <div class="summary-row"><span>ຄ່າຂົນສົ່ງ:</span><span>${s}${formatNumber(order.shipping_fee, cid)}</span></div>
                ${order.vat_enabled ? `<div class="summary-row" style="color:#4cd137"><span>VAT (10%):</span><span>${s}${formatNumber(order.vat_amount, cid)}</span></div>` : ''}
                ${order.refund_amount > 0 ? `
                    <div class="summary-row" style="text-decoration:line-through;color:#999"><span>ຍອດລວມເດີມ:</span><span>${s}${formatNumber(order.total_amount, cid)}</span></div>
                    <div class="summary-row" style="color:#dc3545"><span><i class="fas fa-undo-alt"></i> ຈຳນວນທີ່ຄືນ:</span><span>-${s}${formatNumber(order.refund_amount, cid)}</span></div>
                    <div class="summary-row total" style="color:#28a745"><span>ຍອດລວມສຸດທິ:</span><span>${s}${formatNumber(order.total_amount - order.refund_amount, cid)}</span></div>
                ` : `
                    <div class="summary-row total"><span>ຍອດລວມ:</span><span>${s}${formatNumber(order.total_amount, cid)}</span></div>
                `}
                ${order.deposit_amount > 0 ? `
                    <div class="summary-row"><span>ເງິນມັດຈຳ:</span><span>${s}${formatNumber(order.deposit_amount, cid)}</span></div>
                    <div class="summary-row" style="color:#ffc107"><span>ຄ້າງຊຳລະ:</span><span>${s}${formatNumber(order.total_amount - order.deposit_amount, cid)}</span></div>
                ` : ''}
            </div>

            ${order.notes ? `<div class="info-box" style="margin-top:16px"><h4><i class="fas fa-sticky-note"></i> ໝາຍເຫດ</h4><p>${escapeHtml(order.notes)}</p></div>` : ''}
        `;
        }

        function closeOrderModal() {
            document.getElementById('order-modal').classList.remove('show');
        }

        // ============ Edit Order ============
        function editOrder(orderId) {
            // Get current filter values to pass to edit page for back navigation
            const dateFrom = document.querySelector('input[name="date_from"]').value;
            const dateTo = document.querySelector('input[name="date_to"]').value;
            const search = document.getElementById('search-input').value;

            let url = 'edit_order.php?order_id=' + encodeURIComponent(orderId);
            if (dateFrom) url += '&date_from=' + encodeURIComponent(dateFrom);
            if (dateTo) url += '&date_to=' + encodeURIComponent(dateTo);
            if (search) url += '&search=' + encodeURIComponent(search);

            window.location.href = url;
        }

        function closeEditModal() {
            document.getElementById('edit-modal').classList.remove('show');
        }

        function toggleDepositField() {
            const status = document.getElementById('edit-payment-status').value;
            document.getElementById('deposit-group').style.display = status === 'partial' ? 'block' : 'none';
        }

        // Initialize edit form
        document.getElementById('edit-payment-status').addEventListener('change', toggleDepositField);

        document.getElementById('edit-order-form').addEventListener('submit', function (e) {
            e.preventDefault();
            const saveBtn = document.getElementById('save-edit-btn');
            const errorMsg = document.getElementById('edit-error-msg');

            saveBtn.disabled = true;
            saveBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> ກຳລັງບັນທຶກ...';
            errorMsg.textContent = '';

            const formData = {
                order_id: document.getElementById('edit-order-id').value,
                payment_status: document.getElementById('edit-payment-status').value,
                deposit_amount: document.getElementById('edit-deposit-amount').value || 0,
                shipping_code: document.getElementById('edit-shipping-code').value,
                notes: document.getElementById('edit-notes').value
            };

            fetch('api/update_order.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            })
                .then(response => response.json())
                .then(data => {
                    saveBtn.disabled = false;
                    saveBtn.innerHTML = '<i class="fas fa-save"></i> ບັນທຶກ';

                    if (data.status === 'success') {
                        closeEditModal();
                        Swal.fire({ icon: 'success', title: 'ບັນທຶກສຳເລັດ!', timer: 1500, showConfirmButton: false });
                        loadTablePage(SALES_HISTORY_CONFIG.currentPage);
                    } else {
                        errorMsg.textContent = data.message || 'ເກີດຂໍ້ຜິດພາດ';
                    }
                })
                .catch(error => {
                    saveBtn.disabled = false;
                    saveBtn.innerHTML = '<i class="fas fa-save"></i> ບັນທຶກ';
                    errorMsg.textContent = 'ເກີດຂໍ້ຜິດພາດໃນການເຊື່ອມຕໍ່';
                });
        });

        document.getElementById('edit-modal').addEventListener('click', function (e) { if (e.target === this) closeEditModal(); });

        // ============ Delete Order ============
        function confirmDeleteOrder(orderId) {
            document.getElementById('delete-order-id').value = orderId;
            document.getElementById('delete-password').value = '';
            document.getElementById('delete-error-msg').textContent = '';
            document.getElementById('delete-modal').classList.add('show');
        }

        function closeDeleteModal() {
            document.getElementById('delete-modal').classList.remove('show');
        }

        function initDeleteModal() {
            const confirmBtn = document.getElementById('confirm-delete-btn');
            confirmBtn.addEventListener('click', function () {
                const orderId = document.getElementById('delete-order-id').value;
                const password = document.getElementById('delete-password').value;
                const errorMsg = document.getElementById('delete-error-msg');

                if (!password) {
                    errorMsg.textContent = 'ກະລຸນາປ້ອນລະຫັດຜ່ານ';
                    return;
                }

                confirmBtn.disabled = true;
                confirmBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> ກຳລັງລົບ...';

                fetch('api/delete_order.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ order_id: orderId, password: password })
                })
                    .then(response => response.json())
                    .then(data => {
                        confirmBtn.disabled = false;
                        confirmBtn.innerHTML = '<i class="fas fa-trash-alt"></i> ລົບ';

                        if (data.status === 'success') {
                            closeDeleteModal();
                            const row = document.querySelector(`tr[data-order-id="${orderId}"]`);
                            if (row) {
                                row.style.opacity = '0';
                                setTimeout(() => row.remove(), 300);
                            }
                            Swal.fire({ icon: 'success', title: 'ລຶບສຳເລັດ!', timer: 1500, showConfirmButton: false });
                        } else {
                            errorMsg.textContent = data.message || 'ເກີດຂໍ້ຜິດພາດ';
                        }
                    })
                    .catch(error => {
                        confirmBtn.disabled = false;
                        confirmBtn.innerHTML = '<i class="fas fa-trash-alt"></i> ລົບ';
                        errorMsg.textContent = 'ເກີດຂໍ້ຜິດພາດໃນການເຊື່ອມຕໍ່';
                    });
            });
        }

        // ============ Bulk Selection ============
        function initBulkSelection() {
            const toggleBtn = document.getElementById('toggle-bulk-select');
            const cancelBtn = document.getElementById('cancel-selection');
            const printBtn = document.getElementById('print-selected');
            const selectAll = document.getElementById('select-all');

            toggleBtn.addEventListener('click', function () {
                bulkSelectActive = !bulkSelectActive;
                if (bulkSelectActive) {
                    toggleBtn.innerHTML = '<i class="fas fa-times"></i> ປິດ';
                    document.getElementById('bulk-actions').style.display = 'flex';
                    toggleCheckboxVisibility(true);
                } else {
                    resetBulkSelection();
                }
            });

            cancelBtn.addEventListener('click', function () {
                document.querySelectorAll('.order-checkbox').forEach(cb => cb.checked = false);
                if (selectAll) selectAll.checked = false;
                updatePrintButtonState();
            });

            if (selectAll) {
                selectAll.addEventListener('change', function () {
                    document.querySelectorAll('.order-checkbox').forEach(cb => cb.checked = selectAll.checked);
                    updatePrintButtonState();
                });
            }

            document.addEventListener('change', function (e) {
                if (e.target.classList.contains('order-checkbox')) updatePrintButtonState();
            });

            printBtn.addEventListener('click', printSelectedOrders);
        }

        function toggleCheckboxVisibility(show) {
            document.querySelectorAll('.bulk-checkbox').forEach(el => {
                el.classList.toggle('show', show);
            });
        }

        function resetBulkSelection() {
            bulkSelectActive = false;
            toggleCheckboxVisibility(false);
            document.querySelectorAll('.order-checkbox').forEach(cb => cb.checked = false);
            const selectAll = document.getElementById('select-all');
            if (selectAll) selectAll.checked = false;
            document.getElementById('bulk-actions').style.display = 'none';
            document.getElementById('toggle-bulk-select').innerHTML = '<i class="fas fa-check-square"></i> ເລືອກຫຼາຍລາຍການ';
            document.getElementById('print-selected').disabled = true;
        }

        function updatePrintButtonState() {
            const checked = document.querySelectorAll('.order-checkbox:checked').length;
            document.getElementById('print-selected').disabled = checked === 0;
        }

        function printSelectedOrders() {
            const selectedCheckboxes = Array.from(document.querySelectorAll('.order-checkbox:checked'));
            if (selectedCheckboxes.length === 0) {
                Swal.fire({ icon: 'warning', title: 'ກະລຸນາເລືອກລາຍການ' });
                return;
            }

            // Group by order type
            const onlineOrders = [];
            const shopOrders = [];

            selectedCheckboxes.forEach(cb => {
                const row = cb.closest('tr');
                const orderType = row.dataset.orderType;
                const orderId = cb.dataset.orderId;

                if (orderType === 'online') {
                    onlineOrders.push(orderId);
                } else {
                    shopOrders.push(orderId);
                }
            });

            // Open appropriate print pages
            if (onlineOrders.length > 0) {
                window.open('print_online.php?order_ids=' + onlineOrders.join(','), '_blank');
            }
            if (shopOrders.length > 0) {
                window.open('print_shop.php?order_ids=' + shopOrders.join(','), '_blank');
            }
        }

        // ============ Modal Click Outside ============
        document.getElementById('order-modal').addEventListener('click', function (e) { if (e.target === this) closeOrderModal(); });
        document.getElementById('delete-modal').addEventListener('click', function (e) { if (e.target === this) closeDeleteModal(); });

        // ============ Utilities ============
        function escapeHtml(text) {
            if (!text) return '-';
            const div = document.createElement('div');
            div.textContent = text;
            return div.innerHTML;
        }

        function formatNumber(n, currencyId = null) {
            if (isNaN(n)) return '0';
            // USD (CUR_3) should show 2 decimal places
            if (currencyId === 'CUR_3') {
                return new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(n);
            }
            return new Intl.NumberFormat('en-US').format(Math.round(n));
        }
    </script>
<?php endif; ?>