<?php
$page_title = 'ສິນຄ້າທີ່ບໍ່ໄດ້ຂາຍ';
require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;
if (!$shop_id) {
    echo '<div class="alert alert-danger">ກະລຸນາເລືອກຮ້ານກ່ອນ</div>';
    require_once 'includes/footer.php';
    exit;
}

$days = $_GET['days'] ?? 30;

// Fix: product_id in order_items is PR_id (varchar), not id (int)
$stmt = $conn->prepare("SELECT p.*, c.category_name FROM products p LEFT JOIN product_categories c ON p.category_id = c.id WHERE p.shop_id = ? AND p.deleted_at IS NULL AND p.PR_id NOT IN (SELECT DISTINCT oi.product_id FROM order_items oi JOIN orders o ON oi.order_id = o.id WHERE o.shop_id = ? AND o.created_at >= DATE_SUB(NOW(), INTERVAL ? DAY)) ORDER BY p.created_at");
$stmt->bind_param("iii", $shop_id, $shop_id, $days);
$stmt->execute();
$products = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Calculate total stock value
$total_stock_value = 0;
foreach ($products as $p) {
    $total_stock_value += $p['quantity'] * $p['selling_price'];
}
?>

<style>
    /* Report Page Premium Styles */
    .report-container {
        padding: 25px;
        animation: fadeIn 0.5s ease-out;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(10px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .report-header {
        display: flex;
        align-items: center;
        gap: 15px;
        margin-bottom: 25px;
    }

    .report-header-icon {
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, #6C757D, #495057);
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 28px;
        color: white;
        box-shadow: 0 8px 25px rgba(108, 117, 125, 0.3);
    }

    .report-header-text h1 {
        font-size: 28px;
        font-weight: 700;
        margin-bottom: 5px;
        background: linear-gradient(135deg, #6C757D, #495057);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }

    .report-header-text p {
        color: var(--text-secondary);
        font-size: 14px;
    }

    /* Stats Cards */
    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        margin-bottom: 25px;
    }

    .stat-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        padding: 20px;
        position: relative;
        overflow: hidden;
        transition: all 0.3s ease;
    }

    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 40px rgba(0, 0, 0, 0.15);
    }

    .stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 4px;
        background: linear-gradient(90deg, #6C757D, #495057);
    }

    .stat-card.warning::before {
        background: linear-gradient(90deg, #FFC107, #FF9800);
    }

    .stat-card.info::before {
        background: linear-gradient(90deg, #17A2B8, #138496);
    }

    .stat-icon {
        width: 50px;
        height: 50px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 22px;
        margin-bottom: 15px;
    }

    .stat-icon.gray {
        background: rgba(108, 117, 125, 0.15);
        color: #6C757D;
    }

    .stat-icon.warning {
        background: rgba(255, 193, 7, 0.15);
        color: #FFC107;
    }

    .stat-icon.info {
        background: rgba(23, 162, 184, 0.15);
        color: #17A2B8;
    }

    .stat-value {
        font-size: 28px;
        font-weight: 700;
        margin-bottom: 5px;
    }

    .stat-label {
        color: var(--text-secondary);
        font-size: 14px;
    }

    /* Filter Card */
    .filter-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        padding: 25px;
        margin-bottom: 25px;
    }

    .filter-form {
        display: flex;
        flex-wrap: wrap;
        gap: 15px;
        align-items: flex-end;
    }

    .filter-group {
        flex: 1;
        min-width: 200px;
        max-width: 300px;
    }

    .filter-group label {
        display: block;
        margin-bottom: 8px;
        font-size: 13px;
        font-weight: 600;
        color: var(--text-secondary);
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .filter-group select {
        width: 100%;
        padding: 12px 16px;
        background: var(--bg-secondary);
        border: 1px solid var(--border-color);
        border-radius: 10px;
        color: var(--text-primary);
        font-size: 15px;
        transition: all 0.3s ease;
    }

    .filter-group select:focus {
        outline: none;
        border-color: var(--accent);
        box-shadow: 0 0 0 3px rgba(74, 144, 217, 0.15);
    }

    .btn-search {
        padding: 12px 30px;
        background: linear-gradient(135deg, var(--accent), var(--accent-light));
        border: none;
        border-radius: 10px;
        color: white;
        font-size: 15px;
        font-weight: 600;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 8px;
        transition: all 0.3s ease;
    }

    .btn-search:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(74, 144, 217, 0.3);
    }

    /* Info Alert */
    .info-banner {
        background: linear-gradient(135deg, rgba(23, 162, 184, 0.1), rgba(23, 162, 184, 0.05));
        border: 1px solid rgba(23, 162, 184, 0.3);
        border-radius: 12px;
        padding: 16px 20px;
        margin-bottom: 25px;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .info-banner i {
        font-size: 20px;
        color: #17A2B8;
    }

    .info-banner span {
        color: var(--text-primary);
        font-size: 14px;
    }

    .info-banner strong {
        color: #17A2B8;
    }

    /* Data Table */
    .data-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        overflow: hidden;
    }

    .data-table {
        width: 100%;
        border-collapse: collapse;
    }

    .data-table thead {
        background: var(--bg-secondary);
    }

    .data-table th {
        padding: 16px 20px;
        text-align: left;
        font-weight: 600;
        font-size: 13px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        color: var(--text-secondary);
        border-bottom: 1px solid var(--border-color);
    }

    .data-table td {
        padding: 16px 20px;
        border-bottom: 1px solid var(--border-color);
        transition: all 0.3s ease;
    }

    .data-table tbody tr {
        transition: all 0.3s ease;
    }

    .data-table tbody tr:hover {
        background: var(--bg-secondary);
    }

    .data-table tbody tr:last-child td {
        border-bottom: none;
    }

    /* Product Info */
    .product-info {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .product-image {
        width: 45px;
        height: 45px;
        border-radius: 10px;
        background: var(--bg-secondary);
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--text-secondary);
        font-size: 18px;
        overflow: hidden;
    }

    .product-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .product-name {
        font-weight: 600;
        margin-bottom: 3px;
    }

    .product-code {
        font-size: 12px;
        color: var(--text-secondary);
        font-family: monospace;
    }

    /* Category Badge */
    .category-badge {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        background: rgba(108, 117, 125, 0.15);
        color: var(--text-secondary);
        border-radius: 20px;
        font-size: 13px;
    }

    /* Stock Badge */
    .stock-badge {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        border-radius: 20px;
        font-weight: 600;
        font-size: 13px;
    }

    .stock-badge.warning {
        background: rgba(255, 193, 7, 0.15);
        color: #FFC107;
    }

    .stock-badge.normal {
        background: rgba(40, 167, 69, 0.15);
        color: #28A745;
    }

    /* Price */
    .price-amount {
        font-weight: 600;
        color: var(--text-primary);
    }

    /* Row Number */
    .row-num {
        width: 36px;
        height: 36px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        background: var(--bg-secondary);
        border-radius: 10px;
        font-weight: 600;
        color: var(--text-secondary);
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: var(--text-secondary);
    }

    .empty-state-icon {
        width: 80px;
        height: 80px;
        background: rgba(40, 167, 69, 0.15);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 36px;
        color: #28A745;
        margin: 0 auto 20px;
    }

    .empty-state h3 {
        font-size: 18px;
        margin-bottom: 10px;
        color: #28A745;
    }

    @media (max-width: 768px) {
        .stats-row {
            grid-template-columns: 1fr 1fr;
        }

        .filter-form {
            flex-direction: column;
        }

        .filter-group {
            width: 100%;
            max-width: none;
        }

        .data-table {
            display: block;
            overflow-x: auto;
        }
    }
</style>

<div class="report-container">
    <!-- Header -->
    <div class="report-header">
        <div class="report-header-icon">
            <i class="fas fa-ban"></i>
        </div>
        <div class="report-header-text">
            <h1>ສິນຄ້າທີ່ບໍ່ໄດ້ຂາຍ</h1>
            <p>ສິນຄ້າທີ່ບໍ່ມີການຂາຍໃນ <?= $days ?> ວັນທີ່ຜ່ານມາ</p>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="stats-row">
        <div class="stat-card">
            <div class="stat-icon gray"><i class="fas fa-box"></i></div>
            <div class="stat-value"><?= count($products) ?></div>
            <div class="stat-label">ສິນຄ້າທີ່ບໍ່ເຄື່ອນໄຫວ</div>
        </div>
        <div class="stat-card warning">
            <div class="stat-icon warning"><i class="fas fa-warehouse"></i></div>
            <div class="stat-value"><?= number_format(array_sum(array_column($products, 'quantity'))) ?></div>
            <div class="stat-label">ຈຳນວນຄົງເຫຼືອລວມ</div>
        </div>
        <div class="stat-card info">
            <div class="stat-icon info"><i class="fas fa-coins"></i></div>
            <div class="stat-value"><?= number_format($total_stock_value) ?> ₭</div>
            <div class="stat-label">ມູນຄ່າສິນຄ້າຄ້າງ</div>
        </div>
    </div>

    <!-- Filter -->
    <div class="filter-card">
        <form method="GET" class="filter-form">
            <div class="filter-group">
                <label><i class="fas fa-calendar-alt"></i> ຊ່ວງເວລາ</label>
                <select name="days">
                    <option value="7" <?= $days == 7 ? 'selected' : '' ?>>7 ວັນທີ່ຜ່ານມາ</option>
                    <option value="14" <?= $days == 14 ? 'selected' : '' ?>>14 ວັນທີ່ຜ່ານມາ</option>
                    <option value="30" <?= $days == 30 ? 'selected' : '' ?>>30 ວັນທີ່ຜ່ານມາ</option>
                    <option value="60" <?= $days == 60 ? 'selected' : '' ?>>60 ວັນທີ່ຜ່ານມາ</option>
                    <option value="90" <?= $days == 90 ? 'selected' : '' ?>>90 ວັນທີ່ຜ່ານມາ</option>
                </select>
            </div>
            <button type="submit" class="btn-search">
                <i class="fas fa-search"></i> ຄົ້ນຫາ
            </button>
        </form>
    </div>

    <!-- Info Banner -->
    <?php if (!empty($products)): ?>
        <div class="info-banner">
            <i class="fas fa-info-circle"></i>
            <span>ພົບ <strong><?= count($products) ?></strong> ສິນຄ້າທີ່ບໍ່ໄດ້ຂາຍໃນ <strong><?= $days ?></strong>
                ວັນທີ່ຜ່ານມາ - ພິຈາລະນາທຳໂປຣໂມຊັ່ນ ຫຼື ປັບລາຄາ</span>
        </div>
    <?php endif; ?>

    <!-- Data Table -->
    <div class="data-card">
        <?php if (empty($products)): ?>
            <div class="empty-state">
                <div class="empty-state-icon"><i class="fas fa-check-circle"></i></div>
                <h3>ດີຫລາຍ!</h3>
                <p>ສິນຄ້າທຸກລາຍການຂາຍໄດ້ໃນຊ່ວງ <?= $days ?> ວັນທີ່ຜ່ານມາ</p>
            </div>
        <?php else: ?>
            <table class="data-table">
                <thead>
                    <tr>
                        <th style="width: 60px">#</th>
                        <th>ສິນຄ້າ</th>
                        <th>ປະເພດ</th>
                        <th style="text-align: center">ຈຳນວນຄົງເຫຼືອ</th>
                        <th style="text-align: right">ລາຄາຂາຍ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($products as $i => $p): ?>
                        <tr>
                            <td><span class="row-num"><?= $i + 1 ?></span></td>
                            <td>
                                <div class="product-info">
                                    <div class="product-image">
                                        <?php if (!empty($p['product_image'])): ?>
                                            <img src="<?= htmlspecialchars($p['product_image']) ?>" alt="">
                                        <?php else: ?>
                                            <i class="fas fa-cube"></i>
                                        <?php endif; ?>
                                    </div>
                                    <div>
                                        <div class="product-name"><?= htmlspecialchars($p['product_name']) ?></div>
                                        <div class="product-code"><?= $p['PR_id'] ?></div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="category-badge">
                                    <i class="fas fa-tag"></i>
                                    <?= $p['category_name'] ?? 'ບໍ່ລະບຸ' ?>
                                </span>
                            </td>
                            <td style="text-align: center">
                                <span class="stock-badge <?= $p['quantity'] <= 10 ? 'warning' : 'normal' ?>">
                                    <i class="fas fa-boxes"></i>
                                    <?= number_format($p['quantity']) ?>
                                </span>
                            </td>
                            <td style="text-align: right">
                                <span class="price-amount"><?= number_format($p['selling_price']) ?> ₭</span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>