<?php
$page_title = 'ສິນຄ້າໃກ້ຈະໝົດ';
require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;
if (!$shop_id) {
    echo '<div class="alert alert-danger">ກະລຸນາເລືອກຮ້ານກ່ອນ</div>';
    require_once 'includes/footer.php';
    exit;
}

$threshold = $_GET['threshold'] ?? 10;

$stmt = $conn->prepare("SELECT p.*, c.category_name FROM products p LEFT JOIN product_categories c ON p.category_id = c.id WHERE p.shop_id = ? AND p.deleted_at IS NULL AND p.quantity <= ? ORDER BY p.quantity ASC");
$stmt->bind_param("ii", $shop_id, $threshold);
$stmt->execute();
$products = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Count products by urgency
$critical = 0;
$warning = 0;
$out_of_stock = 0;
foreach ($products as $p) {
    if ($p['quantity'] == 0)
        $out_of_stock++;
    elseif ($p['quantity'] <= 5)
        $critical++;
    else
        $warning++;
}
?>

<style>
/* Report Page Premium Styles */
.report-container {
    padding: 25px;
    animation: fadeIn 0.5s ease-out;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.05); }
}

.report-header {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 25px;
}

.report-header-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #DC3545, #C82333);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 28px;
    color: white;
    box-shadow: 0 8px 25px rgba(220, 53, 69, 0.3);
    animation: pulse 2s infinite;
}

.report-header-text h1 {
    font-size: 28px;
    font-weight: 700;
    margin-bottom: 5px;
    background: linear-gradient(135deg, #DC3545, #C82333);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.report-header-text p {
    color: var(--text-secondary);
    font-size: 14px;
}

/* Stats Cards */
.stats-row {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 20px;
    margin-bottom: 25px;
}

.stat-card {
    background: var(--card-bg);
    border: 1px solid var(--border-color);
    border-radius: 16px;
    padding: 20px;
    position: relative;
    overflow: hidden;
    transition: all 0.3s ease;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0, 0, 0, 0.15);
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 4px;
}

.stat-card.danger::before { background: linear-gradient(90deg, #DC3545, #C82333); }
.stat-card.warning::before { background: linear-gradient(90deg, #FFC107, #FF9800); }
.stat-card.critical::before { background: linear-gradient(90deg, #6C757D, #495057); }
.stat-card.success::before { background: linear-gradient(90deg, #28A745, #218838); }

.stat-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 22px;
    margin-bottom: 15px;
}

.stat-icon.danger { background: rgba(220, 53, 69, 0.15); color: #DC3545; }
.stat-icon.warning { background: rgba(255, 193, 7, 0.15); color: #FFC107; }
.stat-icon.critical { background: rgba(108, 117, 125, 0.15); color: #6C757D; }
.stat-icon.success { background: rgba(40, 167, 69, 0.15); color: #28A745; }

.stat-value {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 5px;
}

.stat-label {
    color: var(--text-secondary);
    font-size: 14px;
}

/* Filter Card */
.filter-card {
    background: var(--card-bg);
    border: 1px solid var(--border-color);
    border-radius: 16px;
    padding: 25px;
    margin-bottom: 25px;
}

.filter-form {
    display: flex;
    flex-wrap: wrap;
    gap: 15px;
    align-items: flex-end;
}

.filter-group {
    flex: 1;
    min-width: 200px;
    max-width: 300px;
}

.filter-group label {
    display: block;
    margin-bottom: 8px;
    font-size: 13px;
    font-weight: 600;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.filter-group input {
    width: 100%;
    padding: 12px 16px;
    background: var(--bg-secondary);
    border: 1px solid var(--border-color);
    border-radius: 10px;
    color: var(--text-primary);
    font-size: 15px;
    transition: all 0.3s ease;
}

.filter-group input:focus {
    outline: none;
    border-color: var(--accent);
    box-shadow: 0 0 0 3px rgba(74, 144, 217, 0.15);
}

.btn-search {
    padding: 12px 30px;
    background: linear-gradient(135deg, var(--accent), var(--accent-light));
    border: none;
    border-radius: 10px;
    color: white;
    font-size: 15px;
    font-weight: 600;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
}

.btn-search:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(74, 144, 217, 0.3);
}

/* Warning Banner */
.warning-banner {
    background: linear-gradient(135deg, rgba(220, 53, 69, 0.1), rgba(220, 53, 69, 0.05));
    border: 1px solid rgba(220, 53, 69, 0.3);
    border-radius: 12px;
    padding: 16px 20px;
    margin-bottom: 25px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.warning-banner i {
    font-size: 24px;
    color: #DC3545;
    animation: pulse 1.5s infinite;
}

.warning-banner span {
    color: var(--text-primary);
    font-size: 14px;
}

.warning-banner strong {
    color: #DC3545;
}

/* Data Table */
.data-card {
    background: var(--card-bg);
    border: 1px solid var(--border-color);
    border-radius: 16px;
    overflow: hidden;
}

.data-table {
    width: 100%;
    border-collapse: collapse;
}

.data-table thead {
    background: var(--bg-secondary);
}

.data-table th {
    padding: 16px 20px;
    text-align: left;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    color: var(--text-secondary);
    border-bottom: 1px solid var(--border-color);
}

.data-table td {
    padding: 16px 20px;
    border-bottom: 1px solid var(--border-color);
    transition: all 0.3s ease;
}

.data-table tbody tr {
    transition: all 0.3s ease;
}

.data-table tbody tr:hover {
    background: var(--bg-secondary);
}

.data-table tbody tr:last-child td {
    border-bottom: none;
}

.data-table tbody tr.row-danger {
    background: rgba(220, 53, 69, 0.05);
}

.data-table tbody tr.row-danger:hover {
    background: rgba(220, 53, 69, 0.1);
}

.data-table tbody tr.row-warning {
    background: rgba(255, 193, 7, 0.05);
}

.data-table tbody tr.row-warning:hover {
    background: rgba(255, 193, 7, 0.1);
}

/* Product Info */
.product-info {
    display: flex;
    align-items: center;
    gap: 12px;
}

.product-image {
    width: 45px;
    height: 45px;
    border-radius: 10px;
    background: var(--bg-secondary);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--text-secondary);
    font-size: 18px;
    overflow: hidden;
}

.product-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.product-name {
    font-weight: 600;
    margin-bottom: 3px;
}

.product-code {
    font-size: 12px;
    color: var(--text-secondary);
    font-family: monospace;
}

/* Category Badge */
.category-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    background: rgba(108, 117, 125, 0.15);
    color: var(--text-secondary);
    border-radius: 20px;
    font-size: 13px;
}

/* Stock Badge */
.stock-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 8px 14px;
    border-radius: 20px;
    font-weight: 700;
    font-size: 14px;
}

.stock-badge.out-of-stock {
    background: rgba(220, 53, 69, 0.2);
    color: #DC3545;
    animation: pulse 2s infinite;
}

.stock-badge.critical {
    background: rgba(255, 193, 7, 0.2);
    color: #E6A800;
}

.stock-badge.warning {
    background: rgba(255, 152, 0, 0.15);
    color: #FF9800;
}

/* Price */
.price-amount {
    font-weight: 600;
    color: var(--text-primary);
}

/* Row Number */
.row-num {
    width: 36px;
    height: 36px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    background: var(--bg-secondary);
    border-radius: 10px;
    font-weight: 600;
    color: var(--text-secondary);
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 60px 20px;
    color: var(--text-secondary);
}

.empty-state-icon {
    width: 80px;
    height: 80px;
    background: rgba(40, 167, 69, 0.15);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 36px;
    color: #28A745;
    margin: 0 auto 20px;
}

.empty-state h3 {
    font-size: 18px;
    margin-bottom: 10px;
    color: #28A745;
}

@media (max-width: 768px) {
    .stats-row {
        grid-template-columns: 1fr 1fr;
    }
    
    .filter-form {
        flex-direction: column;
    }
    
    .filter-group {
        width: 100%;
        max-width: none;
    }
    
    .data-table {
        display: block;
        overflow-x: auto;
    }
}
</style>

<div class="report-container">
    <!-- Header -->
    <div class="report-header">
        <div class="report-header-icon">
            <i class="fas fa-exclamation-triangle"></i>
        </div>
        <div class="report-header-text">
            <h1>ສິນຄ້າໃກ້ຈະໝົດ</h1>
            <p>ເຕືອນສິນຄ້າທີ່ມີຈຳນວນຕ່ຳກວ່າ ≤ <?= $threshold ?> ຊິ້ນ</p>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="stats-row">
        <div class="stat-card danger">
            <div class="stat-icon danger"><i class="fas fa-times-circle"></i></div>
            <div class="stat-value"><?= $out_of_stock ?></div>
            <div class="stat-label">ໝົດສະຕ໋ອກ</div>
        </div>
        <div class="stat-card warning">
            <div class="stat-icon warning"><i class="fas fa-exclamation-circle"></i></div>
            <div class="stat-value"><?= $critical ?></div>
            <div class="stat-label">ວິກິດ (≤ 5)</div>
        </div>
        <div class="stat-card critical">
            <div class="stat-icon critical"><i class="fas fa-battery-quarter"></i></div>
            <div class="stat-value"><?= $warning ?></div>
            <div class="stat-label">ເຕືອນ (6-<?= $threshold ?>)</div>
        </div>
        <div class="stat-card success">
            <div class="stat-icon success"><i class="fas fa-clipboard-list"></i></div>
            <div class="stat-value"><?= count($products) ?></div>
            <div class="stat-label">ລວມທັງໝົດ</div>
        </div>
    </div>

    <!-- Filter -->
    <div class="filter-card">
        <form method="GET" class="filter-form">
            <div class="filter-group">
                <label><i class="fas fa-sort-numeric-down"></i> ເຕືອນເມື່ອຈຳນວນ ≤</label>
                <input type="number" name="threshold" value="<?= $threshold ?>" min="1" placeholder="ໃສ່ຈຳນວນ">
            </div>
            <button type="submit" class="btn-search">
                <i class="fas fa-search"></i> ຄົ້ນຫາ
            </button>
        </form>
    </div>

    <!-- Warning Banner -->
    <?php if ($out_of_stock > 0): ?>
        <div class="warning-banner">
            <i class="fas fa-exclamation-triangle"></i>
            <span>⚠️ ມີ <strong><?= $out_of_stock ?></strong> ສິນຄ້າໝົດສະຕ໋ອກ! ກະລຸນາສັ່ງຊື້ເພີ່ມໂດຍດ່ວນ</span>
        </div>
    <?php endif; ?>

    <!-- Data Table -->
    <div class="data-card">
        <?php if (empty($products)): ?>
                <div class="empty-state">
                    <div class="empty-state-icon"><i class="fas fa-check-circle"></i></div>
                    <h3>ສະຕ໋ອກພຽງພໍ!</h3>
                    <p>ສິນຄ້າທຸກລາຍການມີຈຳນວນຫຼາຍກວ່າ <?= $threshold ?> ຊິ້ນ</p>
                </div>
        <?php else: ?>
                <table class="data-table">
                    <thead>
                        <tr>
                            <th style="width: 60px">#</th>
                            <th>ສິນຄ້າ</th>
                            <th>ປະເພດ</th>
                            <th style="text-align: center">ຈຳນວນຄົງເຫຼືອ</th>
                            <th style="text-align: right">ລາຄາຂາຍ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($products as $i => $p):
                            $rowClass = $p['quantity'] == 0 ? 'row-danger' : ($p['quantity'] <= 5 ? 'row-warning' : '');
                            $badgeClass = $p['quantity'] == 0 ? 'out-of-stock' : ($p['quantity'] <= 5 ? 'critical' : 'warning');
                            ?>
                                <tr class="<?= $rowClass ?>">
                                    <td><span class="row-num"><?= $i + 1 ?></span></td>
                                    <td>
                                        <div class="product-info">
                                            <div class="product-image">
                                                <?php if (!empty($p['product_image'])): ?>
                                                        <img src="<?= htmlspecialchars($p['product_image']) ?>" alt="">
                                                <?php else: ?>
                                                        <i class="fas fa-cube"></i>
                                                <?php endif; ?>
                                            </div>
                                            <div>
                                                <div class="product-name"><?= htmlspecialchars($p['product_name']) ?></div>
                                                <div class="product-code"><?= $p['PR_id'] ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="category-badge">
                                            <i class="fas fa-tag"></i>
                                            <?= $p['category_name'] ?? 'ບໍ່ລະບຸ' ?>
                                        </span>
                                    </td>
                                    <td style="text-align: center">
                                        <span class="stock-badge <?= $badgeClass ?>">
                                            <?php if ($p['quantity'] == 0): ?>
                                                    <i class="fas fa-times-circle"></i> ໝົດ
                                            <?php else: ?>
                                                    <i class="fas fa-cubes"></i> <?= number_format($p['quantity']) ?>
                                            <?php endif; ?>
                                        </span>
                                    </td>
                                    <td style="text-align: right">
                                        <span class="price-amount"><?= number_format($p['selling_price']) ?> ₭</span>
                                    </td>
                                </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
        <?php endif; ?>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>