<?php
$page_title = 'ລາຍງານລາຍຮັບ-ຈ່າຍ';
require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;
if (!$shop_id) {
    echo '<div class="empty-state"><i class="fas fa-store-slash"></i><h4>ກະລຸນາເລືອກຮ້ານກ່ອນ</h4></div>';
    require_once 'includes/footer.php';
    exit;
}

$start = $_GET['start_date'] ?? date('Y-m-01');
$end = $_GET['end_date'] ?? date('Y-m-d');

// Sales from orders
$stmt = $conn->prepare("SELECT SUM(total_amount) as total FROM orders WHERE shop_id = ? AND deleted_at IS NULL AND DATE(created_at) BETWEEN ? AND ?");
$stmt->bind_param("iss", $shop_id, $start, $end);
$stmt->execute();
$sales = $stmt->get_result()->fetch_assoc()['total'] ?? 0;

// Other Income
$stmt = $conn->prepare("SELECT SUM(amount) as total FROM other_income WHERE shop_id = ? AND deleted_at IS NULL AND income_date BETWEEN ? AND ?");
$stmt->bind_param("iss", $shop_id, $start, $end);
$stmt->execute();
$income = $stmt->get_result()->fetch_assoc()['total'] ?? 0;

// Expenses
$stmt = $conn->prepare("SELECT SUM(amount) as total FROM expenses WHERE shop_id = ? AND deleted_at IS NULL AND expense_date BETWEEN ? AND ?");
$stmt->bind_param("iss", $shop_id, $start, $end);
$stmt->execute();
$expenses = $stmt->get_result()->fetch_assoc()['total'] ?? 0;

$totalIncome = $sales + $income;
$profit = $totalIncome - $expenses;
$profitPercent = $totalIncome > 0 ? round(($profit / $totalIncome) * 100, 1) : 0;
?>

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px
    }

    .page-header h1 {
        font-size: 26px;
        font-weight: 700;
        display: flex;
        align-items: center;
        gap: 12px;
        margin: 0
    }

    .page-header h1 i {
        color: var(--accent);
        font-size: 28px
    }

    .filter-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        padding: 24px;
        margin-bottom: 24px;
        display: flex;
        flex-wrap: wrap;
        gap: 16px;
        align-items: flex-end
    }

    .filter-group {
        display: flex;
        flex-direction: column;
        gap: 8px
    }

    .filter-group label {
        font-size: 13px;
        font-weight: 600;
        color: var(--text-secondary)
    }

    .filter-input {
        padding: 12px 16px;
        border: 2px solid var(--border-color);
        border-radius: 10px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 14px;
        transition: all .3s
    }

    .filter-input:focus {
        outline: none;
        border-color: var(--accent);
        box-shadow: 0 0 0 3px rgba(74, 144, 217, .15)
    }

    .btn-search {
        padding: 12px 28px;
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff;
        border: none;
        border-radius: 10px;
        font-weight: 600;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 8px;
        transition: all .3s
    }

    .btn-search:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(74, 144, 217, .4)
    }

    .search-input {
        padding: 12px 16px;
        border: 2px solid var(--border-color);
        border-radius: 25px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 14px;
        width: 280px;
        transition: all .3s
    }

    .search-input:focus {
        outline: none;
        border-color: var(--accent);
        box-shadow: 0 0 0 3px rgba(74, 144, 217, .15)
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 20px;
        margin-bottom: 32px
    }

    .stat-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        padding: 24px;
        position: relative;
        overflow: hidden;
        transition: all .3s
    }

    .stat-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 12px 30px rgba(0, 0, 0, .15)
    }

    .stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px
    }

    .stat-card.sales::before {
        background: linear-gradient(90deg, #3498db, #2ecc71)
    }

    .stat-card.income::before {
        background: linear-gradient(90deg, #9b59b6, #3498db)
    }

    .stat-card.expense::before {
        background: linear-gradient(90deg, #e74c3c, #f39c12)
    }

    .stat-card.profit::before {
        background: linear-gradient(90deg, #27ae60, #2ecc71)
    }

    .stat-card.loss::before {
        background: linear-gradient(90deg, #e74c3c, #c0392b)
    }

    .stat-icon {
        width: 52px;
        height: 52px;
        border-radius: 14px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 22px;
        color: #fff;
        margin-bottom: 16px
    }

    .stat-card.sales .stat-icon {
        background: linear-gradient(135deg, #3498db, #2ecc71)
    }

    .stat-card.income .stat-icon {
        background: linear-gradient(135deg, #9b59b6, #3498db)
    }

    .stat-card.expense .stat-icon {
        background: linear-gradient(135deg, #e74c3c, #f39c12)
    }

    .stat-card.profit .stat-icon {
        background: linear-gradient(135deg, #27ae60, #2ecc71)
    }

    .stat-card.loss .stat-icon {
        background: linear-gradient(135deg, #e74c3c, #c0392b)
    }

    .stat-label {
        font-size: 14px;
        color: var(--text-secondary);
        margin-bottom: 8px;
        font-weight: 500
    }

    .stat-value {
        font-size: 28px;
        font-weight: 700;
        margin: 0
    }

    .stat-value.positive {
        color: #27ae60
    }

    .stat-value.negative {
        color: #e74c3c
    }

    /* Transaction Table Styles */
    .transactions-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 20px;
        overflow: hidden;
        margin-top: 24px
    }

    .transactions-header {
        padding: 20px 28px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 16px
    }

    .transactions-header h3 {
        margin: 0;
        font-size: 18px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .transactions-header h3 i {
        color: var(--accent)
    }

    .transactions-table {
        width: 100%;
        border-collapse: collapse
    }

    .transactions-table th,
    .transactions-table td {
        padding: 14px 16px;
        text-align: left;
        border-bottom: 1px solid var(--border-color)
    }

    .transactions-table th {
        background: rgba(var(--accent-rgb), .1);
        font-weight: 600;
        font-size: 13px;
        color: var(--text-secondary);
        text-transform: uppercase;
        letter-spacing: .5px
    }

    .transactions-table tbody tr:hover {
        background: rgba(var(--accent-rgb), .05)
    }

    .transactions-table tbody tr:last-child td {
        border-bottom: none
    }

    .status-badge {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600
    }

    .status-badge.income {
        background: rgba(39, 174, 96, .15);
        color: #27ae60
    }

    .status-badge.expense {
        background: rgba(231, 76, 60, .15);
        color: #e74c3c
    }

    .status-badge.deposit {
        background: rgba(155, 89, 182, .15);
        color: #9b59b6
    }

    .status-badge.pending {
        background: rgba(241, 196, 15, .15);
        color: #f39c12
    }

    .status-badge.payment {
        background: rgba(52, 152, 219, .15);
        color: #3498db
    }

    .text-right {
        text-align: right
    }

    .text-positive {
        color: #27ae60
    }

    .text-negative {
        color: #e74c3c
    }

    .table-footer {
        padding: 20px 28px;
        background: rgba(var(--accent-rgb), .05);
        border-top: 2px solid var(--border-color)
    }

    .table-footer .totals-row {
        display: flex;
        justify-content: flex-end;
        gap: 40px;
        flex-wrap: wrap
    }

    .table-footer .total-item {
        text-align: right
    }

    .table-footer .total-label {
        font-size: 12px;
        color: var(--text-secondary);
        margin-bottom: 4px
    }

    .table-footer .total-value {
        font-size: 18px;
        font-weight: 700
    }

    .load-more-btn {
        display: block;
        width: 100%;
        padding: 16px;
        background: transparent;
        border: none;
        color: var(--accent);
        font-weight: 600;
        cursor: pointer;
        transition: all .3s
    }

    .load-more-btn:hover {
        background: rgba(var(--accent-rgb), .1)
    }

    .loading-row td {
        text-align: center;
        padding: 40px;
        color: var(--text-secondary)
    }

    .empty-row td {
        text-align: center;
        padding: 40px;
        color: var(--text-secondary)
    }

    @media(max-width:768px) {
        .stats-grid {
            grid-template-columns: repeat(2, 1fr);
            gap: 12px
        }

        .stat-value {
            font-size: 22px
        }

        .filter-card {
            flex-direction: column
        }

        .filter-group {
            width: 100%
        }

        .filter-input,
        .btn-search,
        .search-input {
            width: 100%
        }

        .transactions-table {
            font-size: 13px
        }

        .transactions-table th,
        .transactions-table td {
            padding: 10px 8px
        }
    }
</style>

<div class="page-header">
    <h1><i class="fas fa-chart-pie"></i> ລາຍງານລາຍຮັບ-ຈ່າຍ</h1>
</div>

<form method="GET" class="filter-card" id="filterForm">
    <div class="filter-group">
        <label><i class="fas fa-calendar"></i> ຈາກວັນທີ</label>
        <input type="date" name="start_date" id="start_date" class="filter-input" value="<?= $start ?>">
    </div>
    <div class="filter-group">
        <label>ຫາວັນທີ</label>
        <input type="date" name="end_date" id="end_date" class="filter-input" value="<?= $end ?>">
    </div>
    <button type="submit" class="btn-search">
        <i class="fas fa-search"></i> ຄົ້ນຫາ
    </button>
    <div style="flex-grow:1"></div>
    <input type="text" id="searchInput" class="search-input" placeholder="ຄົ້ນຫາລາຍການ...">
</form>

<div class="stats-grid">
    <div class="stat-card sales">
        <div class="stat-icon"><i class="fas fa-shopping-cart"></i></div>
        <div class="stat-label">ຍອດຂາຍ</div>
        <p class="stat-value"><?= number_format($sales) ?> ₭</p>
    </div>

    <div class="stat-card income">
        <div class="stat-icon"><i class="fas fa-hand-holding-usd"></i></div>
        <div class="stat-label">ລາຍຮັບອື່ນ</div>
        <p class="stat-value"><?= number_format($income) ?> ₭</p>
    </div>

    <div class="stat-card expense">
        <div class="stat-icon"><i class="fas fa-receipt"></i></div>
        <div class="stat-label">ລາຍຈ່າຍ</div>
        <p class="stat-value"><?= number_format($expenses) ?> ₭</p>
    </div>

    <div class="stat-card <?= $profit >= 0 ? 'profit' : 'loss' ?>">
        <div class="stat-icon"><i class="fas fa-chart-line"></i></div>
        <div class="stat-label">ກຳໄລ/ຂາດທຶນ</div>
        <p class="stat-value <?= $profit >= 0 ? 'positive' : 'negative' ?>"><?= number_format($profit) ?> ₭</p>
    </div>
</div>

<!-- Transactions Table -->
<div class="transactions-card">
    <div class="transactions-header">
        <h3><i class="fas fa-list-alt"></i> ລາຍການທັງໝົດ</h3>
        <span id="dateRangeText" style="color:var(--text-secondary);font-size:14px">
            ຊ່ວງວັນທີ: <?= date('d/m/Y', strtotime($start)) ?> - <?= date('d/m/Y', strtotime($end)) ?>
        </span>
    </div>

    <div style="overflow-x:auto">
        <table class="transactions-table">
            <thead>
                <tr>
                    <th>ລຳດັບ</th>
                    <th>ວັນທີ</th>
                    <th>ສະຖານະ</th>
                    <th>ແຫຼ່ງທີ່ມາ</th>
                    <th>ລາຍລະອຽດ</th>
                    <th>ສະກຸນເງິນ</th>
                    <th class="text-right">ຈຳນວນທີ່ຮັບ</th>
                    <th>ອັດຕາແລກປ່ຽນ</th>
                    <th class="text-right">ລາຍຮັບ (LAK)</th>
                    <th class="text-right">ລາຍຈ່າຍ</th>
                    <th class="text-right">ຕົ້ນທຶນ (LAK)</th>
                    <th class="text-right">ກຳໄລ (LAK)</th>
                    <th class="text-right">ກຳໄລສະສົມ</th>
                </tr>
            </thead>
            <tbody id="transactionsBody">
                <tr class="loading-row">
                    <td colspan="13"><i class="fas fa-spinner fa-spin"></i> ກຳລັງໂຫລດຂໍ້ມູນ...</td>
                </tr>
            </tbody>
        </table>
    </div>

    <button type="button" id="loadMoreBtn" class="load-more-btn" style="display:none">
        <i class="fas fa-plus"></i> ໂຫລດຂໍ້ມູນເພີ່ມເຕິມ
    </button>

    <div class="table-footer">
        <div class="totals-row">
            <div class="total-item">
                <div class="total-label">ລວມລາຍຮັບ</div>
                <div class="total-value text-positive" id="totalIncome">0 ₭</div>
            </div>
            <div class="total-item">
                <div class="total-label">ລວມລາຍຈ່າຍ</div>
                <div class="total-value text-negative" id="totalExpense">0 ₭</div>
            </div>
            <div class="total-item">
                <div class="total-label">ລວມຕົ້ນທຶນ</div>
                <div class="total-value" id="totalCost">0 ₭</div>
            </div>
            <div class="total-item">
                <div class="total-label">ກຳໄລສຸດທິ</div>
                <div class="total-value text-positive" id="totalProfit">0 ₭</div>
            </div>
        </div>
    </div>
</div>

<script>
    // State
    let currentOffset = 0;
    const pageSize = 100;
    let isLoading = false;
    let isEndOfData = false;
    let searchTimeout;
    let runningBalance = 0;

    function numberWithCommas(x) {
        if (typeof x !== 'number') x = parseFloat(x);
        if (isNaN(x)) return '0';
        return x.toLocaleString('en-US', { minimumFractionDigits: 0, maximumFractionDigits: 0 });
    }

    function formatDate(dateStr) {
        const date = new Date(dateStr);
        const day = String(date.getDate()).padStart(2, '0');
        const month = String(date.getMonth() + 1).padStart(2, '0');
        const year = date.getFullYear();
        return `${day}/${month}/${year}`;
    }

    function getStatusBadge(transaction) {
        let status, badgeClass;

        if (transaction.source === 'expenses' || transaction.source === 'purchase_orders') {
            status = transaction.source === 'purchase_orders' ? 'ຊື້ສິນຄ້າ' : 'ລາຍຈ່າຍ';
            badgeClass = 'expense';
        } else if (transaction.source === 'pending' || transaction.payment_status === 'pending') {
            status = 'ຍັງບໍ່ຈ່າຍ';
            badgeClass = 'pending';
        } else if (transaction.payment_status === 'was_pending') {
            // Original pending row (order has been paid now, but this keeps the history)
            status = 'ຍັງບໍ່ຈ່າຍ';
            badgeClass = 'pending';
        } else if (transaction.payment_status === 'deposit_paid') {
            // Deposit that has been settled (split from paid order)
            status = 'ມັດຈຳ';
            badgeClass = 'deposit';
        } else if (transaction.source === 'payment_received' || transaction.payment_status === 'payment_received') {
            // Remaining payment received (split from paid order)
            status = 'ຊຳລະເງິນ';
            badgeClass = 'payment';
        } else if (transaction.source === 'deposit' || transaction.payment_status === 'partial') {
            status = 'ມັດຈຳ';
            badgeClass = 'deposit';
        } else if (transaction.source === 'other_income') {
            status = 'ລາຍຮັບ';
            badgeClass = 'income';
        } else {
            status = 'ຊຳລະແລ້ວ';
            badgeClass = 'income';
        }

        return `<span class="status-badge ${badgeClass}">${status}</span>`;
    }

    function formatCurrency(amount, currencySymbol, currencysId) {
        if (!amount || amount <= 0) return '-';
        // USD: 2 decimal places
        if (currencysId === 'CUR_3') {
            return amount.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }) + ' ' + currencySymbol;
        }
        // LAK and others: no decimals
        return numberWithCommas(amount) + ' ' + currencySymbol;
    }

    function renderRow(transaction, index) {
        const incomeAmount = parseFloat(transaction.amount) || 0;
        const incomeAmountLak = parseFloat(transaction.amount_in_lak) || incomeAmount;
        const expenseAmount = parseFloat(transaction.expense_amount) || 0;
        const costAmount = parseFloat(transaction.cost_amount) || 0;
        const currencySymbol = transaction.currency_symbol || '₭';
        const currencyName = transaction.currency_name || 'LAK';
        const currencyRate = parseFloat(transaction.currency_rate) || 1;
        const isForeignCurrency = transaction.is_foreign_currency || false;

        // Calculate profit in LAK
        const profitLak = incomeAmountLak - costAmount;

        // Skip pending and was_pending for balance calculation (but not for purchase_orders)
        const isPending = (transaction.payment_status === 'pending' || transaction.payment_status === 'was_pending' || transaction.source === 'pending')
            && transaction.source !== 'purchase_orders';

        if (!isPending && transaction.source !== 'purchase_orders') {
            runningBalance += (incomeAmountLak - expenseAmount);
        } else if (transaction.source === 'purchase_orders') {
            runningBalance -= expenseAmount;
        }

        // Format exchange rate display
        const exchangeRateDisplay = isForeignCurrency
            ? `1 ${currencyName} = ${numberWithCommas(currencyRate)} ₭`
            : '–';

        // Format received amount display
        const receivedAmountDisplay = incomeAmount > 0
            ? `${numberWithCommas(incomeAmount)} ${currencySymbol}`
            : (expenseAmount > 0 ? `${numberWithCommas(expenseAmount)} ₭` : '–');

        // For pending orders, show all dashes
        if (isPending) {
            return `
            <tr>
                <td>${index}</td>
                <td>${formatDate(transaction.transaction_date)}</td>
                <td>${getStatusBadge(transaction)}</td>
                <td>${transaction.source_type}</td>
                <td>${transaction.details}</td>
                <td>–</td>
                <td class="text-right">–</td>
                <td>–</td>
                <td class="text-right">–</td>
                <td class="text-right">–</td>
                <td class="text-right">–</td>
                <td class="text-right">–</td>
                <td class="text-right">0 ₭</td>
            </tr>
            `;
        }

        // For expenses
        if (transaction.source === 'expenses') {
            return `
            <tr>
                <td>${index}</td>
                <td>${formatDate(transaction.transaction_date)}</td>
                <td>${getStatusBadge(transaction)}</td>
                <td>${transaction.source_type}</td>
                <td>${transaction.details}</td>
                <td>LAK</td>
                <td class="text-right text-negative">${numberWithCommas(expenseAmount)} ₭</td>
                <td>–</td>
                <td class="text-right">–</td>
                <td class="text-right text-negative">${numberWithCommas(expenseAmount)} ₭</td>
                <td class="text-right">–</td>
                <td class="text-right">–</td>
                <td class="text-right ${runningBalance >= 0 ? 'text-positive' : 'text-negative'}">${numberWithCommas(runningBalance)} ₭</td>
            </tr>
            `;
        }

        // For purchase orders
        if (transaction.source === 'purchase_orders') {
            return `
            <tr>
                <td>${index}</td>
                <td>${formatDate(transaction.transaction_date)}</td>
                <td>${getStatusBadge(transaction)}</td>
                <td>${transaction.source_type}</td>
                <td>${transaction.details}</td>
                <td>LAK</td>
                <td class="text-right text-negative">${numberWithCommas(expenseAmount)} ₭</td>
                <td>–</td>
                <td class="text-right">–</td>
                <td class="text-right text-negative">${numberWithCommas(expenseAmount)} ₭</td>
                <td class="text-right">–</td>
                <td class="text-right">–</td>
                <td class="text-right ${runningBalance >= 0 ? 'text-positive' : 'text-negative'}">${numberWithCommas(runningBalance)} ₭</td>
            </tr>
            `;
        }

        // For income (orders, other_income)
        return `
        <tr>
            <td>${index}</td>
            <td>${formatDate(transaction.transaction_date)}</td>
            <td>${getStatusBadge(transaction)}</td>
            <td>${transaction.source_type}</td>
            <td>${transaction.details}</td>
            <td>${currencyName}</td>
            <td class="text-right text-positive">${formatCurrency(incomeAmount, currencySymbol, transaction.currencys_id)}</td>
            <td>${exchangeRateDisplay}</td>
            <td class="text-right text-positive">${numberWithCommas(incomeAmountLak)} ₭</td>
            <td class="text-right">–</td>
            <td class="text-right">${costAmount > 0 ? numberWithCommas(costAmount) + ' ₭' : '–'}</td>
            <td class="text-right ${profitLak > 0 ? 'text-positive' : (profitLak < 0 ? 'text-negative' : '')}">${numberWithCommas(profitLak)} ₭</td>
            <td class="text-right ${runningBalance >= 0 ? 'text-positive' : 'text-negative'}">${numberWithCommas(runningBalance)} ₭</td>
        </tr>
    `;
    }

    function performSearch(searchTerm = '', isLoadMore = false) {
        if (isLoading) return;

        if (!isLoadMore) {
            currentOffset = 0;
            isEndOfData = false;
            runningBalance = 0;
        }

        isLoading = true;

        const tableBody = document.getElementById('transactionsBody');
        const loadMoreBtn = document.getElementById('loadMoreBtn');

        if (!isLoadMore) {
            tableBody.innerHTML = '<tr class="loading-row"><td colspan="13"><i class="fas fa-spinner fa-spin"></i> ກຳລັງໂຫລດຂໍ້ມູນ...</td></tr>';
        }

        // Update date range text
        const searchActive = searchTerm.length > 0;
        const dateRangeText = document.getElementById('dateRangeText');
        if (searchActive) {
            dateRangeText.textContent = 'ຜົນການຄົ້ນຫາ: "' + searchTerm + '"';
        } else {
            const start = document.getElementById('start_date').value;
            const end = document.getElementById('end_date').value;
            if (start && end) {
                const startParts = start.split('-');
                const endParts = end.split('-');
                dateRangeText.textContent = `ຊ່ວງວັນທີ: ${startParts[2]}/${startParts[1]}/${startParts[0]} - ${endParts[2]}/${endParts[1]}/${endParts[0]}`;
            }
        }

        const formData = new FormData();
        formData.append('search_term', searchTerm);
        formData.append('start_date', searchActive ? '' : document.getElementById('start_date').value);
        formData.append('end_date', searchActive ? '' : document.getElementById('end_date').value);
        formData.append('offset', currentOffset);
        formData.append('limit', pageSize);

        fetch('search_transactions.php', {
            method: 'POST',
            body: formData
        })
            .then(response => response.json())
            .then(data => {
                isLoading = false;

                if (data.error) {
                    console.error('Search error:', data.error);
                    tableBody.innerHTML = '<tr class="empty-row"><td colspan="13">ເກີດຂໍ້ຜິດພາດ: ' + data.error + '</td></tr>';
                    return;
                }

                let html = '';
                let startIndex = isLoadMore ? tableBody.querySelectorAll('tr:not(.loading-row):not(.empty-row)').length : 0;

                if (data.transactions && data.transactions.length > 0) {
                    data.transactions.forEach((transaction, index) => {
                        html += renderRow(transaction, startIndex + index + 1);
                    });

                    if (!isLoadMore) {
                        tableBody.innerHTML = html;
                    } else {
                        tableBody.insertAdjacentHTML('beforeend', html);
                    }

                    // Show/hide load more button
                    if (data.transactions.length < pageSize) {
                        isEndOfData = true;
                        loadMoreBtn.style.display = 'none';
                    } else {
                        loadMoreBtn.style.display = 'block';
                    }
                } else {
                    if (!isLoadMore) {
                        tableBody.innerHTML = '<tr class="empty-row"><td colspan="13"><i class="fas fa-inbox"></i> ບໍ່ພົບຂໍ້ມູນ</td></tr>';
                    }
                    loadMoreBtn.style.display = 'none';
                }

                // Update totals
                if (data.totals) {
                    document.getElementById('totalIncome').textContent = numberWithCommas(data.totals.total_income) + ' ₭';
                    document.getElementById('totalExpense').textContent = numberWithCommas(data.totals.total_expense) + ' ₭';
                    document.getElementById('totalCost').textContent = numberWithCommas(data.totals.total_cost) + ' ₭';
                    document.getElementById('totalProfit').textContent = numberWithCommas(data.totals.total_profit) + ' ₭';

                    const profitEl = document.getElementById('totalProfit');
                    if (data.totals.total_profit >= 0) {
                        profitEl.classList.remove('text-negative');
                        profitEl.classList.add('text-positive');
                    } else {
                        profitEl.classList.remove('text-positive');
                        profitEl.classList.add('text-negative');
                    }
                }
            })
            .catch(error => {
                isLoading = false;
                console.error('Search failed:', error);
                tableBody.innerHTML = '<tr class="empty-row"><td colspan="13" style="color:#e74c3c">ເກີດຂໍ້ຜິດພາດໃນການໂຫລດຂໍ້ມູນ</td></tr>';
            });
    }

    // Event Listeners
    document.getElementById('searchInput').addEventListener('keyup', function () {
        const filter = this.value.trim();
        if (searchTimeout) clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => performSearch(filter), 300);
    });

    document.getElementById('filterForm').addEventListener('submit', function (e) {
        e.preventDefault();
        const searchVal = document.getElementById('searchInput').value.trim();
        performSearch(searchVal);
    });

    document.getElementById('loadMoreBtn').addEventListener('click', function () {
        if (!isLoading && !isEndOfData) {
            currentOffset += pageSize;
            const searchVal = document.getElementById('searchInput').value.trim();
            performSearch(searchVal, true);
        }
    });

    // Initial load
    document.addEventListener('DOMContentLoaded', function () {
        performSearch('');
    });
</script>

<?php require_once 'includes/footer.php'; ?>