<?php
$page_title = 'ສິນຄ້າຂາຍດີ';
require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;
if (!$shop_id) {
    echo '<div class="alert alert-danger">ກະລຸນາເລືອກຮ້ານກ່ອນ</div>';
    require_once 'includes/footer.php';
    exit;
}

$start = $_GET['start_date'] ?? date('Y-m-01');
$end = $_GET['end_date'] ?? date('Y-m-d');
$limit = $_GET['limit'] ?? 20;

$stmt = $conn->prepare("SELECT oi.product_name, SUM(oi.quantity) as total_qty, SUM(oi.total) as total_sales, p.PR_id, p.selling_price, p.product_image FROM order_items oi JOIN orders o ON oi.order_id = o.id LEFT JOIN products p ON oi.product_id = p.PR_id WHERE o.shop_id = ? AND o.deleted_at IS NULL AND DATE(o.created_at) BETWEEN ? AND ? GROUP BY oi.product_id, oi.product_name ORDER BY total_qty DESC LIMIT ?");
$stmt->bind_param("issi", $shop_id, $start, $end, $limit);
$stmt->execute();
$products = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Calculate totals
$total_items_sold = array_sum(array_column($products, 'total_qty'));
$total_revenue = array_sum(array_column($products, 'total_sales'));
?>

<style>
/* Report Page Premium Styles */
.report-container {
    padding: 25px;
    animation: fadeIn 0.5s ease-out;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.report-header {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 25px;
}

.report-header-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #FF6B35, #F7931E);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 28px;
    color: white;
    box-shadow: 0 8px 25px rgba(255, 107, 53, 0.3);
}

.report-header-text h1 {
    font-size: 28px;
    font-weight: 700;
    margin-bottom: 5px;
    background: linear-gradient(135deg, #FF6B35, #F7931E);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.report-header-text p {
    color: var(--text-secondary);
    font-size: 14px;
}

/* Stats Cards */
.stats-row {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 25px;
}

.stat-card {
    background: var(--card-bg);
    border: 1px solid var(--border-color);
    border-radius: 16px;
    padding: 20px;
    position: relative;
    overflow: hidden;
    transition: all 0.3s ease;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0, 0, 0, 0.15);
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 4px;
    background: linear-gradient(90deg, var(--accent), var(--accent-light));
}

.stat-card.gold::before { background: linear-gradient(90deg, #FFD700, #FFA500); }
.stat-card.silver::before { background: linear-gradient(90deg, #C0C0C0, #A0A0A0); }
.stat-card.bronze::before { background: linear-gradient(90deg, #CD7F32, #B87333); }

.stat-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 22px;
    margin-bottom: 15px;
}

.stat-icon.gold { background: rgba(255, 215, 0, 0.15); color: #FFD700; }
.stat-icon.silver { background: rgba(192, 192, 192, 0.15); color: #C0C0C0; }
.stat-icon.bronze { background: rgba(205, 127, 50, 0.15); color: #CD7F32; }
.stat-icon.blue { background: rgba(74, 144, 217, 0.15); color: var(--accent); }

.stat-value {
    font-size: 28px;
    font-weight: 700;
    margin-bottom: 5px;
}

.stat-label {
    color: var(--text-secondary);
    font-size: 14px;
}

/* Filter Card */
.filter-card {
    background: var(--card-bg);
    border: 1px solid var(--border-color);
    border-radius: 16px;
    padding: 25px;
    margin-bottom: 25px;
}

.filter-form {
    display: flex;
    flex-wrap: wrap;
    gap: 15px;
    align-items: flex-end;
}

.filter-group {
    flex: 1;
    min-width: 150px;
}

.filter-group label {
    display: block;
    margin-bottom: 8px;
    font-size: 13px;
    font-weight: 600;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.filter-group input,
.filter-group select {
    width: 100%;
    padding: 12px 16px;
    background: var(--bg-secondary);
    border: 1px solid var(--border-color);
    border-radius: 10px;
    color: var(--text-primary);
    font-size: 15px;
    transition: all 0.3s ease;
}

.filter-group input:focus,
.filter-group select:focus {
    outline: none;
    border-color: var(--accent);
    box-shadow: 0 0 0 3px rgba(74, 144, 217, 0.15);
}

.btn-search {
    padding: 12px 30px;
    background: linear-gradient(135deg, var(--accent), var(--accent-light));
    border: none;
    border-radius: 10px;
    color: white;
    font-size: 15px;
    font-weight: 600;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
}

.btn-search:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(74, 144, 217, 0.3);
}

/* Data Table */
.data-card {
    background: var(--card-bg);
    border: 1px solid var(--border-color);
    border-radius: 16px;
    overflow: hidden;
}

.data-table {
    width: 100%;
    border-collapse: collapse;
}

.data-table thead {
    background: var(--bg-secondary);
}

.data-table th {
    padding: 16px 20px;
    text-align: left;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    color: var(--text-secondary);
    border-bottom: 1px solid var(--border-color);
}

.data-table td {
    padding: 16px 20px;
    border-bottom: 1px solid var(--border-color);
    transition: all 0.3s ease;
}

.data-table tbody tr {
    transition: all 0.3s ease;
}

.data-table tbody tr:hover {
    background: var(--bg-secondary);
}

.data-table tbody tr:last-child td {
    border-bottom: none;
}

/* Rank Badges */
.rank-badge {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 36px;
    height: 36px;
    border-radius: 10px;
    font-weight: 700;
    font-size: 14px;
}

.rank-badge.gold {
    background: linear-gradient(135deg, #FFD700, #FFA500);
    color: #5C4300;
    box-shadow: 0 4px 15px rgba(255, 215, 0, 0.4);
}

.rank-badge.silver {
    background: linear-gradient(135deg, #E8E8E8, #C0C0C0);
    color: #555;
    box-shadow: 0 4px 15px rgba(192, 192, 192, 0.4);
}

.rank-badge.bronze {
    background: linear-gradient(135deg, #CD7F32, #B87333);
    color: white;
    box-shadow: 0 4px 15px rgba(205, 127, 50, 0.4);
}

.rank-badge.normal {
    background: var(--bg-secondary);
    color: var(--text-secondary);
}

/* Product Info */
.product-info {
    display: flex;
    align-items: center;
    gap: 12px;
}

.product-image {
    width: 45px;
    height: 45px;
    border-radius: 10px;
    background: var(--bg-secondary);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--text-secondary);
    font-size: 18px;
    overflow: hidden;
}

.product-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.product-name {
    font-weight: 600;
    margin-bottom: 3px;
}

.product-code {
    font-size: 12px;
    color: var(--text-secondary);
    font-family: monospace;
}

/* Quantity Badge */
.qty-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    background: rgba(40, 167, 69, 0.15);
    color: #28A745;
    border-radius: 20px;
    font-weight: 600;
}

/* Sales Amount */
.sales-amount {
    font-weight: 700;
    font-size: 16px;
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 60px 20px;
    color: var(--text-secondary);
}

.empty-state-icon {
    width: 80px;
    height: 80px;
    background: var(--bg-secondary);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 36px;
    margin: 0 auto 20px;
}

.empty-state h3 {
    font-size: 18px;
    margin-bottom: 10px;
}

@media (max-width: 768px) {
    .stats-row {
        grid-template-columns: 1fr 1fr;
    }
    
    .filter-form {
        flex-direction: column;
    }
    
    .filter-group {
        width: 100%;
    }
    
    .data-table {
        display: block;
        overflow-x: auto;
    }
}
</style>

<div class="report-container">
    <!-- Header -->
    <div class="report-header">
        <div class="report-header-icon">
            <i class="fas fa-fire"></i>
        </div>
        <div class="report-header-text">
            <h1>ສິນຄ້າຂາຍດີ</h1>
            <p>ລາຍງານສິນຄ້າຂາຍດີທີ່ສຸດ ຕັ້ງແຕ່ <?= date('d/m/Y', strtotime($start)) ?> - <?= date('d/m/Y', strtotime($end)) ?></p>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="stats-row">
        <div class="stat-card gold">
            <div class="stat-icon gold"><i class="fas fa-trophy"></i></div>
            <div class="stat-value"><?= count($products) ?></div>
            <div class="stat-label">ສິນຄ້າທີ່ຂາຍໄດ້</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon blue"><i class="fas fa-boxes"></i></div>
            <div class="stat-value"><?= number_format($total_items_sold) ?></div>
            <div class="stat-label">ຈຳນວນທີ່ຂາຍໄດ້</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon blue"><i class="fas fa-coins"></i></div>
            <div class="stat-value"><?= number_format($total_revenue) ?> ₭</div>
            <div class="stat-label">ຍອດຂາຍລວມ</div>
        </div>
    </div>

    <!-- Filter -->
    <div class="filter-card">
        <form method="GET" class="filter-form">
            <div class="filter-group">
                <label><i class="fas fa-calendar"></i> ວັນທີເລີ່ມ</label>
                <input type="date" name="start_date" value="<?= $start ?>">
            </div>
            <div class="filter-group">
                <label><i class="fas fa-calendar"></i> ວັນທີສິ້ນສຸດ</label>
                <input type="date" name="end_date" value="<?= $end ?>">
            </div>
            <div class="filter-group">
                <label><i class="fas fa-list-ol"></i> ຈຳນວນ</label>
                <select name="limit">
                    <option value="10" <?= $limit == 10 ? 'selected' : '' ?>>Top 10</option>
                    <option value="20" <?= $limit == 20 ? 'selected' : '' ?>>Top 20</option>
                    <option value="50" <?= $limit == 50 ? 'selected' : '' ?>>Top 50</option>
                    <option value="100" <?= $limit == 100 ? 'selected' : '' ?>>Top 100</option>
                </select>
            </div>
            <button type="submit" class="btn-search">
                <i class="fas fa-search"></i> ຄົ້ນຫາ
            </button>
        </form>
    </div>

    <!-- Data Table -->
    <div class="data-card">
        <?php if (empty($products)): ?>
            <div class="empty-state">
                <div class="empty-state-icon"><i class="fas fa-box-open"></i></div>
                <h3>ບໍ່ມີຂໍ້ມູນ</h3>
                <p>ບໍ່ພົບສິນຄ້າຂາຍໃນຊ່ວງເວລານີ້</p>
            </div>
        <?php else: ?>
            <table class="data-table">
                <thead>
                    <tr>
                        <th style="width: 70px">ອັນດັບ</th>
                        <th>ສິນຄ້າ</th>
                        <th style="text-align: center">ຈຳນວນຂາຍ</th>
                        <th style="text-align: right">ຍອດຂາຍ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($products as $i => $p): 
                        $rankClass = $i === 0 ? 'gold' : ($i === 1 ? 'silver' : ($i === 2 ? 'bronze' : 'normal'));
                    ?>
                        <tr>
                            <td>
                                <span class="rank-badge <?= $rankClass ?>">
                                    <?php if ($i < 3): ?>
                                        <i class="fas fa-trophy"></i>
                                    <?php else: ?>
                                        <?= $i + 1 ?>
                                    <?php endif; ?>
                                </span>
                            </td>
                            <td>
                                <div class="product-info">
                                    <div class="product-image">
                                        <?php if (!empty($p['product_image'])): ?>
                                            <img src="<?= htmlspecialchars($p['product_image']) ?>" alt="">
                                        <?php else: ?>
                                            <i class="fas fa-cube"></i>
                                        <?php endif; ?>
                                    </div>
                                    <div>
                                        <div class="product-name"><?= htmlspecialchars($p['product_name']) ?></div>
                                        <div class="product-code"><?= $p['PR_id'] ?? '-' ?></div>
                                    </div>
                                </div>
                            </td>
                            <td style="text-align: center">
                                <span class="qty-badge">
                                    <i class="fas fa-shopping-cart"></i>
                                    <?= number_format($p['total_qty']) ?>
                                </span>
                            </td>
                            <td style="text-align: right">
                                <span class="sales-amount"><?= number_format($p['total_sales']) ?> ₭</span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>