<?php
$page_title = 'ສ້າງໃບສັ່ງຊື້';

// Handle POST request BEFORE any HTML output
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    @ob_end_clean();
    @ini_set('display_errors', 0);
    @error_reporting(0);
    if (session_status() === PHP_SESSION_NONE)
        @session_start();

    // Try multiple paths for database connection
    $db_paths = [__DIR__ . '/../includes/con_database.php', dirname(__FILE__) . '/../includes/con_database.php', $_SERVER['DOCUMENT_ROOT'] . '/epcommerce/includes/con_database.php'];
    foreach ($db_paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            break;
        }
    }

    $shop_id = $_SESSION['shop_id'] ?? null;
    $user_id = $_SESSION['user_id'] ?? null;

    if ($shop_id) {
        $supplier_name = trim($_POST['supplier_name'] ?? '');
        $order_date = $_POST['order_date'] ?? date('Y-m-d');
        $notes = trim($_POST['notes'] ?? '');
        $items = json_decode($_POST['items'], true);

        if (!empty($items)) {
            $total = array_sum(array_map(fn($i) => $i['qty'] * $i['price'], $items));

            $stmt = $conn->prepare("INSERT INTO purchase_orders (shop_id, supplier_name, order_date, total_amount, notes, status, created_by) VALUES (?, ?, ?, ?, ?, 'pending', ?)");
            $stmt->bind_param("issdsi", $shop_id, $supplier_name, $order_date, $total, $notes, $user_id);
            $stmt->execute();
            $po_id = $conn->insert_id;

            foreach ($items as $item) {
                $stmt2 = $conn->prepare("INSERT INTO purchase_order_items (purchase_order_id, product_id, product_name, quantity_ordered, unit_price, total) VALUES (?, ?, ?, ?, ?, ?)");
                $subtotal = $item['qty'] * $item['price'];
                $stmt2->bind_param("iisidd", $po_id, $item['id'], $item['name'], $item['qty'], $item['price'], $subtotal);
                $stmt2->execute();
            }

            $_SESSION['success'] = 'ສ້າງໃບສັ່ງຊື້ສຳເລັດ';
            header('Location: purchase_history.php');
            exit;
        }
    }
}

require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;
$user_id = $_SESSION['user_id'] ?? null;
?>

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px
    }

    .page-header h1 {
        font-size: 24px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 12px;
        margin: 0
    }

    .page-header h1 i {
        color: var(--accent)
    }

    .po-container {
        display: grid;
        grid-template-columns: 1fr 420px;
        gap: 24px;
    }

    .data-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        overflow: hidden;
    }

    .data-card-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .data-card-header h3 {
        font-size: 18px;
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .data-card-header h3 i {
        color: var(--accent)
    }

    .search-box {
        display: flex;
        align-items: center;
        gap: 8px;
        background: var(--input-bg);
        border: 1px solid var(--border-color);
        border-radius: 10px;
        padding: 12px 16px;
        width: 100%;
        margin-bottom: 16px;
    }

    .search-box input {
        border: none;
        background: transparent;
        outline: none;
        color: var(--text-primary);
        width: 100%;
        font-size: 14px
    }

    .product-list {
        max-height: 500px;
        overflow-y: auto;
        padding: 0 24px 24px;
    }

    .product-item {
        padding: 14px 0;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center;
        gap: 12px;
    }

    .product-item:last-child {
        border-bottom: none
    }

    .product-info strong {
        display: block;
        margin-bottom: 4px
    }

    .product-info small {
        color: var(--text-secondary);
        font-size: 13px
    }

    .btn-add {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: linear-gradient(135deg, #27ae60, #2ecc71);
        color: #fff;
        border: none;
        font-size: 16px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all .2s;
        flex-shrink: 0;
    }

    .btn-add:hover {
        transform: scale(1.1);
        box-shadow: 0 4px 15px rgba(39, 174, 96, .4);
    }

    .order-card {
        position: sticky;
        top: 24px;
    }

    .order-body {
        padding: 24px;
    }

    .form-pro-group {
        margin-bottom: 16px
    }

    .form-pro-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 500
    }

    .form-pro-input {
        width: 100%;
        padding: 12px 14px;
        border: 2px solid var(--border-color);
        border-radius: 10px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 14px;
        transition: all .2s
    }

    .form-pro-input:focus {
        outline: none;
        border-color: var(--accent)
    }

    .order-items {
        max-height: 250px;
        overflow-y: auto;
        margin: 16px 0;
        padding-right: 8px;
    }

    .order-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 10px 0;
        border-bottom: 1px solid var(--border-color);
        gap: 8px;
    }

    .order-item-qty {
        width: 60px;
        padding: 6px 8px;
        border: 1px solid var(--border-color);
        border-radius: 6px;
        background: var(--input-bg);
        color: var(--text-primary);
        text-align: center;
    }

    .btn-remove {
        width: 28px;
        height: 28px;
        border-radius: 6px;
        background: rgba(220, 53, 69, .15);
        color: #dc3545;
        border: none;
        cursor: pointer;
        font-size: 14px;
    }

    .btn-remove:hover {
        background: #dc3545;
        color: #fff;
    }

    .order-total {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 16px 0;
        border-top: 2px solid var(--border-color);
        margin-top: 16px;
    }

    .order-total h3 {
        margin: 0;
        color: var(--accent);
        font-size: 22px;
    }

    .btn-pro {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        width: 100%;
        padding: 14px 24px;
        border-radius: 12px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        transition: all .3s;
        font-size: 15px;
        margin-top: 16px;
    }

    .btn-pro.primary {
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff;
        box-shadow: 0 4px 15px rgba(74, 144, 217, .3)
    }

    .btn-pro.primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(74, 144, 217, .4)
    }

    .empty-order {
        text-align: center;
        padding: 40px 20px;
        color: var(--text-secondary);
    }

    .empty-order i {
        font-size: 48px;
        opacity: .3;
        margin-bottom: 12px;
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: var(--text-secondary)
    }

    .empty-state i {
        font-size: 64px;
        opacity: .3;
        margin-bottom: 20px
    }

    @media (max-width: 991px) {
        .po-container {
            grid-template-columns: 1fr;
        }

        .order-card {
            position: static;
        }
    }
</style>

<?php if (!$shop_id): ?>
    <div class="empty-state"><i class="fas fa-store-slash"></i>
        <h4>ກະລຸນາເລືອກຮ້ານກ່ອນ</h4>
    </div>
<?php else:
    $products = $conn->query("SELECT id, PR_id, product_name, cost_price, quantity FROM products WHERE shop_id = $shop_id AND deleted_at IS NULL ORDER BY product_name")->fetch_all(MYSQLI_ASSOC);
    ?>

    <div class="page-header">
        <h1><i class="fas fa-file-invoice"></i> ສ້າງໃບສັ່ງຊື້ສິນຄ້າ</h1>
        <a href="purchase_history.php" class="btn-pro"
            style="width:auto;background:var(--border-color);color:var(--text-primary)">
            <i class="fas fa-history"></i> ປະຫວັດການສັ່ງຊື້
        </a>
    </div>

    <form method="POST" id="poForm">
        <input type="hidden" name="items" id="itemsData">

        <div class="po-container">
            <!-- Product List -->
            <div class="data-card">
                <div class="data-card-header">
                    <h3><i class="fas fa-box"></i> ລາຍການສິນຄ້າ</h3>
                    <span style="color:var(--text-secondary)"><?= count($products) ?> ລາຍການ</span>
                </div>
                <div style="padding: 16px 24px 0;">
                    <div class="search-box">
                        <i class="fas fa-search"></i>
                        <input type="text" id="searchProduct" placeholder="ຄົ້ນຫາສິນຄ້າ...">
                    </div>
                </div>
                <div class="product-list">
                    <?php foreach ($products as $p): ?>
                        <div class="product-item" data-name="<?= strtolower($p['product_name']) ?>">
                            <div class="product-info">
                                <strong><?= htmlspecialchars($p['product_name']) ?></strong>
                                <small>
                                    <i class="fas fa-tag"></i> <?= number_format($p['cost_price']) ?> ₭
                                    &nbsp;&nbsp;
                                    <i class="fas fa-cubes"></i> ຄົງເຫຼືອ: <?= $p['quantity'] ?>
                                </small>
                            </div>
                            <button type="button" class="btn-add" onclick="addItem(<?= htmlspecialchars(json_encode($p)) ?>)">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- Order Summary -->
            <div class="data-card order-card">
                <div class="data-card-header">
                    <h3><i class="fas fa-shopping-cart"></i> ໃບສັ່ງຊື້</h3>
                </div>
                <div class="order-body">
                    <div class="form-pro-group">
                        <label><i class="fas fa-truck"></i> ຜູ້ສະໜອງ</label>
                        <input type="text" name="supplier_name" class="form-pro-input" placeholder="ຊື່ຜູ້ສະໜອງ/ບໍລິສັດ">
                    </div>
                    <div class="form-pro-group">
                        <label><i class="fas fa-calendar"></i> ວັນທີສັ່ງ</label>
                        <input type="date" name="order_date" class="form-pro-input" value="<?= date('Y-m-d') ?>">
                    </div>
                    <div class="form-pro-group">
                        <label><i class="fas fa-sticky-note"></i> ໝາຍເຫດ</label>
                        <textarea name="notes" class="form-pro-input" rows="2" placeholder="ບັນທຶກເພີ່ມເຕີມ..."></textarea>
                    </div>

                    <div class="order-items" id="poItems">
                        <div class="empty-order">
                            <i class="fas fa-inbox"></i>
                            <p>ກົດ + ເພື່ອເພີ່ມສິນຄ້າ</p>
                        </div>
                    </div>

                    <div class="order-total">
                        <span style="font-size:16px">ລວມທັງໝົດ:</span>
                        <h3><span id="poTotal">0</span> ₭</h3>
                    </div>

                    <button type="submit" class="btn-pro primary">
                        <i class="fas fa-save"></i> ບັນທຶກໃບສັ່ງຊື້
                    </button>
                </div>
            </div>
        </div>
    </form>

<?php endif; ?>

<?php require_once 'includes/footer.php'; ?>

<?php if ($shop_id): ?>
    <script>
        let items = [];

        function addItem(product) {
            const existing = items.find(i => i.id === product.id);
            if (existing) {
                existing.qty++;
            } else {
                items.push({ id: product.id, name: product.product_name, price: parseFloat(product.cost_price), qty: 1 });
            }
            renderItems();
        }

        function renderItems() {
            const container = document.getElementById('poItems');
            if (items.length === 0) {
                container.innerHTML = '<div class="empty-order"><i class="fas fa-inbox"></i><p>ກົດ + ເພື່ອເພີ່ມສິນຄ້າ</p></div>';
            } else {
                container.innerHTML = items.map((item, i) => `
                <div class="order-item">
                    <span style="flex:1;font-weight:500">${item.name}</span>
                    <input type="number" class="order-item-qty" value="${item.qty}" min="1" onchange="updateQty(${i}, this.value)">
                    <span style="min-width:80px;text-align:right">${(item.qty * item.price).toLocaleString()}</span>
                    <button type="button" class="btn-remove" onclick="removeItem(${i})"><i class="fas fa-times"></i></button>
                </div>
            `).join('');
            }
            const total = items.reduce((sum, i) => sum + (i.qty * i.price), 0);
            document.getElementById('poTotal').textContent = total.toLocaleString();
            document.getElementById('itemsData').value = JSON.stringify(items);
        }

        function updateQty(index, qty) { items[index].qty = parseInt(qty) || 1; renderItems(); }
        function removeItem(index) { items.splice(index, 1); renderItems(); }

        document.getElementById('searchProduct').addEventListener('input', function () {
            const q = this.value.toLowerCase();
            document.querySelectorAll('.product-item').forEach(item => {
                item.style.display = item.dataset.name.includes(q) ? '' : 'none';
            });
        });

        document.getElementById('poForm').addEventListener('submit', function (e) {
            if (items.length === 0) {
                e.preventDefault();
                Swal.fire({ icon: 'warning', title: 'ກະລຸນາເພີ່ມສິນຄ້າ', text: 'ບໍ່ມີສິນຄ້າໃນໃບສັ່ງຊື້' });
            }
        });
    </script>
<?php endif; ?>