<?php
$page_title = 'ປະຫວັດການສັ່ງຊື້';

// Handle POST request BEFORE any HTML output
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_status'])) {
    if (session_status() === PHP_SESSION_NONE)
        session_start();
    require_once __DIR__ . '/../includes/con_database.php';

    $shop_id = $_SESSION['shop_id'] ?? null;
    $user_id = $_SESSION['user_id'] ?? null;

    if ($shop_id) {
        $id = (int) $_POST['id'];
        $status = $_POST['status'];

        $stmt = $conn->prepare("UPDATE purchase_orders SET order_status = ?, updated_by = ? WHERE id = ? AND shop_id = ?");
        $stmt->bind_param("siii", $status, $user_id, $id, $shop_id);
        $stmt->execute();

        // If received, update product quantities
        if ($status === 'received') {
            $items = $conn->query("SELECT product_id, quantity FROM purchase_order_items WHERE purchase_order_id = $id")->fetch_all(MYSQLI_ASSOC);
            foreach ($items as $item) {
                $conn->query("UPDATE products SET quantity = quantity + {$item['quantity']} WHERE id = {$item['product_id']}");
            }
        }

        header('Location: purchase_history.php');
        exit;
    }
}

require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;
$user_id = $_SESSION['user_id'] ?? null;

$statusLabels = ['pending' => 'ລໍຖ້າ', 'ordered' => 'ສັ່ງແລ້ວ', 'received' => 'ຮັບແລ້ວ', 'cancelled' => 'ຍົກເລີກ'];
$statusColors = ['pending' => '#ffc107', 'ordered' => '#17a2b8', 'received' => '#28a745', 'cancelled' => '#dc3545'];
?>

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px
    }

    .page-header h1 {
        font-size: 24px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 12px;
        margin: 0
    }

    .page-header h1 i {
        color: var(--accent)
    }

    .btn-pro {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 24px;
        border-radius: 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        transition: all .3s;
        font-size: 14px;
        text-decoration: none
    }

    .btn-pro.primary {
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff;
        box-shadow: 0 4px 15px rgba(74, 144, 217, .3)
    }

    .btn-pro.primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(74, 144, 217, .4)
    }

    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
        gap: 16px;
        margin-bottom: 24px
    }

    .mini-stat {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        padding: 20px;
        display: flex;
        align-items: center;
        gap: 16px
    }

    .mini-stat .icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 18px;
        color: #fff
    }

    .mini-stat .info h3 {
        font-size: 22px;
        margin: 0
    }

    .mini-stat .info p {
        color: var(--text-secondary);
        margin: 0;
        font-size: 13px
    }

    .filter-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        padding: 20px 24px;
        margin-bottom: 24px;
        display: flex;
        gap: 16px;
        align-items: center;
        flex-wrap: wrap;
    }

    .filter-input {
        padding: 12px 16px;
        border: 2px solid var(--border-color);
        border-radius: 10px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 14px;
    }

    .filter-input:focus {
        outline: none;
        border-color: var(--accent);
    }

    .btn-filter {
        padding: 12px 20px;
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff;
        border: none;
        border-radius: 10px;
        font-weight: 600;
        cursor: pointer;
    }

    .data-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        overflow: hidden
    }

    .data-card-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center
    }

    .data-card-header h3 {
        font-size: 18px;
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .data-card-header h3 i {
        color: var(--accent)
    }

    .pro-table {
        width: 100%;
        border-collapse: collapse
    }

    .pro-table th {
        background: rgba(var(--accent-rgb), 0.1);
        padding: 14px 16px;
        text-align: left;
        font-weight: 600;
        font-size: 13px;
        text-transform: uppercase;
        color: var(--text-secondary);
        white-space: nowrap
    }

    .pro-table td {
        padding: 16px;
        border-bottom: 1px solid var(--border-color);
        vertical-align: middle
    }

    .pro-table tbody tr:hover {
        background: rgba(var(--accent-rgb), 0.05)
    }

    .pro-table tbody tr:last-child td {
        border-bottom: none
    }

    .status-badge {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600
    }

    .status-select {
        padding: 8px 12px;
        border: 2px solid var(--border-color);
        border-radius: 8px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 13px;
        cursor: pointer;
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: var(--text-secondary)
    }

    .empty-state i {
        font-size: 64px;
        opacity: .3;
        margin-bottom: 20px
    }

    @media(max-width:768px) {
        .page-header {
            flex-direction: column;
            align-items: flex-start
        }

        .pro-table {
            display: block;
            overflow-x: auto
        }

        .filter-card {
            flex-direction: column;
        }

        .filter-input {
            width: 100%
        }
    }
</style>

<?php if (!$shop_id): ?>
    <div class="empty-state"><i class="fas fa-store-slash"></i>
        <h4>ກະລຸນາເລືອກຮ້ານກ່ອນ</h4>
    </div>
<?php else:
    $start = $_GET['start_date'] ?? date('Y-m-01');
    $end = $_GET['end_date'] ?? date('Y-m-d');

    $stmt = $conn->prepare("SELECT * FROM purchase_orders WHERE shop_id = ? AND deleted_at IS NULL AND order_date BETWEEN ? AND ? ORDER BY created_at ASC");
    $stmt->bind_param("iss", $shop_id, $start, $end);
    $stmt->execute();
    $orders = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

    $total_orders = count($orders);
    $total_amount = array_sum(array_column($orders, 'total_amount'));
    $pending_count = count(array_filter($orders, fn($o) => $o['order_status'] === 'pending'));
    $received_count = count(array_filter($orders, fn($o) => $o['order_status'] === 'received'));
    ?>

    <div class="page-header">
        <h1><i class="fas fa-history"></i> ປະຫວັດການສັ່ງຊື້</h1>
        <a href="purchase_order.php" class="btn-pro primary">
            <i class="fas fa-plus"></i> ສ້າງໃບສັ່ງຊື້ໃໝ່
        </a>
    </div>

    <?php if (isset($_SESSION['success'])): ?>
        <script>Swal.fire({ icon: 'success', title: '<?= $_SESSION['success'] ?>', timer: 2000, showConfirmButton: false })</script>
        <?php unset($_SESSION['success']); endif; ?>

    <div class="stats-row">
        <div class="mini-stat">
            <div class="icon" style="background: linear-gradient(135deg, #3498db, #2980b9)"><i
                    class="fas fa-file-invoice"></i></div>
            <div class="info">
                <h3><?= $total_orders ?></h3>
                <p>ໃບສັ່ງຊື້ທັງໝົດ</p>
            </div>
        </div>
        <div class="mini-stat">
            <div class="icon" style="background: linear-gradient(135deg, #27ae60, #2ecc71)"><i
                    class="fas fa-money-bill-wave"></i></div>
            <div class="info">
                <h3><?= number_format($total_amount) ?></h3>
                <p>ມູນຄ່າລວມ (₭)</p>
            </div>
        </div>
        <div class="mini-stat">
            <div class="icon" style="background: linear-gradient(135deg, #f39c12, #e67e22)"><i class="fas fa-clock"></i>
            </div>
            <div class="info">
                <h3><?= $pending_count ?></h3>
                <p>ລໍຖ້າດຳເນີນການ</p>
            </div>
        </div>
        <div class="mini-stat">
            <div class="icon" style="background: linear-gradient(135deg, #00b894, #00cec9)"><i
                    class="fas fa-check-circle"></i></div>
            <div class="info">
                <h3><?= $received_count ?></h3>
                <p>ຮັບສິນຄ້າແລ້ວ</p>
            </div>
        </div>
    </div>

    <div class="filter-card">
        <form method="GET" style="display:flex;gap:12px;align-items:center;flex-wrap:wrap;width:100%">
            <label style="font-weight:500"><i class="fas fa-calendar"></i> ຈາກວັນທີ:</label>
            <input type="date" name="start_date" class="filter-input" value="<?= $start ?>">
            <label style="font-weight:500">ຫາວັນທີ:</label>
            <input type="date" name="end_date" class="filter-input" value="<?= $end ?>">
            <button type="submit" class="btn-filter"><i class="fas fa-search"></i> ຄົ້ນຫາ</button>
        </form>
    </div>

    <div class="data-card">
        <div class="data-card-header">
            <h3><i class="fas fa-list"></i> ລາຍການໃບສັ່ງຊື້</h3>
        </div>

        <?php if (empty($orders)): ?>
            <div class="empty-state"><i class="fas fa-inbox"></i>
                <h4>ບໍ່ມີຂໍ້ມູນ</h4>
            </div>
        <?php else: ?>
            <div style="overflow-x:auto">
                <table class="pro-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>ລະຫັດ</th>
                            <th>ວັນທີ</th>
                            <th>ຜູ້ສະໜອງ</th>
                            <th>ມູນຄ່າ</th>
                            <th>ສະຖານະ</th>
                            <th>ຈັດການ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($orders as $i => $o): ?>
                            <tr>
                                <td><?= $i + 1 ?></td>
                                <td><code
                                        style="background:rgba(var(--accent-rgb),0.15);padding:4px 10px;border-radius:6px"><?= $o['PO_id'] ?></code>
                                </td>
                                <td><?= date('d/m/Y', strtotime($o['order_date'])) ?></td>
                                <td><strong><?= htmlspecialchars($o['supplier_name'] ?? '-') ?></strong></td>
                                <td><strong style="color:var(--accent)"><?= number_format($o['total_amount']) ?> ₭</strong></td>
                                <td>
                                    <span class="status-badge"
                                        style="background:<?= $statusColors[$o['order_status']] ?>20;color:<?= $statusColors[$o['order_status']] ?>">
                                        <i class="fas fa-circle" style="font-size:8px"></i>
                                        <?= $statusLabels[$o['order_status']] ?>
                                    </span>
                                </td>
                                <td>
                                    <?php if ($o['order_status'] === 'pending'): ?>
                                        <form method="POST" style="display:inline">
                                            <input type="hidden" name="update_status" value="1">
                                            <input type="hidden" name="id" value="<?= $o['id'] ?>">
                                            <select name="status" class="status-select" onchange="this.form.submit()">
                                                <option value="pending" selected>ລໍຖ້າ</option>
                                                <option value="ordered">ສັ່ງແລ້ວ</option>
                                                <option value="received">ຮັບແລ້ວ</option>
                                                <option value="cancelled">ຍົກເລີກ</option>
                                            </select>
                                        </form>
                                    <?php else: ?>
                                        <span style="color:var(--text-secondary)">-</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>

<?php endif; ?>

<?php require_once 'includes/footer.php'; ?>