<?php
$page_title = 'ສິນຄ້າ';

// Handle AJAX requests BEFORE any HTML output
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    @ob_end_clean();
    @ini_set('display_errors', 0);
    @error_reporting(0);
    if (session_status() === PHP_SESSION_NONE)
        @session_start();

    // Try multiple paths for database connection
    $db_paths = [__DIR__ . '/../includes/con_database.php', dirname(__FILE__) . '/../includes/con_database.php', $_SERVER['DOCUMENT_ROOT'] . '/epcommerce/includes/con_database.php'];
    foreach ($db_paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            break;
        }
    }
    require_once __DIR__ . '/../includes/secondary_ids.php';

    header('Content-Type: application/json');

    $shop_id = $_SESSION['shop_id'] ?? null;
    $user_id = $_SESSION['user_id'] ?? null;
    $user_secondary_id = getUserSecondaryId($conn, $user_id);
    $action = $_POST['action'] ?? '';

    if (!$shop_id) {
        echo json_encode(['success' => false, 'message' => 'ກະລຸນາເລືອກຮ້ານກ່ອນ']);
        exit;
    }

    if ($action === 'add') {
        $cat = $_POST['category_id'] ?: null;
        $unit = $_POST['unit_id'] ?: null;
        $color = $_POST['color_id'] ?: null;
        $rep_price = $_POST['representative_price'] ?: null;

        // Handle image upload
        $image_path = null;
        if (isset($_FILES['product_image']) && $_FILES['product_image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = __DIR__ . '/img/products/';
            if (!is_dir($upload_dir))
                mkdir($upload_dir, 0755, true);

            $ext = strtolower(pathinfo($_FILES['product_image']['name'], PATHINFO_EXTENSION));
            $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            if (in_array($ext, $allowed)) {
                $filename = 'product_' . time() . '_' . uniqid() . '.' . $ext;
                if (move_uploaded_file($_FILES['product_image']['tmp_name'], $upload_dir . $filename)) {
                    $image_path = 'img/products/' . $filename;
                }
            }
        }

        // Debug - log image upload info
        $qty = floatval($_POST['quantity'] ?? 0);
        $cost = floatval($_POST['cost_price'] ?? 0);
        $selling = floatval($_POST['selling_price'] ?? 0);
        $rep = $rep_price !== null ? floatval($rep_price) : null;

        $stmt = $conn->prepare("INSERT INTO products (shop_id, product_name, product_code, barcode, category_id, unit_id, color_id, quantity, cost_price, selling_price, representative_price, product_image, description, created_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("isssiiiidddsss", $shop_id, $_POST['product_name'], $_POST['product_code'], $_POST['barcode'], $cat, $unit, $color, $qty, $cost, $selling, $rep, $image_path, $_POST['description'], $user_secondary_id);
        $result = $stmt->execute();
        if (!$result) {
            echo json_encode(['success' => false, 'message' => 'DB Error: ' . $stmt->error]);
        } else {
            echo json_encode(['success' => true, 'message' => 'ເພີ່ມສິນຄ້າສຳເລັດ', 'debug_image' => $image_path]);
        }
        exit;
    }

    if ($action === 'edit') {
        $cat = $_POST['category_id'] ?: null;
        $unit = $_POST['unit_id'] ?: null;
        $color = $_POST['color_id'] ?: null;
        $rep_price = $_POST['representative_price'] ?: null;

        // Handle image upload
        $image_path = $_POST['existing_image'] ?? null;
        if (isset($_FILES['product_image']) && $_FILES['product_image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = __DIR__ . '/img/products/';
            if (!is_dir($upload_dir))
                mkdir($upload_dir, 0755, true);

            $ext = strtolower(pathinfo($_FILES['product_image']['name'], PATHINFO_EXTENSION));
            $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            if (in_array($ext, $allowed)) {
                $filename = 'product_' . time() . '_' . uniqid() . '.' . $ext;
                if (move_uploaded_file($_FILES['product_image']['tmp_name'], $upload_dir . $filename)) {
                    // Delete old image if exists
                    if ($image_path && file_exists(__DIR__ . '/' . $image_path)) {
                        @unlink(__DIR__ . '/' . $image_path);
                    }
                    $image_path = 'img/products/' . $filename;
                }
            }
        }

        // Convert to proper types
        $qty = floatval($_POST['quantity'] ?? 0);
        $cost = floatval($_POST['cost_price'] ?? 0);
        $selling = floatval($_POST['selling_price'] ?? 0);
        $rep = $rep_price !== null ? floatval($rep_price) : null;
        $prod_id = intval($_POST['id']);

        $stmt = $conn->prepare("UPDATE products SET product_name = ?, product_code = ?, barcode = ?, category_id = ?, unit_id = ?, color_id = ?, quantity = ?, cost_price = ?, selling_price = ?, representative_price = ?, product_image = ?, description = ?, updated_by = ? WHERE id = ? AND shop_id = ?");
        $stmt->bind_param("sssiiiddddsssii", $_POST['product_name'], $_POST['product_code'], $_POST['barcode'], $cat, $unit, $color, $qty, $cost, $selling, $rep, $image_path, $_POST['description'], $user_secondary_id, $prod_id, $shop_id);
        $result = $stmt->execute();
        if (!$result) {
            echo json_encode(['success' => false, 'message' => 'DB Error: ' . $stmt->error]);
        } else {
            echo json_encode(['success' => true, 'message' => 'ແກ້ໄຂສຳເລັດ', 'debug_image' => $image_path]);
        }
        exit;
    }

    if ($action === 'delete') {
        $stmt = $conn->prepare("UPDATE products SET deleted_at = NOW(), deleted_by = ? WHERE id = ? AND shop_id = ?");
        $stmt->bind_param("sii", $user_secondary_id, $_POST['id'], $shop_id);
        echo json_encode(['success' => $stmt->execute(), 'message' => 'ລຶບສຳເລັດ']);
        exit;
    }

    // Quick add category
    if ($action === 'quick_add_category') {
        $name = trim($_POST['name'] ?? '');
        if (!$name) {
            echo json_encode(['success' => false, 'message' => 'ກະລຸນາປ້ອນຊື່']);
            exit;
        }
        $stmt = $conn->prepare("INSERT INTO product_categories (shop_id, category_name, created_by) VALUES (?, ?, ?)");
        $stmt->bind_param("iss", $shop_id, $name, $user_secondary_id);
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'id' => $conn->insert_id]);
        } else {
            echo json_encode(['success' => false, 'message' => $stmt->error]);
        }
        exit;
    }

    // Quick add unit
    if ($action === 'quick_add_unit') {
        $name = trim($_POST['name'] ?? '');
        if (!$name) {
            echo json_encode(['success' => false, 'message' => 'ກະລຸນາປ້ອນຊື່']);
            exit;
        }
        $stmt = $conn->prepare("INSERT INTO units (shop_id, unit_name, created_by) VALUES (?, ?, ?)");
        $stmt->bind_param("iss", $shop_id, $name, $user_secondary_id);
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'id' => $conn->insert_id]);
        } else {
            echo json_encode(['success' => false, 'message' => $stmt->error]);
        }
        exit;
    }

    // Quick add color
    if ($action === 'quick_add_color') {
        $name = trim($_POST['name'] ?? '');
        $color_code = $_POST['color_code'] ?? '#000000';
        if (!$name) {
            echo json_encode(['success' => false, 'message' => 'ກະລຸນາປ້ອນຊື່']);
            exit;
        }
        $stmt = $conn->prepare("INSERT INTO colors (shop_id, color_name, color_code, created_by) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("isss", $shop_id, $name, $color_code, $user_secondary_id);
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'id' => $conn->insert_id]);
        } else {
            echo json_encode(['success' => false, 'message' => $stmt->error]);
        }
        exit;
    }
}

require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;
$user_id = $_SESSION['user_id'] ?? null;

$products = $cats = $units = $colors = [];
if ($shop_id) {
    $search = $_GET['q'] ?? '';
    $sql = "SELECT p.*, c.category_name, u.unit_name FROM products p LEFT JOIN product_categories c ON p.category_id=c.id LEFT JOIN units u ON p.unit_id=u.id WHERE p.shop_id = ? AND p.deleted_at IS NULL";
    if ($search)
        $sql .= " AND (p.product_name LIKE ? OR p.product_code LIKE ? OR p.barcode LIKE ?)";
    $sql .= " ORDER BY p.created_at ASC";

    $stmt = $conn->prepare($sql);
    if ($search) {
        $s = "%$search%";
        $stmt->bind_param("isss", $shop_id, $s, $s, $s);
    } else {
        $stmt->bind_param("i", $shop_id);
    }
    $stmt->execute();
    $products = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

    $cats = $conn->query("SELECT id, category_name FROM product_categories WHERE shop_id = $shop_id AND deleted_at IS NULL")->fetch_all(MYSQLI_ASSOC);
    $units = $conn->query("SELECT id, unit_name FROM units WHERE shop_id = $shop_id AND deleted_at IS NULL")->fetch_all(MYSQLI_ASSOC);
    $colors = $conn->query("SELECT id, color_name, color_code FROM colors WHERE shop_id = $shop_id AND deleted_at IS NULL")->fetch_all(MYSQLI_ASSOC);
}
$totalStock = array_sum(array_column($products, 'quantity'));
?>

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px
    }

    .page-header h1 {
        font-size: 24px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 12px;
        margin: 0
    }

    .page-header h1 i {
        color: var(--accent)
    }

    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
        gap: 16px;
        margin-bottom: 24px
    }

    .mini-stat {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        padding: 20px;
        display: flex;
        align-items: center;
        gap: 16px
    }

    .mini-stat .icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        color: #fff
    }

    .mini-stat .icon.blue {
        background: linear-gradient(135deg, #4A90D9, #2D5A87)
    }

    .mini-stat .icon.green {
        background: linear-gradient(135deg, #28a745, #1e7e34)
    }

    .mini-stat .icon.orange {
        background: linear-gradient(135deg, #fd7e14, #dc6a00)
    }

    .mini-stat .info h3 {
        font-size: 24px;
        margin: 0
    }

    .mini-stat .info p {
        color: var(--text-secondary);
        margin: 0;
        font-size: 13px
    }

    .data-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        overflow: hidden
    }

    .data-card-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 16px
    }

    .search-box {
        display: flex;
        align-items: center;
        gap: 8px;
        background: var(--input-bg);
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 8px 12px;
        width: 300px;
        max-width: 100%
    }

    .search-box input {
        border: none;
        background: transparent;
        outline: none;
        color: var(--text-primary);
        width: 100%;
        font-size: 14px
    }

    .pro-table {
        width: 100%;
        border-collapse: collapse
    }

    .pro-table th {
        background: rgba(var(--accent-rgb), 0.1);
        padding: 14px 16px;
        text-align: left;
        font-weight: 600;
        font-size: 13px;
        text-transform: uppercase;
        color: var(--text-secondary);
        white-space: nowrap
    }

    .pro-table td {
        padding: 16px;
        border-bottom: 1px solid var(--border-color);
        vertical-align: middle
    }

    .pro-table tbody tr:hover {
        background: rgba(var(--accent-rgb), 0.05)
    }

    .action-btns {
        display: flex;
        gap: 8px
    }

    .btn-icon {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        border: none;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all .2s;
        font-size: 14px
    }

    .btn-icon.edit {
        background: rgba(255, 193, 7, .15);
        color: #ffc107
    }

    .btn-icon.edit:hover {
        background: #ffc107;
        color: #000
    }

    .btn-icon.delete {
        background: rgba(220, 53, 69, .15);
        color: #dc3545
    }

    .btn-icon.delete:hover {
        background: #dc3545;
        color: #fff
    }

    .btn-pro {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 24px;
        border-radius: 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        transition: all .3s;
        font-size: 14px
    }

    .btn-pro.primary {
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff;
        box-shadow: 0 4px 15px rgba(74, 144, 217, .3)
    }

    .pro-modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, .6);
        backdrop-filter: blur(4px);
        z-index: 9999;
        align-items: center;
        justify-content: center;
        padding: 20px
    }

    .pro-modal.show {
        display: flex
    }

    .pro-modal-content {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 20px;
        width: 100%;
        max-width: 650px;
        max-height: 90vh;
        overflow-y: auto;
        animation: modalSlide .3s ease
    }

    @keyframes modalSlide {
        from {
            opacity: 0;
            transform: translateY(-20px) scale(.95)
        }

        to {
            opacity: 1;
            transform: translateY(0) scale(1)
        }
    }

    .pro-modal-header {
        padding: 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center
    }

    .pro-modal-header h3 {
        margin: 0;
        font-size: 20px;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .pro-modal-header h3 i {
        color: var(--accent)
    }

    .pro-modal-close {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        border: none;
        background: rgba(255, 255, 255, .1);
        color: var(--text-secondary);
        cursor: pointer;
        font-size: 18px
    }

    .pro-modal-body {
        padding: 24px
    }

    .pro-modal-footer {
        padding: 20px 24px;
        border-top: 1px solid var(--border-color);
        display: flex;
        gap: 12px;
        justify-content: flex-end
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 16px
    }

    .form-row-2 {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 16px
    }

    .form-pro-group {
        margin-bottom: 20px
    }

    .form-pro-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 500
    }

    .form-pro-group label span {
        color: #dc3545
    }

    .form-pro-input {
        width: 100%;
        padding: 14px 16px;
        border: 2px solid var(--border-color);
        border-radius: 10px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 15px;
        transition: all .2s
    }

    .form-pro-input:focus {
        outline: none;
        border-color: var(--accent)
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: var(--text-secondary)
    }

    .empty-state i {
        font-size: 64px;
        opacity: .3;
        margin-bottom: 20px
    }

    .stock-low {
        color: #dc3545;
        font-weight: 600
    }

    .stock-ok {
        color: #28a745
    }

    .price-tag {
        background: rgba(40, 167, 69, .1);
        color: #28a745;
        padding: 4px 10px;
        border-radius: 6px;
        font-weight: 600
    }

    @media(max-width:768px) {
        .page-header {
            flex-direction: column;
            align-items: flex-start
        }

        .search-box {
            width: 100%
        }

        .pro-table {
            display: block;
            overflow-x: auto
        }

        .form-row,
        .form-row-2 {
            grid-template-columns: 1fr
        }
    }

    .quick-add-btn-inline {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 20px;
        height: 20px;
        border-radius: 50%;
        border: 1px solid var(--accent);
        background: transparent;
        color: var(--accent);
        font-size: 10px;
        cursor: pointer;
        margin-left: 6px;
        transition: all .2s;
        vertical-align: middle;
    }

    .quick-add-btn-inline:hover {
        background: var(--accent);
        color: #fff;
    }
</style>

<?php if (!$shop_id): ?>
    <div class="empty-state"><i class="fas fa-store-slash"></i>
        <h4>ກະລຸນາເລືອກຮ້ານກ່ອນ</h4>
    </div>
<?php else: ?>

    <div class="page-header">
        <h1><i class="fas fa-box"></i> ສິນຄ້າ</h1>
        <button class="btn-pro primary" onclick="openModal('add')"><i class="fas fa-plus"></i> ເພີ່ມສິນຄ້າໃໝ່</button>
    </div>

    <div class="stats-row">
        <div class="mini-stat">
            <div class="icon blue"><i class="fas fa-box"></i></div>
            <div class="info">
                <h3><?= count($products) ?></h3>
                <p>ສິນຄ້າທັງໝົດ</p>
            </div>
        </div>
        <div class="mini-stat">
            <div class="icon green"><i class="fas fa-cubes"></i></div>
            <div class="info">
                <h3><?= number_format($totalStock) ?></h3>
                <p>ຈຳນວນຄົງເຫຼືອ</p>
            </div>
        </div>
        <div class="mini-stat">
            <div class="icon orange"><i class="fas fa-exclamation-triangle"></i></div>
            <div class="info">
                <h3><?= count(array_filter($products, fn($p) => $p['quantity'] <= 10)) ?></h3>
                <p>ໃກ້ຈະໝົດ</p>
            </div>
        </div>
    </div>

    <div class="data-card">
        <div class="data-card-header">
            <h3><i class="fas fa-list"></i> ລາຍການສິນຄ້າ</h3>
            <form method="GET" class="search-box"><i class="fas fa-search"></i><input type="text" name="q"
                    placeholder="ຄົ້ນຫາສິນຄ້າ..." value="<?= htmlspecialchars($_GET['q'] ?? '') ?>"></form>
        </div>

        <?php if (empty($products)): ?>
            <div class="empty-state"><i class="fas fa-inbox"></i>
                <h4>ຍັງບໍ່ມີສິນຄ້າ</h4>
            </div>
        <?php else: ?>
            <div style="overflow-x:auto">
                <table class="pro-table" id="dataTable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>ຮູບ</th>
                            <th></th>ລະຫັດ</th>
                            <th>ສິນຄ້າ</th>
                            <th>ປະເພດ</th>
                            <th>ຈຳນວນ</th>
                            <th>ລາຄາທຶນ</th>
                            <th>ລາຄາຂາຍ</th>
                            <th>ຈັດການ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($products as $i => $p): ?>
                            <tr>
                                <td><?= $i + 1 ?></td>
                                <td>
                                    <?php if (!empty($p['product_image'])): ?>
                                        <img src="<?= htmlspecialchars($p['product_image']) ?>" alt=""
                                            style="width:50px;height:50px;object-fit:cover;border-radius:8px;">
                                    <?php else: ?>
                                        <div
                                            style="width:50px;height:50px;background:var(--border-color);border-radius:8px;display:flex;align-items:center;justify-content:center;">
                                            <i class="fas fa-image" style="color:var(--text-secondary);opacity:0.3;"></i>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td><code
                                        style="background:rgba(var(--accent-rgb),0.1);color:var(--accent);padding:4px 10px;border-radius:6px;font-size:11px"><?= $p['PR_id'] ?></code>
                                </td>
                                <td><strong><?= htmlspecialchars($p['product_name']) ?></strong><?php if ($p['product_code']): ?><br><small
                                            style="color:var(--text-secondary)"><?= $p['product_code'] ?></small><?php endif; ?></td>
                                <td><?= $p['category_name'] ?? '-' ?></td>
                                <td class="<?= $p['quantity'] <= 10 ? 'stock-low' : 'stock-ok' ?>">
                                    <?= number_format($p['quantity']) ?>             <?php if ($p['unit_name']): ?>
                                        <?= $p['unit_name'] ?>             <?php endif; ?>
                                </td>
                                <td><?= number_format($p['cost_price']) ?></td>
                                <td><span class="price-tag"><?= number_format($p['selling_price']) ?></span></td>
                                <td>
                                    <div class="action-btns">
                                        <button class="btn-icon edit"
                                            onclick="openModal('edit', <?= htmlspecialchars(json_encode($p)) ?>)"><i
                                                class="fas fa-pen"></i></button>
                                        <button class="btn-icon delete"
                                            onclick="confirmDelete(<?= $p['id'] ?>, '<?= htmlspecialchars($p['product_name']) ?>')"><i
                                                class="fas fa-trash"></i></button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>

    <div class="pro-modal" id="formModal">
        <div class="pro-modal-content">
            <div class="pro-modal-header">
                <h3><i class="fas fa-box"></i> <span id="modalTitle">ເພີ່ມສິນຄ້າ</span></h3>
                <button class="pro-modal-close" onclick="closeModal()">&times;</button>
            </div>
            <form id="dataForm" enctype="multipart/form-data">
                <div class="pro-modal-body">
                    <input type="hidden" name="action" id="formAction" value="add">
                    <input type="hidden" name="id" id="formId">
                    <input type="hidden" name="existing_image" id="existing_image">

                    <!-- Image Upload -->
                    <div class="form-pro-group">
                        <label>ຮູບສິນຄ້າ</label>
                        <div style="display:flex;gap:16px;align-items:flex-start;">
                            <div id="imagePreview"
                                style="width:120px;height:120px;border:2px dashed var(--border-color);border-radius:12px;display:flex;align-items:center;justify-content:center;overflow:hidden;background:var(--input-bg);">
                                <i class="fas fa-image" style="font-size:32px;color:var(--text-secondary);opacity:0.5;"></i>
                            </div>
                            <div style="flex:1;">
                                <input type="file" name="product_image" id="product_image" accept="image/*"
                                    style="display:none;" onchange="previewImage(this)">
                                <button type="button" onclick="document.getElementById('product_image').click()"
                                    class="btn-pro" style="background:var(--accent);color:#fff;margin-bottom:8px;">
                                    <i class="fas fa-upload"></i> ເລືອກຮູບ
                                </button>
                                <p style="color:var(--text-secondary);font-size:12px;margin:0;">JPG, PNG, GIF, WebP (ແນະນຳ
                                    300x300px)</p>
                            </div>
                        </div>
                    </div>

                    <div class="form-pro-group">
                        <label>ຊື່ສິນຄ້າ <span>*</span></label>
                        <input type="text" name="product_name" id="product_name" class="form-pro-input" required>
                    </div>

                    <div class="form-row-2">
                        <div class="form-pro-group"><label>ລະຫັດສິນຄ້າ</label><input type="text" name="product_code"
                                id="product_code" class="form-pro-input"></div>
                        <div class="form-pro-group"><label>Barcode</label><input type="text" name="barcode" id="barcode"
                                class="form-pro-input"></div>
                    </div>

                    <div class="form-row">
                        <!-- Category with Quick Add -->
                        <div class="form-pro-group">
                            <label>ປະເພດ <button type="button" onclick="quickAdd('category')" class="quick-add-btn-inline"
                                    title="ເພີ່ມໃໝ່"><i class="fas fa-plus"></i></button></label>
                            <select name="category_id" id="category_id" class="form-pro-input">
                                <option value="">-</option><?php foreach ($cats as $c): ?>
                                    <option value="<?= $c['id'] ?>"><?= $c['category_name'] ?></option><?php endforeach; ?>
                            </select>
                        </div>
                        <!-- Unit with Quick Add -->
                        <div class="form-pro-group">
                            <label>ຫົວໜ່ວຍ <button type="button" onclick="quickAdd('unit')" class="quick-add-btn-inline"
                                    title="ເພີ່ມໃໝ່"><i class="fas fa-plus"></i></button></label>
                            <select name="unit_id" id="unit_id" class="form-pro-input">
                                <option value="">-</option><?php foreach ($units as $u): ?>
                                    <option value="<?= $u['id'] ?>"><?= $u['unit_name'] ?></option><?php endforeach; ?>
                            </select>
                        </div>
                        <!-- Color with Quick Add and Color Swatch -->
                        <div class="form-pro-group">
                            <label>ສີ <button type="button" onclick="quickAdd('color')" class="quick-add-btn-inline"
                                    title="ເພີ່ມໃໝ່"><i class="fas fa-plus"></i></button></label>
                            <select name="color_id" id="color_id" class="form-pro-input">
                                <option value="">-</option><?php foreach ($colors as $c): ?>
                                    <option value="<?= $c['id'] ?>" data-color="<?= $c['color_code'] ?? '' ?>">
                                        <?= $c['color_name'] ?>
                                    </option><?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-pro-group"><label>ຈຳນວນ</label><input type="number" name="quantity" id="quantity"
                                class="form-pro-input" value="0"></div>
                        <div class="form-pro-group"><label>ລາຄາທຶນ</label><input type="number" name="cost_price"
                                id="cost_price" class="form-pro-input" value="0"></div>
                        <div class="form-pro-group"><label>ລາຄາຂາຍ</label><input type="number" name="selling_price"
                                id="selling_price" class="form-pro-input" value="0"></div>
                    </div>

                    <div class="form-row-2">
                        <div class="form-pro-group"><label>ລາຄາຕົວແທນ</label><input type="number"
                                name="representative_price" id="representative_price" class="form-pro-input" value="0"
                                placeholder="ລາຄາສຳລັບຕົວແທນ"></div>
                        <div class="form-pro-group"></div>
                    </div>

                    <div class="form-pro-group"><label>ລາຍລະອຽດ</label><textarea name="description" id="description"
                            class="form-pro-input" rows="2"></textarea></div>
                </div>
                <div class="pro-modal-footer">
                    <button type="button" class="btn-pro" style="background:var(--border-color);color:var(--text-primary)"
                        onclick="closeModal()">ຍົກເລີກ</button>
                    <button type="submit" class="btn-pro primary"><i class="fas fa-save"></i> ບັນທຶກ</button>
                </div>
            </form>
        </div>
    </div>

<?php endif; ?>
<?php require_once 'includes/footer.php'; ?>

<?php if ($shop_id): ?>
    <script>
        function openModal(mode, data = null) {
            document.getElementById('dataForm').reset();
            document.getElementById('formId').value = '';
            document.getElementById('existing_image').value = '';
            // Reset image preview
            document.getElementById('imagePreview').innerHTML = '<i class="fas fa-image" style="font-size:32px;color:var(--text-secondary);opacity:0.5;"></i>';

            if (mode === 'add') {
                document.getElementById('modalTitle').textContent = 'ເພີ່ມສິນຄ້າໃໝ່';
                document.getElementById('formAction').value = 'add';
            } else {
                document.getElementById('modalTitle').textContent = 'ແກ້ໄຂສິນຄ້າ';
                document.getElementById('formAction').value = 'edit';
                document.getElementById('formId').value = data.id;
                document.getElementById('product_name').value = data.product_name;
                document.getElementById('product_code').value = data.product_code || '';
                document.getElementById('barcode').value = data.barcode || '';
                document.getElementById('category_id').value = data.category_id || '';
                document.getElementById('unit_id').value = data.unit_id || '';
                document.getElementById('color_id').value = data.color_id || '';
                document.getElementById('quantity').value = data.quantity;
                document.getElementById('cost_price').value = data.cost_price;
                document.getElementById('selling_price').value = data.selling_price;
                document.getElementById('representative_price').value = data.representative_price || 0;
                document.getElementById('description').value = data.description || '';
                document.getElementById('existing_image').value = data.product_image || '';

                // Show existing image
                if (data.product_image) {
                    document.getElementById('imagePreview').innerHTML = `<img src="${data.product_image}" style="width:100%;height:100%;object-fit:cover;">`;
                }
            }
            document.getElementById('formModal').classList.add('show');
        }

        function closeModal() { document.getElementById('formModal').classList.remove('show'); }
        document.getElementById('formModal').addEventListener('click', function (e) { if (e.target === this) closeModal(); });

        document.getElementById('dataForm').addEventListener('submit', async function (e) {
            e.preventDefault();
            closeModal();
            Swal.fire({ title: 'ກຳລັງບັນທຶກ...', text: 'ກະລຸນາລໍຖ້າ', allowOutsideClick: false, showConfirmButton: false, didOpen: () => Swal.showLoading() });
            try {
                const response = await fetch('products.php', { method: 'POST', body: new FormData(this) });
                const data = await response.json();
                if (data.success) {
                    await Swal.fire({ icon: 'success', title: 'ສຳເລັດ!', timer: 1500, timerProgressBar: true, showConfirmButton: false });
                    location.reload();
                } else {
                    Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: data.message });
                }
            } catch (error) {
                Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: 'ການເຊື່ອມຕໍ່ມີປັນຫາ' });
            }
        });

        async function confirmDelete(id, name) {
            const result = await Swal.fire({
                title: 'ຢືນຢັນການລຶບ?', html: `ລຶບສິນຄ້າ <strong>"${name}"</strong> ແທ້ບໍ?`, icon: 'warning',
                showCancelButton: true, confirmButtonColor: '#dc3545', confirmButtonText: '<i class="fas fa-trash"></i> ລຶບ', cancelButtonText: 'ຍົກເລີກ', reverseButtons: true
            });
            if (result.isConfirmed) {
                Swal.fire({ title: 'ກຳລັງລຶບ...', allowOutsideClick: false, showConfirmButton: false, didOpen: () => Swal.showLoading() });
                try {
                    const fd = new FormData(); fd.append('action', 'delete'); fd.append('id', id);
                    const response = await fetch('products.php', { method: 'POST', body: fd });
                    const data = await response.json();
                    if (data.success) {
                        await Swal.fire({ icon: 'success', title: 'ລຶບສຳເລັດ!', timer: 1500, showConfirmButton: false });
                        location.reload();
                    } else {
                        Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: data.message });
                    }
                } catch (error) {
                    Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: 'ການເຊື່ອມຕໍ່ມີປັນຫາ' });
                }
            }
        }

        // Image preview function
        function previewImage(input) {
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    document.getElementById('imagePreview').innerHTML = `<img src="${e.target.result}" style="width:100%;height:100%;object-fit:cover;">`;
                };
                reader.readAsDataURL(input.files[0]);
            }
        }

        // Quick add for category/unit/color
        async function quickAdd(type) {
            const labels = { category: 'ປະເພດ', unit: 'ຫົວໜ່ວຍ', color: 'ສີ' };
            const isColor = type === 'color';

            const htmlContent = isColor ? `
                <input id="swal-name" class="swal2-input" placeholder="ຊື່${labels[type]}">
                <input id="swal-color" type="color" class="swal2-input" value="#4A90D9" style="height:50px;padding:5px;">
            ` : `<input id="swal-name" class="swal2-input" placeholder="ຊື່${labels[type]}">`;

            const { isConfirmed, value } = await Swal.fire({
                title: `ເພີ່ມ${labels[type]}ໃໝ່`,
                html: htmlContent,
                showCancelButton: true,
                confirmButtonText: '<i class="fas fa-plus"></i> ເພີ່ມ',
                cancelButtonText: 'ຍົກເລີກ',
                preConfirm: () => {
                    const name = document.getElementById('swal-name').value.trim();
                    if (!name) {
                        Swal.showValidationMessage('ກະລຸນາປ້ອນຊື່');
                        return false;
                    }
                    const color = isColor ? document.getElementById('swal-color').value : null;
                    return { name, color };
                }
            });

            if (isConfirmed && value) {
                try {
                    const fd = new FormData();
                    fd.append('action', 'quick_add_' + type);
                    fd.append('name', value.name);
                    if (value.color) fd.append('color_code', value.color);

                    const response = await fetch('products.php', { method: 'POST', body: fd });
                    const data = await response.json();

                    if (data.success) {
                        // Add to dropdown
                        const select = document.getElementById(type === 'category' ? 'category_id' : (type === 'unit' ? 'unit_id' : 'color_id'));
                        const option = document.createElement('option');
                        option.value = data.id;
                        option.textContent = value.name;
                        if (value.color) option.dataset.color = value.color;
                        option.selected = true;
                        select.appendChild(option);

                        Swal.fire({ icon: 'success', title: 'ເພີ່ມສຳເລັດ!', timer: 1500, showConfirmButton: false });
                    } else {
                        throw new Error(data.message);
                    }
                } catch (error) {
                    Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: error.message });
                }
            }
        }
    </script>
<?php endif; ?>