<?php
$page_title = 'ລະບົບຂາຍ (POS)';
require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;
$user_id = $_SESSION['user_id'] ?? null;

if (!$shop_id) {
    echo '<div class="alert alert-danger">ກະລຸນາເລືອກຮ້ານກ່ອນ</div>';
    require_once 'includes/footer.php';
    exit;
}

// Get products with categories
$products = $conn->query("SELECT p.*, c.category_name 
    FROM products p 
    LEFT JOIN product_categories c ON p.category_id = c.id 
    WHERE p.shop_id = $shop_id AND p.deleted_at IS NULL AND p.quantity > 0 
    ORDER BY p.product_name")->fetch_all(MYSQLI_ASSOC);

// Get categories
$categories = $conn->query("SELECT id, category_name FROM product_categories WHERE shop_id = $shop_id AND deleted_at IS NULL ORDER BY category_name")->fetch_all(MYSQLI_ASSOC);

// Get customers
$customers = $conn->query("SELECT id, CU_id, name, phone, address FROM customers WHERE shop_id = $shop_id AND deleted_at IS NULL ORDER BY name")->fetch_all(MYSQLI_ASSOC);

// Get shipping companies
$shippingCompanies = $conn->query("SELECT id, SC_id, company_name FROM shipping_companies WHERE shop_id = $shop_id AND deleted_at IS NULL AND is_active = 1 ORDER BY company_name")->fetch_all(MYSQLI_ASSOC);

// Get shipping branches
$branchQuery = $conn->query("SELECT id, SB_id, company_id, branch_name FROM shipping_branches WHERE shop_id = " . intval($shop_id) . " AND deleted_at IS NULL AND is_active = 1 ORDER BY branch_name");
$shippingBranches = $branchQuery ? $branchQuery->fetch_all(MYSQLI_ASSOC) : [];

// Get currencies with latest rates
$currencies = $conn->query("
    SELECT c.*, r.rate_id, r.rate_amount, r.rate_datetime
    FROM currencys c
    LEFT JOIN (
        SELECT r1.* FROM rates r1
        INNER JOIN (
            SELECT currencys_id, MAX(rate_datetime) as max_dt 
            FROM rates WHERE shop_id = $shop_id GROUP BY currencys_id
        ) r2 ON r1.currencys_id = r2.currencys_id AND r1.rate_datetime = r2.max_dt
        WHERE r1.shop_id = $shop_id
    ) r ON c.currencys_id = r.currencys_id
    WHERE c.shop_id = $shop_id
    ORDER BY c.base_currency DESC, c.currencys_name
")->fetch_all(MYSQLI_ASSOC);

// Default to LAK if no currencies
if (empty($currencies)) {
    $currencies = [['currencys_id' => 'LAK', 'currencys_name' => 'Lao Kip', 'currencys_symbol' => '₭', 'rate_amount' => 1]];
}
?>

<style>
    /* Prevent SweetAlert scrollbar jitter */
    html {
        scrollbar-gutter: stable;
    }

    body.swal2-shown:not(.swal2-no-backdrop):not(.swal2-toast-shown) {
        padding-right: 0 !important;
        overflow: auto !important;
    }

    .swal2-container {
        overflow-y: auto !important;
    }

    /* POS Layout */
    .pos-wrapper {
        display: grid;
        grid-template-columns: 1fr 420px;
        gap: 20px;
        height: calc(100vh - 120px);
        padding: 0;
    }

    /* Products Panel */
    .products-panel {
        display: flex;
        flex-direction: column;
        background: var(--card-bg);
        border-radius: 16px;
        border: 1px solid var(--border-color);
        overflow: hidden;
    }

    .products-header {
        padding: 20px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        gap: 15px;
        flex-wrap: wrap;
        align-items: center;
    }

    .search-box {
        flex: 1;
        min-width: 200px;
        position: relative;
    }

    .search-box input {
        width: 100%;
        padding: 12px 15px 12px 45px;
        border-radius: 12px;
        border: 2px solid var(--border-color);
        background: var(--bg-primary);
        color: var(--text-primary);
        font-size: 16px;
        transition: all 0.2s;
    }

    .search-box input:focus {
        border-color: var(--accent);
        outline: none;
    }

    .search-box i {
        position: absolute;
        left: 15px;
        top: 50%;
        transform: translateY(-50%);
        color: var(--text-secondary);
    }

    .filter-select {
        padding: 12px 15px;
        border-radius: 12px;
        border: 2px solid var(--border-color);
        background: var(--bg-primary);
        color: var(--text-primary);
        font-size: 16px;
        min-width: 150px;
        cursor: pointer;
    }

    .filter-select:focus {
        border-color: var(--accent);
        outline: none;
    }

    .vat-toggle {
        padding: 12px 20px;
        border-radius: 12px;
        border: 2px solid var(--border-color);
        background: var(--bg-primary);
        color: var(--text-secondary);
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 8px;
        transition: all 0.2s;
    }

    .vat-toggle.active {
        background: linear-gradient(135deg, #28a745, #20c997);
        color: white;
        border-color: transparent;
    }

    .vat-toggle:hover {
        transform: translateY(-2px);
    }

    /* Products Grid */
    .products-grid {
        flex: 1;
        overflow-y: auto;
        padding: 20px;
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));
        gap: 15px;
        align-content: start;
    }

    .product-card {
        background: var(--bg-primary);
        border: 2px solid var(--border-color);
        border-radius: 16px;
        padding: 15px;
        text-align: center;
        cursor: pointer;
        transition: all 0.25s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }

    .product-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: var(--accent);
        transform: scaleX(0);
        transition: transform 0.3s;
    }

    .product-card:hover {
        border-color: var(--accent);
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
    }

    .product-card:hover::before {
        transform: scaleX(1);
    }

    .product-card h4 {
        font-size: 16px;
        font-weight: 600;
        margin-bottom: 8px;
        color: var(--text-primary);
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    .product-card .price {
        font-size: 20px;
        font-weight: 700;
        color: var(--accent);
        margin-bottom: 5px;
    }

    .product-card .stock {
        font-size: 14px;
        color: var(--text-secondary);
    }

    .product-card .product-img {
        width: 100%;
        height: 80px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgba(var(--accent-rgb), 0.1);
        border-radius: 8px;
        margin-bottom: 10px;
        overflow: hidden;
    }

    .product-card .product-img img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .product-card .product-img i {
        font-size: 28px;
        color: var(--accent);
        opacity: 0.5;
    }

    .product-card .add-icon {
        position: absolute;
        bottom: 10px;
        right: 10px;
        width: 30px;
        height: 30px;
        background: var(--accent);
        color: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        opacity: 0;
        transform: scale(0.5);
        transition: all 0.2s;
    }

    .product-card:hover .add-icon {
        opacity: 1;
        transform: scale(1);
    }

    /* Cart Panel */
    .cart-panel {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        display: flex;
        flex-direction: column;
        overflow: hidden;
    }

    .cart-header {
        padding: 20px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .cart-header h3 {
        display: flex;
        align-items: center;
        gap: 10px;
        font-size: 18px;
        color: var(--text-primary);
    }

    .clear-cart-btn {
        padding: 8px 15px;
        border-radius: 8px;
        border: none;
        background: rgba(220, 53, 69, 0.1);
        color: #dc3545;
        font-size: 13px;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.2s;
    }

    .clear-cart-btn:hover {
        background: #dc3545;
        color: white;
    }

    .cart-items {
        flex: 1;
        overflow-y: auto;
        padding: 15px;
    }

    .cart-item {
        background: var(--bg-primary);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        padding: 12px;
        margin-bottom: 10px;
    }

    .cart-item-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 10px;
    }

    .cart-item-name {
        font-weight: 600;
        font-size: 14px;
        color: var(--text-primary);
    }

    .cart-item-remove {
        background: none;
        border: none;
        color: var(--text-secondary);
        cursor: pointer;
        padding: 5px;
        font-size: 16px;
    }

    .cart-item-remove:hover {
        color: #dc3545;
    }

    .cart-item-controls {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .qty-controls {
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .qty-btn {
        width: 32px;
        height: 32px;
        border-radius: 8px;
        border: 1px solid var(--border-color);
        background: var(--bg-primary);
        color: var(--text-primary);
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.2s;
    }

    .qty-btn:hover {
        background: var(--accent);
        color: white;
        border-color: var(--accent);
    }

    .qty-display {
        font-weight: 600;
        width: 40px;
        text-align: center;
    }

    .item-total {
        font-weight: 700;
        color: var(--accent);
        font-size: 15px;
    }

    .empty-cart {
        text-align: center;
        padding: 40px 20px;
        color: var(--text-secondary);
    }

    .empty-cart i {
        font-size: 48px;
        margin-bottom: 15px;
        opacity: 0.3;
    }

    /* Cart Summary */
    .cart-summary {
        padding: 20px;
        border-top: 1px solid var(--border-color);
        background: var(--bg-primary);
    }

    .summary-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 12px;
        font-size: 16px;
    }

    .summary-row.vat-row {
        color: #28a745;
    }

    .summary-row.total-row {
        font-size: 24px;
        font-weight: 700;
        color: var(--accent);
        padding-top: 12px;
        border-top: 2px dashed var(--border-color);
        margin-top: 12px;
    }

    .summary-row.discount-row {
        color: #dc3545;
    }

    .discount-input {
        width: 100px;
        padding: 6px 10px;
        border: 1px solid var(--border-color);
        border-radius: 6px;
        background: var(--bg-secondary);
        color: var(--text-primary);
        font-size: 14px;
        text-align: right;
    }

    .discount-input:focus {
        outline: none;
        border-color: var(--accent);
    }

    .currency-note {
        font-size: 14px;
        color: var(--text-secondary);
        margin-top: 10px;
    }

    /* Checkout Button */
    .checkout-btn {
        width: 100%;
        padding: 16px;
        margin-top: 15px;
        border-radius: 12px;
        border: none;
        background: linear-gradient(135deg, var(--accent), var(--accent-light, var(--accent)));
        color: white;
        font-size: 18px;
        font-weight: 700;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        transition: all 0.3s;
        box-shadow: 0 4px 15px rgba(var(--accent-rgb), 0.3);
    }

    .checkout-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(var(--accent-rgb), 0.4);
    }

    .checkout-btn:disabled {
        background: var(--border-color);
        cursor: not-allowed;
        transform: none;
        box-shadow: none;
    }

    /* Checkout Modal */
    .pos-modal {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0);
        backdrop-filter: blur(0px);
        z-index: 2000;
        display: flex;
        align-items: center;
        justify-content: center;
        opacity: 0;
        visibility: hidden;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .pos-modal.show {
        opacity: 1;
        visibility: visible;
        background: rgba(0, 0, 0, 0.6);
        backdrop-filter: blur(8px);
        -webkit-backdrop-filter: blur(8px);
    }

    .pos-modal-content {
        background: var(--card-bg);
        border-radius: 20px;
        width: 100%;
        max-width: 550px;
        max-height: 90vh;
        overflow-y: auto;
        border: 1px solid var(--border-color);
        box-shadow: 0 25px 50px rgba(0, 0, 0, 0.3);
        transform: scale(0.9) translateY(-20px);
        opacity: 0;
        transition: all 0.35s cubic-bezier(0.34, 1.56, 0.64, 1);
    }

    .pos-modal.show .pos-modal-content {
        transform: scale(1) translateY(0);
        opacity: 1;
    }

    /* Remove old keyframes, using CSS transitions instead */
    @keyframes modalSlide {
        from {
            opacity: 0;
            transform: scale(0.95) translateY(-20px);
        }

        to {
            opacity: 1;
            transform: scale(1) translateY(0);
        }
    }

    .modal-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .modal-header h2 {
        font-size: 20px;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .modal-close {
        background: none;
        border: none;
        font-size: 24px;
        color: var(--text-secondary);
        cursor: pointer;
    }

    .modal-body {
        padding: 24px;
    }

    .form-section {
        margin-bottom: 20px;
        padding-bottom: 20px;
        border-bottom: 1px solid var(--border-color);
    }

    .form-section:last-child {
        border-bottom: none;
        margin-bottom: 0;
    }

    .form-section h4 {
        font-size: 16px;
        color: var(--text-secondary);
        margin-bottom: 15px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .form-group {
        margin-bottom: 15px;
    }

    .form-group:last-child {
        margin-bottom: 0;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 500;
        color: var(--text-secondary);
    }

    .form-control {
        width: 100%;
        padding: 14px 16px;
        border-radius: 10px;
        border: 2px solid var(--border-color);
        background: var(--bg-primary);
        color: var(--text-primary);
        font-size: 15px;
    }

    .form-control:focus {
        border-color: var(--accent);
        outline: none;
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 15px;
    }

    /* Input with Button */
    .input-with-btn {
        display: flex;
        gap: 8px;
    }

    .input-with-btn select,
    .input-with-btn input {
        flex: 1;
    }

    .quick-add-btn {
        width: 50px;
        height: 50px;
        border-radius: 10px;
        border: 2px solid var(--border-color);
        background: var(--bg-primary);
        color: var(--accent);
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.2s;
        flex-shrink: 0;
    }

    .quick-add-btn:hover {
        background: var(--accent);
        color: white;
        border-color: var(--accent);
        transform: scale(1.05);
    }

    .quick-add-form {
        margin-top: 10px;
        padding: 12px;
        background: var(--bg-primary);
        border: 2px solid var(--accent);
        border-radius: 10px;
        animation: slideDown 0.2s ease;
    }

    @keyframes slideDown {
        from {
            opacity: 0;
            transform: translateY(-10px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .quick-add-form input {
        margin-bottom: 10px;
    }

    .quick-add-actions {
        display: flex;
        gap: 8px;
    }

    .btn-quick-save {
        flex: 1;
        padding: 8px 12px;
        border-radius: 8px;
        border: none;
        background: var(--accent);
        color: white;
        font-size: 12px;
        font-weight: 600;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 5px;
        transition: all 0.2s;
    }

    .btn-quick-save:hover {
        opacity: 0.9;
        transform: translateY(-1px);
    }

    .btn-quick-cancel {
        padding: 8px 12px;
        border-radius: 8px;
        border: 2px solid var(--border-color);
        background: transparent;
        color: var(--text-secondary);
        cursor: pointer;
        transition: all 0.2s;
    }

    .btn-quick-cancel:hover {
        background: rgba(220, 53, 69, 0.1);
        color: #dc3545;
        border-color: #dc3545;
    }

    .radio-group {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
    }

    .radio-label {
        display: flex;
        align-items: center;
        gap: 8px;
        padding: 10px 15px;
        border: 2px solid var(--border-color);
        border-radius: 10px;
        cursor: pointer;
        transition: all 0.2s;
        font-size: 15px;
    }

    .radio-label:hover {
        border-color: var(--accent);
    }

    .radio-label input {
        display: none;
    }

    .radio-label.active {
        background: var(--accent);
        color: white;
        border-color: var(--accent);
    }

    .cash-section {
        background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
        border-radius: 12px;
        padding: 15px;
        margin-top: 15px;
        border: 1px solid var(--border-color);
    }

    .input-group-custom {
        position: relative;
        display: flex;
        align-items: center;
    }

    .input-group-custom .form-control {
        padding-right: 40px;
        /* Make space for symbol */
    }

    .currency-addon {
        position: absolute;
        right: 12px;
        color: var(--text-secondary);
        font-weight: 600;
        pointer-events: none;
    }

    [data-theme="dark"] .cash-section {
        background: linear-gradient(135deg, var(--bg-secondary) 0%, var(--card-bg) 100%);
    }

    .cash-section h4 {
        margin-bottom: 15px;
        color: var(--text-primary);
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .quick-amounts {
        display: flex;
        flex-wrap: wrap;
        gap: 8px;
        margin-bottom: 12px;
    }

    .quick-amount-btn {
        padding: 8px 12px;
        border-radius: 8px;
        border: 1px solid var(--border-color);
        background: var(--bg-primary);
        color: var(--text-primary);
        font-size: 12px;
        cursor: pointer;
        transition: all 0.2s;
    }

    .quick-amount-btn:hover {
        background: var(--accent);
        color: white;
        border-color: var(--accent);
    }

    .change-display {
        background: linear-gradient(135deg, #28a745, #20c997);
        padding: 15px;
        border-radius: 10px;
        text-align: center;
        margin-top: 12px;
    }

    .change-display label {
        color: rgba(255, 255, 255, 0.9);
        font-size: 12px;
        margin-bottom: 5px;
    }

    .change-display .amount {
        font-size: 24px;
        font-weight: 700;
        color: white;
    }

    .modal-summary {
        background: var(--bg-primary);
        border-radius: 12px;
        padding: 15px;
        margin-top: 20px;
    }

    .modal-summary h4 {
        margin-bottom: 15px;
        font-size: 14px;
        color: var(--text-secondary);
    }

    .modal-footer {
        padding: 20px 24px;
        border-top: 1px solid var(--border-color);
        display: flex;
        gap: 10px;
    }

    .btn-cancel {
        flex: 1;
        padding: 14px;
        border-radius: 10px;
        border: 2px solid var(--border-color);
        background: transparent;
        color: var(--text-primary);
        font-weight: 600;
        cursor: pointer;
    }

    .btn-confirm {
        flex: 2;
        padding: 14px;
        border-radius: 10px;
        border: none;
        background: var(--accent);
        color: white;
        font-weight: 600;
        cursor: pointer;
    }

    /* Responsive */
    @media (max-width: 991px) {
        .pos-wrapper {
            grid-template-columns: 1fr;
            height: auto;
        }

        .products-panel {
            max-height: 60vh;
        }

        .cart-panel {
            max-height: 50vh;
        }
    }
</style>

<div class="pos-wrapper">
    <!-- Products Panel -->
    <div class="products-panel">
        <div class="products-header">
            <div class="search-box">
                <i class="fas fa-search"></i>
                <input type="text" id="searchProduct" placeholder="ຄົ້ນຫາສິນຄ້າ...">
            </div>
            <select id="categoryFilter" class="filter-select">
                <option value="">ທຸກປະເພດ</option>
                <?php foreach ($categories as $cat): ?>
                    <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['category_name']) ?></option>
                <?php endforeach; ?>
            </select>
            <select id="currencySelect" class="filter-select">
                <?php foreach ($currencies as $cur): ?>
                    <option value="<?= $cur['currencys_id'] ?>" data-symbol="<?= $cur['currencys_symbol'] ?? '₭' ?>"
                        data-rate="<?= $cur['rate_amount'] ?? 1 ?>" data-rate-id="<?= $cur['rate_id'] ?? '' ?>"
                        <?= ($cur['base_currency'] ?? '') === 'YES' ? 'selected' : '' ?>>
                        <?= $cur['currencys_symbol'] ?? '₭' ?>     <?= htmlspecialchars($cur['currencys_name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <button id="vatToggle" class="vat-toggle active" onclick="toggleVAT()">
                <i class="fas fa-percent"></i> VAT 10%
            </button>
        </div>

        <div class="products-grid" id="productsGrid">
            <?php foreach ($products as $p): ?>
                <div class="product-card" data-id="<?= $p['id'] ?>" data-name="<?= htmlspecialchars($p['product_name']) ?>"
                    data-price="<?= $p['selling_price'] ?>" data-stock="<?= $p['quantity'] ?>"
                    data-category="<?= $p['category_id'] ?>" onclick="addToCart(<?= htmlspecialchars(json_encode($p)) ?>)">
                    <div class="product-img">
                        <?php if (!empty($p['product_image'])): ?>
                            <img src="<?= htmlspecialchars($p['product_image']) ?>" alt="">
                        <?php else: ?>
                            <i class="fas fa-box"></i>
                        <?php endif; ?>
                    </div>
                    <h4><?= htmlspecialchars($p['product_name']) ?></h4>
                    <div class="price" data-base-price="<?= $p['selling_price'] ?>">
                        <?= number_format($p['selling_price']) ?> ₭
                    </div>
                    <div class="stock">ຍັງເຫຼືອ: <?= number_format($p['quantity']) ?></div>
                    <div class="add-icon"><i class="fas fa-plus"></i></div>
                </div>
            <?php endforeach; ?>

            <?php if (empty($products)): ?>
                <div class="empty-cart" style="grid-column: 1/-1">
                    <i class="fas fa-box-open"></i>
                    <p>ບໍ່ພົບສິນຄ້າ</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Cart Panel -->
    <div class="cart-panel">
        <div class="cart-header">
            <h3><i class="fas fa-shopping-cart"></i> ກະຕ່າສິນຄ້າ</h3>
            <button class="clear-cart-btn" onclick="clearCart()">
                <i class="fas fa-trash"></i> ລ້າງ
            </button>
        </div>

        <div class="cart-items" id="cartItems">
            <div class="empty-cart">
                <i class="fas fa-shopping-cart"></i>
                <p>ບໍ່ມີສິນຄ້າໃນກະຕ່າ</p>
            </div>
        </div>

        <div class="cart-summary">
            <div class="summary-row">
                <span>ລວມຍ່ອຍ:</span>
                <span id="subtotal">0 ₭</span>
            </div>
            <div class="summary-row discount-row">
                <span>ສ່ວນຫຼຸດ:</span>
                <div class="input-group-custom">
                    <input type="number" id="discountAmountCart" class="discount-input form-control" value="0" min="0"
                        oninput="updateDiscountBase()">
                    <span class="currency-addon">₭</span>
                </div>
            </div>
            <div class="summary-row vat-row" id="vatRow">
                <span>VAT (10%):</span>
                <span id="vatAmount">0 ₭</span>
            </div>
            <div class="summary-row total-row">
                <span>ລວມທັງໝົດ:</span>
                <span id="grandTotal">0 ₭</span>
            </div>
            <div class="currency-note" id="currencyNote">ລາຄາເປັນ: ກີບລາວ</div>

            <button class="checkout-btn" id="checkoutBtn" onclick="startCheckout()" disabled>
                <i class="fas fa-check-circle"></i> ຊໍາລະເງິນ
            </button>
        </div>
    </div>
</div>

<!-- Checkout Modal -->
<div class="pos-modal" id="checkoutModal">
    <div class="pos-modal-content">
        <div class="modal-header">
            <h2><i class="fas fa-receipt"></i> <span id="modalTitle">ຢືນຢັນການຊໍາລະ</span></h2>
            <button class="modal-close" onclick="closeCheckoutModal()">&times;</button>
        </div>
        <div class="modal-body">
            <!-- Section 1: Customer Info (Online Only) -->
            <div class="form-section" id="sectionCustomer">
                <h4><i class="fas fa-user"></i> 1. ຂໍ້ມູນລູກຄ້າ</h4>
                <div class="form-row">
                    <div class="form-group">
                        <label>ເລືອກລູກຄ້າ:</label>
                        <div class="input-with-btn">
                            <select id="customerSelect" class="form-control" onchange="fillCustomerInfo()">
                                <option value="">ເລືອກລູກຄ້າ</option>
                                <?php foreach ($customers as $cust): ?>
                                    <option value="<?= $cust['CU_id'] ?>" data-name="<?= htmlspecialchars($cust['name']) ?>"
                                        data-phone="<?= htmlspecialchars($cust['phone'] ?? '') ?>">
                                        <?= htmlspecialchars($cust['name']) ?> -
                                        <?= htmlspecialchars($cust['phone'] ?? '') ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <button type="button" class="quick-add-btn" onclick="showQuickAddCustomer()"
                                title="ເພີ່ມລູກຄ້າໃໝ່">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                        <!-- Quick Add Customer Form -->
                        <div id="quickAddCustomerForm" class="quick-add-form" style="display:none;">
                            <input type="text" id="newCustomerName" class="form-control" placeholder="ຊື່ລູກຄ້າ"
                                style="margin-bottom:8px;">
                            <input type="text" id="newCustomerPhone" class="form-control" placeholder="ເບີໂທ">
                            <div class="quick-add-actions">
                                <button type="button" class="btn-quick-save" onclick="saveQuickCustomer()">
                                    <i class="fas fa-check"></i> ບັນທຶກ
                                </button>
                                <button type="button" class="btn-quick-cancel" onclick="hideQuickAddCustomer()">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Hidden inputs for customer data -->
                <input type="hidden" id="customerName">
                <input type="hidden" id="customerPhone">
            </div>

            <!-- Section 2: Shipping Info (Online Only) -->
            <div class="form-section" id="sectionShipping">
                <h4><i class="fas fa-truck"></i> 2. ຂໍ້ມູນຂົນສົ່ງ</h4>
                <div class="form-row">
                    <div class="form-group">
                        <label>ບໍລິສັດຂົນສົ່ງ:</label>
                        <div class="input-with-btn">
                            <select id="shippingCompany" class="form-control">
                                <option value="">ເລືອກບໍລິສັດ</option>
                                <?php foreach ($shippingCompanies as $sc): ?>
                                    <option value="<?= $sc['id'] ?>"><?= htmlspecialchars($sc['company_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <button type="button" class="quick-add-btn" onclick="showQuickAddCompany()"
                                title="ເພີ່ມບໍລິສັດໃໝ່">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                        <!-- Quick Add Company Form -->
                        <div id="quickAddCompanyForm" class="quick-add-form" style="display:none;">
                            <input type="text" id="newCompanyName" class="form-control" placeholder="ຊື່ບໍລິສັດໃໝ່">
                            <div class="quick-add-actions">
                                <button type="button" class="btn-quick-save" onclick="saveQuickCompany()">
                                    <i class="fas fa-check"></i> ບັນທຶກ
                                </button>
                                <button type="button" class="btn-quick-cancel" onclick="hideQuickAddCompany()">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>ສາຂາຂົນສົ່ງ:</label>
                        <div class="input-with-btn">
                            <select id="shippingBranch" class="form-control">
                                <option value="">ເລືອກສາຂາ</option>
                                <?php foreach ($shippingBranches as $sb): ?>
                                    <option value="<?= $sb['id'] ?>" data-company="<?= $sb['company_id'] ?>">
                                        <?= htmlspecialchars($sb['branch_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <button type="button" class="quick-add-btn" onclick="showQuickAddBranch()"
                                title="ເພີ່ມສາຂາໃໝ່">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                        <!-- Quick Add Branch Form -->
                        <div id="quickAddBranchForm" class="quick-add-form" style="display:none;">
                            <input type="text" id="newBranchName" class="form-control" placeholder="ຊື່ສາຂາໃໝ່">
                            <div class="quick-add-actions">
                                <button type="button" class="btn-quick-save" onclick="saveQuickBranch()">
                                    <i class="fas fa-check"></i> ບັນທຶກ
                                </button>
                                <button type="button" class="btn-quick-cancel" onclick="hideQuickAddBranch()">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Section 3: COD Type (Online Only) -->
            <div class="form-section" id="sectionCOD">
                <h4><i class="fas fa-money-check-alt"></i> 3. ຄ່າຝາກ</h4>
                <div class="radio-group" id="codTypeGroup">
                    <label class="radio-label" onclick="selectRadio(this, 'codType')">
                        <input type="radio" name="codType" value="ຫັກ COD"> ຫັກ COD
                    </label>
                    <label class="radio-label" onclick="selectRadio(this, 'codType')">
                        <input type="radio" name="codType" value="ຄ່າຝາກປາຍທາງ"> ຄ່າຝາກປາຍທາງ
                    </label>
                </div>
            </div>

            <!-- Section 4: Payment Status -->
            <div class="form-section" id="sectionPaymentStatus">
                <h4><i class="fas fa-credit-card"></i> <span class="section-number">4</span>. ສະຖານະການຈ່າຍ</h4>
                <div class="radio-group" id="paymentStatusGroup">
                    <label class="radio-label" onclick="selectPaymentStatus(this, 'paid')">
                        <input type="radio" name="paymentStatus" value="paid"> ຈ່າຍແລ້ວ
                    </label>
                    <label class="radio-label" onclick="selectPaymentStatus(this, 'partial')">
                        <input type="radio" name="paymentStatus" value="partial"> ມັດຈຳ
                    </label>
                    <label class="radio-label" onclick="selectPaymentStatus(this, 'pending')">
                        <input type="radio" name="paymentStatus" value="pending"> ຍັງບໍ່ຈ່າຍ
                    </label>
                </div>
                <div class="form-group" id="depositGroup" style="display: none; margin-top: 15px;">
                    <label>ຈຳນວນມັດຈຳ:</label>
                    <div class="input-group-custom">
                        <input type="number" id="depositAmount" class="form-control" placeholder="0"
                            oninput="updateModalTotals()">
                        <span class="currency-addon">₭</span>
                    </div>
                </div>
            </div>

            <!-- Section 5: Payment Method -->
            <div class="form-section" id="sectionPaymentMethod">
                <h4><i class="fas fa-wallet"></i> <span class="section-number">5</span>. ວິທີຊໍາລະ</h4>
                <div class="radio-group" id="paymentMethodGroup">
                    <label class="radio-label" onclick="selectPaymentMethod(this, 'cash')">
                        <input type="radio" name="paymentMethod" value="cash"> ເງິນສົດ
                    </label>
                    <label class="radio-label" onclick="selectPaymentMethod(this, 'transfer')">
                        <input type="radio" name="paymentMethod" value="transfer"> ໂອນ
                    </label>
                </div>

                <!-- Cash Section -->
                <div class="cash-section" id="cashSection" style="display: none;">
                    <h4><i class="fas fa-cash-register"></i> ການຮັບເງິນສົດ</h4>
                    <div class="quick-amounts" id="quickAmounts"></div>
                    <div class="form-group">
                        <label>ຮັບເງິນ:</label>
                        <input type="number" id="cashReceived" class="form-control" placeholder="0"
                            oninput="calculateChange()">
                    </div>
                    <div class="change-display">
                        <label>ເງິນທອນ:</label>
                        <div class="amount" id="changeAmount">0 ₭</div>
                    </div>
                </div>
            </div>

            <!-- Section 6: Discount -->
            <div class="form-section" id="sectionDiscount">
                <h4><i class="fas fa-tags"></i> <span class="section-number">6</span>. ສ່ວນຫຼຸດ</h4>
                <div class="form-group">
                    <label>ຈຳນວນສ່ວນຫຼຸດ:</label>
                    <div class="input-group-custom">
                        <input type="number" id="discountAmount" class="form-control" value="0" min="0"
                            oninput="updateModalTotals()">
                        <span class="currency-addon">₭</span>
                    </div>
                </div>
            </div>

            <!-- Order Summary -->
            <div class="modal-summary">
                <h4>ສະຫຼຸບລາຍການ</h4>
                <div id="modalOrderItems"></div>
                <div class="summary-row" style="margin-top: 15px;">
                    <span>ລວມຍ່ອຍ:</span>
                    <span id="modalSubtotal">0 ₭</span>
                </div>
                <div class="summary-row">
                    <span>ສ່ວນຫຼຸດ:</span>
                    <span id="modalDiscount">0 ₭</span>
                </div>
                <div class="summary-row" id="modalDepositRow" style="display: none;">
                    <span>ມັດຈຳ:</span>
                    <span id="modalDeposit">0 ₭</span>
                </div>
                <div class="summary-row vat-row" id="modalVatRow">
                    <span>VAT (10%):</span>
                    <span id="modalVat">0 ₭</span>
                </div>
                <div class="summary-row total-row">
                    <span>ຍອດລວມ:</span>
                    <span id="modalTotal">0 ₭</span>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button class="btn-cancel" onclick="closeCheckoutModal()">ຍົກເລີກ</button>
            <button class="btn-confirm" id="confirmOrderBtn" onclick="submitOrder()">
                <i class="fas fa-check"></i> ຢືນຢັນ
            </button>
        </div>
    </div>
</div>

<script>
    // ===== POS System State =====
    let cart = [];
    let vatEnabled = true;
    let saleMode = 'online'; // 'online' or 'pos'
    let currentCurrency = {
        id: '<?= $currencies[0]['currencys_id'] ?? 'LAK' ?>',
        symbol: '<?= $currencies[0]['currencys_symbol'] ?? '₭' ?>',
        rate: <?= $currencies[0]['rate_amount'] ?? 1 ?>,
        rateId: '<?= $currencies[0]['rate_id'] ?? '' ?>'
    };

    // Base discount stored in LAK to prevent precision loss when switching currencies
    let baseDiscountLAK = 0;

    // Shipping branches data
    const shippingBranches = <?= json_encode($shippingBranches) ?>;

    // ===== Initialize =====
    document.addEventListener('DOMContentLoaded', function () {
        // Currency change
        document.getElementById('currencySelect').addEventListener('change', function () {
            const opt = this.options[this.selectedIndex];
            const oldRate = currentCurrency.rate;
            const oldCurrencyId = currentCurrency.id;

            const newRate = parseFloat(opt.dataset.rate) || 1;

            // Get discount input element
            const discountInput = document.getElementById('discountAmountCart');

            // Convert baseDiscountLAK to new currency for display ONLY
            // DO NOT update baseDiscountLAK here - it should only be updated when user types
            if (baseDiscountLAK > 0) {
                if (newRate === 1) {
                    // Displaying in LAK - use exact baseDiscountLAK value
                    discountInput.value = Math.round(baseDiscountLAK);
                } else {
                    // Displaying in foreign currency - convert from baseDiscountLAK
                    const displayDiscount = baseDiscountLAK / newRate;
                    if (opt.dataset.symbol === '$') {
                        discountInput.value = (Math.ceil(displayDiscount * 100) / 100).toFixed(2);
                    } else {
                        discountInput.value = Math.ceil(displayDiscount);
                    }
                }
            }

            currentCurrency = {
                id: this.value,
                symbol: opt.dataset.symbol,
                rate: newRate,
                rateId: opt.dataset.rateId || ''
            };
            updateAllPrices();
            updateTotals();
        });

        // Search & filter
        document.getElementById('searchProduct').addEventListener('input', filterProducts);
        document.getElementById('categoryFilter').addEventListener('change', filterProducts);

        // Modal Discount Input Listener
        document.getElementById('discountAmount').addEventListener('input', updateDiscountBaseModal);
    });

    // ===== Toggle VAT =====
    function toggleVAT() {
        vatEnabled = !vatEnabled;
        const btn = document.getElementById('vatToggle');
        const vatRow = document.getElementById('vatRow');

        if (vatEnabled) {
            btn.classList.add('active');
            btn.innerHTML = '<i class="fas fa-percent"></i> VAT 10%';
            vatRow.style.display = 'flex';
        } else {
            btn.classList.remove('active');
            btn.innerHTML = '<i class="fas fa-percent"></i> ບໍ່ເອົາ VAT';
            vatRow.style.display = 'none';
        }
        updateTotals();
    }

    // ===== Cart Functions =====
    function addToCart(product) {
        const existing = cart.find(i => i.id === product.id);
        if (existing) {
            if (existing.qty < product.quantity) existing.qty++;
            else {
                Swal.fire({ icon: 'warning', title: 'ສິນຄ້າໝົດ', timer: 1500, showConfirmButton: false });
                return;
            }
        } else {
            cart.push({
                id: product.id,
                name: product.product_name,
                basePriceLAK: product.selling_price,
                price: convertPrice(product.selling_price),
                qty: 1,
                maxQty: product.quantity
            });
        }
        renderCart();
        updateTotals();
    }

    function convertPrice(priceLAK) {
        if (currentCurrency.rate === 1) return priceLAK;
        const rawPrice = priceLAK / currentCurrency.rate;
        // For foreign currencies, round up to prevent loss
        return roundUpPrice(rawPrice);
    }

    // Round up price for foreign currencies to prevent selling below cost
    function roundUpPrice(price) {
        // CUR_1 = LAK (no rounding needed)
        if (currentCurrency.id === 'CUR_1' || currentCurrency.rate === 1) {
            return price;
        }
        // CUR_3 = USD (round up to 2 decimal places)
        if (currentCurrency.id === 'CUR_3') {
            return Math.ceil(price * 100) / 100;
        }
        // THB and others: round up to integer
        return Math.ceil(price);
    }

    // Get original price without rounding (for tip calculation)
    function convertPriceRaw(priceLAK) {
        return currentCurrency.rate === 1 ? priceLAK : priceLAK / currentCurrency.rate;
    }

    function updateAllPrices() {
        document.querySelectorAll('.product-card .price').forEach(el => {
            const basePrice = parseFloat(el.dataset.basePrice);
            el.textContent = formatNumber(convertPrice(basePrice)) + ' ' + currentCurrency.symbol;
        });

        const currencySelect = document.getElementById('currencySelect');
        document.getElementById('currencyNote').textContent = 'ລາຄາເປັນ: ' + currencySelect.options[currencySelect.selectedIndex].text;

        // Update modal input currency symbols
        document.querySelectorAll('.currency-addon').forEach(el => {
            el.textContent = currentCurrency.symbol;
        });

        cart.forEach(item => item.price = convertPrice(item.basePriceLAK));
        renderCart();
    }

    function renderCart() {
        const container = document.getElementById('cartItems');
        if (cart.length === 0) {
            container.innerHTML = '<div class="empty-cart"><i class="fas fa-shopping-cart"></i><p>ບໍ່ມີສິນຄ້າໃນກະຕ່າ</p></div>';
            document.getElementById('checkoutBtn').disabled = true;
            return;
        }
        document.getElementById('checkoutBtn').disabled = false;
        container.innerHTML = cart.map((item, idx) => `
        <div class="cart-item">
            <div class="cart-item-header">
                <div class="cart-item-name">${item.name}</div>
                <button class="cart-item-remove" onclick="removeFromCart(${idx})"><i class="fas fa-times"></i></button>
            </div>
            <div class="cart-item-controls">
                <div class="qty-controls">
                    <button class="qty-btn" onclick="changeQty(${idx}, -1)">-</button>
                    <span class="qty-display">${item.qty}</span>
                    <button class="qty-btn" onclick="changeQty(${idx}, 1)">+</button>
                </div>
                <div class="item-total">${formatNumber(item.price * item.qty)} ${currentCurrency.symbol}</div>
            </div>
        </div>
    `).join('');
    }

    function changeQty(index, delta) {
        cart[index].qty += delta;
        if (cart[index].qty <= 0) cart.splice(index, 1);
        else if (cart[index].qty > cart[index].maxQty) cart[index].qty = cart[index].maxQty;
        renderCart();
        updateTotals();
    }

    function removeFromCart(index) {
        cart.splice(index, 1);
        renderCart();
        updateTotals();
    }

    function clearCart() {
        if (cart.length === 0) return;
        Swal.fire({
            title: 'ລ້າງກະຕ່າ?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            confirmButtonText: 'ລ້າງ',
            cancelButtonText: 'ຍົກເລີກ'
        }).then(r => {
            if (r.isConfirmed) {
                cart = [];
                baseDiscountLAK = 0;
                document.getElementById('discountAmountCart').value = '0';
                renderCart();
                updateTotals();
            }
        });
    }

    // Called ONLY when user types in discount input
    function updateDiscountBase() {
        const discountCartInput = parseFloat(document.getElementById('discountAmountCart').value) || 0;
        // Convert to LAK and store as anchor
        baseDiscountLAK = currentCurrency.rate === 1 ? discountCartInput : discountCartInput * currentCurrency.rate;
        updateTotals();
    }

    function updateTotals() {
        const subtotalLAK = cart.reduce((sum, i) => sum + (i.basePriceLAK * i.qty), 0);

        // Use baseDiscountLAK directly (do NOT update it here)
        const discountLAK = baseDiscountLAK;

        // Calculate VAT on (subtotal - discount)
        const taxableAmountLAK = subtotalLAK - discountLAK;
        const vatAmountLAK = vatEnabled ? taxableAmountLAK * 0.1 : 0;
        const totalLAK = taxableAmountLAK + vatAmountLAK;

        document.getElementById('subtotal').textContent = formatNumber(convertPrice(subtotalLAK)) + ' ' + currentCurrency.symbol;
        document.getElementById('vatAmount').textContent = formatNumber(convertPrice(vatAmountLAK)) + ' ' + currentCurrency.symbol;
        document.getElementById('grandTotal').textContent = formatTotal(convertPrice(totalLAK)) + ' ' + currentCurrency.symbol;
    }

    function filterProducts() {
        const search = document.getElementById('searchProduct').value.toLowerCase();
        const category = document.getElementById('categoryFilter').value;
        document.querySelectorAll('.product-card').forEach(card => {
            const matchSearch = card.dataset.name.toLowerCase().includes(search);
            const matchCategory = !category || card.dataset.category == category;
            card.style.display = (matchSearch && matchCategory) ? 'block' : 'none';
        });
    }

    // ===== Checkout Flow =====
    function startCheckout() {
        if (cart.length === 0) return;

        Swal.fire({
            title: 'ປະເພດການຂາຍ',
            text: 'ທ່ານຕ້ອງການຂາຍແບບໃດ?',
            icon: 'question',
            showDenyButton: true,
            showCancelButton: true,
            confirmButtonText: '<i class="fas fa-globe"></i> ຂາຍອອນລາຍ',
            denyButtonText: '<i class="fas fa-store"></i> ຂາຍໜ້າຮ້ານ',
            cancelButtonText: 'ຍົກເລີກ',
            confirmButtonColor: '#3085d6',
            denyButtonColor: '#28a745'
        }).then(result => {
            if (result.isConfirmed) {
                openCheckoutModal('online');
            } else if (result.isDenied) {
                openCheckoutModal('pos');
            }
        });
    }

    function openCheckoutModal(mode) {
        saleMode = mode;

        // Show/hide sections based on mode
        const onlineSections = ['sectionCustomer', 'sectionShipping', 'sectionCOD'];
        onlineSections.forEach(id => {
            document.getElementById(id).style.display = mode === 'online' ? 'block' : 'none';
        });

        // Update section numbers
        const sectionNumbers = document.querySelectorAll('.section-number');
        if (mode === 'online') {
            sectionNumbers[0].textContent = '4';
            sectionNumbers[1].textContent = '5';
            sectionNumbers[2].textContent = '6';
            document.getElementById('modalTitle').textContent = 'ຂາຍອອນລາຍ';
        } else {
            sectionNumbers[0].textContent = '1';
            sectionNumbers[1].textContent = '2';
            sectionNumbers[2].textContent = '3';
            document.getElementById('modalTitle').textContent = 'ຂາຍໜ້າຮ້ານ';
        }

        // Reset form
        resetModalForm();
        updateModalTotals();
        generateQuickAmounts();

        document.getElementById('checkoutModal').classList.add('show');
    }

    function closeCheckoutModal() {
        document.getElementById('checkoutModal').classList.remove('show');
    }

    function resetModalForm() {
        document.getElementById('customerSelect').value = '';
        document.getElementById('customerName').value = '';
        document.getElementById('customerPhone').value = '';
        document.getElementById('shippingCompany').value = '';
        document.getElementById('shippingBranch').value = ''; // Just reset selection, don't clear options
        document.getElementById('depositAmount').value = '';
        // Sync discount from cart panel to modal
        document.getElementById('discountAmount').value = document.getElementById('discountAmountCart').value || '0';
        document.getElementById('cashReceived').value = '';
        document.getElementById('depositGroup').style.display = 'none';
        document.getElementById('cashSection').style.display = 'none';
        document.getElementById('modalDepositRow').style.display = 'none';

        // Reset radio buttons
        document.querySelectorAll('.radio-label').forEach(l => l.classList.remove('active'));
    }

    function filterBranches() {
        const companyId = document.getElementById('shippingCompany').value;
        const branchSelect = document.getElementById('shippingBranch');
        branchSelect.innerHTML = '<option value="">ເລືອກສາຂາ</option>';

        // Show all branches if no company selected, or filter by company
        const branches = companyId
            ? shippingBranches.filter(b => b.company_id == companyId)
            : shippingBranches;

        branches.forEach(b => {
            branchSelect.innerHTML += `<option value="${b.id}">${b.branch_name}</option>`;
        });
    }

    // ===== Radio Selection =====
    function selectRadio(el, group) {
        document.querySelectorAll(`[name="${group}"]`).forEach(input => {
            input.closest('.radio-label').classList.remove('active');
        });
        el.classList.add('active');
        el.querySelector('input').checked = true;
    }

    function selectPaymentStatus(el, status) {
        selectRadio(el, 'paymentStatus');

        // Show deposit input if partial
        document.getElementById('depositGroup').style.display = status === 'partial' ? 'block' : 'none';
        document.getElementById('modalDepositRow').style.display = status === 'partial' ? 'flex' : 'none';

        // Hide payment method if pending
        document.getElementById('sectionPaymentMethod').style.display = status === 'pending' ? 'none' : 'block';

        if (status === 'pending') {
            document.getElementById('cashSection').style.display = 'none';
        }

        updateModalTotals();
    }

    function selectPaymentMethod(el, method) {
        selectRadio(el, 'paymentMethod');

        const paymentStatus = document.querySelector('[name="paymentStatus"]:checked')?.value;

        // Show cash section only if cash + paid
        if (method === 'cash' && paymentStatus === 'paid') {
            document.getElementById('cashSection').style.display = 'block';
            generateQuickAmounts();
        } else {
            document.getElementById('cashSection').style.display = 'none';
        }
    }

    // ===== Cash Handling =====
    function generateQuickAmounts() {
        const total = getModalTotal();
        let amounts = [];

        if (total === 0) return;

        // Dynamic suggestions based on currency magnitude
        if (currentCurrency.symbol === '₭') {
            // LAK: 1,000, 2,000, 5,000, 10,000, 20,000, 50,000, 100,000
            const bases = [1000, 2000, 5000, 10000, 20000, 50000, 100000, 500000, 1000000];
            amounts = bases.filter(b => b >= total).slice(0, 4);
            // Always include exact amount if not present
            if (amounts.length < 4) amounts.push(Math.ceil(total / 1000) * 1000);

        } else if (currentCurrency.symbol === '฿') {
            // THB: 20, 50, 100, 500, 1000
            const bases = [20, 50, 100, 500, 1000, 2000, 5000, 10000];
            amounts = bases.filter(b => b >= total).slice(0, 4);
            // If total is like 125, suggest 130 or 140? No, usually next 20 or 100
            if (amounts.length === 0 || amounts[0] > total * 2) {
                amounts = [
                    Math.ceil(total / 10) * 10,
                    Math.ceil(total / 20) * 20,
                    Math.ceil(total / 50) * 50,
                    Math.ceil(total / 100) * 100
                ];
            }

        } else {
            // USD/General: 1, 5, 10, 20, 50, 100
            const bases = [1, 5, 10, 20, 50, 100, 500, 1000];
            amounts = bases.filter(b => b >= total).slice(0, 4);
            if (amounts.length === 0) {
                amounts = [
                    Math.ceil(total),
                    Math.ceil(total / 5) * 5,
                    Math.ceil(total / 10) * 10,
                    Math.ceil(total / 20) * 20
                ];
            }
        }

        // Ensure unique and sorted
        amounts = [...new Set([total, ...amounts])].sort((a, b) => a - b).filter(v => v >= total).slice(0, 5);

        const container = document.getElementById('quickAmounts');
        container.innerHTML = amounts.map(a =>
            `<button class="quick-amount-btn" onclick="setCashReceived(${a})">${formatNumber(a)}</button>`
        ).join('');
    }

    function setCashReceived(amount) {
        document.getElementById('cashReceived').value = amount;
        calculateChange();
    }

    function calculateChange() {
        const received = parseFloat(document.getElementById('cashReceived').value) || 0;
        const total = getModalTotal();
        const change = Math.max(0, received - total);
        document.getElementById('changeAmount').textContent = formatNumber(change) + ' ' + currentCurrency.symbol;
    }

    // Called ONLY when user types in discount input IN MODAL
    function updateDiscountBaseModal() {
        const discountInput = parseFloat(document.getElementById('discountAmount').value) || 0;
        // Update the anchor
        baseDiscountLAK = currentCurrency.rate === 1 ? discountInput : discountInput * currentCurrency.rate;

        // Also update the cart input to match
        document.getElementById('discountAmountCart').value = document.getElementById('discountAmount').value;

        updateTotals(); // Update cart summary
        updateModalTotals(); // Update modal summary
    }

    // ===== Modal Totals =====
    function getModalTotal() {
        const subtotalLAK = cart.reduce((sum, i) => sum + (i.basePriceLAK * i.qty), 0);
        // Use baseDiscountLAK directly (source of truth)
        const discountLAK = baseDiscountLAK;
        const depositInput = parseFloat(document.getElementById('depositAmount').value) || 0;

        const depositLAK = currentCurrency.rate === 1 ? depositInput : depositInput * currentCurrency.rate;

        const afterDiscount = subtotalLAK - discountLAK;
        const vatAmountLAK = vatEnabled ? afterDiscount * 0.1 : 0;
        let totalLAK = afterDiscount + vatAmountLAK;

        const paymentStatus = document.querySelector('[name="paymentStatus"]:checked')?.value;
        if (paymentStatus === 'partial') {
            totalLAK = totalLAK - depositLAK;
        }

        return convertPrice(totalLAK);
    }

    function updateModalTotals() {
        const subtotalLAK = cart.reduce((sum, i) => sum + (i.basePriceLAK * i.qty), 0);
        // Use baseDiscountLAK directly (source of truth)
        const discountLAK = baseDiscountLAK;
        const depositInput = parseFloat(document.getElementById('depositAmount').value) || 0;

        // Calculate display value for discount (for UI only)
        const discountInput = currentCurrency.rate === 1 ? discountLAK : discountLAK / currentCurrency.rate;

        const depositLAK = currentCurrency.rate === 1 ? depositInput : depositInput * currentCurrency.rate;

        const afterDiscount = subtotalLAK - discountLAK;
        const vatAmountLAK = vatEnabled ? afterDiscount * 0.1 : 0;
        const totalLAK = afterDiscount + vatAmountLAK;


        // Items
        document.getElementById('modalOrderItems').innerHTML = cart.map(i => `
        <div class="summary-row">
            <span>${i.name} × ${i.qty}</span>
            <span>${formatNumber(i.price * i.qty)} ${currentCurrency.symbol}</span>
        </div>
    `).join('');

        document.getElementById('modalSubtotal').textContent = formatNumber(convertPrice(subtotalLAK)) + ' ' + currentCurrency.symbol;
        document.getElementById('modalDiscount').textContent = formatNumber(discountInput) + ' ' + currentCurrency.symbol;
        document.getElementById('modalDeposit').textContent = formatNumber(depositInput) + ' ' + currentCurrency.symbol;
        document.getElementById('modalVat').textContent = formatNumber(convertPrice(vatAmountLAK)) + ' ' + currentCurrency.symbol;
        document.getElementById('modalVatRow').style.display = vatEnabled ? 'flex' : 'none';
        document.getElementById('modalTotal').textContent = formatTotal(convertPrice(totalLAK)) + ' ' + currentCurrency.symbol;

        generateQuickAmounts();
        calculateChange();
    }

    // ===== Calculate Tip Data (Rounding Difference) =====
    function calculateTipData(subtotalLAK, discountLAK, vatAmountLAK, totalLAK) {
        // Only calculate tip for foreign currencies
        if (currentCurrency.id === 'CUR_1' || currentCurrency.rate === 1) {
            return null; // No tip for LAK
        }

        // Calculate raw total (before rounding)
        const rawTotal = convertPriceRaw(totalLAK);
        // Calculate rounded total
        const roundedTotal = convertPrice(totalLAK);
        // Tip is the difference
        const tipForeign = roundedTotal - rawTotal;

        if (tipForeign <= 0) {
            return null; // No tip if no rounding occurred
        }

        // Convert tip to LAK
        const tipLAK = tipForeign * currentCurrency.rate;

        return {
            currencys_id: currentCurrency.id,
            currency_rate: currentCurrency.rate,
            original_total: rawTotal,
            rounded_total: roundedTotal,
            tip_amount_foreign: tipForeign,
            tip_amount_lak: tipLAK,
            calculation_note: `ยอดเดิม: ${rawTotal.toFixed(4)} ${currentCurrency.symbol} → ปัดเป็น: ${roundedTotal} ${currentCurrency.symbol} | Tip: ${tipForeign.toFixed(4)} ${currentCurrency.symbol} = ${tipLAK.toFixed(2)} ₭ (Rate: ${currentCurrency.rate})`
        };
    }

    // ===== Submit Order =====
    function submitOrder() {
        // Validation
        if (saleMode === 'online') {
            if (!document.getElementById('customerName').value.trim()) {
                Swal.fire({ icon: 'warning', title: 'ກະລຸນາປ້ອນຊື່ລູກຄ້າ' });
                return;
            }
        }

        const paymentStatus = document.querySelector('[name="paymentStatus"]:checked')?.value;
        if (!paymentStatus) {
            Swal.fire({ icon: 'warning', title: 'ກະລຸນາເລືອກສະຖານະການຈ່າຍ' });
            return;
        }

        if (paymentStatus !== 'pending') {
            const paymentMethod = document.querySelector('[name="paymentMethod"]:checked')?.value;
            if (!paymentMethod) {
                Swal.fire({ icon: 'warning', title: 'ກະລຸນາເລືອກວິທີຊໍາລະ' });
                return;
            }
        }

        // Prepare data
        const subtotalLAK = cart.reduce((sum, i) => sum + (i.basePriceLAK * i.qty), 0);
        // Use baseDiscountLAK directly (the anchor value) - DO NOT convert from display
        const discountLAK = baseDiscountLAK;
        const depositInput = parseFloat(document.getElementById('depositAmount').value) || 0;
        const cashReceived = parseFloat(document.getElementById('cashReceived').value) || 0;

        const depositLAK = currentCurrency.rate === 1 ? depositInput : depositInput * currentCurrency.rate;

        const afterDiscount = subtotalLAK - discountLAK;
        const vatAmountLAK = vatEnabled ? afterDiscount * 0.1 : 0;
        const totalLAK = afterDiscount + vatAmountLAK;

        // Convert to selected currency for display/saving
        const subtotalDisplay = convertPrice(subtotalLAK);
        const discountDisplay = convertPrice(discountLAK);
        const vatDisplay = convertPrice(vatAmountLAK);
        const totalDisplay = convertPrice(totalLAK);

        const orderPayload = {
            shop_id: <?= $shop_id ?>,
            sale_type: saleMode,
            customer_name: document.getElementById('customerName').value.trim(),
            customer_phone: document.getElementById('customerPhone').value.trim(),
            shipping_company_id: document.getElementById('shippingCompany').value || null,
            shipping_branch_id: document.getElementById('shippingBranch').value || null,
            cod_type: document.querySelector('[name="codType"]:checked')?.value || null,
            payment_status: paymentStatus,
            payment_method: document.querySelector('[name="paymentMethod"]:checked')?.value || null,
            cart: cart.map(i => ({
                product_id: i.id,
                product_name: i.name,
                quantity: i.qty,
                unit_price_lak: i.basePriceLAK,
                unit_price_display: i.price,  // Price in selected currency
                subtotal_lak: i.basePriceLAK * i.qty,
                subtotal_display: i.price * i.qty  // Subtotal in selected currency
            })),
            // LAK values (base currency - always saved for reference)
            subtotal_lak: subtotalLAK,
            discount_lak: discountLAK,
            vat_amount_lak: vatAmountLAK,
            total_amount_lak: totalLAK,
            // Display currency values (selected currency)
            subtotal_display: subtotalDisplay,
            discount_display: discountDisplay,
            vat_display: vatDisplay,
            total_display: totalDisplay,
            // Currency info
            currencys_id: currentCurrency.id,
            currency_rate: currentCurrency.rate,
            rate_id: currentCurrency.rateId,
            vat_enabled: vatEnabled ? 1 : 0,
            // Deposit amount for partial payments
            deposit_amount: paymentStatus === 'partial' ? depositInput : 0,
            amount_received: cashReceived,
            change_amount: Math.max(0, cashReceived - totalDisplay),
            // Tip data (rounding difference)
            tip_data: calculateTipData(subtotalLAK, discountLAK, vatAmountLAK, totalLAK)
        };

        Swal.fire({ title: 'ກຳລັງບັນທຶກ...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });

        fetch('api/pos_submit_order.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(orderPayload)
        })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'ບັນທຶກສຳເລັດ!',
                        text: 'ຕ້ອງການພິມໃບບິນບໍ່?',
                        showCancelButton: true,
                        confirmButtonText: 'ພິມໃບບິນ',
                        cancelButtonText: 'ບໍ່ພິມ'
                    }).then(result => {
                        if (result.isConfirmed && data.order_id) {
                            window.open('print_invoice.php?id=' + data.order_id, '_blank');
                        }
                    });

                    cart = [];
                    baseDiscountLAK = 0;
                    document.getElementById('discountAmountCart').value = '0';
                    renderCart();
                    updateTotals();
                    closeCheckoutModal();
                } else {
                    throw new Error(data.message || 'ເກີດຂໍ້ຜິດພາດ');
                }
            })
            .catch(err => {
                Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: err.message });
            });
    }

    // ===== Utility =====
    function formatNumber(num) {
        if (currentCurrency.id === 'CUR_3') {
            return new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(num);
        }
        return new Intl.NumberFormat('en-US', { minimumFractionDigits: 0, maximumFractionDigits: 0 }).format(Math.round(num));
    }

    // Format grand total with rounding (to avoid confusion with small decimal differences)
    function formatTotal(num) {
        if (currentCurrency.id === 'CUR_3') {
            // USD: round to 2 decimal places
            return new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(Math.round(num * 100) / 100);
        }
        if (currentCurrency.id === 'CUR_2') {
            // THB: round to integer
            return new Intl.NumberFormat('en-US', { minimumFractionDigits: 0, maximumFractionDigits: 0 }).format(Math.round(num));
        }
        // LAK: already integer
        return new Intl.NumberFormat('en-US', { minimumFractionDigits: 0, maximumFractionDigits: 0 }).format(Math.round(num));
    }

    // ===== Customer Selection =====
    function fillCustomerInfo() {
        const select = document.getElementById('customerSelect');
        const option = select.options[select.selectedIndex];
        document.getElementById('customerName').value = option.dataset.name || '';
        document.getElementById('customerPhone').value = option.dataset.phone || '';
    }

    // ===== Quick Add Customer =====
    function showQuickAddCustomer() {
        document.getElementById('quickAddCustomerForm').style.display = 'block';
        document.getElementById('newCustomerName').focus();
    }

    function hideQuickAddCustomer() {
        document.getElementById('quickAddCustomerForm').style.display = 'none';
        document.getElementById('newCustomerName').value = '';
        document.getElementById('newCustomerPhone').value = '';
    }

    function saveQuickCustomer() {
        const name = document.getElementById('newCustomerName').value.trim();
        const phone = document.getElementById('newCustomerPhone').value.trim();

        if (!name || !phone) {
            Swal.fire({ icon: 'warning', title: 'ກະລຸນາປ້ອນຊື່ ແລະ ເບີໂທ', timer: 2000, showConfirmButton: false });
            return;
        }

        fetch('api/pos_quick_add.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ type: 'customer', name: name, phone: phone, shop_id: <?= $shop_id ?> })
        })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    // Add to dropdown and select
                    const select = document.getElementById('customerSelect');
                    const option = document.createElement('option');
                    option.value = data.id;
                    option.textContent = name + ' - ' + phone;
                    option.dataset.name = name;
                    option.dataset.phone = phone;
                    option.selected = true;
                    select.appendChild(option);

                    // Fill hidden inputs
                    document.getElementById('customerName').value = name;
                    document.getElementById('customerPhone').value = phone;

                    hideQuickAddCustomer();

                    Swal.fire({ icon: 'success', title: 'ເພີ່ມລູກຄ້າແລ້ວ', timer: 1500, showConfirmButton: false });
                } else {
                    throw new Error(data.message || 'ເກີດຂໍ້ຜິດພາດ');
                }
            })
            .catch(err => {
                Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: err.message });
            });
    }

    // ===== Quick Add Shipping Company =====
    function showQuickAddCompany() {
        document.getElementById('quickAddCompanyForm').style.display = 'block';
        document.getElementById('newCompanyName').focus();
    }

    function hideQuickAddCompany() {
        document.getElementById('quickAddCompanyForm').style.display = 'none';
        document.getElementById('newCompanyName').value = '';
    }

    function saveQuickCompany() {
        const name = document.getElementById('newCompanyName').value.trim();
        if (!name) {
            Swal.fire({ icon: 'warning', title: 'ກະລຸນາປ້ອນຊື່ບໍລິສັດ', timer: 2000, showConfirmButton: false });
            return;
        }

        fetch('api/pos_quick_add.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ type: 'company', name: name, shop_id: <?= $shop_id ?> })
        })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    // Add to dropdown and select
                    const select = document.getElementById('shippingCompany');
                    const option = document.createElement('option');
                    option.value = data.id;
                    option.textContent = name;
                    option.selected = true;
                    select.appendChild(option);

                    hideQuickAddCompany();

                    Swal.fire({ icon: 'success', title: 'ເພີ່ມບໍລິສັດແລ້ວ', timer: 1500, showConfirmButton: false });
                } else {
                    throw new Error(data.message || 'ເກີດຂໍ້ຜິດພາດ');
                }
            })
            .catch(err => {
                Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: err.message });
            });
    }

    // ===== Quick Add Shipping Branch =====
    function showQuickAddBranch() {
        document.getElementById('quickAddBranchForm').style.display = 'block';
        document.getElementById('newBranchName').focus();
    }

    function hideQuickAddBranch() {
        document.getElementById('quickAddBranchForm').style.display = 'none';
        document.getElementById('newBranchName').value = '';
    }

    function saveQuickBranch() {
        const name = document.getElementById('newBranchName').value.trim();
        const companyId = document.getElementById('shippingCompany').value;

        if (!name) {
            Swal.fire({ icon: 'warning', title: 'ກະລຸນາປ້ອນຊື່ສາຂາ', timer: 2000, showConfirmButton: false });
            return;
        }

        fetch('api/pos_quick_add.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ type: 'branch', name: name, company_id: companyId, shop_id: <?= $shop_id ?> })
        })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    // Add to dropdown and select
                    const select = document.getElementById('shippingBranch');
                    const option = document.createElement('option');
                    option.value = data.id;
                    option.textContent = name;
                    option.selected = true;
                    select.appendChild(option);

                    // Also add to global branches array for future filtering
                    shippingBranches.push({ id: data.id, company_id: companyId, branch_name: name });

                    hideQuickAddBranch();

                    Swal.fire({ icon: 'success', title: 'ເພີ່ມສາຂາແລ້ວ', timer: 1500, showConfirmButton: false });
                } else {
                    throw new Error(data.message || 'ເກີດຂໍ້ຜິດພາດ');
                }
            })
            .catch(err => {
                Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: err.message });
            });
    }
</script>

<?php require_once 'includes/footer.php'; ?>