<?php
require_once("auth.php");
require_once("db_con.php");

if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "<script>alert('ບໍ່ພົບລະຫັດໃບສັ່ງຊື້'); window.location.href='show_Ordering_Report';</script>";
    exit;
}

$order_id = $_GET['id'];

// ດຶງຂໍ້ມູນໃບສັ່ງຊື້
$sql = "SELECT po.*, s.store_name, s.store_phone 
        FROM purchase_orders po
        LEFT JOIN stores s ON po.store_id = s.store_id
        WHERE po.id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo "<script>alert('ບໍ່ພົບຂໍ້ມູນໃບສັ່ງຊື້'); window.location.href='show_Ordering_Report';</script>";
    exit;
}

$order = $result->fetch_assoc();

// ດຶງຂໍ້ມູນລາຍການສິນຄ້າໃນໃບສັ່ງຊື້
$sql = "SELECT poi.*, p.product_name 
        FROM purchase_order_items poi
        LEFT JOIN products p ON poi.product_id = p.product_id
        WHERE poi.purchase_order_id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$result = $stmt->get_result();

$items = [];
while ($row = $result->fetch_assoc()) {
    $items[] = $row;
}

function formatAmount($amount) {
    $amount = floatval($amount);
    if ($amount == floor($amount)) {
        return number_format($amount, 0);
    } else {
        return number_format($amount, 2);
    }
}
?>

<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/view_purchase_order.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <title>ລາຍລະອຽດໃບສັ່ງຊື້ - <?php echo htmlspecialchars($order['order_code']); ?></title>
    <link rel="icon" type="image/png" href="/test01/favicon.png">

</head>
<body>
    <?php include('home.php'); ?>

    <div class="content-area">
        <div class="order-container">
            <div class="order-header">
                <h2>ລາຍລະອຽດໃບສັ່ງຊື້ - <?php echo htmlspecialchars($order['order_code']); ?></h2>
                <div>
                    <?php if ($order['status'] == 'pending'): ?>
                        <span class="status-pending">ລໍຖ້າ</span>
                    <?php elseif ($order['status'] == 'completed'): ?>
                        <span class="status-completed">ສຳເລັດແລ້ວ</span>
                    <?php elseif ($order['status'] == 'cancelled'): ?>
                        <span class="status-cancelled">ຍົກເລີກ</span>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="order-info">
                <div class="info-group">
                    <h3>ຂໍ້ມູນໃບສັ່ງຊື້</h3>
                    <div class="info-item">
                        <span class="info-label">ລະຫັດໃບສັ່ງຊື້:</span>
                        <span><?php echo htmlspecialchars($order['order_code']); ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">ວັນທີສັ່ງຊື້:</span>
                        <span><?php echo date('d/m/Y', strtotime($order['order_date'])); ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">ສະຖານະ:</span>
                        <span>
                            <?php if ($order['status'] == 'pending'): ?>
                                <span class="status-pending">ລໍຖ້າ</span>
                            <?php elseif ($order['status'] == 'completed'): ?>
                                <span class="status-completed">ສຳເລັດແລ້ວ</span>
                            <?php elseif ($order['status'] == 'cancelled'): ?>
                                <span class="status-cancelled">ຍົກເລີກ</span>
                            <?php endif; ?>
                        </span>
                    </div>
                </div>
                
                <div class="info-group">
                    <h3>ຂໍ້ມູນຮ້ານຄ້າ</h3>
                    <div class="info-item">
                        <span class="info-label">ຊື່ຮ້ານຄ້າ:</span>
                        <span><?php echo htmlspecialchars($order['store_name'] ?? 'N/A'); ?></span>
                    </div>
                    <!-- <div class="info-item">
                        <span class="info-label">ທີ່ຢູ່:</span>
                        <span><?php echo htmlspecialchars($order['store_address'] ?? 'N/A'); ?></span>
                    </div> -->
                    <div class="info-item">
                        <span class="info-label">ເບີໂທ:</span>
                        <span><?php echo htmlspecialchars($order['store_phone'] ?? 'N/A'); ?></span>
                    </div>
                </div>
                
                <div class="info-group">
                    <h3>ຂໍ້ມູນຜູ້ສະໜອງ</h3>
                    <div class="info-item">
                        <span class="info-label">ຊື່ຜູ້ສະໜອງ:</span>
                        <span><?php echo htmlspecialchars($order['supplier_name']); ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">ຂໍ້ມູນຕິດຕໍ່:</span>
                        <span><?php echo htmlspecialchars($order['supplier_contact'] ?? 'N/A'); ?></span>
                    </div>
                </div>
            </div>
            
            <?php if (!empty($order['notes'])): ?>
            <div class="info-group">
                <h3>ໝາຍເຫດ</h3>
                <p><?php echo nl2br(htmlspecialchars($order['notes'])); ?></p>
            </div>
            <?php endif; ?>
            
            <h3>ລາຍການສິນຄ້າ</h3>
            <table>
                <thead>
                    <tr>
                        <th>ລຳດັບ</th>
                        <!-- <th>ລະຫັດສິນຄ້າ</th> -->
                        <th>ຊື່ສິນຄ້າ</th>
                        <th>ຈຳນວນ</th>
                        <th>ລາຄາຕໍ່ຫນ່ວຍ</th>
                        <th>ລວມ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($items) > 0): ?>
                        <?php $i = 1; foreach ($items as $item): ?>
                            <tr>
                                <td><?php echo $i++; ?></td>
                                <!-- <td><?php echo htmlspecialchars($item['product_code'] ?? 'N/A'); ?></td> -->
                                <td><?php echo htmlspecialchars($item['product_name'] ?? 'N/A'); ?></td>
                                <td><?php echo number_format($item['quantity'], 0); ?></td>
                                <td><?php echo formatAmount($item['price']) . " ກີບ"; ?></td>
                                <td><?php echo formatAmount($item['total']) . " ກີບ"; ?></td>
                            </tr>
                        <?php endforeach; ?>
                        <tr class="total-row">
                            <td colspan="4" style="text-align: right;">ຍອດລວມທັງໝົດ:</td>
                            <td><?php echo formatAmount($order['total_amount']) . " ກີບ"; ?></td>
                        </tr>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" style="text-align: center;">ບໍ່ພົບລາຍການສິນຄ້າ</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            
            <div class="action-buttons">
                <a href="show_Ordering_Report" class="back-btn"><i class="fas fa-arrow-left"></i> ກັບຄືນ</a>
                <a href="print_purchase_order?id=<?php echo $order_id; ?>" target="_blank" class="print-btn"><i class="fas fa-print"></i> ພິມໃບສັ່ງຊື້</a>
                <a href="edit_purchase_order?id=<?php echo $order_id; ?>" class="edit-btn"><i class="fas fa-edit"></i> ແກ້ໄຂ</a>
            </div>
        </div>
    </div>
</body>
</html>



