<?php

session_start();
require_once("auth.php");
require_once("db_con.php");

header('Content-Type: application/json');

// ตรวจสอบว่าผู้ใช้ล็อกอินอยู่หรือไม่
if (!isset($_SESSION['id_em'])) {
    echo json_encode(['success' => false, 'message' => 'Not logged in']);
    exit;
}

$em_id = $_SESSION['id_em'];
$theme = isset($_POST['theme']) ? $_POST['theme'] : 'default';

// ตรวจสอบว่า theme ที่ส่งมาถูกต้องหรือไม่
// เพิ่ม purple theme
$allowed_themes = ['default', 'blue', 'pink', 'purple'];
if (!in_array($theme, $allowed_themes)) {
    echo json_encode(['success' => false, 'message' => 'Invalid theme']);
    exit;
}

$sql = "UPDATE employee SET theme = ? WHERE em_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $theme, $em_id);
if ($stmt->execute()) {
    echo json_encode(['success' => true, 'theme' => $theme]);
} else {
    echo json_encode(['success' => false, 'message' => 'Update failed']);
}
$stmt->close();
$conn->close();
?>
