<?php
session_start();
require_once("db_con.php");

$response = ["success" => false, "message" => ""];

// ตรวจสอบสิทธิ์
if (!isset($_SESSION['id_em'])) {
    $response["message"] = "Not logged in";
    echo json_encode($response);
    exit;
}

// รับชื่อร้าน
$shop_name = isset($_POST['shop_name']) ? trim($_POST['shop_name']) : '';
if ($shop_name === '') {
    $response["message"] = "Shop name is required";
    echo json_encode($response);
    exit;
}

// อัปโหลดโลโก้
$logo_path = null;
if (isset($_FILES['shop_logo']) && $_FILES['shop_logo']['error'] === UPLOAD_ERR_OK) {
    $ext = strtolower(pathinfo($_FILES['shop_logo']['name'], PATHINFO_EXTENSION));
    $allowed = ['jpg','jpeg','png','gif','webp'];
    if (!in_array($ext, $allowed)) {
        $response["message"] = "Invalid logo file type";
        echo json_encode($response);
        exit;
    }
    $new_name = 'logo_' . time() . '_' . rand(1000,9999) . '.' . $ext;
    $target = 'img/' . $new_name;
    if (move_uploaded_file($_FILES['shop_logo']['tmp_name'], $target)) {
        $logo_path = $target;
    } else {
        $response["message"] = "Logo upload failed";
        echo json_encode($response);
        exit;
    }
}

// อัปเดตฐานข้อมูล (อัปเดตทุกแถว ไม่เลือก em_id)
$sql = "UPDATE employee SET em_shopname = ?, em_logo = ?";
$stmt = $conn->prepare($sql);
if ($stmt === false) {
    $response["message"] = "Database error";
    echo json_encode($response);
    exit;
}
$stmt->bind_param("ss", $shop_name, $logo_path);
if ($stmt->execute()) {
    $response["success"] = true;
    $response["message"] = "Shop info updated for all employees";
    $response["logo"] = $logo_path;
    $response["shop_name"] = $shop_name;
} else {
    $response["message"] = "Update failed";
}
$stmt->close();
$conn->close();

echo json_encode($response);
?>
