<?php
// filepath: c:\xampp\htdocs\touk\ep1_touk\update_printed_status.php
require_once("auth.php");
require_once("db_con.php");

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['order_ids']) || !isset($data['type'])) {
    echo json_encode(['status' => 'error', 'message' => 'Missing parameters']);
    exit;
}

$order_ids = $data['order_ids'];
$type = $data['type'];

if (!is_array($order_ids) || count($order_ids) === 0) {
    echo json_encode(['status' => 'error', 'message' => 'No order IDs']);
    exit;
}

$column = null;
if ($type === 'ຂາຍໜ້າຮ້ານ') {
    $column = 'printed_shop';
} elseif ($type === 'ຂາຍອອນລາຍ') {
    $column = 'printed_online';
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid type']);
    exit;
}

$placeholders = implode(',', array_fill(0, count($order_ids), '?'));
$sql = "UPDATE orders SET $column = 1 WHERE order_id IN ($placeholders)";
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    echo json_encode(['status' => 'error', 'message' => 'Prepare failed']);
    exit;
}

$types = str_repeat('s', count($order_ids));
$params = [];
$params[] = &$types;
foreach ($order_ids as $k => $id) {
    $params[] = &$order_ids[$k];
}
call_user_func_array([$stmt, 'bind_param'], $params);

if ($stmt->execute()) {
    echo json_encode(['status' => 'success']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'DB error']);
}
$stmt->close();
$conn->close();
?>