<?php
require_once("auth.php");
require_once("db_con.php");
 
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['customer_id']) && isset($_POST['comment'])) {
    $customer_id = $_POST['customer_id'];
    $comment = $_POST['comment'];  
    
    // Add error logging
    error_log("Updating comment for customer ID: $customer_id");
    
    $sql = "UPDATE customers SET comment = ? WHERE customer_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $comment, $customer_id); // UUID รองรับ string
    
    if ($stmt->execute()) {
        error_log("Comment updated successfully");
        echo json_encode(['success' => true]);
    } else {
        error_log("Error updating comment: " . $conn->error);
        echo json_encode(['success' => false, 'error' => $conn->error]);
    }
} else {
    error_log("Invalid request to update_comment");
    echo json_encode(['success' => false, 'error' => 'Invalid request']);
}
?>

