<?php
require_once("db_con.php");

// Get an order ID to test with
$sql = "SELECT order_id, payment_status FROM orders WHERE payment_status = 'ມັດຈຳ' LIMIT 1";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $order_id = $row["order_id"];
    $current_status = $row["payment_status"];
    
    echo "Testing with Order ID: " . $order_id . "<br>";
    echo "Current payment status: " . $current_status . "<br>";
    
    // Update the payment status
    $new_status = "ຈ່າຍເເລ້ວ";
    $sql = "UPDATE orders SET payment_status = ?, updated_at = CURRENT_TIMESTAMP WHERE order_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $new_status, $order_id);
    
    if ($stmt->execute()) {
        echo "Payment status updated successfully<br>";
        
        // Check if updated_at was changed
        $sql = "SELECT payment_status, created_at, updated_at FROM orders WHERE order_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $order_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $row = $result->fetch_assoc();
        
        echo "New payment status: " . $row["payment_status"] . "<br>";
        echo "Created at: " . $row["created_at"] . "<br>";
        echo "Updated at: " . $row["updated_at"] . "<br>";
        
        if ($row["created_at"] != $row["updated_at"]) {
            echo "updated_at was changed correctly";
        } else {
            echo "WARNING: updated_at was not changed";
        }
    } else {
        echo "Error updating payment status: " . $stmt->error;
    }
    
    $stmt->close();
} else {
    echo "No orders with payment status 'ມັດຈຳ' found";
}

$conn->close();
?>