<?php
require_once("auth.php");
require_once("db_con.php");

// ຮັບຄ່າຕົວກອງຈາກ URL
$status = isset($_GET['status']) ? $_GET['status'] : 'all';
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : '';
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : '';
$supplier = isset($_GET['supplier']) ? $_GET['supplier'] : '';

// สร้าง SQL query <|im_start|>้ນฐาน
$sql = "SELECT po.*, s.store_name 
        FROM purchase_orders po
        LEFT JOIN stores s ON po.store_id = s.store_id";

// เ<|im_start|>่มเงื่อนไขการกรอง
$conditions = [];
$params = [];
$types = "";

if ($status != 'all') {
    $conditions[] = "po.status = ?";
    $params[] = $status;
    $types .= "s";
}

if (!empty($date_from) && !empty($date_to)) {
    $conditions[] = "po.order_date BETWEEN ? AND ?";
    $params[] = $date_from;
    $params[] = $date_to;
    $types .= "ss";
} elseif (!empty($date_from)) {
    $conditions[] = "po.order_date >= ?";
    $params[] = $date_from;
    $types .= "s";
} elseif (!empty($date_to)) {
    $conditions[] = "po.order_date <= ?";
    $params[] = $date_to;
    $types .= "s";
}

if (!empty($supplier)) {
    $conditions[] = "po.supplier_name LIKE ?";
    $params[] = "%$supplier%";
    $types .= "s";
}

// เ:semicolonเงื่อนไขเข้าไปใน SQL query
if (!empty($conditions)) {
    $sql .= " WHERE " . implode(" AND ", $conditions);
}

// เรียงลำ<|im_start|>ตาม<|im_start|><|im_start|>
$sql .= " ORDER BY po.order_date DESC";

// เັດລັດ SQL
$stmt = $conn->prepare($sql);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
$orders = $result->fetch_all(MYSQLI_ASSOC);

// <lemmaข้อมูล<lemmaพพลายเออร์<lemmaกรอง
$supplier_sql = "SELECT DISTINCT supplier_name FROM purchase_orders ORDER BY supplier_name";
$supplier_result = $conn->query($supplier_sql);
$suppliers = $supplier_result->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/show_Ordering_Report.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <title>ສະເເດງລາຍງານໃບສັ່ງຊື້ສິນຄ້າ</title>
    <link rel="icon" type="image/png" href="/test01/favicon.png">
 
</head>
<body>
    <?php include('home.php'); ?>

    <div class="content-area">
        <div class="report-container">
            <h2><i class="fa fa-file-invoice report-title-icon"></i>ສະເເດງລາຍງານໃບສັ່ງຊື້ສິນຄ້າ</h2>
            
            <!-- ຟອມກອງຂໍ້ມູນ -->
            <form class="filter-form" method="GET">
                <div class="form-group">
                    <label for="status">ສະຖານະ:</label>
                    <select name="status" id="status">
                        <option value="all" <?php echo $status == 'all' ? 'selected' : ''; ?>>ທັງໝົດ</option>
                        <option value="pending" <?php echo $status == 'pending' ? 'selected' : ''; ?>>ລໍຖ້າ</option>
                        <option value="completed" <?php echo $status == 'completed' ? 'selected' : ''; ?>>ສຳເລັດແລ້ວ</option>
                        <option value="cancelled" <?php echo $status == 'cancelled' ? 'selected' : ''; ?>>ຍົກເລີກ</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="date_from">ຈາກວັນທີ:</label>
                    <input type="date" name="date_from" id="date_from" value="<?php echo $date_from; ?>">
                </div>
                <div class="form-group">
                    <label for="date_to">ຮອດວັນທີ:</label>
                    <input type="date" name="date_to" id="date_to" value="<?php echo $date_to; ?>">
                </div>
                <div class="form-group">
                    <label for="supplier">ຜູ້ສະໜອງ:</label>
                    <select name="supplier" id="supplier">
                        <option value="">ທັງໝົດ</option>
                        <?php foreach ($suppliers as $sup): ?>
                            <option value="<?php echo htmlspecialchars($sup['supplier_name']); ?>" <?php echo $supplier == $sup['supplier_name'] ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($sup['supplier_name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <button type="submit">ຄົ້ນຫາ</button>
            </form>
            
            <!-- ຕາຕະລາງສະແດງຂໍ້ມູນ -->
            <table>
                <thead>
                    <tr>
                        <th>ລະຫັດໃບສັ່ງຊື້</th>
                        <th>ວັນທີສັ່ງຊື້</th>
                        <th>ຮ້ານຄ້າ</th>
                        <th>ຜູ້ສະໜອງ</th>
                        <th>ຍອດລວມ</th>
                        <th>ສະຖານະ</th>
                        <th>ຈັດການ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($orders) > 0): ?>
                        <?php foreach ($orders as $order): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($order['order_code']); ?></td>
                                <td><?php echo date('d/m/Y', strtotime($order['order_date'])); ?></td>
                                <td><?php echo htmlspecialchars($order['store_name'] ?? 'N/A'); ?></td>
                                <td><?php echo htmlspecialchars($order['supplier_name']); ?></td>
                                <td><?php 
                                    $amount = floatval($order['total_amount']);
                                    if ($amount == floor($amount)) {
                                        echo number_format($amount, 0); // แสดงเป็นจำนวนเต็มถ้าไม่มีทศนิยม
                                    } else {
                                        echo number_format($amount, 2); // แสดงทศนิยม 2 ตำแหน่งถ้ามีทศนิยม
                                    }
                                ?> ກີບ</td>
                                <td>
                                    <?php if ($order['status'] == 'pending'): ?>
                                        <span class="status-pending">ລໍຖ້າ</span>
                                    <?php elseif ($order['status'] == 'completed'): ?>
                                        <span class="status-completed">ສຳເລັດແລ້ວ</span>
                                    <?php elseif ($order['status'] == 'cancelled'): ?>
                                        <span class="status-cancelled">ຍົກເລີກ</span>
                                    <?php endif; ?>
                                </td>
                                <td class="action-buttons">
                                    <a href="view_purchase_order?id=<?php echo $order['id']; ?>" class="view-btn"><i class="fas fa-eye"></i> ເບິ່ງ</a>
                                    <a href="print_purchase_order?id=<?php echo $order['id']; ?>" target="_blank" class="print-btn"><i class="fas fa-print"></i> ພິມ</a>
                                    <a href="edit_purchase_order?id=<?php echo $order['id']; ?>" class="edit-btn"><i class="fas fa-edit"></i> ແກ້ໄຂ</a>
                                    <a href="javascript:void(0)" onclick="confirmDelete(<?php echo $order['id']; ?>)" class="delete-btn"><i class="fas fa-trash"></i> ລຶບ</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="7" style="text-align: center;">ບໍ່ພົບຂໍ້ມູນໃບສັ່ງຊື້</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <script>
        function confirmDelete(orderId) {
            if (confirm('ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລຶບໃບສັ່ງຊື້ນີ້?')) {
                fetch('delete_purchase_order', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'id=' + encodeURIComponent(orderId)
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert(data.message);
                        location.reload();
                    } else {
                        alert(data.message);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('<lemmaข้อ<lemmaพลาดในการลบข้อมูล');
                });
            }
        }
    </script>
</body>
</html>


