<?php
// ตั้งค่าการเชื่อมต่อฐานข้อมูล
require_once("db_con.php");

// ดึงประเภทสินค้าจากตาราง product_category
$cat_sql = "SELECT category_id, category_name FROM product_category ORDER BY category_name ASC";
$cat_result = $conn->query($cat_sql);

// รับค่าประเภทที่เลือก
$category_id = isset($_GET['category_id']) ? $_GET['category_id'] : '';
$mode = isset($_GET['mode']) && $_GET['mode'] === 'best' ? 'best' : 'all';

// ดึงชื่อหมวดหมู่ที่เลือก (ถ้ามี)
$category_name = '';
if ($category_id != '') {
    $cat_name_sql = "SELECT category_name FROM product_category WHERE category_id = ?";
    $cat_name_stmt = $conn->prepare($cat_name_sql);
    $cat_name_stmt->bind_param("s", $category_id);
    $cat_name_stmt->execute();
    $cat_name_stmt->bind_result($category_name);
    $cat_name_stmt->fetch();
    $cat_name_stmt->close();
}

// Query สินค้า
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$product_type = 'ສິນຄ້າທົ່ວໄປ'; // เพิ่ม filter เฉพาะสินค้าทั่วไป

if ($mode === 'best') {
    $sql = "SELECT product_id, product_name, selling_price, product_image, quantity, category_id 
            FROM products 
            WHERE quantity > 0 AND product_type = ?";
    $params = [$product_type];
    $types = "s";
    if ($category_id != '') {
        $sql .= " AND category_id = ?";
        $params[] = $category_id;
        $types .= "s";
    }
    if ($search != '') {
        $sql .= " AND product_name LIKE ?";
        $params[] = "%$search%";
        $types .= "s";
    }
    $sql .= " ORDER BY quantity ASC, product_id DESC LIMIT 8";
} else {
    $sql = "SELECT product_id, product_name, selling_price, product_image, quantity, category_id 
            FROM products WHERE product_type = ?";
    $params = [$product_type];
    $types = "s";
    if ($category_id != '' || $search != '') {
        if ($category_id != '') {
            $sql .= " AND category_id = ?";
            $params[] = $category_id;
            $types .= "s";
        }
        if ($search != '') {
            $sql .= " AND product_name LIKE ?";
            $params[] = "%$search%";
            $types .= "s";
        }
    }
    $sql .= " ORDER BY product_id DESC";
}

$stmt = $conn->prepare($sql);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <title>ສິນຄ້າ | Touk Shop</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@400;700&display=swap" rel="stylesheet">
    <style>
        html {
    scroll-behavior: smooth;
}
body {
    background: #f6f8fa;
    font-family: 'Noto Sans Lao', sans-serif;
    color: #1e293b;
    font-size: 1rem;
    transition: background 0.3s;
}
.navbar, .navbar-brand, .nav-link, .btn, .form-control, .form-select {
    transition: background 0.2s, color 0.2s, box-shadow 0.2s, border-color 0.2s;
}
.product-card {
    border-radius: 16px;
    box-shadow: 0 2px 12px rgba(30,41,59,0.07);
    background: #fff;
    transition:
        box-shadow 0.35s cubic-bezier(.4,0,.2,1),
        transform 0.35s cubic-bezier(.4,0,.2,1),
        background 0.35s cubic-bezier(.4,0,.2,1),
        filter 0.35s cubic-bezier(.4,0,.2,1);
    will-change: transform, box-shadow, background, filter;
    overflow: hidden;
    border: none;
    display: flex;
    flex-direction: column;
    align-items: center;
    height: 100%;
}
.product-card:hover {
    box-shadow: 0 12px 36px rgba(220,38,38,0.16);
    transform: translateY(-8px) scale(1.035);
    background: #fef2f2;
    filter: brightness(1.03);
}
.product-img {
    transition: transform 0.35s cubic-bezier(.4,0,.2,1), box-shadow 0.35s cubic-bezier(.4,0,.2,1);
    will-change: transform, box-shadow;
}
.product-card:hover .product-img {
    transform: scale(1.10) rotate(-2deg);
    box-shadow: 0 8px 32px 0 rgba(220,38,38,0.13);
}
.btn, .btn-danger, .btn-all, .btn-best {
    transition: background 0.18s, color 0.18s, box-shadow 0.18s;
}
.form-control:focus, .form-select:focus {
    box-shadow: 0 0 0 2px #dc2626;
    border-color: #dc2626;
    transition: box-shadow 0.18s, border-color 0.18s;
}
.out-stock-badge, .badge-best {
    transition: background 0.18s, color 0.18s;
}
        body {
            background: #f1f5f9;
            font-family: 'Noto Sans Lao', sans-serif;
            color: #1e293b;
            font-size: 1rem;
        }
        /* Responsive & modern card with image shadow */
.product-card {
    border-radius: 14px;
    box-shadow: 0 2px 12px rgba(30,41,59,0.07);
    background: #fff;
    transition: box-shadow 0.18s;
    overflow: hidden;
    border: none;
    padding: 1rem 0.7rem 0.7rem 0.7rem;
    display: flex;
    flex-direction: column;
    align-items: center;
    height: 100%;
}
.product-img-wrap {
    width: 100%;
    background: #fff;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 0.7rem;
}
.product-img {
    width: 100%;
    max-width: 120px;
    max-height: 120px;
    object-fit: contain;
    border-radius: 10px;
    box-shadow: 0 4px 16px 0 rgba(0,0,0,0.07);
    background: #fff;
}
@media (max-width: 991.98px) {
    .product-img-wrap { height: 160px; }
    .product-img { max-height: 130px; }
}
@media (max-width: 767.98px) {
    .product-img-wrap { height: 120px; }
    .product-img { max-height: 90px; }
    .product-card { padding: 0.7rem !important; }
}
@media (max-width: 575.98px) {
    .product-card {
        padding: 0.7rem 0.3rem 0.5rem 0.3rem;
    }
    .product-img {
        max-width: 90px;
        max-height: 90px;
    }
    .product-name, .product-price, .in-stock {
        font-size: 0.93rem;
    }
}
.row.g-4 {
    row-gap: 1.5rem !important;
    column-gap: 0.5rem !important;
}
        .product-card.out-stock {
            position: relative;
        }
        .product-card.out-stock::after {
            content: "";
            position: absolute;
            inset: 0;
            background: rgba(30, 30, 30, 0.55);
            z-index: 2;
            border-radius: 16px;
        }
        .product-card.out-stock .out-stock-badge {
            background: #dc2626 !important;
            color: #fff !important;
            border: none;
            z-index: 10;
            position: absolute;
            top: 16px;
            right: 16px;
        }
        .product-card.out-stock::after {
            z-index:
        }
        .product-card:hover {
            transform: translateY(-6px) scale(1.03);
            box-shadow: 0 8px 24px rgba(30,41,59,0.13);
        }
        .product-name {
            font-size: 0.98rem;
    font-weight: 500;
    color: #22223b;
    min-height: 38px;
    text-align: left;
    width: 100%;
    margin-bottom: 0.2rem;
        }
        .product-price {
            color: #dc2626;
            font-size: 1.08rem;
            font-weight: 700;
            margin-bottom: 0.1rem;
            text-align: left;
            width: 100%;
        }
        .out-stock-badge {
            position: absolute;
            top: 12px;
            right: 12px;
            background: #222831;
            color: #fff;
            font-size: 0.93rem;
            font-weight: 600;
            padding: 3px 12px;
            border-radius: 10px;
            z-index: 10;
            opacity: 0.95;
        }
        .in-stock {
            color: #10b981;
            font-size: 0.93rem;
            font-weight: 500;
            text-align: left;
            width: 100%;
        }
        .badge-best {
            position: absolute;
            top: 16px;
            left: 16px;
            background: #f59e42;
            color: #fff;
            font-size: 0.98rem;
            font-weight: 700;
            padding: 4px 14px;
            border-radius: 12px;
            z-index: 2;
            box-shadow: 0 2px 8px rgba(245,158,66,0.12);
        }
        .navbar-brand {
            font-size: 1.35rem;
            font-weight: 700;
            letter-spacing: 1px;
            color: #dc2626 !important;
            font-family: 'Noto Sans Lao', sans-serif;
        }
        .nav-link.active {
            color: #dc2626 !important;
            font-weight: 700;
        }
        .nav-link {
            font-size: 1.08rem;
            font-weight: 500;
            color: #1e293b !important;
            font-family: 'Noto Sans Lao', sans-serif;
        }
        .nav-link:hover {
            color: #dc2626 !important;
        }
        h2 {
            color: #1e293b;
            font-weight: 700;
            letter-spacing: 1px;
            font-size: 1.7rem;
        }
        .filter-bar {
            margin-bottom: 1.5rem;
        }
        .btn-best, .btn-all {
            background: #dc2626;
            color: #fff;
            font-weight: 700;
            border-radius: 8px;
            padding: 6px 18px;
            margin-left: 8px;
            transition: background 0.15s;
            border: none;
            font-size: 1.02rem;
            font-weight: 600;
        }
        .btn-best.active, .btn-all.active {
            background: #991b1b;
        }
        .btn-best:hover, .btn-all:hover {
            background: #991b1b;
            color: #fff;
        }
        .form-control, .form-select {
            font-size: 1rem;
        }
        /* Modal ปรับให้ดู modern */
.modal-content {
    border-radius: 18px;
    box-shadow: 0 8px 32px rgba(220,38,38,0.13);
    border: none;
}
.modal-header {
    border-bottom: 1px solid #f1f1f1;
    background: #fff;
    border-radius: 18px 18px 0 0;
}
.modal-title {
    font-weight: 700;
    color: #dc2626;
    letter-spacing: 1px;
}
@media (max-width: 575.98px) {
    .modal-content { border-radius: 10px; }
    .modal-title { font-size: 1.1rem; }
}
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="">
    <img src="img/Logo.png" alt="" style="height:38px;width:auto;margin-right:10px;">
    Jຕຸກຂາຍເຄື່ອງໃຊ້ໄຟຟ້າ
</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
               <ul class="navbar-nav ms-auto">
    <li class="nav-item">
        <a class="nav-link<?php if(!isset($_GET['mode']) || $_GET['mode'] !== 'best') echo ' active'; ?>" href="/shop">ສິນຄ້າທັງໝົດ</a>
    </li>
    <!-- <li class="nav-item">
        <a class="nav-link<?php if(isset($_GET['mode']) && $_GET['mode'] === 'best') echo ' active'; ?>" href="/shop?mode=best">ສິນຄ້າຂາຍດີ</a>
    </li> -->
    <li class="nav-item">
    <a 
        class="nav-link"
        href="https://wa.me/8562076951620?text=<?php echo urlencode('ສົນໃຈສັ່ງຊື້ສິນຄໍາ'); ?>"
        target="_blank"
        rel="noopener"
    >ຕິດຕໍ່ຮ້ານເຮົາ</a>
</li>
</ul>
            </div>
        </div>
    </nav>

    <!-- Filter bar -->
    <div class="container filter-bar">
    <form id="filterForm" method="get" class="row g-1 align-items-center justify-content-end py-2 px-2 rounded shadow-sm" style="background:#fff;">
        <div class="col-auto">
            <select name="category_id" class="form-select form-select-sm rounded-pill" style="min-width:170px;" onchange="this.form.submit()">
                <option value="">ທັງໝົດ</option>
                <?php if ($cat_result): while($cat = $cat_result->fetch_assoc()): ?>
                    <option value="<?php echo htmlspecialchars($cat['category_id']); ?>" <?php if($category_id==$cat['category_id']) echo 'selected'; ?>>
                        <?php echo htmlspecialchars($cat['category_name']); ?>
                    </option>
                <?php endwhile; endif; ?>
            </select>
        </div>
        <div class="col-auto">
            <input type="text" id="searchInput" name="search" class="form-control form-control-sm rounded-pill"
                style="min-width:150px;"
                placeholder="🔍 ຄົ້ນຫາ..." 
                value="<?php echo isset($_GET['search']) ? htmlspecialchars($_GET['search']) : ''; ?>">
        </div>
        <div class="col-auto">
            <button type="submit" class="btn btn-danger btn-sm rounded-pill px-3">
                <span style="font-weight: 530;">ຄົ້ນຫາ</span>
            </button>
        </div>
    </form>
</div>

<!-- ส่วนแสดงสินค้า -->
<div class="container-fluid px-1">
    <div id="productList" class="row g-2">
        <?php if ($result && $result->num_rows > 0): ?>
            <?php while($row = $result->fetch_assoc()): ?>
                <div class="col-6 col-md-4 col-lg-3 mb-3">
            <div class="product-card<?php if ($row['quantity'] <= 0) echo ' out-stock'; ?>"
                 style="cursor:pointer"
                 data-bs-toggle="modal"
                 data-bs-target="#productModal"
                 data-id="<?php echo $row['product_id']; ?>">
                <?php if ($row['quantity'] <= 0): ?>
                    <div class="out-stock-badge">ສິນຄ້າໝົດ</div>
                <?php elseif ($mode === 'best'): ?>
                    <div class="badge-best" style="background:#facc15 !important; color:#222 !important;">ຂາຍດີ</div>
                <?php endif; ?>
                <div class="product-img-wrap">
                    <img src="img/products/<?php echo htmlspecialchars($row['product_image']); ?>"
                         class="product-img"
                         alt="<?php echo htmlspecialchars($row['product_name']); ?>"
                         onerror="this.onerror=null;this.src='img/no-image.png';">
                </div>
                <div class="product-name"><?php echo htmlspecialchars($row['product_name']); ?></div>
                <div class="product-price">₭<?php echo number_format($row['selling_price']); ?></div>
                <?php if ($row['quantity'] > 0): ?>
                    <div class="mb-2">ຈຳນວນຄົງເຫຼືອ: <?php echo $row['quantity']; ?></div>
<!-- <div class="mb-2">ລາຍລະອຽດ: <?php echo nl2br(htmlspecialchars($row['product_detail'])); ?></div> -->
                <?php endif; ?>
            </div>
        </div>
            <?php endwhile; ?>
        <?php else: ?>
            <div class="col-12 text-center text-muted">ບໍ່ມີຂໍ້ມູນສິນຄໍາ</div>
        <?php endif; ?>
    </div>
</div>

    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
document.addEventListener('DOMContentLoaded', function() {
    var modal = document.getElementById('productModal');
    var modalBody = document.getElementById('modalProductBody');
    document.querySelectorAll('.product-card[data-id]').forEach(function(card) {
        card.addEventListener('click', function() {
            var pid = this.getAttribute('data-id');
            fetch('product_detail.php?id=' + encodeURIComponent(pid))
                .then(res => res.text())
                .then(html => { modalBody.innerHTML = html; });
        });
    });
    modal.addEventListener('hidden.bs.modal', function () {
        modalBody.innerHTML = '';
    });

    // Realtime search
    let searchInput = document.getElementById('searchInput');
    let filterForm = document.getElementById('filterForm');
    let productList = document.getElementById('productList');
    let typingTimer;
    let lastRequest = null;

    searchInput.addEventListener('input', function() {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function() {
            let formData = new FormData(filterForm);
            let params = new URLSearchParams(formData).toString();
            if (lastRequest) lastRequest.abort?.();
            fetch('shop.php?' + params, { headers: { 'X-Requested-With': 'XMLHttpRequest' } })
                .then(res => res.text())
                .then(html => {
                    // ดึงเฉพาะส่วน productList
                    let temp = document.createElement('div');
                    temp.innerHTML = html;
                    let newList = temp.querySelector('#productList');
                    if (newList) productList.innerHTML = newList.innerHTML;
                });
        }, 350); // ปรับ delay ได้
    });
});
    </script>

    <!-- HTML: วางไว้ท้าย body -->
<div class="modal fade" id="productModal" tabindex="-1" aria-labelledby="productModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="productModalLabel">ລາຍລະອຽດສິນຄໍາ</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="modalProductBody">
        <!-- content ajax -->
      </div>
    </div>
  </div>
</div>
</body>
</html>

<?php
// เพิ่มโค้ดนี้ด้านบนสุดของไฟล์ shop.php
if (
    isset($_SERVER['HTTP_X_REQUESTED_WITH']) &&
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest'
) {
    ob_start();
    ?>
    <div id="productList" class="row g-2">
        <?php if ($result && $result->num_rows > 0): ?>
            <?php while($row = $result->fetch_assoc()): ?>
                <div class="col-6 col-md-4 col-lg-3 mb-3">
            <div class="product-card<?php if ($row['quantity'] <= 0) echo ' out-stock'; ?>"
                 style="cursor:pointer"
                 data-bs-toggle="modal"
                 data-bs-target="#productModal"
                 data-id="<?php echo $row['product_id']; ?>">
                <?php if ($row['quantity'] <= 0): ?>
                    <div class="out-stock-badge">ສິນຄ້າໝົດ</div>
                <?php elseif ($mode === 'best'): ?>
                    <div class="badge-best" style="background:#facc15 !important; color:#222 !important;">ຂາຍດີ</div>
                <?php endif; ?>
                <div class="product-img-wrap">
                    <img src="img/products/<?php echo htmlspecialchars($row['product_image']); ?>"
                         class="product-img"
                         alt="<?php echo htmlspecialchars($row['product_name']); ?>"
                         onerror="this.onerror=null;this.src='img/no-image.png';">
                </div>
                <div class="product-name"><?php echo htmlspecialchars($row['product_name']); ?></div>
                <div class="product-price">₭<?php echo number_format($row['selling_price']); ?></div>
                <?php if ($row['quantity'] > 0): ?>
                    <div class="mb-2">ຈຳນວນຄົງເຫຼືອ: <?php echo $row['quantity']; ?></div>
<!-- <div class="mb-2">ລາຍລະອຽດ: <?php echo nl2br(htmlspecialchars($row['product_detail'])); ?></div> -->
                <?php endif; ?>
            </div>
        </div>
            <?php endwhile; ?>
        <?php else: ?>
            <div class="col-12 text-center text-muted">ບໍ່ມີຂໍ້ມູນສິນຄໍາ</div>
        <?php endif; ?>
    </div>
    <?php
    echo ob_get_clean();
    exit;
}