<?php require_once("db_con.php"); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <title>ສິນຄ້າຕົວແທນ - ຮ້ານ Jຕຸກຂາຍເຄື່ອງໃຊ້ໄຟຟ້າ</title>
    <style>
        body {
            font-family: 'Noto Sans Lao', sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 0;
            color: #333;
        }
        
        .header {
            background-color: #333;
            color: white;
            padding: 20px;
            text-align: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .header h1 {
            margin: 0;
            font-size: 28px;
        }
        
        .header img {
            width: 60px;
            height: auto;
            margin-right: 15px;
            vertical-align: middle;
        }
        
        .content-area {
            max-width: 1200px;
            margin: 30px auto;
            padding: 0 20px;
        }
        
        .product-table-container {
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            padding: 25px;
            animation: fadeIn 0.5s ease;
            overflow-x: auto; /* เຫຼັງໃນແຈ້ງ */
        }
        
        .table-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            border-bottom: 1px solid #eee;
            padding-bottom: 15px;
        }
        
        .table-header h1 {
            margin: 0;
            font-size: 24px;
            display: flex;
            align-items: center;
        }
        
        .table-header h1 i {
            margin-right: 10px;
            color: #EE4035;
        }
        
        .search-container {
            display: flex;
            align-items: center;
        }
        
        #representative-search {
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
            width: 300px;
            transition: all 0.3s;
            font-family: 'Noto Sans Lao', sans-serif;
        }
        
        #representative-search:focus {
            border-color: #EE4035;
            box-shadow: 0 0 5px rgba(238, 64, 53, 0.3);
            outline: none;
        }
        
        .product-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        
        .product-table th, .product-table td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }
        
        .product-table th {
            background-color: #f9f9f9;
            font-weight: 600;
            color: #555;
        }
        
        .product-table tr:hover {
            background-color: #f9f9f9;
            transition: background-color 0.3s;
        }
        
        .product-table img {
            border-radius: 5px;
            object-fit: cover;
            transition: transform 0.3s;
        }
        
        .product-table tr:hover img {
            transform: scale(1.1);
        }
        
        .normal-stock {
            color: #28a745;
            font-weight: 500;
        }
        
        .low-stock {
            color: #ffc107;
            font-weight: 500;
        }
        
        .out-of-stock {
            color: #dc3545;
            font-weight: 500;
        }
        
        .back-btn {
            display: inline-block;
            margin-top: 20px;
            padding: 10px 20px;
            background-color: #333;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            transition: all 0.3s;
            font-family: 'Noto Sans Lao', sans-serif;
        }
        
        .back-btn:hover {
            background-color: #555;
            transform: translateY(-2px);
        }
        
        .back-btn i {
            margin-right: 8px;
        }
        
        /* Tab styles */
        .tabs {
            display: flex;
            margin-bottom: 20px;
            border-bottom: 1px solid #ddd;
            flex-wrap: wrap; /* เຫຼັງໃນແຈ້ງ */
        }
        
        .tab {
            padding: 12px 20px;
            cursor: pointer;
            font-weight: 500;
            transition: all 0.3s;
            border-bottom: 3px solid transparent;
            color: #666;
        }
        
        .tab.active {
            color: #EE4035;
            border-bottom: 3px solid #EE4035;
        }
        
        .tab:hover {
            background-color: #f9f9f9;
        }
        
        .tab i {
            margin-right: 8px;
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
            animation: fadeIn 0.5s ease;
        }
        
        /* Best selling styles */
        .rank-badge {
            display: inline-block;
            width: 30px;
            height: 30px;
            line-height: 30px;
            text-align: center;
            border-radius: 50%;
            background-color: #f0f0f0;
            color: #333;
            font-weight: bold;
            margin-right: 10px;
        }
        
        .rank-1 {
            background-color: gold;
            color: #333;
        }
        
        .rank-2 {
            background-color: silver;
            color: #333;
        }
        
        .rank-3 {
            background-color: #cd7f32; /* bronze */
            color: white;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Responsive styles */
        @media (max-width: 992px) {
            .content-area {
                padding: 0 15px;
                margin: 20px auto;
            }
            
            .product-table-container {
                padding: 15px;
            }
        }
        
        @media (max-width: 768px) {
            .header h1 {
                font-size: 22px;
            }
            
            .header img {
                width: 50px;
            }
            
            .table-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 15px;
            }
            
            .search-container {
                width: 100%;
            }
            
            #representative-search {
                width: 100%;
            }
            
            .tab {
                padding: 10px 15px;
                font-size: 14px;
            }
        }
        
        @media (max-width: 576px) {
            .header h1 {
                font-size: 18px;
            }
            
            .header img {
                width: 40px;
                margin-right: 10px;
            }
            
            .product-table-container {
                padding: 10px;
            }
            
            .table-header h1 {
                font-size: 20px;
            }
            
            .product-table th, 
            .product-table td {
                padding: 10px 8px;
                font-size: 14px;
            }
            
            .back-btn {
                width: 100%;
                text-align: center;
            }
            
            .tab {
                flex: 1;
                text-align: center;
                padding: 8px 10px;
            }
            
            .tab i {
                margin-right: 5px;
            }
        }
        
        /* เຊົ້າສະຫຼັດ */
        .product-image {
            cursor: pointer;
            transition: transform 0.2s;
        }
        
        .product-image:hover {
            transform: scale(1.1);
        }
        
        /* ສະຫຼັດດີນີ້ */
        .download-btn {
            display: inline-block;
            margin-top: 5px;
            padding: 3px 8px;
            background-color: #4CAF50;
            color: white;
            border-radius: 3px;
            font-size: 12px;
            cursor: pointer;
            text-decoration: none;
        }
        
        .download-btn:hover {
            background-color: #45a049;
        }
        
        /* เรียกใช้ CSS responsive design */
        @media (max-width: 767px) {
            .product-table {
                font-size: 14px;
            }
            
            .product-table th, 
            .product-table td {
                padding: 8px 5px;
            }
            
            /* ซ่อนบางคอลัมน์ໍີ້ນີ້ */
            .product-table th:nth-child(4),
            .product-table td:nth-child(4) {
                display: none;
            }
            
            /* ขนาดภาพให้เล็กลงบนจอเล็ก */
            .product-image {
                width: 40px !important;
                height: 40px !important;
            }
            
            /* ขนาดปุ่ມดาวນ์โหลดให้เล็กลง */
            .download-btn {
                padding: 2px 5px;
                font-size: 10px;
            }
            
            /* ขนาดช่องค้นหาให้เต็มความกว้าง */
            #representative-search {
                width: 100%;
                box-sizing: border-box;
            }
            
            /* header ให้เล็กบนจอเล็ก */
            .header h1 {
                font-size: 18px;
            }
            
            .header img {
                width: 40px;
            }
            
            /* tab ให้เล็กบนจอเล็ก */
            .tabs {
                flex-wrap: wrap;
            }
            
            .tab {
                flex: 1 0 100%;
                text-align: center;
                padding: 10px;
                margin: 2px 0;
            }
        }
        
        /* จอขนาดเล็กมาก */
        @media (max-width: 480px) {
            .product-table-container {
                padding: 10px;
            }
            
            .table-header h1 {
                font-size: 18px;
            }
            
            .table-header {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .search-container {
                width: 100%;
                margin-top: 10px;
            }
            
            /* ตารางให้เล็กบนจอเล็ก */
            .product-table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
                font-size: 12px;
            }
            
            .product-table th, 
            .product-table td {
                padding: 6px 4px;
            }
            
            /* ซ่อนคอลัมน์ໍີ້ນີ້ */
            .product-table th:nth-child(5),
            .product-table td:nth-child(5) {
                display: none;
            }
        }
        
        /* modal */
        @media (max-width: 767px) {
            /* ขนาดภาพในโหมดแสดงภาพขนาดໃຫ້ */
            img[style*="max-height: 80vh"] {
                max-height: 60vh !important;
            }
            
            /* ขนาดปุ่ມใน modal */
            button[style*="position: absolute"] {
                width: 25px !important;
                height: 25px !important;
                font-size: 16px !important;
                top: -10px !important;
                right: -10px !important;
            }
            
            /* ขนาดปุ่ມดาวນ์โหลดใน modal */
            a[style*="margin-top: 15px"] {
                padding: 8px 15px !important;
                font-size: 14px !important;
            }
        }
        
        /* แสดงผลแบบ card view */
        @media (max-width: 600px) {
            /* เปลี่ยนการแสดงผลตารางเป็นแบบ card */
            .product-table, 
            .product-table tbody, 
            .product-table tr {
                display: block;
                width: 100%;
            }
            
            .product-table thead {
                display: none; /* ซ่อนส่วน<ตาราง */
            }
            
            .product-table td {
                display: flex;
                justify-content: space-between;
                padding: 8px 10px;
                text-align: right;
                border-bottom: 1px solid #eee;
            }
            
            .product-table td:before {
                content: attr(data-label);
                font-weight: bold;
                text-align: left;
                padding-right: 10px;
            }
            
            .product-table tr {
                margin-bottom: 15px;
                border: 1px solid #ddd;
                border-radius: 8px;
                overflow: hidden;
                background-color: white;
                box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            }
            
            /* เซลล์<ภาพ */
            .product-table td:nth-child(2) {
                display: block;
                text-align: center;
                padding: 15px;
            }
            
            .product-table td:nth-child(2):before {
                display: none;
            }
            
            /* ขนาดภาพในโหมด card */
            .product-table td:nth-child(2) img {
                width: 80px !important;
                height: 80px !important;
                object-fit: contain;
            }
            
            /* ปุ่มดาวນ์โหลดในโหมด card */
            .product-table td:nth-child(2) .download-btn {
                margin-top: 10px;
                padding: 5px 10px;
                font-size: 12px;
            }
            
            /* เซลล์สถานะ */
            .product-table td:last-child {
                background-color: #f9f9f9;
            }
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // ค้นหาค้า
            const searchInput = document.getElementById('representative-search');
            if (searchInput) {
                searchInput.addEventListener('keyup', function() {
                    const searchValue = this.value.toLowerCase();
                    const tableRows = document.querySelectorAll('#representative-table-body tr');
                    
                    tableRows.forEach(row => {
                        let found = false;
                        const cells = row.querySelectorAll('td');
                        
                        cells.forEach(cell => {
                            if (cell.textContent.toLowerCase().includes(searchValue)) {
                                found = true;
                            }
                        });
                        
                        if (found) {
                            row.style.display = '';
                        } else {
                            row.style.display = 'none';
                        }
                    });
                });
            }
            
            // เอา animation เมื้อโหลดหน้า
            const tableRows = document.querySelectorAll('.product-table tbody tr');
            tableRows.forEach((row, index) => {
                row.style.opacity = '0';
                row.style.transform = 'translateY(20px)';
                row.style.transition = 'opacity 0.3s ease, transform 0.3s ease';
                
                setTimeout(() => {
                    row.style.opacity = '1';
                    row.style.transform = 'translateY(0)';
                }, 100 + (index * 50));
            });
            
            // เอา event listener ค้า
            const allProductsTab = document.querySelector('.tab[data-tab="all-products"]');
            if (allProductsTab) {
                allProductsTab.addEventListener('click', function() {
                    // ลบ active class จาก tab
                    document.querySelectorAll('.tab').forEach(tab => {
                        tab.classList.remove('active');
                    });
                    
                    // เอา active class ให้ tab
                    this.classList.add('active');
                    
                    // ซ่อนเนื้อหา <ງหมด
                    document.querySelectorAll('.tab-content').forEach(content => {
                        content.classList.remove('active');
                    });
                    
                    // แสดงเนื้อหาค้า
                    const allProductsContent = document.getElementById('all-products');
                    if (allProductsContent) {
                        allProductsContent.classList.add('active');
                    }
                });
            }
            
            // เอา event listener ค้า
            const bestSellingTab = document.getElementById('best-selling-tab');
            if (bestSellingTab) {
                bestSellingTab.addEventListener('click', function() {
                    // ลบ active class จาก tab
                    document.querySelectorAll('.tab').forEach(tab => {
                        tab.classList.remove('active');
                    });
                    
                    // เอา active class ให้ tab
                    this.classList.add('active');
                    
                    // ซ่อนเนื้อหา <ງหมด
                    document.querySelectorAll('.tab-content').forEach(content => {
                        content.classList.remove('active');
                    });
                    
                    // แสดงเนื้อหาค้า
                    const bestSellingContent = document.getElementById('best-selling');
                    if (bestSellingContent) {
                        bestSellingContent.classList.add('active');
                        
                        // ใส่ animation ให้ แถว แสดง
                        const visibleRows = bestSellingContent.querySelectorAll('tbody tr');
                        visibleRows.forEach((row, index) => {
                            row.style.opacity = '0';
                            row.style.transform = 'translateY(20px)';
                            
                            setTimeout(() => {
                                row.style.opacity = '1';
                                row.style.transform = 'translateY(0)';
                            }, 100 + (index * 50));
                        });
                    } else {
                        console.error('ไม่พบ element ค้าขาย id: best-selling');
                        alert('ไม่พบข้อมูลค้าขาย ลองใหม่ครั้ง');
                    }
                });
            }
        });
    </script>
</head>
<body>
    <div class="header">
        <img src="img/Logo.png" alt="Logo">
        <h1>ຮ້ານ Jຕຸກຂາຍເຄື່ອງໃຊ້ໄຟຟ້າ</h1>
    </div>

    <div class="content-area">
        <div class="product-table-container">
            <div class="table-header">
                <h1><i class="fas fa-handshake"></i> ສິນຄ້າຕົວແທນ</h1>
                <div class="search-container">
                    <input type="text" id="representative-search" placeholder="ຄົ້ນຫາສິນຄ້າຕົວແທນ...">
                </div>
            </div>
            
            <div class="tabs">
                <div class="tab active" data-tab="all-products">
                    <i class="fas fa-boxes"></i> ສິນຄ້າທັງໝົດ
                </div>
                <div class="tab" data-tab="best-selling" id="best-selling-tab">
                    <i class="fas fa-chart-line"></i> ສິນຄ້າຂາຍດີ
                </div>
            </div>
            
            <!-- เี่ม meta viewport tag เี่อให้แสดงผลบนได้ -->
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
            
            <!-- เี่มปุ่ມหน้า -->
            <div class="mobile-back-btn">
                <a href="logout" class="back-btn">
                    <i class="fas fa-sign-out-alt"></i> ອອກຈາກລະບົບ
                </a>
            </div>
        </div>
        
        <div id="all-products" class="tab-content active">
            <?php
            // Make sure we have a database connection
            require_once("db_con.php");
            
            // Debug: Check connection
            if ($conn->connect_error) {
                die("Connection failed: " . $conn->connect_error);
            }
            
            // Query to show only representative products - fixed spelling to match database
            $sql = "SELECT p.*, pc.category_name 
                    FROM products p 
                    LEFT JOIN product_category pc ON p.category_id = pc.category_id
                    WHERE TRIM(p.product_type) = 'ສິນຄ້າຕົວແທນ'
                    ORDER BY p.pro_id ASC";
            
            $result = $conn->query($sql);
            
            // Debug: Check for query errors and show SQL
            if (!$result) {
                echo "<p>Error: " . $conn->error . "</p>";
                echo "<p>SQL: $sql</p>";
            } else {
                // Debug: Show how many rows found
                echo "<!-- Found rows: " . $result->num_rows . " -->";
            }
            ?>
            
            <table class="product-table">
                <thead>
                    <tr>
                        <th>ລະຫັດສິນຄ້າ</th>
                        <th>ຮູບສິນຄ້າ</th>
                        <th>ຊື່ສິນຄ້າ</th>
                        <th>ປະເພດເຄື່ອງສິນຄ້າ</th>
                        <th>ຈໍານວນ</th>
                        <th>ລາຄາຂາຍ</th>
                        <th>ສະຖານະ</th>
                    </tr>
                </thead>
                <tbody id="representative-table-body">
                    <?php
                    if ($result->num_rows > 0) {
                        while($row = $result->fetch_assoc()) {
                            // กำหนดสถานะ
                            if ($row['quantity'] <= 0) {
                                $status_class = 'out-of-stock';
                                $status_text = 'ສິນຄ້າໝົດ';
                                $status_icon = 'fa-times-circle';
                            } elseif ($row['quantity'] <= 20) {
                                $status_class = 'low-stock';
                                $status_text = 'ສິນຄ້າໃກ້ຈະໝົດ';
                                $status_icon = 'fa-exclamation-triangle';
                            } else {
                                $status_class = 'normal-stock';
                                $status_text = 'ມີສິນຄໍາ';
                                $status_icon = 'fa-check-circle';
                            }
                            
                            echo "<tr>";
                            echo "<td>".$row['pro_id']."</td>";
                            echo "<td>
                                    <img src='img/products/".$row['product_image']."' alt='".$row['product_name']."' width='50' class='product-image' 
                                        onclick='showImagePreview(\"img/products/".$row['product_image']."\", \"".$row['product_name']."\")' 
                                        onerror=\"this.src='img/Logo.png'\">
                                    <br>
                                    <a href='img/products/".$row['product_image']."' download='".$row['product_name'].".jpg' class='download-btn'>
                                        <i class='fas fa-download'></i> ດາວໂຫລດ
                                    </a>
                                  </td>";
                            echo "<td>".$row['product_name']."</td>";
                            echo "<td>".$row['category_name']."</td>";
                            echo "<td>".$row['quantity']."</td>";
                            echo "<td>₭".number_format($row['selling_price'], 0)."</td>";
                            echo "<td class='".$status_class."'><i class='fas ".$status_icon."'></i> ".$status_text."</td>";
                            echo "</tr>";
                        }
                    } else {
                        echo "<tr><td colspan='7' style='text-align:center'>ບໍ່ພົບຂໍ້ມູນສິນຄ້າຕົວແທນ</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
        
        <div id="best-selling" class="tab-content">
            <?php
            // SQL query for best-selling representative products only - fixed spelling
            $best_sql = "SELECT p.pro_id, p.product_name, p.product_image, pc.category_name, 
                        p.quantity, p.selling_price, SUM(oi.quantity) as total_sold, 
                        SUM(oi.quantity * oi.price) as total_sales
                        FROM products p
                        LEFT JOIN product_category pc ON p.category_id = pc.category_id
                        INNER JOIN order_items oi ON p.product_id = oi.product_id
                        INNER JOIN orders o ON oi.order_id = o.order_id
                        WHERE p.product_type = 'ສິນຄ້າຕົວແທນ'
                        AND o.order_date >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)
                        GROUP BY p.pro_id
                        ORDER BY total_sold DESC
                        LIMIT 20";
            
            // ทดสอบ query
            $best_result = $conn->query($best_sql);
            
            // ตรวจสอบข้อ พลาด
            if (!$best_result) {
                echo "<p>ข้อ พลาดในการ ข้อมูล: " . $conn->error . "</p>";
            }
            ?>
            
            <table class="product-table">
                <thead>
                    <tr>
                        <th>ອັນດັບ</th>
                        <th>ລະຫັດສິນຄ້າ</th>
                        <th>ຮູບສິນຄ້າ</th>
                        <th>ຊື່ສິນຄ້າ</th>
                        <th>ປະເພດເຄື່ອງສິນຄ້າ</th>
                        <th>ຈໍານວນຂາຍ</th>
                        <th>ລາຄາຂາຍ</th>
                        <!-- <th>ຍອດຂາຍລວມ</th> -->
                    </tr>
                </thead>
                <tbody id="best-selling-table-body">
                    <?php
                    if ($best_result && $best_result->num_rows > 0) {
                        $rank = 1;
                        while($row = $best_result->fetch_assoc()) {
                            // กำหนด class
                            $rank_class = '';
                            if ($rank == 1) $rank_class = 'rank-1';
                            else if ($rank == 2) $rank_class = 'rank-2';
                            else if ($rank == 3) $rank_class = 'rank-3';
                            
                            echo "<tr>";
                            echo "<td><span class='rank-badge ".$rank_class."'>".$rank."</span></td>";
                            echo "<td>".$row['pro_id']."</td>";
                            echo "<td>
                                    <img src='img/products/".$row['product_image']."' alt='".$row['product_name']."' width='50' class='product-image' 
                                        onclick='showImagePreview(\"img/products/".$row['product_image']."\", \"".$row['product_name']."\")' 
                                        onerror=\"this.src='img/Logo.png'\">
                                    <br>
                                    <a href='img/products/".$row['product_image']."' download='".$row['product_name'].".jpg' class='download-btn'>
                                        <i class='fas fa-download'></i> ດາວໂຫລດ
                                    </a>
                                  </td>";
                            echo "<td>".$row['product_name']."</td>";
                            echo "<td>".$row['category_name']."</td>";
                            echo "<td>".number_format($row['total_sold'] ?? 0, 0)." ຊິ້ນ</td>";
                            echo "<td>₭".number_format($row['selling_price'], 0)."</td>";
                            // echo "<td>₭".number_format($row['total_sales'] ?? 0, 0)."</td>";
                            echo "</tr>";
                            $rank++;
                        }
                    } else {
                        echo "<tr><td colspan='8' style='text-align:center'>ບໍ່ພົບຂໍ້ມູນການຂາຍສິນຄ້າຕົວແທນໃນ 30 ວັນທີ່ຜ່ານມາ</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
        
       

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // ค้นหาค้า
            const searchInput = document.getElementById('representative-search');
            if (searchInput) {
                searchInput.addEventListener('keyup', function() {
                    const searchValue = this.value.toLowerCase();
                    const tableRows = document.querySelectorAll('#representative-table-body tr');
                    
                    tableRows.forEach(row => {
                        let found = false;
                        const cells = row.querySelectorAll('td');
                        
                        cells.forEach(cell => {
                            if (cell.textContent.toLowerCase().includes(searchValue)) {
                                found = true;
                            }
                        });
                        
                        if (found) {
                            row.style.display = '';
                        } else {
                            row.style.display = 'none';
                        }
                    });
                });
            }
            
            // เอา animation เมื้อโหลดหน้า
            const tableRows = document.querySelectorAll('.product-table tbody tr');
            tableRows.forEach((row, index) => {
                row.style.opacity = '0';
                row.style.transform = 'translateY(20px)';
                row.style.transition = 'opacity 0.3s ease, transform 0.3s ease';
                
                setTimeout(() => {
                    row.style.opacity = '1';
                    row.style.transform = 'translateY(0)';
                }, 100 + (index * 50));
            });
            
            // เอา event listener ค้า
            const allProductsTab = document.querySelector('.tab[data-tab="all-products"]');
            if (allProductsTab) {
                allProductsTab.addEventListener('click', function() {
                    // ลบ active class จาก tab
                    document.querySelectorAll('.tab').forEach(tab => {
                        tab.classList.remove('active');
                    });
                    
                    // เอา active class ให้ tab
                    this.classList.add('active');
                    
                    // ซ่อนเนื้อหา <ງหมด
                    document.querySelectorAll('.tab-content').forEach(content => {
                        content.classList.remove('active');
                    });
                    
                    // แสดงเนื้อหาค้า
                    const allProductsContent = document.getElementById('all-products');
                    if (allProductsContent) {
                        allProductsContent.classList.add('active');
                    }
                });
            }
            
            // เอา event listener ค้า
            const bestSellingTab = document.getElementById('best-selling-tab');
            if (bestSellingTab) {
                bestSellingTab.addEventListener('click', function() {
                    // ลบ active class จาก tab
                    document.querySelectorAll('.tab').forEach(tab => {
                        tab.classList.remove('active');
                    });
                    
                    // เอา active class ให้ tab
                    this.classList.add('active');
                    
                    // ซ่อนเนื้อหา <ງหมด
                    document.querySelectorAll('.tab-content').forEach(content => {
                        content.classList.remove('active');
                    });
                    
                    // แสดงเนื้อหาค้า
                    const bestSellingContent = document.getElementById('best-selling');
                    if (bestSellingContent) {
                        bestSellingContent.classList.add('active');
                        
                        // ใส่ animation ให้ แถว แสดง
                        const visibleRows = bestSellingContent.querySelectorAll('tbody tr');
                        visibleRows.forEach((row, index) => {
                            row.style.opacity = '0';
                            row.style.transform = 'translateY(20px)';
                            
                            setTimeout(() => {
                                row.style.opacity = '1';
                                row.style.transform = 'translateY(0)';
                            }, 100 + (index * 50));
                        });
                    } else {
                        console.error('ไม่พบ element ค้าขาย id: best-selling');
                        alert('ไม่พบข้อมูลค้าขาย ลองใหม่ครั้ง');
                    }
                });
            }
        });
    </script>
    <script>
        // <lemmaก์ lemmaแสด lemmaภาพນີ້
        function showImagePreview(imageSrc, productName) {
            // สร้าง modal lemmaภาพ
            const modal = document.createElement('div');
            modal.style.position = 'fixed';
            modal.style.top = '0';
            modal.style.left = '0';
            modal.style.width = '100%';
            modal.style.height = '100%';
            modal.style.backgroundColor = 'rgba(0,0,0,0.8)';
            modal.style.display = 'flex';
            modal.style.flexDirection = 'column';
            modal.style.alignItems = 'center';
            modal.style.justifyContent = 'center';
            modal.style.zIndex = '1000';
            
            // สร้างส่วนแสดง lemmaภาพ
            const imageContainer = document.createElement('div');
            imageContainer.style.position = 'relative';
            imageContainer.style.maxWidth = '80%';
            imageContainer.style.maxHeight = '80%';
            
            // สร้าง lemmaภาพ
            const image = document.createElement('img');
            image.src = imageSrc;
            image.alt = productName;
            image.style.maxWidth = '100%';
            image.style.maxHeight = '80vh';
            image.style.objectFit = 'contain';
            image.style.border = '2px solid white';
            image.style.borderRadius = '5px';
            image.onerror = function() {
                this.src = 'img/Logo.png';
            };
            
            // สร้างปุ่ມดาวນ์โหลด
            const downloadBtn = document.createElement('a');
            downloadBtn.href = imageSrc;
            downloadBtn.download = productName + '.jpg';
            downloadBtn.innerHTML = '<i class="fas fa-download"></i> ດາວໂຫລດຮູບພາບ';
            downloadBtn.style.display = 'block';
            downloadBtn.style.marginTop = '15px';
            downloadBtn.style.padding = '10px 20px';
            downloadBtn.style.backgroundColor = '#4CAF50';
            downloadBtn.style.color = 'white';
            downloadBtn.style.borderRadius = '5px';
            downloadBtn.style.textDecoration = 'none';
            downloadBtn.style.textAlign = 'center';
            downloadBtn.style.fontFamily = "'Noto Sans Lao', sans-serif";
            
            // สร้างปุ่ມ lemma
            const closeBtn = document.createElement('button');
            closeBtn.innerHTML = '&times;';
            closeBtn.style.position = 'absolute';
            closeBtn.style.top = '-15px';
            closeBtn.style.right = '-15px';
            closeBtn.style.width = '30px';
            closeBtn.style.height = '30px';
            closeBtn.style.borderRadius = '50%';
            closeBtn.style.backgroundColor = 'red';
            closeBtn.style.color = 'white';
            closeBtn.style.border = 'none';
            closeBtn.style.fontSize = '20px';
            closeBtn.style.cursor = 'pointer';
            closeBtn.onclick = function() {
                document.body.removeChild(modal);
            };
            
            // สร้างชื่อ lemmaค้า
            const title = document.createElement('h3');
            title.textContent = productName;
            title.style.color = 'white';
            title.style.marginBottom = '15px';
            title.style.fontFamily = "'Noto Sans Lao', sans-serif";
            
            // เ wyśwັງค์ประกอบเข้าด้วย lemma
            imageContainer.appendChild(image);
            imageContainer.appendChild(closeBtn);
            modal.appendChild(title);
            modal.appendChild(imageContainer);
            modal.appendChild(downloadBtn);
            
            // เຊົ້າ modal เข้าไปໃນ body
            document.body.appendChild(modal);
            
            // <lemma modal เมื่อ lemma lemma่ lemma
            modal.addEventListener('click', function(event) {
                if (event.target === modal) {
                    document.body.removeChild(modal);
                }
            });
        }
    </script>
</body>
</html>





















































