<?php
require_once("auth.php");
require_once("db_con.php");

$date_from = $_GET['date_from'] ?? '';
$date_to = $_GET['date_to'] ?? '';
$category = $_GET['category'] ?? 'all';
$search = $_GET['search'] ?? '';

$where = [];
if ($date_from && $date_to) {
    // เพิ่มเวลาให้ date_to เป็น 23:59:59
    $where[] = "o.order_date BETWEEN '$date_from 00:00:00' AND '$date_to 23:59:59'";
}
if ($category !== 'all') {
    $where[] = "p.category_id = '$category'";
}
if ($search !== '') {
    $search_sql = $conn->real_escape_string($search);
    $where[] = "(p.pro_id LIKE '%$search_sql%' OR p.product_name LIKE '%$search_sql%')";
}
$where_sql = $where ? 'WHERE ' . implode(' AND ', $where) : '';

$sql = "SELECT 
            p.pro_id, 
            p.product_name, 
            p.product_image, 
            p.category_id, 
            p.product_type, 
            oi.quantity, 
            oi.price, 
            o.order_date
        FROM order_items oi
        JOIN products p ON oi.product_id = p.product_id
        JOIN orders o ON oi.order_id = o.order_id
        $where_sql
        ORDER BY o.order_date DESC";
$result = $conn->query($sql);

// จัดกลุ่มข้อมูล
$productGroups = [];
$totalDays = [];
if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $pro_id = $row['pro_id'];
        $date = substr($row['order_date'], 0, 10); // yyyy-mm-dd
        $totalDays[$date] = true;

        if (!isset($productGroups[$pro_id])) {
            $productGroups[$pro_id] = [
                'pro_id' => $pro_id,
                'product_name' => $row['product_name'],
                'product_image' => $row['product_image'],
                'category_id' => $row['category_id'],
                'product_type' => $row['product_type'],
                'price' => $row['price'],
                'total_quantity' => 0,
                'total_amount' => 0,
                'daily_sales' => []
            ];
        }
        $qty = (int)$row['quantity'];
        $amt = $qty * (float)$row['price'];
        $productGroups[$pro_id]['total_quantity'] += $qty;
        $productGroups[$pro_id]['total_amount'] += $amt;

        if (!isset($productGroups[$pro_id]['daily_sales'][$date])) {
            $productGroups[$pro_id]['daily_sales'][$date] = [
                'quantity' => 0,
                'amount' => 0
            ];
        }
        $productGroups[$pro_id]['daily_sales'][$date]['quantity'] += $qty;
        $productGroups[$pro_id]['daily_sales'][$date]['amount'] += $amt;
    }

    // ถ้ามีหลายวัน แสดง summary + breakdown
    if (count($totalDays) > 1) {
        // เรียงตามยอดขายมากไปน้อย
        usort($productGroups, function($a, $b) {
            return $b['total_quantity'] - $a['total_quantity'];
        });

        foreach ($productGroups as $product) {
            echo '<tr class="product-header"><td colspan="9">';
            echo '<div class="product-summary-header">';
            echo '<div class="product-info">';
            echo '<img src="img/products/' . htmlspecialchars($product['product_image'] ?? '') . '" alt="' . htmlspecialchars($product['product_name'] ?? '') . '" onerror="this.src=\'img/Logo.png\'">';
            echo '<div class="product-details">';
            echo '<h3>' . htmlspecialchars($product['product_name'] ?? '') . '</h3>';
            echo '<p>ລະຫັດ: ' . htmlspecialchars($product['pro_id'] ?? '') . ' | ປະເພດ: ' . htmlspecialchars($product['category_id'] ?? '') . '</p>';
            echo '</div></div>';
            echo '<div class="product-summary">';
            echo '<div class="summary-item"><span class="summary-label">ຈຳນວນຂາຍທັງໝົດ:</span> <span class="summary-value">' . $product['total_quantity'] . ' ອັນ</span></div>';
            echo '<div class="summary-item"><span class="summary-label">ລາຄາຂາຍ:</span> <span class="summary-value">₭' . number_format($product['price']) . '</span></div>';
            echo '<div class="summary-item"><span class="summary-label">ຍອດຂາຍລວມ:</span> <span class="summary-value">₭' . number_format($product['total_amount']) . '</span></div>';
            echo '</div></div></td></tr>';

            // daily breakdown
            echo '<tr class="daily-sales-row"><td colspan="9">';
            echo '<table class="daily-sales-table"><thead><tr><th>ວັນທີ</th><th>ຈຳນວນຂາຍ</th><th>ຍອດຂາຍ</th></tr></thead><tbody>';
            // เรียงวันที่ใหม่ -> เก่า
            $dates = array_keys($product['daily_sales']);
            usort($dates, function($a, $b) { return strtotime($b) - strtotime($a); });
            foreach ($dates as $date) {
                $daily = $product['daily_sales'][$date];
                $dateParts = explode('-', $date);
                $formattedDate = $dateParts[2] . '-' . $dateParts[1] . '-' . $dateParts[0];
                echo '<tr><td>' . $formattedDate . '</td><td>' . $daily['quantity'] . ' ອັນ</td><td>₭' . number_format($daily['amount']) . '</td></tr>';
            }
            echo '</tbody></table></td></tr>';
            echo '<tr class="separator-row"><td colspan="9" class="separator"></td></tr>';
        }
    } else {
        // ถ้ามีแค่วันเดียว แสดงแบบ row ปกติ
        foreach ($productGroups as $product) {
            foreach ($product['daily_sales'] as $date => $daily) {
                $dateParts = explode('-', $date);
                $formattedDate = $dateParts[2] . '-' . $dateParts[1] . '-' . $dateParts[0];
                echo '<tr>';
                echo '<td>' . htmlspecialchars($product['pro_id'] ?? '') . '</td>';
                echo '<td><img src="img/products/' . htmlspecialchars($product['product_image'] ?? '') . '" alt="' . htmlspecialchars($product['product_name'] ?? '') . '" onerror="this.src=\'img/Logo.png\'"></td>';
                echo '<td>' . htmlspecialchars($product['product_name'] ?? '') . '</td>';
                echo '<td>' . htmlspecialchars($product['category_id'] ?? '') . '</td>';
                echo '<td>' . htmlspecialchars($product['product_type'] ?? '') . '</td>';
                echo '<td>' . $daily['quantity'] . '</td>';
                echo '<td>₭' . number_format($product['price']) . '</td>';
                echo '<td>₭' . number_format($daily['amount']) . '</td>';
                echo '<td>' . $formattedDate . '</td>';
                echo '</tr>';
            }
        }
    }
} else {
    echo '<tr><td colspan="9" class="loading-message">ບໍ່ພົບຂໍ້ມູນ</td></tr>';
}
?>
