<?php require_once("auth.php"); ?>
<?php require_once("db_con.php"); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/reduce_products.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <title>ສະຫຼຸບຈຳນວນສິນຄ້າທີ່ຂາຍໄດ້</title>
    <link rel="icon" type="image/png" href="/test01/favicon.png">
</head>
<style>
    *{
        font-family: 'Noto Sans Lao';
    }
</style> 
<body>
    <?php include('home.php'); ?>
 
    <div class="content-area">
        <div class="reduce-products-container">
            <div class="table-header">
                <h1><i class="fas fa-shopping-basket"></i> ສະຫຼຸບຈຳນວນສິນຄ້າທີ່ຂາຍໄດ້</h1>
                <div class="filter-container">
                    <div class="date-filter">
                        <label for="date-from">ຈາກວັນທີ:</label>
                        <input type="date" id="date-from" name="date_from">
                        <label for="date-to">ເຖິງວັນທີ:</label>
                        <input type="date" id="date-to" name="date_to">
                        <button type="button" id="filter-btn" class="btn filter-btn"><i class="fas fa-filter"></i> ກັ່ນຕອງ</button>
                        <button type="button" id="reset-btn" class="btn reset-btn"><i class="fas fa-undo"></i> ລ້າງຕົວກອງ</button>
                    </div>
                    
                    <div class="category-filter">
                        <label for="category-filter">ປະເພດສິນຄ້າ:</label>
                        <select id="category-filter">
                            <option value="all">ທັງໝົດ</option>
                            <?php
                            // Get all categories
                            $cat_sql = "SELECT * FROM product_category ORDER BY category_name";
                            $cat_result = $conn->query($cat_sql);
                            
                            if ($cat_result->num_rows > 0) {
                                while($cat_row = $cat_result->fetch_assoc()) {
                                    echo "<option value='".$cat_row['category_id']."'>".$cat_row['category_name']."</option>";
                                }
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div class="search-container">
                        <input type="text" id="product-search" placeholder="ຄົ້ນຫາສິນຄ້າ...">
                    </div>
                </div>
            </div>
            
            <div class="table-container">
                <table class="sold-products-table">
                    <thead>
                        <tr>
                            <th>ລະຫັດສິນຄ້າ</th>
                            <th>ຮູບສິນຄ້າ</th>
                            <th>ຊື່ສິນຄ້າ</th>
                            <th>ປະເພດເຄື່ອງສິນຄ້າ</th>
                            <th>ປະເພດສິນຄ້າຂາຍ</th>
                            <th>ຈຳນວນທີ່ຂາຍໄດ້</th>
                            <th>ລາຄາຂາຍ</th>
                            <th>ລວມເງິນ</th>
                            <th>ວັນທີຂາຍ</th>
                        </tr>
                    </thead>
                    <tbody id="sold-products-table-body">
                        <!-- ตารางจะถูกโหลดด้วย AJAX -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script src="js/reduce_products.js"></script>
</body>
</html>




