<?php
require_once("db_con.php");
$id = isset($_GET['id']) ? $_GET['id'] : '';
$stmt = $conn->prepare("SELECT * FROM products WHERE product_id=?");
$stmt->bind_param("s", $id);
$stmt->execute();
$result = $stmt->get_result();
if($row = $result->fetch_assoc()):
?>
<div class="row align-items-center">
    <div class="col-md-5 text-center mb-3 mb-md-0">
        <div style="background:#f8fafc;border-radius:16px;padding:18px;box-shadow:0 2px 16px rgba(30,41,59,0.09);display:inline-block;">
            <img src="img/products/<?php echo htmlspecialchars($row['product_image']); ?>" 
                 alt="" 
                 class="img-fluid rounded shadow-sm"
                 style="max-height:220px;object-fit:contain;">
        </div>
    </div>
    <div class="col-md-7">
        <h4 class="fw-bold mb-2" style="color:#dc2626;"><?php echo htmlspecialchars($row['product_name']); ?></h4>
        <div class="mb-3">
            <span class="badge bg-danger fs-6" style="vertical-align:middle;">ລາຄາ</span>
            <span class="text-danger fw-bold fs-4 ms-2">₭<?php echo number_format($row['selling_price']); ?></span>
        </div>
        <div class="mb-2">
            <span class="badge bg-secondary">ປະເພດ</span>
            <span class="ms-2"><?php echo htmlspecialchars($row['category_id']); ?></span>
        </div>
        <div class="mb-2">
            <span class="badge bg-success">ຈຳນວນຄົງເຫຼືອ</span>
            <span class="ms-2"><?php echo $row['quantity']; ?></span>
        </div>
        <?php if ($row['quantity'] <= 0): ?>
            <div class="mt-3">
                <span class="badge bg-dark fs-6 px-3 py-2">ສິນຄ້າໝົດ</span>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php endif; $stmt->close(); $conn->close(); ?>