<?php
require_once("auth.php");
require_once("db_con.php");

if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "ບໍ່ພົບລະຫັດໃບສັ່ງຊື້";
    exit;
}

$order_id = $_GET['id'];

// ດຶງຂໍ້ມູນໃບສັ່ງຊື້
$sql = "SELECT po.*, s.store_name, s.store_phone, s.shop_owner_name 
        FROM purchase_orders po
        LEFT JOIN stores s ON po.store_id = s.store_id
        WHERE po.id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo "ບໍ່ພົບຂໍ້ມູນໃບສັ່ງຊື້";
    exit;
}

$order = $result->fetch_assoc();

// ດຶງຂໍ້ມູນລາຍການສິນຄ້າໃນໃບສັ່ງຊື້
$sql = "SELECT poi.*, p.product_name, p.pro_id 
        FROM purchase_order_items poi
        LEFT JOIN products p ON poi.product_id = p.product_id
        WHERE poi.purchase_order_id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$result = $stmt->get_result();

$items = [];
while ($row = $result->fetch_assoc()) {
    $items[] = $row;
}

function formatAmount($amount) {
    $amount = floatval($amount);
    if ($amount == floor($amount)) {
        return number_format($amount, 0);
    } else {
        return number_format($amount, 2);
    }
}
?>

<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ພິມໃບສັ່ງຊື້ - <?php echo htmlspecialchars($order['order_code']); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/print_purchase_order.css">
    <link rel="icon" type="image/png" href="/test01/favicon.png">

</head>
<body>
    <div class="print-button">
        <button onclick="window.print()">ພິມໃບສັ່ງຊື້</button>
    </div>
    
    <div class="order-container">
        <div class="order-header">
            <h1>ໃບສັ່ງຊື້ສິນຄ້າ</h1>
            <h2><?php echo htmlspecialchars($order['order_code']); ?></h2>
        </div>
        
        <div class="order-info">
            <div class="info-group">
                <h3>ຂໍ້ມູນຮ້ານຄ້າ</h3>
                <div class="info-item">
                    <span class="info-label">ຊື່ຮ້ານຄ້າ:</span>
                    <span><?php echo htmlspecialchars($order['store_name'] ?? 'N/A'); ?></span>
                </div>
                <!-- <div class="info-item">
                    <span class="info-label">ທີ່ຢູ່:</span>
                    <span><?php echo htmlspecialchars($order['store_name'] ?? 'N/A'); ?></span>
                </div> -->
                <div class="info-item">
                    <span class="info-label">ເບີໂທ:</span>
                    <span><?php echo htmlspecialchars($order['store_phone'] ?? 'N/A'); ?></span>
                </div>
            </div>
            
            <div class="info-group">
                <h3>ຂໍ້ມູນຜູ້ສະໜອງ</h3>
                <div class="info-item">
                    <span class="info-label">ຊື່ຜູ້ສະໜອງ:</span>
                    <span><?php echo htmlspecialchars($order['supplier_name']); ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">ຂໍ້ມູນຕິດຕໍ່:</span>
                    <span><?php echo htmlspecialchars($order['supplier_contact'] ?? 'N/A'); ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">ວັນທີສັ່ງຊື້:</span>
                    <span><?php echo date('d/m/Y', strtotime($order['order_date'])); ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">ສະຖານະ:</span>
                    <span>
                        <?php 
                        if ($order['status'] == 'pending') echo "ລໍຖ້າ";
                        elseif ($order['status'] == 'completed') echo "ສຳເລັດແລ້ວ";
                        elseif ($order['status'] == 'cancelled') echo "ຍົກເລີກ";
                        ?>
                    </span>
                </div>
            </div>
        </div>
        
        <?php if (!empty($order['notes'])): ?>
        <div class="info-group">
            <h3>ໝາຍເຫດ</h3>
            <p><?php echo nl2br(htmlspecialchars($order['notes'])); ?></p>
        </div>
        <?php endif; ?>
        
        <h3>ລາຍການສິນຄ້າ</h3>
        <table>
            <thead>
                <tr>
                    <th>ລຳດັບ</th>
                    <!-- <th>ລະຫັດສິນຄ້າ</th> -->
                    <th>ຊື່ສິນຄ້າ</th>
                    <th>ຈຳນວນ</th>
                    <th>ລາຄາຕໍ່ຫນ່ວຍ</th>
                    <th>ລວມ</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($items) > 0): ?>
                    <?php $i = 1; foreach ($items as $item): ?>
                        <tr>
                            <td><?php echo $i++; ?></td>
                            <!-- <td><?php echo htmlspecialchars($item['pro_id'] ?? 'N/A'); ?></td> -->
                            <td><?php echo htmlspecialchars($item['product_name'] ?? 'N/A'); ?></td>
                            <td><?php echo number_format($item['quantity'], 0); ?></td>
                            <td><?php echo formatAmount($item['price']); ?> </td>
                            <td><?php echo formatAmount($item['total']); ?> </td>
                        </tr>
                    <?php endforeach; ?>
                    <tr class="total-row">
                        <td colspan="4" style="text-align: right;">ຍອດລວມທັງໝົດ:</td>
                        <td><?php echo formatAmount($order['total_amount']); ?> ກີບ</td>
                    </tr>
                <?php else: ?>
                    <tr>
                        <td colspan="5" style="text-align: center;">ບໍ່ພົບລາຍການສິນຄ້າ</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-line"></div>
                <p>ຜູ້ສັ່ງຊື້</p>
            </div>
            <div class="signature-box">
                <div class="signature-line"></div>
                <p>ຜູ້ອະນຸມັດ</p>
            </div>
            <div class="signature-box">
                <div class="signature-line"></div>
                <p>ຜູ້ສະໜອງ</p>
            </div>
        </div>
    </div>
</body>
</html>





