<?php
require_once("auth.php");
require_once("db_con.php");

$swal = null; // <-- Add this line

// ດຶງຂໍ້ມູນສິນຄ້າທັງຫມົດ
$sql = "SELECT * FROM products ORDER BY product_name";
$result = $conn->query($sql);
$products = [];
if ($result) {
    $products = $result->fetch_all(MYSQLI_ASSOC);
}

// ດຶງຂໍ້ມູນຮ້ານຄ້າ
$sql = "SELECT * FROM stores";
$result = $conn->query($sql);
$stores = [];
if ($result) {
    $stores = $result->fetch_all(MYSQLI_ASSOC);
}

// ຖ້າມີການສົ່ງຟອມ
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_order'])) {
    try {
        $conn->begin_transaction();
        
        // ສ້າງລະຫັດໃບສັ່ງຊື້
        $order_code = "PO-" . date("Ymd") . "-" . rand(1000, 9999);
        
        // ຂໍ້ມູນໃບສັ່ງຊື້
        $store_id = isset($_POST['store_id']) ? $_POST['store_id'] : '';  // ไม่ต้องใช้ intval
        $order_date = date('Y-m-d');
        $supplier_name = isset($_POST['supplier_name']) ? $_POST['supplier_name'] : '';
        $supplier_contact = isset($_POST['supplier_contact']) ? $_POST['supplier_contact'] : '';
        $notes = isset($_POST['notes']) ? $_POST['notes'] : '';
        
        // ບັນທຶກຂໍ້ມູນໃບສັ່ງຊື້
        $sql = "INSERT INTO purchase_orders (order_code, store_id, order_date, supplier_name, 
                supplier_contact, notes, status) 
                VALUES (?, ?, ?, ?, ?, ?, 'pending')";
        
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssss", 
            $order_code, 
            $store_id,  // เປັ່ນຈາກ i ຫຼື່ງ s ຫຼື່ງ string
            $order_date, 
            $supplier_name, 
            $supplier_contact, 
            $notes
        );
        $stmt->execute();
        
        $purchase_order_id = $conn->insert_id;
        
        // ບັນທຶກລາຍການສິນຄ້າ
        $product_ids = isset($_POST['product_id']) ? $_POST['product_id'] : [];
        $quantities = isset($_POST['quantity']) ? $_POST['quantity'] : [];
        $prices = isset($_POST['price']) ? $_POST['price'] : [];
        
        $total_amount = 0;
        
        for ($i = 0; $i < count($product_ids); $i++) {
            if (!empty($product_ids[$i]) && !empty($quantities[$i]) && !empty($prices[$i])) {
                $product_id = $product_ids[$i];
                $quantity = $quantities[$i];
                $price = $prices[$i];
                $total = $quantity * $price;
                $total_amount += $total;
                
                $sql = "INSERT INTO purchase_order_items (purchase_order_id, product_id, quantity, price, total) 
                        VALUES (?, ?, ?, ?, ?)";
                
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("iiddd", 
                    $purchase_order_id, 
                    $product_id, 
                    $quantity, 
                    $price, 
                    $total
                );
                $stmt->execute();
            }
        }
        
        // ອັບເດດຍອດລວມໃນໃບສັ່ງຊື້
        $sql = "UPDATE purchase_orders SET total_amount = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("di", $total_amount, $purchase_order_id);
        $stmt->execute();
        
        $conn->commit();

        // ເປີດໜ້າພິມໃບສັ່ງຊື້
        echo "<script>window.open('print_purchase_order?id=" . $purchase_order_id . "', '_blank');</script>";

        // Set SweetAlert2 success message for later output
        $swal = [
            'icon' => 'success',
            'title' => 'ສ້າງໃບສັ່ງຊື້ສຳເລັດແລ້ວ',
            'confirmButtonText' => 'ຕົກລົງ'
        ];

    } catch (Exception $e) {
        $conn->rollback();
        // Set SweetAlert2 error message for later output
        $swal = [
            'icon' => 'error',
            'title' => 'ເກີດຂໍ້ຜິດພາດ',
            'text' => addslashes($e->getMessage()),
            'confirmButtonText' => 'ຕົກລົງ'
        ];
    }
}
?>

<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/print_order.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <title>ພີມລາຍງານໃບສັ່ງຊື້ສິນຄ້າ</title>
    <link rel="icon" type="image/png" href="/test01/favicon.png">

</head>
<body>
    <?php include('home.php'); ?>
    
    <div class="content-area">
        
        
        <form method="post" class="order-form">
            <h2><i class="fa fa-cart-plus"></i>ສ້າງໃບສັ່ງຊື້ສິນຄ້າ</h2>
            <div class="form-group">
                <label for="store_id">ຮ້ານຄ້າ:</label>
                <select name="store_id" id="store_id" class="form-control" required>
                    <option value="">ເລືອກຮ້ານຄ້າ</option>
                    <?php foreach ($stores as $store): ?>
                        <option value="<?php echo htmlspecialchars($store['store_id']); ?>">
                            <?php echo htmlspecialchars($store['store_name'] ?? ''); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="supplier_name">ຊື່ຜູ້ສະໜອງ:</label>
                <input type="text" name="supplier_name" id="supplier_name" class="form-control" required>
            </div>
            
            <div class="form-group">
                <label for="supplier_contact">ເບີຕິດຕໍ່ຜູ້ສະໜອງ:</label>
                <input type="text" name="supplier_contact" id="supplier_contact" class="form-control">
            </div>
            
            <div class="form-group">
                <label for="notes">ໝາຍເຫດ:</label>
                <textarea name="notes" id="notes" class="form-control" rows="3"></textarea>
            </div>
            
            <h2>ລາຍການສິນຄ້າ</h2>
            
            <button type="button" class="btn-add-row" id="add-row">+ ເພີ່ມລາຍການສິນຄ້າ</button>
            
            <table class="items-table" id="items-table">
                <thead>
                    <tr>
                        <th>ສິນຄ້າ</th>
                        <th>ຈຳນວນ</th>
                        <th>ລາຄາຕໍ່ຫນ່ວຍ</th>
                        <th>ລວມ</th>
                        <th>ຈັດການ</th>
                    </tr>
                </thead>
                <tbody id="items-body">
                    <tr>
                        <td>
                            <select name="product_id[]" class="form-control product-select" required>
                                <option value="">ຄົ້ນຫາແລະເລືອກສິນຄ້າ...</option>
                                <?php foreach ($products as $product): ?>
                                    <option value="<?php echo htmlspecialchars($product['product_id'] ?? ''); ?>" 
                                            data-price="<?php echo htmlspecialchars($product['price'] ?? '0'); ?>"
                                            data-image="<?php echo htmlspecialchars($product['product_image'] ?? 'default.png'); ?>">
                                        <div class="product-option-content">
                                            <?php echo htmlspecialchars($product['product_name'] ?? ''); ?>
                                        </div>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </td>
                        <td><input type="number" name="quantity[]" class="form-control quantity" min="1" value="1" required></td>
                        <td><input type="number" name="price[]" class="form-control price" min="0" step="0.01" required></td>
                        <td><span class="row-total">0</span></td>
                        <td><button type="button" class="btn-remove-row">ລຶບ</button></td>
                    </tr>
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="3" style="text-align: right;"><strong>ຍອດລວມທັງໝົດ:</strong></td>
                        <td><span id="grand-total">0</span></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
            
            <button type="submit" name="create_order" class="btn-submit">ສ້າງໃບສັ່ງຊື້</button>
        </form>
    </div>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize Select2 for product dropdowns
            $('.product-select').select2({
                templateResult: formatProduct,
                templateSelection: formatProductSelection,
                dropdownPosition: 'above',
                dropdownParent: $('body'),
                placeholder: 'ຄົ້ນຫາແລະເລືອກສິນຄ້າ...',
                allowClear: true,
                language: {
                    searching: function() {
                        return 'ກຳລັງຄົ້ນຫາ...';
                    },
                    noResults: function() {
                        return 'ບໍ່ພົບສິນຄ້າ';
                    }
                }
            });
            
            // Format product options in dropdown
            function formatProduct(product) {
                if (!product.id) {
                    return product.text;
                }
                
                var imageUrl = 'img/products/' + $(product.element).data('image');
                var $product = $(
                    '<div class="product-option-content">' +
                    '<img src="' + imageUrl + '" class="product-image" onerror="this.src=\'img/Logo.png\'" />' +
                    '<span>' + product.text + '</span>' +
                    '</div>'
                );
                
                return $product;
            }
            
            // Format selected product
            function formatProductSelection(product) {
                if (!product.id) {
                    return product.text;
                }
                
                var imageUrl = 'img/products/' + $(product.element).data('image');
                var $product = $(
                    '<div class="product-option-content">' +
                    '<img src="' + imageUrl + '" class="product-image" style="width: 25px; height: 25px;" onerror="this.src=\'img/Logo.png\'" />' +
                    '<span>' + product.text + '</span>' +
                    '</div>'
                );
                
                return $product;
            }
            
            // Re-initialize Select2 when adding new rows
            function initializeNewRowSelect2(row) {
                $(row).find('.product-select').select2({
                    templateResult: formatProduct,
                    templateSelection: formatProductSelection,
                    dropdownPosition: 'above',
                    dropdownParent: $('body'),
                    placeholder: 'ຄົ້ນຫາແລະເລືອກສິນຄ້າ...',
                    allowClear: true,
                    language: {
                        searching: function() {
                            return 'ກຳລັງຄົ້ນຫາ...';
                        },
                        noResults: function() {
                            return 'ບໍ່ພົບສິນຄ້າ';
                        }
                    }
                });
            }
            
            // Force dropdowns to open upwards
            $(document).on('select2:open', '.product-select', function() {
                setTimeout(function() {
                    $('.select2-dropdown').addClass('select2-dropdown--above');
                    $('.select2-dropdown').removeClass('select2-dropdown--below');
                    $('.select2-container--open .select2-selection__arrow b').css('border-width', '0 4px 5px 4px');
                }, 0);
            });
            
            // ເພີ່ມແຖວໃໝ່
            document.getElementById('add-row').addEventListener('click', function() {
                addNewRow();
            });
            
            // ລຶບແຖວ
            document.getElementById('items-body').addEventListener('click', function(e) {
                if (e.target.classList.contains('btn-remove-row')) {
                    if (document.querySelectorAll('#items-body tr').length > 1) {
                        e.target.closest('tr').remove();
                        calculateTotals();
                    } else {
                        Swal.fire({
                                    icon: 'warning',
                                    title: 'ຕ້ອງມີຢ່າງໜ້ອຍ 1 ລາຍການ',
                                    confirmButtonText: 'ຕົກລົງ'
                                });
                    }
                }
            });
            
            // ຄຳນວນລາຄາ
            $(document).on('change', '.product-select', function() {
                const row = $(this).closest('tr')[0];
                const priceInput = row.querySelector('.price');
                const selectedOption = this.options[this.selectedIndex];
                
                if (selectedOption && selectedOption.dataset && selectedOption.dataset.price) {
                    priceInput.value = selectedOption.dataset.price;
                }
                
                calculateRowTotal(row);
                calculateTotals();
            });
            
            document.getElementById('items-body').addEventListener('input', function(e) {
                if (e.target.classList.contains('quantity') || e.target.classList.contains('price')) {
                    if (e.target.closest('tr')) {
                        calculateRowTotal(e.target.closest('tr'));
                        calculateTotals();
                    }
                }
            });
            
            // ຄຳນວນລາຄາລວມຂອງແຖວ
            function calculateRowTotal(row) {
                if (!row) return;
                
                const quantityEl = row.querySelector('.quantity');
                const priceEl = row.querySelector('.price');
                const rowTotalEl = row.querySelector('.row-total');
                
                if (!quantityEl || !priceEl || !rowTotalEl) return;
                
                const quantity = parseFloat(quantityEl.value) || 0;
                const price = parseFloat(priceEl.value) || 0;
                const total = quantity * price;
                
                rowTotalEl.textContent = total.toFixed(2);
            }
            
            // ຄຳນວນລາຄາລວມທັງໝົດ
            function calculateTotals() {
                let grandTotal = 0;
                const rowTotals = document.querySelectorAll('.row-total');
                
                rowTotals.forEach(function(element) {
                    grandTotal += parseFloat(element.textContent) || 0;
                });
                
                const grandTotalEl = document.getElementById('grand-total');
                if (grandTotalEl) {
                    grandTotalEl.textContent = grandTotal.toFixed(2);
                }
            }
            
            // ເພີ່ມແຖວໃໝ່
            function addNewRow() {
                const tbody = document.getElementById('items-body');
                if (!tbody) return;
                
                const firstRow = tbody.querySelector('tr');
                if (!firstRow) return;
                
                // Destroy Select2 before cloning
                $(firstRow).find('.product-select').select2('destroy');
                
                const newRow = firstRow.cloneNode(true);
                
                // ລ້າງຄ່າໃນແຖວໃໝ່
                const productSelect = newRow.querySelector('.product-select');
                const quantity = newRow.querySelector('.quantity');
                const price = newRow.querySelector('.price');
                const rowTotal = newRow.querySelector('.row-total');
                
                if (productSelect) productSelect.value = '';
                if (quantity) quantity.value = '1';
                if (price) price.value = '';
                if (rowTotal) rowTotal.textContent = '0';
                
                tbody.appendChild(newRow);
                
                // Re-initialize Select2 for both rows
                initializeNewRowSelect2(firstRow);
                initializeNewRowSelect2(newRow);
            }
            
            // ຄຳນວນລາຄາເລີ່ມຕົ້ນ
            calculateTotals();
        });
    </script>
    <?php if ($swal): ?>
    <script>
        Swal.fire({
            icon: '<?php echo $swal['icon']; ?>',
            title: '<?php echo $swal['title']; ?>',
            <?php if (isset($swal['text'])): ?>
            text: '<?php echo $swal['text']; ?>',
            <?php endif; ?>
            confirmButtonText: '<?php echo $swal['confirmButtonText']; ?>'
        });
    </script>
    <?php endif; ?>
</body>
</html>














