<?php
require_once("auth.php");
require_once("db_con.php");

$order_ids = [];
if (isset($_GET['order_ids'])) {
    $order_ids = explode(',', $_GET['order_ids']);
}

if (empty($order_ids)) {
    header("Location: invoice_history");
    exit;
}

$sanitized_order_ids = [];
foreach ($order_ids as $id) {
    $sanitized_order_ids[] = $conn->real_escape_string(trim($id));
}

$placeholders = implode(',', array_fill(0, count($sanitized_order_ids), '?'));
$types = str_repeat('s', count($sanitized_order_ids));
?>

<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ພິມໃບບິນຫຼາຍລາຍການ</title>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" type="image/png" href="/test01/favicon.png">
    <style>
        .to {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        @media print {
            @page {
                size: 70mm 100mm;
                margin: 0;
            }
            
            * {
                font-family: 'Noto Sans Lao', sans-serif !important;
                margin: 0;
                padding: 0;
                box-sizing: border-box;
            }
            
            body {
                width: 70mm;
                margin: 0;
                padding: 2mm 2mm;
                font-size: 6pt;
            }
            
            .bill-header {
                margin-top: -4px;
                margin-bottom: -5px;
                text-align: center;
            }
            
            .bill-header h1 {
                font-size: 20px !important;
                margin-bottom: 0.5mm;
                margin-top: 0;
            }
            
            .bill-header h2 {
                font-size: 11px !important;
                margin-bottom: 0.5mm;
                margin-top: 0.5mm;
            }
            
            .bill-header p {
                font-size: 8px !important;
                margin: 0.3mm 0;
            }
            
            .sender-receiver {
                display: flex;
                justify-content: space-between;
                margin-top: -5px;
                padding-right: 1mm;
                padding-left: 1mm;
                gap: 2mm;
            }
            
            .sender-receiver h1 {
                font-size: 16px !important;
                margin: 0 0 1mm 0;
                margin-bottom: 1mm;
                text-align: center;
            }
            
            .sender-receiver p {
                font-size: 11px !important;
                margin-bottom: 0.5mm;
            }
            
            .transport-info {
                padding-right: 1mm;
                padding-left: 1mm;
                display: flex;
                justify-content: space-between;
                gap: 2mm;
                text-align: center;
            }
            
            .transport-info h2 {
                font-size: 11px !important;
                margin-bottom: 1mm;
            }
            
            .transport-info p {
                font-size: 11px !important;
            }
            
            .transport-info .transport-branch p {
                font-size: 11px !important;
            }
            
            .price-info {
                padding-right: 6mm;
                padding-left: 6mm;
                display: flex;
                justify-content: space-between;
                margin-top: -8px;
                margin-bottom: -9px;
                gap: 2mm;
                text-align: center;
            }
            
            .price-info h2 {
                font-size: 11px !important;
                margin-bottom: 1mm;
            }
            
            .price-info p {
                font-size: 11px !important;
            }
            
            hr {
                margin: 1.5mm 0;
                border: none;
                border-top: 0.1pt solid #999;
            }
            
            table {
                width: 100%;
                border-collapse: collapse;
                margin: 1.5mm 0;
            }
            
            th, td {
                border: 0.1pt solid #999;
                padding: 0.8mm;
                text-align: left;
                font-size: 6pt;
            }
            
            th {
                background-color: #f8f8f8;
            }
            
            .thank-you {
                text-align: center;
                margin-bottom: 10px;
            }
            
            .thank-you h2 {
                font-size: 11px !important;
                margin: 0;
            }
            
            strong {
                font-weight: bold;
            }
            
            .print-button {
                text-align: center;
                margin: 20px 0;
            }
            
            .print-button button {
                padding: 10px 20px;
                background-color: #4a90e2;
                color: white;
                border: none;
                border-radius: 4px;
                cursor: pointer;
                font-size: 14px;
            }
            
            @media print {
                .print-button {
                    display: none;
                }
            }
            
            .invoice-container {
                page-break-after: always;
                width: 70mm;
                margin: 0 auto;
                padding: 2mm 2mm;
            }
            
            .invoice-container:last-child {
                page-break-after: auto;
            }
        }
        
        /* SweetAlert2 Noto Sans Lao Font */
        .swal2-popup {
            font-family: 'Noto Sans Lao', sans-serif !important;
        }
        .swal2-title {
            font-family: 'Noto Sans Lao', sans-serif !important;
        }
        .swal2-content {
            font-family: 'Noto Sans Lao', sans-serif !important;
        }
        .swal2-confirm, .swal2-cancel {
            font-family: 'Noto Sans Lao', sans-serif !important;
        }
    </style>
</head>
<body>
    <div class="print-button">
        <button onclick="window.print()">ພິມໃບບິນ</button>
    </div>
    
    <?php
    $sql = "SELECT o.*, c.name as customer_name, c.phone as customer_phone, sc.shipping_name, s.store_name, s.store_phone, s.shop_owner_name 
            FROM orders o
            LEFT JOIN customers c ON o.customer_id = c.customer_id COLLATE utf8mb4_general_ci
            LEFT JOIN shipping_company sc ON o.shipping_company = sc.shipping_id COLLATE utf8mb4_general_ci
            LEFT JOIN stores s ON o.store_id = s.store_id COLLATE utf8mb4_general_ci
            WHERE o.order_id IN ($placeholders)";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param($types, ...$sanitized_order_ids);
    $stmt->execute();
    $result = $stmt->get_result();
    
    while ($order = $result->fetch_assoc()) {
        $order_id = $order['order_id'];
        $items_sql = "SELECT oi.*, p.product_name, p.pro_id 
                      FROM order_items oi 
                      LEFT JOIN products p ON oi.product_id = p.product_id 
                      WHERE oi.order_id = ?";
        
        $items_stmt = $conn->prepare($items_sql);
        $items_stmt->bind_param("s", $order_id);
        $items_stmt->execute();
        $items_result = $items_stmt->get_result();
        
        $items = [];
        while ($item = $items_result->fetch_assoc()) {
            $items[] = $item;
        }
        
        ?>
        <div class="invoice-container">
            <div class="bill-container">
                <div class="bill-header">
                    <h1>ບິນຝາກພັດສະດຸ</h1>
                    <h2 style="margin-top:-5px;"><?php echo htmlspecialchars($order['store_name'] ?? ''); ?></h2>
                    <div class="to">
                        <p style="font-size: 11px;">ເລກທີບິນ: <?php echo htmlspecialchars($order['order_id']); ?></p>
                        <p style="font-size: 11px;">ວັນທີ: <?php echo date('d/m/Y', strtotime($order['order_date'])); ?></p>
                    </div>
                </div>
                
                <hr>
                
                <div class="sender-receiver">
                    <div class="sender">
                        <h1>ຜູ້ຝາກ</h1>
                        <p style="font-size: 11px;"><strong>ຊື່:</strong> <?php echo htmlspecialchars($order['shop_owner_name'] ?? ''); ?></p>
                        <p style="font-size: 11px;"><strong>ເບີໂທ:</strong><?php echo htmlspecialchars($order['store_phone'] ?? 'XXXXXXXX'); ?></p>
                    </div>
                    <div class="receiver">
                        <h1>ຜູ້ຮັບ</h1>
                        <p style="font-size: 11px;"><strong>ຊື່ລູກຄ້າ:</strong> <?php echo htmlspecialchars($order['customer_name'] ?? 'ບໍ່ມີຂໍ້ມູນ'); ?></p>
                        <p style="font-size: 11px;"><strong>ເບີໂທ:</strong> <?php echo htmlspecialchars($order['customer_phone'] ?? 'ບໍ່ມີຂໍ້ມູນ'); ?></p>
                    </div>
                </div>
                
                <hr>
                
                <div class="transport-info">
                    <div class="transport-company">
                        <h2>ບໍລິສັດຂົນສົ່ງ</h2>
                        <p style="font-size: 11px;"><?php echo htmlspecialchars($order['shipping_name'] ?? 'ບໍ່ມີຂໍ້ມູນ'); ?></p>
                    </div>
                    <div class="transport-branch">
                        <h2 style="text-align: right;margin-right: 10px;">ສາຂາຂົນສົ່ງ: <p style="font-weight: normal; font-size: 11px;"><?php echo htmlspecialchars($order['shipping_branch'] ?? 'ບໍ່ມີຂໍ້ມູນ'); ?></p></h2>
                    </div>
                </div>
                
                <hr>
                
                <div class="price-info" style="margin-bottom: 2mm;">
                    <div class="price">
                        <h2>ລາຄາ</h2>
                        <p style="font-size: 11px;"><?php 
                            if ($order['payment_status'] == 'ຈ່າຍເເລ້ວ' || $order['payment_status'] == 'ຈ່າຍແລ້ວ') {
                                echo "ຈ່າຍເເລ້ວ";
                            } else {
                                $subtotal = floatval($order['subtotal'] ?? 0);
                                $discount = floatval($order['discount'] ?? 0);
                                $depositAmount = floatval($order['deposit_amount'] ?? 0);
                                $remainingAmount = $subtotal - $discount - $depositAmount;
                                echo number_format($remainingAmount, 0) . " ກີບ"; 
                            }
                        ?></p>
                    </div>
                    <div class="deposit">
                        <h2>ຄ່າຝາກ</h2>
                        <p style="font-size: 11px;"><?php echo htmlspecialchars($order['cod_type'] ?? 'ບໍ່ມີຂໍ້ມູນ'); ?></p>
                    </div>
                </div>
                
                <hr>
                
                <div style="font-size: 11px;">
                    <?php if (count($items) > 0): ?>
                        <?php foreach ($items as $item): ?>
                            <?php echo htmlspecialchars($item['product_name'] ?? 'ບໍ່ມີຂໍ້ມູນ'); ?>: <?php echo number_format($item['quantity'], 0); ?><br>
                        <?php endforeach; ?>
                    <?php else: ?>
                        ບໍ່ພົບລາຍການສິນຄ້າ
                    <?php endif; ?>
                </div>
                
                <hr>
                
                <div class="thank-you">
                    <h2 style="font-size: 11px;">ຂອບໃຈທີ່ໃຊ້ບໍລິການ🤍</h2>
                </div>
            </div>
        </div>
        <?php
        
        $items_stmt->close();
    }
    
    $stmt->close();
    ?>
    
    <script>
document.addEventListener('DOMContentLoaded', function() {
    // ดึง order_ids จาก PHP (array)
    var orderIds = <?php echo json_encode($order_ids ?? []); ?>;
    // ประเภทการขาย (กรณีนี้คือขายออนไลน์)
    var saleType = "ຂາຍອອນລາຍ";
    
    var printDialogOpened = false;
    var userPrinted = false;

    // เรียก print dialog
    setTimeout(function() {
        printDialogOpened = true;
        window.print();
    }, 500);

    // ตรวจสอบว่าผู้ใช้ print จริงหรือ cancel
    window.onafterprint = function() {
        if (printDialogOpened) {
            // แสดง SweetAlert2 ให้ผู้ใช้ยืนยันว่าได้ print แล้วจริงหรือไม่
            Swal.fire({
                title: 'ຢືນຢັນການພິມ',
                text: 'ທ່ານໄດ້ພິມໃບບິນແລ້ວບໍ່?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#28a745',
                cancelButtonColor: '#dc3545',
                confirmButtonText: '✓ ພິມແລ້ວ',
                cancelButtonText: '✗ ຍົກເລີກ',
                allowOutsideClick: false,
                allowEscapeKey: false
            }).then((result) => {
                if (result.isConfirmed) {
                    userPrinted = true;
                    updatePrintedStatus();
                } else {
                    // ผู้ใช้ยกเลิก ไม่อัปเดตสถานะ
                    userPrinted = true; // ตั้งค่าเป็น true เพื่อปิด onbeforeunload
                    window.close();
                }
            });
        }
    };
    
    function updatePrintedStatus() {
        fetch('update_printed_status.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify({
                order_ids: orderIds,
                type: saleType
            })
        })
        .then(res => res.json())
        .then(data => {
            if (data.status === 'success') {
                Swal.fire({
                    title: 'ສຳເລັດ!',
                    text: 'ອັບເດດສະຖານະການພິມແລ້ວ',
                    icon: 'success',
                    timer: 1500,
                    showConfirmButton: false
                }).then(() => {
                    window.close();
                });
            } else {
                window.close();
            }
        })
        .catch(error => {
            console.error('Error:', error);
            window.close();
        });
    }

    // ถ้าผู้ใช้ปิดหน้าต่างโดยไม่ print
    window.onbeforeunload = function() {
        if (!userPrinted && printDialogOpened) {
            return 'ທ່ານຍັງບໍ່ໄດ້ພິມໃບບີນ ສະຖານະການພິມຈະບໍ່ຖືກອັບເດດ';
        }
    };
});
    </script>
</body>
</html>


