<?php
require_once("auth.php");
require_once("db_con.php");

$order_ids = [];
if (isset($_GET['order_ids'])) {
    $order_ids = explode(',', $_GET['order_ids']);
} elseif (isset($_GET['order_id'])) {
    $order_ids = [$_GET['order_id']];
}

if (empty($order_ids)) {
    echo "ບໍ່ພົບລະຫັດໃບບິນ"; 
    exit;
}
?>
<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <title>ໃບບິນຫນ້າຮ້ານ</title>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" type="image/png" href="/test01/favicon.png">
    <style>
        html, body {
            /* width: 70mm; */
            /* height: 100mm; */
            /* min-width: 70mm; */
            /* min-height: 100mm; */
            /* max-width: 70mm; */
            /* max-height: 100mm; */
            margin: 0 auto;
            padding: 0;
            box-sizing: border-box;
            background: #fff;
            color: #000;
            /* overflow: hidden; */
        }
        @media print {
            @page {
                size: 70mm 100mm;
                margin: 0;
            }
            html, body {
                /* width: 70mm; */
                /* height: 100mm; */
                /* min-width: 70mm; */
                /* min-height: 100mm; */
                /* max-width: 70mm; */
                /* max-height: 100mm; */
                margin: 0;
                padding: 0;
                /* overflow: hidden; */
            }
        }
        .bill-container {
            width: 70mm;
            height: 100mm;
            box-sizing: border-box;
            padding: 8px 8px 8px 8px;
            display: block;
            page-break-after: always;
        }
            .bill-container:not(:first-of-type) {
            page-break-before: always;
        }
        .bill-header {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            align-items: flex-start;
            width: 100%;
            padding-bottom: 8px;
            margin-bottom: 2mm;
            position: relative;
            border-bottom: 1px solid #bbb;
            /* เต็มหน้ากระดาษ */
            box-sizing: border-box;
        }
        .bill-header img {
            width: 35px;
           
            object-fit: contain;
            margin-bottom: 0;
            margin-top: 0;
            margin-left: 0;
        }
        .bill-title {
            
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 0.2mm;
            text-align: center;
            flex: 1 1 auto;
        }
        .bill-shop {
            font-size: 8pt;
            font-weight: 500;
            margin-bottom: 0;
            text-align: center;
            flex: 1 1 auto;
        }
        .bill-header div[style*="text-align: right"] span {
            font-size: 7pt !important;
        }
        .bill-date-row {
            display: flex;
            justify-content: space-between;
            font-size: 9pt;
            margin-bottom: 2mm;
            flex: 0 0 auto;
            text-align: right;
            align-self: flex-start;
            min-width: 32mm;
        }
        .bill-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 7pt;
            margin-bottom: 2mm;
        }
        .bill-table th, .bill-table td {
            border-bottom: none;
            padding: 0.5px 0;
            text-align: center;
        }
        .bill-table th {
            font-weight: bold;
        }
        .bill-table td {
            font-weight: 400;
        }
        .bill-table .item-name {
            text-align: left;
            padding-left: 2mm;
            width: 32mm;
            max-width: 32mm;
            word-break: break-all;
        }
        .bill-table .item-qty, .bill-table .item-price {
            width: 12mm;
        }
        .bill-table .item-no {
            width: 8mm;
        }
        .bill-table .item-price {
            text-align: right;
            padding-right: 2mm;
        }
        .bill-table .item-qty {
            text-align: center;
        }
        .bill-table .item-no {
            text-align: center;
        }
        .bill-table .empty-row td {
            border: none;
            color: #bbb;
        }
        .bill-total-row {
            font-size: 14px;
            font-weight: bold;
            text-align: right;
            margin-top: -4px;
            margin-bottom: 1mm;
            border-top: 1px solid #bbb;
            border-bottom: 1px solid #bbb;
            width: 100%;
            box-sizing: border-box;
            padding: 4px 0 2px 0;
            line-height: 1.2;
        }
        .bill-footer {
            margin-top: -5px;
            font-size: 7pt;
        }
        .bill-social {
            font-size: 7pt;
        }
        .thankyou {
            margin-top: 2px;
            font-size: 5pt;
            text-align: center;
            width: 100%;
            display: block;
        }
        .print-button {
            text-align: center;
            margin: 10px 0;
        }
        .print-button button {
            padding: 8px 18px;
            background-color: #4a90e2;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }
        @media print {
            .print-button { display: none; }
        }
        html, body, .bill-container, .bill-header, .bill-title, .bill-shop, .bill-date-row, .bill-table, .bill-table th, .bill-table td, .bill-total-row, .bill-footer, .bill-social, .thankyou, .print-button, .print-button button {
            font-family: 'Noto Sans Lao', sans-serif !important;
        }
        
        /* SweetAlert2 Noto Sans Lao Font */
        .swal2-popup {
            font-family: 'Noto Sans Lao', sans-serif !important;
        }
        .swal2-title {
            font-family: 'Noto Sans Lao', sans-serif !important;
        }
        .swal2-content {
            font-family: 'Noto Sans Lao', sans-serif !important;
        }
        .swal2-confirm, .swal2-cancel {
            font-family: 'Noto Sans Lao', sans-serif !important;
        }
    </style>
</head>
<body>
    <div class="print-button">
        <button onclick="window.print()">ພິມໃບບິນ</button>
    </div>
    <?php foreach ($order_ids as $order_id): ?>
    <?php
    $sql = "SELECT o.*, c.name as customer_name, c.phone as customer_phone, sc.shipping_name, s.store_name, s.store_phone, s.shop_owner_name 
            FROM orders o 
            LEFT JOIN customers c ON o.customer_id = c.customer_id COLLATE utf8mb4_general_ci
            LEFT JOIN shipping_company sc ON o.shipping_company = sc.shipping_id COLLATE utf8mb4_general_ci
            LEFT JOIN stores s ON o.store_id = s.store_id COLLATE utf8mb4_general_ci
            WHERE o.order_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $order_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows === 0) {
        echo "<div style='color:red;'>ບໍ່ພົບຂໍ້ມູນໃບບິນ: $order_id</div>";
        continue;
    }
    $order = $result->fetch_assoc();
    // --- ดึงรายการสินค้า ---
    $sql = "SELECT oi.*, p.product_name 
            FROM order_items oi 
            LEFT JOIN products p ON oi.product_id = p.product_id 
            WHERE oi.order_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $order_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $items = [];
    while ($row = $result->fetch_assoc()) {
        $items[] = $row;
    }
    $logo = 'img/Logo.png';
    $date = date('d/m/Y', strtotime($order['order_date']));
    $total = 0;
    ?>
    <div class="bill-container">
        <div class="bill-header">
            <div style="flex: 0 0 auto; display: flex; flex-direction: column; align-items: flex-start; padding-top: 6px;">
                <img src="<?= $logo ?>" alt="logo" style="object-fit: contain; margin-bottom: 5px; margin-top: 0; margin-left: 0; display: block;">
            </div>
            <div style="position: absolute; left: 0; right: 0; top: -6px; text-align: center; z-index: 2; padding-top: 0;">
                <div class="bill-title" style="margin-top: 0; margin-bottom: 0mm;">ໃບບິນຊື້-ຂາຍ</div>
                <div class="bill-shop" style="margin-top: -4px; margin-bottom: 0;">ຮ້ານ Jຕຸກຂາຍເຄື່ອງໃຊ້ໄຟຟ້າ</div>
            </div>
            <div style="flex: 0 0 auto; text-align: right; align-self: flex-start; min-width: 32mm; padding-top: 0;">
                <span style="display:block; font-size:7pt;">ເລກທີ: <?= htmlspecialchars($order['order_id']) ?></span>
                <span style="display:block; font-size:7pt; margin-top:1mm;"><?= $date ?></span>
            </div>
        </div>
    
        <table class="bill-table">
            <thead>
            <tr>
                <th class="item-no">ອັນດັບ</th>
                <th class="item-name">ລາຍການ</th>
                <th class="item-qty">ຈຳນວນ</th>
                <th class="item-price">ລາຄາ</th>
            </tr>
            </thead>
            <tbody>
            <?php
            $maxRows = 15;
            $i = 1;
            foreach ($items as $item):
                $total += $item['total'];
            ?>
            <tr>
                <td class="item-no"><?= $i ?></td>
                <td class="item-name"><?= htmlspecialchars($item['product_name']) ?></td>
                <td class="item-qty"><?= $item['quantity'] ?></td>
                <td class="item-price"><?= number_format($item['total']) ?>K</td>
            </tr>
            <?php $i++; endforeach; ?>
            <?php
            $itemCount = count($items);
            if ($itemCount < 7) {
                for ($j = $itemCount + 1; $j <= 7; $j++) {
            ?>
            <tr class="empty-row">
                <td>-</td><td></td><td></td><td></td>
            </tr>
            <?php
                }
            }
            ?>
            </tbody>
        </table>
        <div class="bill-total-row" style="border-top: 1px solid #bbb; border-bottom: 1px solid #bbb; padding: 4px 0 2px 0; margin-top: -4px; margin-bottom: 1mm; font-size: 18px; text-align: right; line-height: 1.2;">
            <span style="font-size:13px; font-weight:bold; color:#EE4035;">ລາຄາລວມທີ່ຕ້ອງຈ່າຍ: <?= number_format($total - floatval($order['discount']) - floatval($order['deposit_amount'])) ?> K</span><br>
            <?php if ($order['payment_status'] === 'ຍັງບໍ່ຈ່າຍ'): ?>
                <span style="font-size:13px; font-weight:bold; color:#EE4035;">ຍັງບໍ່ທັນຈ່າຍ</span>
            <?php elseif ($order['payment_status'] === 'ມັດຈຳ'): ?>
                <span style="font-size:13px; font-weight:bold; color:#EE4035;">ມັດຈຳ: <?= number_format(floatval($order['deposit_amount'])) ?> K</span>
            <?php elseif ($order['payment_method'] === 'ໂອນ'): ?>
                <span style="font-size:13px; font-weight:bold; color:#EE4035;">ໂອນຈ່າຍ</span>
            <?php else: ?>
                <span style="font-size:9px; font-weight:normal; color:#333; margin-top:0; margin-bottom:0;">ເງິນທີ່ໄດ້ຮັບ : <?= isset($order['cash_received']) ? number_format($order['cash_received']) : '-' ?> K</span><br>
                <span style="font-size:9px; font-weight:normal; color:#333; margin-top:0; margin-bottom:0;">ເງິນທອນ : <?= (isset($order['cash_received']) && ($order['cash_received'] - ($total - floatval($order['discount']) - floatval($order['deposit_amount'])) >= 0)) ? number_format($order['cash_received'] - ($total - floatval($order['discount']) - floatval($order['deposit_amount']))) : '-' ?> K</span>
            <?php endif; ?>
        </div>
        <div class="bill-footer">
            <div class="bill-social">
                <i class="fab fa-tiktok"></i>
                <i class="fab fa-facebook"></i> Jຕຸກຂາຍເຄື່ອງໃຊ້ໄຟຟ້າ
                <i class="fab fa-whatsapp"></i> 020 7695 1620
            </div>
            <div class="thankyou" style="text-align:center; width:100%; display:block;">THANK YOU <span style="font-size:5pt;">☺</span></div>
        </div>
    </div>
    <?php endforeach; ?>
    <script>
document.addEventListener('DOMContentLoaded', function() {
    // ดึง order_ids จาก PHP (รองรับทั้ง order_id เดี่ยวและหลายใบ)
    var orderIds = <?php echo json_encode($order_ids); ?>;
    // ประเภทการขาย (กรณีนี้คือขายหน้าร้าน)
    var saleType = "ຂາຍໜ້າຮ້ານ";
    
    var printDialogOpened = false;
    var userPrinted = false;

    // เรียก print dialog
    setTimeout(function() {
        printDialogOpened = true;
        window.print();
    }, 500);

    // ตรวจสอบว่าผู้ใช้ print จริงหรือ cancel
    window.onafterprint = function() {
        if (printDialogOpened) {
            // แสดง SweetAlert2 ให้ผู้ใช้ยืนยันว่าได้ print แล้วจริงหรือไม่
            Swal.fire({
                title: 'ຢືນຢັນການພິມ',
                text: 'ທ່ານໄດ້ພິມໃບບິນແລ້ວບໍ່?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#28a745',
                cancelButtonColor: '#dc3545',
                confirmButtonText: '✓ ພິມແລ້ວ',
                cancelButtonText: '✗ ຍົກເລີກ',
                allowOutsideClick: false,
                allowEscapeKey: false
            }).then((result) => {
                if (result.isConfirmed) {
                    userPrinted = true;
                    updatePrintedStatus();
                } else {
                    // ผู้ใช้ยกเลิก ไม่อัปเดตสถานะ
                    userPrinted = true; // ตั้งค่าเป็น true เพื่อปิด onbeforeunload
                    window.close();
                }
            });
        }
    };
    
    function updatePrintedStatus() {
        fetch('update_printed_status.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify({
                order_ids: orderIds,
                type: saleType
            })
        })
        .then(res => res.json())
        .then(data => {
            if (data.status === 'success') {
                Swal.fire({
                    title: 'ສຳເລັດ!',
                    text: 'ອັບເດດສະຖານະການພິມແລ້ວ',
                    icon: 'success',
                    timer: 1500,
                    showConfirmButton: false
                }).then(() => {
                    window.close();
                });
            } else {
                window.close();
            }
        })
        .catch(error => {
            console.error('Error:', error);
            window.close();
        });
    }

    // ถ้าผู้ใช้ปิดหน้าต่างโดยไม่ print
    window.onbeforeunload = function() {
        if (!userPrinted && printDialogOpened) {
            return 'ທ່ານຍັງບໍ່ໄດ້ພິມໃບບີນ ສະຖານະການພິມຈະບໍ່ຖືກອັບເດດ';
        }
    };
});
</script>
</body>
</html>
