<?php
require_once("auth.php");
require_once("db_con.php");
?>
<!DOCTYPE html>
<html lang="en"> 
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ລະບົບຂາຍສິນຄ້າອອນໄລນ໌</title>
    <link rel="stylesheet" href="css/home.css"> 
    <link rel="stylesheet" href="css/pos.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <link rel="icon" type="image/png" href="/test01/favicon.png">
</head>
<style>
    *{ 
        font-family: 'Noto Sans Lao';
    }
</style>
<body>
    <?php include_once('home.php'); ?>

    <div class="content-area">
        <div class="pos-container">
            <div class="pos-header">
                <h1 style="color: white;"><i class="fas fa-shopping-cart" style="color: white;"></i> ລະບົບຂາຍສິນຄ້າອອນໄລນ໌</h1>
            </div>

            <div class="pos-main">
                <div class="product-section">
                    <div class="search-bar">
                        <input type="text" id="product-search" placeholder="ຄົ້ນຫາສິນຄ້າ...">
                    </div>
                    
                    <div class="categories">
                        <label for="category-select" class="category-label">ເລືອກປະເພດ</label>
                        <select id="category-select" class="category-dropdown">
                            <option value="all">ທັງໝົດ</option>
                            <!-- Categories will be loaded from database -->
                        </select>
                    </div>
                    
                    <div class="products-grid" id="products-container">
                        <!-- Products will be loaded from database -->
                        <div class="loading">ກຳລັງໂຫຼດຂໍ້ມູນ...</div>
                    </div>
                </div> 
                
                <div class="cart-section" style="max-height: 100vh; overflow: hidden; display: flex; flex-direction: column;">
                    <div class="cart-header">
                        <h2>ລາຍການສິນຄ້າ</h2>
                        <button id="clear-cart" class="btn danger-btn"><i class="fas fa-trash"></i> ລ້າງລາຍການ</button>
                    </div>
                    
                    <div class="cart-items" style="width: 100%; flex: 1 1 auto; min-height: unset; overflow-y: auto;">
                        <table id="cart-table">
                            <thead>
                                <tr>
                                    <th>ສິນຄ້າ</th>
                                    <th>ລາຄາ</th>
                                    <th>ຈຳນວນ</th>
                                    <th>ລວມ</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody id="cart-body">
                                <!-- Cart items will be added here -->
                            </tbody>
                        </table>
                    </div>
                    
      <div class="cart-summary">
                        <div class="summary-row total">
                            <span>ຍອດເງິນທັງໝົດ:</span>
                            <span id="total">₭0</span>
                        </div>
                        
                        <button id="checkout-btn" class="btn primary-btn"><i class="fas fa-check-circle"></i> ຊຳລະເງິນ</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Checkout Modal -->
    <div id="checkout-modal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>ຂໍ້ມູນການສັ່ງຊື້</h2>
            
            <!-- 1. ຂໍ້ມູນລູກຄ້າ -->
            <div class="form-section">
                <h3>1. ຂໍ້ມູນລູກຄ້າ</h3>
                <div class="form-group">
                    <label for="customer-name">ຊື່ເຟດ:</label>
                    <input type="text" id="customer-name" required>
                </div>
                
                <div class="form-group">
                    <label for="customer-phone">ເບີຕິດຕໍ່:</label>
                    <input type="text" id="customer-phone" required inputmode="numeric" pattern="[0-9]*" 
                           oninput="this.value = this.value.replace(/[^0-9]/g, '');" 
                           placeholder="ປ້ອນເບີໂທລະສັບ">
                </div>
            </div>
            
            <!-- 2. ຂໍ້ມູນຂົນສົ່ງ -->
            <div class="form-section">
                <h3>2. ຂໍ້ມູນຂົນສົ່ງ</h3>
                <div class="form-group">
                    <label for="shipping-company">ບໍລິສັດຂົນສົ່ງ:</label>
                    <select id="shipping-company">
                        <option value="">ເລືອກບໍລິສັດຂົນສົ່ງ</option>
                        <?php
                        $sql = "SELECT * FROM shipping_company ORDER BY shipping_name";
                        $result = $conn->query($sql);
                        
                        if ($result->num_rows > 0) {
                            while($row = $result->fetch_assoc()) {
                                echo "<option value='".$row['shipping_id']."'>".$row['shipping_name']."</option>";
                            }
                        }
                        ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="customer-address">ສາຂາຂົນສົ່ງ:</label>
                    <textarea id="customer-address" rows="2" placeholder="ກະລຸນາປ້ອນຊື່ສາຂາບໍລິສັດຂົນສົ່ງ"></textarea>
                </div>
            </div>
            
            <!-- 3. ຂໍ້ມູນຄ່າຝາກ -->
            <div class="form-section">
                <h3>3. ຂໍ້ມູນຄ່າຝາກ</h3>
                <div class="form-group">
                    <div class="radio-group">
                        <label><input type="radio" name="cod_type" value="ຫັກ COD"> ຫັກ COD</label>
                        <label><input type="radio" name="cod_type" value="ຄ່າຝາກປາຍທາງ"> ຄ່າຝາກປາຍທາງ</label>
                    </div>
                </div>
            </div>
            
            <!-- 4. ສະຖານະການຈ່າຍຄ່າເຄື່ອງ -->
            <div class="form-section">
                <h3>4. ສະຖານະການຈ່າຍຄ່າເຄື່ອງ</h3>
                <div class="form-group">
                    <div class="radio-group">
                        <label><input type="radio" name="payment_status" value="ຈ່າຍເເລ້ວ"> ຈ່າຍເເລ້ວ</label>
                        <label><input type="radio" name="payment_status" value="ມັດຈຳ"> ມັດຈຳ</label>
                        <label><input type="radio" name="payment_status" value="ຍັງບໍ່ຈ່າຍ" > ຍັງບໍ່ຈ່າຍ</label>
                    </div>
                </div>
                
                <div id="deposit-amount-container" class="form-group" style="display: none;">
                    <label for="deposit-amount">ຈຳນວນເງິນມັດຈຳ:</label>
                    <input type="text" id="deposit-amount" min="0" inputmode="numeric" pattern="[0-9]*"
                           oninput="this.value = this.value.replace(/[^0-9]/g, '');" 
                           placeholder="ປ້ອນຈຳນວນເງິນມັດຈຳ">
                </div>
            </div>
            
            <!-- 5. ປະເພດການຈ່າຍ -->
            <div class="form-section">
                <h3>5. ປະເພດການຈ່າຍ</h3>
                <div class="form-group payment-method-container">
                    <div class="radio-group">
                        <label><input type="radio" name="payment_method" value="ຈ່າຍສົດ"> ຈ່າຍສົດ</label>
                        <label><input type="radio" name="payment_method" value="ໂອນ"> ໂອນ</label>
                    </div>
                </div>
                
                <!-- เຼມการກຳນົດຮ້ານຄ້າ -->

            </div>
            <div class="form-section">
                <h3>6. ເລືອກຮ້ານຄ້າ</h3>
                        <div class="form-group">
                    <label for="store-select">ຮ້ານຄ້າ:</label>
                    <select id="store-select">
                        <option value="">ເລືອກຮ້ານຄ້າ</option>
                        <?php
                        $sql = "SELECT * FROM stores ORDER BY store_name";
                        $result = $conn->query($sql);
                        
                        if ($result->num_rows > 0) {
                            while($row = $result->fetch_assoc()) {
                                echo "<option value='".$row['store_id']."'>".$row['store_name']."</option>";
                            }
                        }
                        ?>
                    </select>
                </div>
                </div>
            <!-- 6. ສ່ວນຫຼຸດ -->
            <div class="form-section">
                <h3>7. ສ່ວນຫຼຸດ</h3>
                <div class="form-group">
                    <label for="discount-amount">ຈຳນວນເງິນສ່ວນຫຼຸດ:</label>
                    <input type="text" id="discount-amount" min="0" value="0" inputmode="numeric" pattern="[0-9]*"
                           oninput="this.value = this.value.replace(/[^0-9]/g, '');" 
                           placeholder="ປ້ອນຈຳນວນເງິນສ່ວນຫຼຸດ">
                </div>
            </div>
            
            <div class="order-summary">
                <div class="summary-row">
                    <span>ລວມເງິນ:</span>
                    <span id="modal-subtotal">₭0</span>
                </div>
                <div class="summary-row">
                    <span>ສ່ວນຫຼຸດ:</span>
                    <span id="modal-discount">₭0</span>
                </div>
                <div class="summary-row" id="deposit-summary-row" style="display: none;">
                    <span>ມັດຈຳ:</span>
                    <span id="modal-deposit">₭0</span>
                </div>
                <div class="summary-row total">
                    <span>ຍອດເງິນທັງໝົດ:</span>
                    <span id="modal-total">₭0</span>
                </div>
            </div>
            
            <div class="cash-section" id="cash-section" style="display:none; margin-top: 16px; padding: 16px; background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%); border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.06); border: 1px solid rgba(0,0,0,0.06);">
                <h3 style="margin: 0 0 12px 0; color: #2c3e50; font-size: 16px; font-weight: 600; text-align: center; display: flex; align-items: center; justify-content: center; gap: 6px;">
                    <i class="fas fa-cash-register" style="color: #28a745; font-size: 16px;"></i>
                    ການຊຳລະດ້ວຍເງິນສົດ
                </h3>
                <div class="form-group" style="margin-bottom: 12px;">
                    <label for="cash-received" style="display: block; margin-bottom: 6px; font-weight: 500; color: #495057; font-size: 15px;">
                        <i class="fas fa-money-bill-wave" style="color: #28a745; margin-right: 4px; font-size: 14px;"></i>
                        ຮັບເງິນ (ສົດ):
                    </label>
                    
                    <!-- Quick Amount Buttons -->
                    <div class="quick-amount-buttons" style="margin-bottom: 8px; display: flex; flex-wrap: wrap; gap: 6px; justify-content: center;">
                        <!-- Buttons will be generated by JavaScript -->
                    </div>
                    
                    <input type="text" id="cash-received" min="0" inputmode="numeric" pattern="[0-9]*" placeholder="ປ້ອນຈຳນວນເງິນສົດ" step="1" 
                           style="width:calc(100% - 4px); max-width:100%; padding: 10px 12px; border: 2px solid #e9ecef; border-radius: 8px; font-size: 16px; font-weight: 500; text-align: center; background: #ffffff; transition: all 0.3s ease; box-shadow: 0 1px 4px rgba(0,0,0,0.04); box-sizing: border-box;" 
                           oninput="let v=this.value.replace(/[^\d]/g,'');if(v.length>12)v=v.slice(0,12);this.value=v?parseInt(v,10).toLocaleString('en-US'):'';"
                           onfocus="this.style.borderColor='#28a745'; this.style.boxShadow='0 2px 8px rgba(40,167,69,0.15)'"
                           onblur="this.style.borderColor='#e9ecef'; this.style.boxShadow='0 1px 4px rgba(0,0,0,0.04)'">
                </div>
                <div class="form-group" style="margin: 0; padding: 12px; background: linear-gradient(135deg, #28a745 0%, #20c997 100%); border-radius: 8px; text-align: center;">
                    <label style="display: block; margin-bottom: 4px; font-weight: 500; color: #ffffff; font-size: 14px; opacity: 0.9;">
                        <i class="fas fa-exchange-alt" style="margin-right: 4px; font-size: 13px;"></i>
                        ເງິນທອນ:
                    </label>
                    <span id="change-amount" style="display: block; font-size: 18px; font-weight: 700; color: #ffffff; text-shadow: 0 1px 2px rgba(0,0,0,0.1);">₭0</span>
                </div>
            </div>
            
            <div class="modal-buttons">
                <button id="cancel-order" class="btn danger-btn">ຍົກເລີກ</button>
                <button id="confirm-order" class="btn primary-btn">ຢືນຢັນການສັ່ງຊື້</button>
                
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="js/pos.js"></script>
    <script>
function formatCashInput(input) {
    let val = input.value.replace(/,/g, '');
    if (!val) { input.value = ''; return; }
    input.value = parseInt(val, 10).toLocaleString('en-US');
}
</script>
</body>
</html>





 












