<?php
require_once("auth.php");
require_once("db_con.php");

$category = $_GET['category'] ?? 'all';
$threshold = $_GET['threshold'] ?? 20;

$where = [];
$where[] = "quantity <= " . intval($threshold);
if ($category !== 'all') {
    $where[] = "p.category_id = '" . $conn->real_escape_string($category) . "'";
}
$where_sql = $where ? 'WHERE ' . implode(' AND ', $where) : '';

$sql = "SELECT p.*, c.category_name
        FROM products p
        LEFT JOIN product_category c ON p.category_id = c.category_id
        $where_sql
        ORDER BY p.quantity ASC";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    $rowNumber = 1;
    while($row = $result->fetch_assoc()) {
        $statusClass = ($row['quantity'] <= 0) ? 'out-of-stock-status' : 'low-stock-status';
        $statusText = ($row['quantity'] <= 0) ? 'ສິນຄ້າໝົດ' : 'ສິນຄ້າໃກ້ຈະໝົດ';
        $statusIcon = ($row['quantity'] <= 0) ? 'fa-times-circle' : 'fa-exclamation-triangle';
        echo '<tr>';
        echo '<td class="animate-td" style="min-width:80px;text-align:center;font-weight:bold;">' . $rowNumber . '</td>';
        echo '<td class="animate-td" style="min-width:120px;">' . htmlspecialchars($row['pro_id']) . '</td>';
        echo '<td class="animate-td" style="min-width:120px;text-align:center;"><img src="img/products/' . htmlspecialchars($row['product_image']) . '" alt="' . htmlspecialchars($row['product_name']) . '" onerror="this.src=\'img/Logo.png\'"></td>';
        echo '<td class="animate-td" style="min-width:120px;">' . htmlspecialchars($row['product_name']) . '</td>';
        echo '<td class="animate-td" style="min-width:120px;">' . htmlspecialchars($row['category_name'] ?? '') . '</td>';
        echo '<td class="animate-td" style="min-width:120px;">' . htmlspecialchars($row['quantity']) . '</td>';
        echo '<td class="animate-td" style="min-width:120px;">₭' . number_format($row['selling_price']) . '</td>';
        echo '<td class="animate-td" style="min-width:120px;"><div class="stock-status ' . $statusClass . '"><i class="fas ' . $statusIcon . '"></i> ' . $statusText . '</div></td>';
        echo '<td class="action-buttons animate-td" style="min-width:100%;min-height:80px;text-align:center;">';
                echo '<button class="action-btn edit-btn" onclick="editProduct(\'' . $row['pro_id'] . '\')"><i class="fas fa-edit"></i></button>';
                echo '<button class="action-btn order-btn" onclick="orderProduct(\'' . $row['pro_id'] . '\')"><i class="fas fa-shopping-cart"></i></button>';
              echo '</td>';
        echo '</tr>';
        $rowNumber++;
    }
} else {
    echo '<tr><td colspan="9" class="loading-message">ບໍ່ພົບຂໍ້ມູນສິນຄ້າທີ່ໃກ້ຈະໝົດ</td></tr>';
}
?>