<?php require_once("auth.php"); ?>
<?php require_once("db_con.php"); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/low_stock.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <title>ສະຫຼຸບສິນຄ້າທີ່ໃກ້ຈະຫມົດ - ຮ້ານ Jຕຸກຂາຍເຄື່ອງໃຊ້ໄຟຟ້າ</title>
    <link rel="icon" type="image/png" href="/test01/favicon.png">
</head>
<style>
    *{
        font-family: 'Noto Sans Lao';
    }
</style> 
<body> 
    <?php include('home.php'); ?>

    <div class="content-area">
        <div class="low-stock-container">
            <div class="table-header">
                <h1><i class="fas fa-exclamation-triangle"></i> ສະຫຼຸບສິນຄ້າທີ່ໃກ້ຈະຫມົດ</h1>
                <div class="filter-container">
                    <div class="category-filter">
                        <label for="category-filter">ປະເພດສິນຄ້າ:</label>
                        <select id="category-filter" onchange="loadLowStockProducts()">
                            <option value="all">ທັງໝົດ</option>
                            <?php
                            // Get all categories
                            $cat_sql = "SELECT * FROM product_category ORDER BY category_name";
                            $cat_result = $conn->query($cat_sql);
                            
                            if ($cat_result->num_rows > 0) {
                                while($cat_row = $cat_result->fetch_assoc()) {
                                    echo "<option value='".$cat_row['category_id']."'>".$cat_row['category_name']."</option>";
                                }
                            }
                            ?>
                        </select>
                    </div>
                    <div class="threshold-filter">
                        <label for="threshold">ຈຳນວນຕ່ຳກວ່າ:</label>
                        <select id="threshold" onchange="loadLowStockProducts()">
                            <option value="5">5 ອັນ</option>
                            <option value="10">10 ອັນ</option>
                            <option value="20" selected>20 ອັນ</option>
                            <option value="30">30 ອັນ</option>
                            <option value="50">50 ອັນ</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <div class="low-stock-table-container">
                <table class="low-stock-table">
                    <thead>
                        <tr>
                            <th>ລຳດັບ</th>
                            <th>ລະຫັດສິນຄ້າ</th>
                            <th>ຮູບສິນຄ້າ</th>
                            <th>ຊື່ສິນຄ້າ</th>
                            <th>ປະເພດສິນຄ້າ</th>
                            <th>ຈຳນວນຄົງເຫຼືອ</th>
                            <th>ລາຄາຂາຍ</th>
                            <th>ສະຖານະ</th>
                            <th>ຈັດການ</th>
                        </tr>
                    </thead>
                    <tbody id="low-stock-table-body">
                        <!-- ตารางจะถูกโหลดด้วย AJAX -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script src="js/low_stock.js"></script>
</body>
</html>