// Responsive Table Script for Mobile
document.addEventListener('DOMContentLoaded', function() {
    const table = document.querySelector('.recent-orders');
    if (!table) return;

    // ข้อความหัวตารางภาษาลาว
    const headers = [
        'ເລກອໍເດີ້',
        'ລູກຄ້າ', 
        'ຍອດລວມ',
        'ສະຖານະ',
        'ວັນທີສັ່ງຊື້'
    ];

    // เพิ่ม data-label attributes ให้กับ td elements
    const rows = table.querySelectorAll('tbody tr');
    
    rows.forEach(function(row) {
        const cells = row.querySelectorAll('td');
        cells.forEach(function(cell, index) {
            if (headers[index]) {
                cell.setAttribute('data-label', headers[index]);
            }
        });
    });

    // ฟังก์ชันตรวจสอบขนาดหน้าจอและปรับ style
    function checkScreenSize() {
        const isMobile = window.innerWidth <= 768;
        
        if (isMobile) {
            table.classList.add('mobile-table');
        } else {
            table.classList.remove('mobile-table');
        }
    }

    // เรียกใช้เมื่อโหลดหน้าและเมื่อ resize
    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);
});