// Modal functionality
const modal = document.getElementById("productModal");
const addBtn = document.getElementById("add-product-btn");
const closeBtn = document.getElementsByClassName("close")[0];

// Modal show/hide functions
function showModal() {
    modal.style.display = "block";
    setTimeout(() => {
        modal.classList.add("show");
    }, 10);
}
function hideModal() {
    modal.classList.remove("show");
    setTimeout(() => {
        modal.style.display = "none";
    }, 300);
}

// Open modal when add button is clicked
addBtn.onclick = function() {
    showModal();
    // Reset modal title when adding new product
    document.querySelector('.modal-title').innerHTML = '<i class="fas fa-box"></i> ເພີ່ມຂໍ້ມູນສິນຄ້າ';
}

// Close modal when X is clicked
closeBtn.onclick = function() {
    hideModal();
}

// Close modal when clicking outside
window.onclick = function(event) {
    if (event.target == modal) {
        hideModal();
    }
}

// แสดงໍ້າຫຼັດ
const productImage = document.getElementById('product_image');
const imagePreview = document.getElementById('imagePreview');
const previewImage = imagePreview.querySelector('.preview-image');
const previewText = imagePreview.querySelector('.preview-text');

productImage.addEventListener('change', function() {
    const file = this.files[0];
    
    if (file) {
        const reader = new FileReader();
        
        previewText.style.display = "none";
        previewImage.style.display = "block";
        
        reader.addEventListener('load', function() {
            previewImage.setAttribute('src', this.result);
        });
        
        reader.readAsDataURL(file);
    } else {
        previewText.style.display = "block";
        previewImage.style.display = "none";
        previewImage.setAttribute('src', '');
    }
});

// ตรวจสอบสถานะສິນຄ້າ
const quantityInput = document.getElementById('quantity');
const stockStatusText = document.querySelectorAll('#stockStatusText');
const stockStatus = document.getElementById('stockStatus');

quantityInput.addEventListener('input', function() {
    const quantity = parseInt(this.value) || 0;
    
    if (quantity <= 20) {
        stockStatusText.forEach(el => el.textContent = 'ສິນຄ້າໃກ້ຈະໝົດ');
        stockStatus.classList.add('low-stock');
        stockStatus.querySelector('i').className = 'fas fa-exclamation-triangle';
    } else {
        stockStatusText.forEach(el => el.textContent = 'ມີສິນຄໍາ');
        stockStatus.classList.remove('low-stock');
        stockStatus.querySelector('i').className = 'fas fa-check-circle';
    }
});

// ค้นหาສິນຄໍາ
document.getElementById('product-search').addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    const rows = document.querySelectorAll('#product-table-body tr');
    let visibleCount = 0;

    rows.forEach(row => {
        const productId = row.querySelector('td:nth-child(2)').textContent.toLowerCase(); // ลำดับที่ 2 (รหัสสินค้า)
        const productName = row.querySelector('td:nth-child(4)').textContent.toLowerCase(); // ลำดับที่ 4 (ชื่อสินค้า)
        const productType = row.querySelector('td:nth-child(5)').textContent.toLowerCase(); // ลำดับที่ 5 (ประเภทสินค้าขาย)
        const productCategory = row.querySelector('td:nth-child(6)').textContent.toLowerCase(); // ลำดับที่ 6 (ประเภทเครื่องสินค้า)
        const supplierPhone = row.querySelector('td:nth-child(10)').textContent.toLowerCase(); // ลำดับที่ 10 (เบอร์ร้าน)

        if (
            productId.includes(searchTerm) ||
            productName.includes(searchTerm) ||
            productType.includes(searchTerm) ||
            productCategory.includes(searchTerm) ||
            supplierPhone.includes(searchTerm)
        ) {
            row.style.display = '';
            visibleCount++;
        } else {
            row.style.display = 'none';
        }
    });

    // Remove old "no data" row if exists
    let noDataRow = document.getElementById('no-data-row');
    if (noDataRow) noDataRow.remove();

    // If no visible rows, add "no data" row
    if (visibleCount === 0) {
        const tbody = document.getElementById('product-table-body');
        const tr = document.createElement('tr');
        tr.id = 'no-data-row';
        const td = document.createElement('td');
        td.colSpan = 12; // อัปเดตเป็น 12 คอลัมน์
        td.style.textAlign = 'center';
        td.textContent = 'ບໍ່ພົບສິນຄ້າ';
        tr.appendChild(td);
        tbody.appendChild(tr);
    }
});

// ปุ่มแก้ไข - ใช้ event delegation เพื่อให้ทำงานกับปุ่มที่สร้างขึ้นใหม่
document.addEventListener('click', function(e) {
    if (e.target.closest('.edit-btn')) {
        const button = e.target.closest('.edit-btn');
        const productId = button.getAttribute('data-id');
        editProduct(productId);
    }
});

// ปุ่มลบ - ใช้ event delegation เพื่อให้ทำงานกับปุ่มที่สร้างขึ้นใหม่
document.addEventListener('click', function(e) {
    if (e.target.closest('.delete-btn')) {
        const button = e.target.closest('.delete-btn');
        const productId = button.getAttribute('data-id');
        
        Swal.fire({
            title: 'ຢືນຢັນການລຶບສິນຄ້າ',
            text: 'ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລຶບສິນຄ້ານີ້?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'ຕົກລົງ',
            cancelButtonText: 'ຍົກເລີກ'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch('delete_product.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'id=' + productId
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        document.querySelector(`tr[data-id="${productId}"]`).remove();
                        Swal.fire('ສຳເລັດ!', 'ລຶບສິນຄ້າສຳເລັດແລ້ວ', 'success');
                    } else {
                        Swal.fire('ຜິດພາດ', 'ເກີດຂໍ້ຜິດພາດ: ' + data.message, 'error');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    Swal.fire('ຜິດພາດ', 'ເກີດຂໍ້ຜິດພາດໃນການລຶບສິນຄ້າ', 'error');
                });
            }
        });
    }
});

function editProduct(productId) {
    // ส่ง AJAX request เ่อดึงข้อมูลค้า
    const xhr = new XMLHttpRequest();
    xhr.open('GET', 'get_product?id=' + encodeURIComponent(productId), true);
    xhr.onload = function() {
        if (this.status === 200) {
            try {
                const data = JSON.parse(this.responseText);
                
                // Set form values
                document.getElementById('pro_id').value = data.pro_id;
                document.getElementById('product_type').value = data.product_type;
                document.getElementById('product_category').value = data.category_id;
                document.getElementById('product_name').value = data.product_name;
                document.getElementById('quantity').value = data.quantity;
                document.getElementById('cost_price').value = Math.floor(data.cost_price);
                document.getElementById('selling_price').value = Math.floor(data.selling_price);
                document.getElementById('supplier_phone').value = data.supplier_phone;

                // Show product image preview if exists
                if (data.product_image && data.product_image !== "") {
                    previewImage.setAttribute('src', 'img/products/' + data.product_image);
                    previewImage.style.display = "block";
                    previewText.style.display = "none";
                } else {
                    previewImage.setAttribute('src', '');
                    previewImage.style.display = "none";
                    previewText.style.display = "block";
                }
                
                // Update modal title
                document.querySelector('.modal-title').innerHTML = '<i class="fas fa-edit"></i> ແກ້ໄຂຂໍ້ມູນສິນຄ້າ';
                
                // Show modal
                showModal();                
            } catch (e) {
                console.error('Error parsing JSON:', e);
                alert('ເກີດຂໍ້ຜິດພາດໃນການດຶງຂໍ້ມູນ');
            }
        }
    };
    xhr.send(); 
}

// ปุ่ม "ເພີ່ມສິນຄ້າໃໝ່"
addBtn.addEventListener('click', function() {
    // reset form
    document.querySelector('form').reset();

    // เซ็ตค่าทุกช่อง input ให้ว่างหรือค่า default
    document.getElementById('pro_id').value = document.getElementById('new_pro_id').value;
    document.getElementById('product_type').value = '';
    document.getElementById('product_category').value = '';
    document.getElementById('product_name').value = '';
    document.getElementById('quantity').value = '';
    document.getElementById('cost_price').value = '';
    document.getElementById('selling_price').value = '';
    document.getElementById('supplier_phone').value = '';

    // ตั้งค่าสถานะສິນຄ້າ
    stockStatusText.forEach(el => el.textContent = 'ມີສິນຄໍາ');
    stockStatus.classList.remove('low-stock');
    stockStatus.querySelector('i').className = 'fas fa-check-circle';

    // ตั้งค่าໍ້າຫຼັດ
    previewText.style.display = "block";
    previewImage.style.display = "none";
    previewImage.setAttribute('src', '');

    // เปลี่ยนชื่อ Modal
    document.querySelector('.modal-title').innerHTML = '<i class="fas fa-box"></i> ເພີ່ມຂໍ້ມູນສິນຄ້າ';

    // เปิด Modal
    modal.style.display = "block";
});

// erset form and status
document.querySelector('button[type="reset"]').addEventListener('click', function() {
    setTimeout(function() {
        stockStatusText.forEach(el => el.textContent = 'ມີສິນຄໍາ');
        stockStatus.classList.remove('low-stock');
        stockStatus.querySelector('i').className = 'fas fa-check-circle';
        previewText.style.display = "block";
        previewImage.style.display = "none";
        previewImage.setAttribute('src', '');
    }, 10);
});

// Function to scroll to product and highlight
function scrollToProduct(productId) {
    // Close modal first
    hideModal();
    
    // Find the product row
    const productRow = document.querySelector(`tr[data-id="${productId}"]`);
    
    if (productRow) {
        // Remove any existing highlight classes
        document.querySelectorAll('.product-table tr').forEach(row => {
            row.classList.remove('highlight');
        });
        
        // Add highlight class to the target row
        productRow.classList.add('highlight');
        
        // Scroll to the product row
        productRow.scrollIntoView({
            behavior: 'smooth',
            block: 'center',
            inline: 'nearest'
        });
        
        // Remove highlight after animation completes
        setTimeout(() => {
            productRow.classList.remove('highlight');
        }, 3000);
    }
}







