document.addEventListener('DOMContentLoaded', function() {
    const container = document.querySelector('.low-stock-container');
    if (container) {
        container.classList.add('animate-container');
        setTimeout(() => {
            container.classList.remove('animate-container');
        }, 500);
    }

    // ใส่ animation ให้ td ตอนแรก
    const tableBody = document.getElementById('low-stock-table-body');
    if (tableBody) {
        const tds = tableBody.querySelectorAll('td');
        tds.forEach(td => td.classList.add('animate-td'));
        setTimeout(() => {
            tds.forEach(td => td.classList.remove('animate-td'));
        }, 700);
    }

    // Load low stock products when page loads
    loadLowStockProducts();
    
    // Toggle sidebar
    const toggleBtn = document.querySelector('.toggle-btn');
    const sidebar = document.querySelector('.sidebar');
    
    if (toggleBtn && sidebar) {
        toggleBtn.addEventListener('click', function() {    
            sidebar.classList.toggle('active');
        });
    } 
});

function loadLowStockProducts() {
    const categoryId = document.getElementById('category-filter').value;
    const threshold = document.getElementById('threshold').value;
    const tableBody = document.getElementById('low-stock-table-body');
    const tbody = tableBody.parentElement;

    // Fade out effect
    tbody.classList.add('fade-out');

    setTimeout(() => {
        tableBody.innerHTML = '<tr><td colspan="8" class="loading-message">ກຳລັງໂຫຼດຂໍ້ມູນ...</td></tr>';

        fetch(`low_stock_table.php?category=${categoryId}&threshold=${threshold}`)
            .then(response => response.text())
            .then(html => {
                tableBody.innerHTML = html;
                tbody.classList.remove('fade-out');
                tbody.classList.add('fade-in');
                setTimeout(() => {
                    tbody.classList.remove('fade-in');
                }, 300);
            })
            .catch(error => {
                tableBody.innerHTML = '<tr><td colspan="8" class="loading-message">ເກີດຂໍ້ຜິດພາດໃນການໂຫຼດຂໍ້ມູນ</td></tr>';
                tbody.classList.remove('fade-out');
                tbody.classList.add('fade-in');
                setTimeout(() => {
                    tbody.classList.remove('fade-in');
                }, 300);
            });
    }, 150);
}

// Function to edit product (redirect to add_product with product ID)
function editProduct(proId) {
    window.location.href = `add_product.php?edit=${proId}`;
}

// Function to create order for product
function orderProduct(proId) {
    // Redirect to print_order.php with product id as query parameter
    window.location.href = `print_order.php?product=${proId}`;
}