// JavaScriptหน้าใบล

    // เมื่อโหลดหน้าเสร็จ
    document.addEventListener('DOMContentLoaded', function() {
        // Modal elements
        const invoiceModal = document.getElementById('invoice-modal'); 
        const closeBtn = document.querySelector('.close');
        
        //  Modal เมื่อปุ่ม
        closeBtn.addEventListener('click', function() {
            invoiceModal.style.display = 'none';
        });
        
        //  Modal เมื่อนอก Modal
        window.addEventListener('click', function(event) {
            if (event.target == invoiceModal) {
                invoiceModal.style.display = 'none';
            }
        });
    });

    // ก์ใบล
    function viewInvoice(orderId) {
        // Get modal elements
        const invoiceModal = document.getElementById('invoice-modal');
        const invoiceDetails = document.getElementById('invoice-details');
        
        // Show elegant loading animation with improved styling
        invoiceDetails.innerHTML = `
            <div class="loading-container">
                <div class="loading-spinner">
                    <i class="fas fa-spinner fa-pulse" style="color: #EE4035;"></i>
                </div>
                <p class="loading-text">ກຳລັງໂຫຼດຂໍ້ມູນ...</p>
            </div>
        `;
        
        // Show modal with enhanced fade-in effect
        invoiceModal.style.display = 'block';
        invoiceModal.classList.add('fade-in');
        
        // Fetch invoice data with proper error handling and timeout
        fetchInvoiceData(orderId, invoiceDetails);
    }

    // Helper function to fetch and display invoice data
    function fetchInvoiceData(orderId, invoiceDetails) {
        fetch(`get_invoice_details?order_id=${orderId}`)
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                if (data.status === 'success') {
                    // Render invoice with a slight delay for smooth transition
                    setTimeout(() => {
                        renderInvoiceDetails(data, invoiceDetails);
                    }, 300);
                } else {
                    showErrorMessage(invoiceDetails, "ບໍ່ພົບຂໍ້ມູນໃບບິນ");
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showErrorMessage(invoiceDetails, "ເກີດຂໍ້ຜິດພາດໃນການດຶງຂໍ້ມູນ");
            });
    }

    // Helper function to render invoice details
    function renderInvoiceDetails(data, invoiceDetails) {
        // Create invoice header
        let html = createInvoiceHeader(data);
        
        // Add invoice items table
        html += createInvoiceItemsTable(data.items);
        
        // Add invoice summary
        html += createInvoiceSummary(data.order);
        
        // Apply with fade-in effect
        invoiceDetails.innerHTML = html;
        invoiceDetails.classList.add('content-fade-in');
    }

    // Helper function to create invoice header
    function createInvoiceHeader(data) {
        return `
            <h2 class="invoice-title">ລາຍລະອຽດໃບບິນ: ${data.order.order_id} - ຮ້ານ: ${data.order.store_name || '-'}</h2>
            <div class="invoice-info">
                <div class="info-group">
                    <p><strong>ວັນທີ:</strong> ${data.order.order_date}</p>
                    <p><strong>ລູກຄ້າ:</strong> ${data.order.customer_name || '-'}</p>
                    <p><strong>ເບີໂທ:</strong> ${data.order.customer_phone || '-'}</p>
                    <p><strong>ທີ່ຢູ່:</strong> ${data.order.shipping_branch || '-'}</p>
                    <p><strong>ເລກໄອດີຂົນສົ່ງ:</strong> ${data.order.shipping_code || '-'}</p>
                </div>
                <div class="info-group">
                    <p><strong>ບໍລິສັດຂົນສົ່ງ:</strong> ${data.order.shipping_name || '-'}</p>
                    <p><strong>ສະຖານະການຈ່າຍ:</strong> ${data.order.payment_status || '-'}</p>
                    <p><strong>ວິທີການຈ່າຍ:</strong> ${data.order.payment_method || '-'}</p>
                    <p><strong>ປະເພດ COD:</strong> ${data.order.cod_type || '-'}</p>
                </div>
            </div>
        `;
    }

    // Helper function to show error message
    function showErrorMessage(container, message) {
        container.innerHTML = `<div class="error-message"><i class="fas fa-exclamation-circle"></i> ${message}</div>`;
    }

    // Helper function to create invoice items table
    function createInvoiceItemsTable(items) {
        if (items && items.length > 0) {
            return `
                <table class="invoice-items-table">
                    <thead>
                        <tr>
                            <th>ລຳດັບ</th>
                            <th>ລາຍການສິນຄ້າ</th>
                            <th>ລາຄາ</th>
                            <th>ຈຳນວນ</th>
                            <th>ລວມ</th>
                        </tr>
                    </thead>
                    <tbody>
                        ${items.map((item, index) => `
                            <tr>
                                <td>${index + 1}</td>
                                <td>${item.product_name || '-'}</td>
                                <td>₭${parseFloat(item.price).toLocaleString()}</td>
                                <td>${item.quantity}</td>
                                <td>₭${parseFloat(item.total).toLocaleString()}</td>
                            </tr>
                        `).join('')}
                    </tbody>
                </table>
            `;
        } else {
            return `<tr><td colspan="5" class="no-data">ບໍ່ພົບລາຍການສິນຄ້າ</td></tr>`;
        }
    }

    // Helper function to create invoice summary
    function createInvoiceSummary(order) {
        // คำนວณยอด<|im_start|>่ะ
        const subtotal = parseFloat(order.subtotal || 0);
        const discount = parseFloat(order.discount || 0);
        const depositAmount = parseFloat(order.deposit_amount || 0);
        const remainingAmount = subtotal - discount - depositAmount;
        
        return `
            <div class="invoice-summary">
                <div class="summary-row">
                    <span>ລວມເງິນ:</span>
                    <span>₭${parseFloat(order.subtotal || 0).toLocaleString()}</span>
                </div>
                <div class="summary-row">
                    <span>ສ່ວນຫຼຸດ:</span>
                    <span>₭${parseFloat(order.discount || 0).toLocaleString()}</span>
                </div>
                <div class="summary-row">
                    <span>ຈຳນວນເງິນມັດຈຳ:</span>
                    <span>₭${parseFloat(order.deposit_amount || 0).toLocaleString()}</span>
                </div>
                <div class="summary-row total">
                    <span>ຍອດເງິນທີ່ຕ້ອງຈ່າຍ:</span>
                    <span>₭${remainingAmount.toLocaleString()}</span>
                </div>
            </div>
        `;
    }

    // ก์ใบล
    function printInvoice(orderId) {
        // เปิดหน้าต่างใหม่
        window.open(`print_invoice?order_id=${orderId}`, '_blank');
    }

    // ก์แก้ไขใบล
    function editInvoice(orderId) {
        // หน้าแก้ไขใบล
        window.location.href = `edit_invoice?order_id=${orderId}`;
    }

    // ฟังก์ชันแก้ไขใบบิลพร้อมส่งพารามิเตอร์ครบ
    function editInvoiceWithParams(orderId, page) {
        const urlParams = new URLSearchParams(window.location.search);
        const editParams = new URLSearchParams();
        
        // เพิ่มพารามิเตอร์พื้นฐาน
        editParams.set('order_id', orderId);
        editParams.set('page', page);
        
        // เพิ่มพารามิเตอร์ search และ date ถ้ามี
        if (urlParams.get('search')) {
            editParams.set('search', urlParams.get('search'));
        }
        if (urlParams.get('date_from')) {
            editParams.set('date_from', urlParams.get('date_from'));
        }
        if (urlParams.get('date_to')) {
            editParams.set('date_to', urlParams.get('date_to'));
        }
        if (urlParams.get('customer_id')) {
            editParams.set('customer_id', urlParams.get('customer_id'));
        }
        
        window.location.href = `edit_invoice.php?${editParams.toString()}`;
    }

    document.addEventListener('DOMContentLoaded', function() {
        // Elements
        const toggleBulkSelectBtn = document.getElementById('toggle-bulk-select');
        const bulkActionsDiv = document.querySelector('.bulk-actions');
        const selectAllCheckbox = document.getElementById('select-all');
        const printSelectedBtn = document.getElementById('print-selected');
        const cancelSelectionBtn = document.getElementById('cancel-selection');
        
        // Toggle bulk selection mode
        if(toggleBulkSelectBtn) {
            toggleBulkSelectBtn.addEventListener('click', function() {
                const isVisible = bulkActionsDiv.style.display !== 'none';
                
                // Toggle visibility
                bulkActionsDiv.style.display = isVisible ? 'none' : 'flex';
                
                // Update button text
                if(isVisible) {
                    toggleBulkSelectBtn.innerHTML = '<i class="fas fa-check-square"></i> ເປີດການເລືອກຫຼາຍລາຍການ';
                    // Hide all checkboxes
                    toggleCheckboxVisibility(false);
                } else {
                    toggleBulkSelectBtn.innerHTML = '<i class="fas fa-times-circle"></i> ປິດການເລືອກຫຼາຍລາຍການ';
                    // Show all checkboxes
                    toggleCheckboxVisibility(true);
                }
            });
        }
        
        // Cancel selection button
        if(cancelSelectionBtn) {
            cancelSelectionBtn.addEventListener('click', function() {
                // Uncheck all checkboxes, but do not hide them
                document.querySelectorAll('.order-checkbox').forEach(cb => cb.checked = false);
                const selectAll = document.getElementById('select-all');
                if (selectAll) selectAll.checked = false;
                updatePrintButtonState();
            });
        }
        
        // Function to toggle checkbox visibility
        function toggleCheckboxVisibility(show) {
            // header
            document.querySelectorAll('.bulk-checkbox-header').forEach(el => {
                el.style.display = show ? 'table-cell' : 'none';
            });
            // cells
            document.querySelectorAll('.bulk-checkbox-cell').forEach(el => {
                el.style.display = show ? 'table-cell' : 'none';
            });
        }
        
        // ซ่อน checkbox ตอนโหลดหน้า
        document.addEventListener('DOMContentLoaded', function() {
            toggleCheckboxVisibility(false);
            // ...โค้ดอื่นๆ...
        });
        
        // เวลากดปุ่ม bulk select
        document.getElementById('toggle-bulk-select').addEventListener('click', function() {
            // toggle ตามสถานะ
            const isVisible = document.querySelector('.bulk-checkbox-header').style.display === 'table-cell';
            toggleCheckboxVisibility(!isVisible);
        });
        
        // Rest of your existing code for handling checkboxes
        if(selectAllCheckbox) {
            selectAllCheckbox.addEventListener('change', function() {
                const checkboxes = document.querySelectorAll('.order-checkbox');
                checkboxes.forEach(checkbox => {
                    checkbox.checked = selectAllCheckbox.checked;
                });
                updatePrintButtonState();
            });
        }
        
        // Handle individual checkboxes
        document.addEventListener('change', function(e) {
            if(e.target && e.target.classList.contains('order-checkbox')) {
                updatePrintButtonState();
            }
        });
        
        // Handle print selected button
        if(printSelectedBtn) {
            printSelectedBtn.addEventListener('click', function() {
                const selectedOrders = getSelectedOrders();
                if(selectedOrders.length > 0) {
                    printSelectedOrders(selectedOrders);
                }
            });
        }
        
        function updatePrintButtonState() {
            const selectedOrders = getSelectedOrders();
            if(printSelectedBtn) {
                printSelectedBtn.disabled = selectedOrders.length === 0;
            }
        }
        
        function getSelectedOrders() {
            const checkboxes = document.querySelectorAll('.order-checkbox:checked');
            return Array.from(checkboxes).map(checkbox => checkbox.dataset.orderId);
        }
        
        function getSelectedOrdersWithSaleType() {
            const checkboxes = document.querySelectorAll('.order-checkbox:checked');
            return Array.from(checkboxes).map(checkbox => ({
                orderId: checkbox.dataset.orderId,
                saleType: checkbox.dataset.saleType
            }));
        }

        function printSelectedOrders() {
            // ดึง order id และ sale_type ที่ถูกเลือก
            const selected = Array.from(document.querySelectorAll('.order-checkbox:checked')).map(cb => ({
                id: cb.dataset.orderId,
                saleType: cb.dataset.saleType
            }));

            if (selected.length === 0) return;

            // แยก order_id ตามประเภท
            const shopOrders = selected.filter(o => o.saleType === 'ຂາຍໜ້າຮ້ານ' || o.saleType === 'ຫນ້າຮ້ານ' || o.saleType === 'ขายหน้าร้าน').map(o => o.id);
            const onlineOrders = selected.filter(o => o.saleType === 'ຂາຍອອນລາຍ' || o.saleType === 'ອອນລາຍ' || o.saleType === 'ขายออนไลน์').map(o => o.id);

            // เปิดหน้าต่าง print ตามประเภท
            if (shopOrders.length > 0) {
                window.open('print_invoice.php?order_ids=' + shopOrders.join(','), '_blank');
            }
            if (onlineOrders.length > 0) {
                window.open('print_multiple_invoices.php?order_ids=' + onlineOrders.join(','), '_blank');
            }
        }
    });

    // เพิ่มฟังก์ชันสำหรับลบใบเสร็จ
    function confirmDeleteInvoice(orderId) {
        const deleteModal = document.getElementById('delete-modal');
        const deleteOrderId = document.getElementById('delete-order-id');
        const deletePass = document.getElementById('delete-pass');
        const errorMsg = document.getElementById('delete-error-msg');
        deleteOrderId.value = orderId;
        deletePass.value = '';
        errorMsg.textContent = '';
        deleteModal.style.display = 'block';
    }

    // Modal ลบ
    window.addEventListener('DOMContentLoaded', function() {
        const deleteModal = document.getElementById('delete-modal');
        const closeDelete = document.querySelector('.close-delete');
        const cancelDeleteBtn = document.getElementById('cancel-delete-btn');
        const confirmDeleteBtn = document.getElementById('confirm-delete-btn');
        const errorMsg = document.getElementById('delete-error-msg');

        // ปิด modal
        closeDelete.addEventListener('click', function() {
            deleteModal.style.display = 'none';
        });
        cancelDeleteBtn.addEventListener('click', function() {
            deleteModal.style.display = 'none';
        });
        window.addEventListener('click', function(event) {
            if (event.target == deleteModal) {
                deleteModal.style.display = 'none';
            }
        });

        // กดลบจริง
        confirmDeleteBtn.addEventListener('click', function() {
            const orderId = document.getElementById('delete-order-id').value;
            const pass = document.getElementById('delete-pass').value;
            errorMsg.textContent = '';
            if (!pass) {
                errorMsg.textContent = 'กรุณากรอกรหัสผ่าน';
                return;
            }
            confirmDeleteBtn.disabled = true;
            fetch('delete_invoice', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ order_id: orderId, pass_unlock: pass })
            })
            .then(res => res.json())
            .then(data => {
                confirmDeleteBtn.disabled = false;
                if (data.status === 'success') {
                    deleteModal.style.display = 'none';
                    // ลบแถวออกจากตารางทันที
                    const row = document.querySelector(`button.delete-btn[onclick*=\\"${orderId}\\"]`).closest('tr');
                    if(row) row.remove();
                    // แจ้งเตือนลบสำเร็จด้วย SweetAlert2
                    Swal.fire({
                        icon: 'success',
                        title: 'ລຶບສຳເລັດ!',
                        text: 'ລຶບໃບບິນສຳເລັດ',
                        timer: 1500,
                        showConfirmButton: false
                    });
                } else {
                    errorMsg.textContent = data.message || 'เกิดข้อผิดพลาด';
                }
            })
            .catch(() => {
                confirmDeleteBtn.disabled = false;
                errorMsg.textContent = 'เกิดข้อผิดพลาด';
            });
        });
    });
    document.addEventListener('DOMContentLoaded', function() {
        const urlParams = new URLSearchParams(window.location.search);
        const orderId = urlParams.get('order_id');
        const highlight = urlParams.get('highlight');
        if(orderId && highlight) {
            // รอให้ตารางโหลดเสร็จ (เพราะโหลดด้วย AJAX)
            setTimeout(function() {
                const row = document.querySelector(`tr[data-order-id='${orderId}']`);
                if(row) {
                    row.classList.add('tr-green-blink');
                    row.scrollIntoView({behavior: 'smooth', block: 'center'});
                    setTimeout(() => row.classList.remove('tr-green-blink'), 3000);
                }
            }, 500); // ปรับเวลาให้เหมาะสมกับการโหลดตาราง
        }
    });

    // สมมติใช้ JS หลังแก้ไขเสร็จ
    // const url = new URL(window.location.href);
    // if (!url.searchParams.get('page')) url.searchParams.set('page', '<?php echo $page; ?>');
    // window.location.href = url.toString();

    document.addEventListener('DOMContentLoaded', function() {
        const printSelectedBtn = document.getElementById('print-selected');

        function getSelectedOrdersWithSaleType() {
            const checkboxes = document.querySelectorAll('.order-checkbox:checked');
            return Array.from(checkboxes).map(checkbox => ({
                orderId: checkbox.dataset.orderId,
                saleType: checkbox.dataset.saleType
            }));
        }

        function printSelectedOrders() {
            const selected = getSelectedOrdersWithSaleType();
            const shopOrders = selected.filter(o => o.saleType === 'ຂາຍໜ້າຮ້ານ').map(o => o.orderId);
            const onlineOrders = selected.filter(o => o.saleType === 'ຂາຍອອນລາຍ').map(o => o.orderId);

            if (shopOrders.length > 0) {
                window.open('print_invoice.php?order_ids=' + shopOrders.join(','), '_blank');
            }
            if (onlineOrders.length > 0) {
                window.open('print_multiple_invoices.php?order_ids=' + onlineOrders.join(','), '_blank');
            }
        }

        if (printSelectedBtn) {
            printSelectedBtn.addEventListener('click', function() {
                printSelectedOrders();
            });
        }
    });

    // === Bulk Select Logic ===
    let bulkSelectActive = false; // Track state globally

    function toggleCheckboxVisibility(show) {
        // header
        document.querySelectorAll('.bulk-checkbox-header').forEach(el => {
            el.style.display = show ? 'table-cell' : 'none';
        });
        // cells
        document.querySelectorAll('.bulk-checkbox-cell').forEach(el => {
            el.style.display = show ? 'table-cell' : 'none';
        });
    }

    function resetBulkSelectState() {
        bulkSelectActive = false;
        toggleCheckboxVisibility(false);
        // Uncheck all checkboxes
        document.querySelectorAll('.order-checkbox').forEach(cb => cb.checked = false);
        const selectAll = document.getElementById('select-all');
        if (selectAll) selectAll.checked = false;
        // Hide bulk actions
        const bulkActionsDiv = document.querySelector('.bulk-actions');
        if (bulkActionsDiv) bulkActionsDiv.style.display = 'none';
        // Reset button text
        const toggleBtn = document.getElementById('toggle-bulk-select');
        if (toggleBtn) toggleBtn.textContent = 'ເລືອກລາຍການ Print ໃບບິນ';
        // Disable print button
        const printBtn = document.getElementById('print-selected');
        if (printBtn) printBtn.disabled = true;
    }

    function activateBulkSelect() {
        bulkSelectActive = true;
        toggleCheckboxVisibility(true);
        // Show bulk actions
        const bulkActionsDiv = document.querySelector('.bulk-actions');
        if (bulkActionsDiv) bulkActionsDiv.style.display = 'flex';
        // Change button text
        const toggleBtn = document.getElementById('toggle-bulk-select');
        if (toggleBtn) toggleBtn.textContent = 'ອອກຈາກການ Print ໃບບິນ';
    }

    document.addEventListener('DOMContentLoaded', function() {
        // Initial state: hide checkboxes
        resetBulkSelectState();

        // Toggle bulk select button
        const toggleBtn = document.getElementById('toggle-bulk-select');
        if (toggleBtn) {
            toggleBtn.addEventListener('click', function() {
                if (bulkSelectActive) {
                    resetBulkSelectState();
                } else {
                    activateBulkSelect();
                }
            });
        }

        // Cancel selection button
        const cancelBtn = document.getElementById('cancel-selection');
        if (cancelBtn) {
            cancelBtn.addEventListener('click', function() {
                // Uncheck all checkboxes, but do not hide them
                document.querySelectorAll('.order-checkbox').forEach(cb => cb.checked = false);
                const selectAll = document.getElementById('select-all');
                if (selectAll) selectAll.checked = false;
                updatePrintButtonState();
            });
        }

        // Select all checkbox
        const selectAll = document.getElementById('select-all');
        if (selectAll) {
            selectAll.addEventListener('change', function() {
                document.querySelectorAll('.order-checkbox').forEach(cb => {
                    cb.checked = selectAll.checked;
                });
                updatePrintButtonState();
            });
        }

        // Individual checkbox
        document.addEventListener('change', function(e) {
            if (e.target && e.target.classList.contains('order-checkbox')) {
                updatePrintButtonState();
            }
        });

        // Print selected
        const printBtn = document.getElementById('print-selected');
        if (printBtn) {
            printBtn.addEventListener('click', function() {
                printSelectedOrders();
            });
        }
    });

    // After AJAX reload, re-apply bulk select state and event listeners
    function afterTableReload() {
        if (bulkSelectActive) {
            activateBulkSelect();
        } else {
            resetBulkSelectState();
        }
        // Re-bind select all and print button if needed (in case DOM replaced)
        const selectAll = document.getElementById('select-all');
        if (selectAll) {
            selectAll.addEventListener('change', function() {
                document.querySelectorAll('.order-checkbox').forEach(cb => {
                    cb.checked = selectAll.checked;
                });
                updatePrintButtonState();
            });
        }
        const printBtn = document.getElementById('print-selected');
        if (printBtn) {
            printBtn.addEventListener('click', function() {
                printSelectedOrders();
            });
        }
    }

    // Update print button state
    function updatePrintButtonState() {
        const printBtn = document.getElementById('print-selected');
        if (printBtn) {
            const checked = document.querySelectorAll('.order-checkbox:checked').length;
            printBtn.disabled = checked === 0;
        }
    }

    // Print selected orders (example, adjust as needed)
    function printSelectedOrders() {
        const selected = Array.from(document.querySelectorAll('.order-checkbox:checked')).map(cb => cb.dataset.orderId);
        if (selected.length > 0) {
            window.open('print_invoice.php?order_ids=' + selected.join(','), '_blank');
        }
    }

    // --- AJAX table/pagination reload ---
    function loadTablePage(page) {
        const params = new URLSearchParams(window.location.search);
        params.set('page', page);

        // เพิ่ม customer_id ถ้ามีใน URL
        const customerId = params.get('customer_id');
        if (customerId) {
            params.set('customer_id', customerId);
        }

        // Load table
        fetch('invoice_history_table.php?' + params.toString())
            .then(res => res.text())
            .then(html => {
                document.getElementById('invoice-table-body').innerHTML = html;
                afterTableReload();
            });

        // Load pagination
        fetch('invoice_history_pagination.php?' + params.toString())
            .then(res => res.text())
            .then(html => {
                const paginationDiv = document.getElementById('pagination');
                if (paginationDiv) {
                    paginationDiv.innerHTML = html;
                } else {
                    const table = document.getElementById('invoice-table');
                    if (table) {
                        const newDiv = document.createElement('div');
                        newDiv.className = 'pagination';
                        newDiv.id = 'pagination';
                        newDiv.innerHTML = html;
                        table.parentNode.insertBefore(newDiv, table.nextSibling);
                    }
                }
            });
    }

    document.addEventListener('DOMContentLoaded', function() {
    const urlParams = new URLSearchParams(window.location.search);
    const page = urlParams.get('page') ? parseInt(urlParams.get('page')) : 1;
    loadTablePage(page);
});

    function highlightRowIfNeeded() {
        // อ่านค่าจาก URL
        const urlParams = new URLSearchParams(window.location.search);
        const highlight = urlParams.get('highlight');
        const orderId = urlParams.get('order_id');
        if (highlight === '1' && orderId) {
            // หาแถวที่ตรงกับ order_id
            const row = document.querySelector(`tr[data-order-id="${orderId}"]`);
            if (row) {
                row.classList.remove('tr-green-blink'); // reset ก่อน
                // trigger reflow เพื่อให้ animation เล่นซ้ำได้
                void row.offsetWidth;
                row.classList.add('tr-green-blink');
                // scroll ให้เห็นแถวนี้
                row.scrollIntoView({ behavior: 'smooth', block: 'center' });
            }
        }
    }

    // เรียกใช้หลัง AJAX โหลดตารางเสร็จ
    function reloadInvoiceTableAndPagination() {
        loadTablePage(1);
        highlightRowIfNeeded();
    }