document.addEventListener('DOMContentLoaded', function() {
    const sidebar = document.querySelector('.sidebar');
    const toggleBtn = document.querySelector('.toggle-btn');
    const body = document.body; 

    // ตรวจสอบว่าเป็น mobile หรือไม่
    function isMobile() {
        return window.innerWidth <= 768;
    }

    // อ่านสถานะจาก localStorage เฉพาะ desktop
    if (!isMobile()) {
        if (localStorage.getItem('sidebarCollapsed  ') === 'true') {
            sidebar.classList.add('collapsed');
            body.classList.add('sidebar-collapsed'); 
            sidebar.classList.remove('show-menu-text');
        } else {
            sidebar.classList.remove('collapsed');
            body.classList.remove('sidebar-collapsed');
            sidebar.classList.add('show-menu-text');
        }
    } else {
        // สำหรับ mobile ให้ sidebar ซ่อนเสมอ
        sidebar.classList.add('collapsed');
        body.classList.add('sidebar-collapsed');
        sidebar.classList.remove('show-menu-text');
    }

    toggleBtn.addEventListener('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        sidebar.classList.toggle('collapsed');
        body.classList.toggle('sidebar-collapsed');
        sidebar.classList.toggle('show-menu-text');
        
        // บันทึก state เฉพาะ desktop
        if (!isMobile()) {
            localStorage.setItem('sidebarCollapsed', sidebar.classList.contains('collapsed') ? 'true' : 'false');
        }
    });
    
    // สำหรับ mobile: ปิด sidebar เมื่อคลิกข้างนอก
    document.addEventListener('click', function(e) {
        if (isMobile() && !body.classList.contains('sidebar-collapsed') && 
            !sidebar.contains(e.target) && !toggleBtn.contains(e.target)) {
            sidebar.classList.add('collapsed');
            body.classList.add('sidebar-collapsed'); 
            sidebar.classList.remove('show-menu-text');
        }
        
        // สำหรับ desktop: เปิด sidebar เมื่อ mouse ใกล้ขอบซ้าย
        if (!isMobile() && body.classList.contains('sidebar-collapsed') && 
            e.clientX < 20 && e.clientY > 50) {
            sidebar.classList.remove('collapsed');
            body.classList.remove('sidebar-collapsed'); 
            sidebar.classList.add('show-menu-text');
            localStorage.setItem('sidebarCollapsed', 'false');
        }
    });
    
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape' && (!isMobile() || !body.classList.contains('sidebar-collapsed'))) {
            sidebar.classList.toggle('collapsed');
            body.classList.toggle('sidebar-collapsed');
            sidebar.classList.toggle('show-menu-text');
            
            // บันทึก state เฉพาะ desktop
            if (!isMobile()) {
                localStorage.setItem('sidebarCollapsed', sidebar.classList.contains('collapsed') ? 'true' : 'false');
            }
        }
    });

    // ปรับ behavior เมื่อ resize window
    window.addEventListener('resize', function() {
        if (isMobile()) {
            // เมื่อเปลี่ยนเป็น mobile ให้ซ่อน sidebar
            sidebar.classList.add('collapsed');
            body.classList.add('sidebar-collapsed');
            sidebar.classList.remove('show-menu-text');
        } else {
            // เมื่อเปลี่ยนกลับเป็น desktop ให้อ่าน localStorage
            const isCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
            if (isCollapsed) {
                sidebar.classList.add('collapsed');
                body.classList.add('sidebar-collapsed');
                sidebar.classList.remove('show-menu-text');
            } else {
                sidebar.classList.remove('collapsed');
                body.classList.remove('sidebar-collapsed');
                sidebar.classList.add('show-menu-text');
            }
        }
    });

    // Highlight current page
    const currentPage = window.location.pathname.split('/').pop();
    const menuLinks = document.querySelectorAll('.menu a');
    menuLinks.forEach(link => {
        const linkPage = link.getAttribute('href');
        if (linkPage === currentPage) {
            link.parentElement.classList.add('active');
            // If it's in a submenu, open the parent dropdown
            const parentDropdown = link.closest('.dropdown');
            if (parentDropdown) {
                parentDropdown.classList.add('active');
                const icon = parentDropdown.querySelector('.fa-chevron-down');
                if (icon) {
                    icon.style.transform = 'rotate(180deg)';
                }
            }
        }
    });

    // ===== DROPEND SUBMENU (ออกขวา สำหรับ desktop) =====
    document.querySelectorAll('.menu .dropdown > a').forEach(function(drop){
        drop.addEventListener('click', function(e){
            e.preventDefault();
            const parent = this.parentElement;
            
            // ปิด dropdown อื่น
            document.querySelectorAll('.menu .dropdown').forEach(function(li){
                if(li !== parent) li.classList.remove('open');
            });
            
            // toggle open
            parent.classList.toggle('open');
            
            // สำหรับ mobile: ปิด sidebar หลังเลือกเมนู
            if (isMobile()) {
                setTimeout(() => {
                    sidebar.classList.add('collapsed');
                    body.classList.add('sidebar-collapsed');
                    sidebar.classList.remove('show-menu-text');
                }, 300);
            }
        });
    });

    // ปิด dropdown เมื่อคลิกข้างนอก
    document.addEventListener('click', function(e){
        if(!e.target.closest('.menu .dropdown')) {
            document.querySelectorAll('.menu .dropdown').forEach(function(li){
                li.classList.remove('open');
            });
        }
    });

    // ปรับ behavior สำหรับการคลิกเมนู
    document.querySelectorAll('.sidebar .menu li > a').forEach(link => {
        link.addEventListener('click', function(e) {
            const sidebar = document.querySelector('.sidebar');
            const body = document.body;
            
            // ถ้าเป็น mobile และไม่ใช่ dropdown link
            if (isMobile() && !this.closest('.dropdown')) {
                e.preventDefault();
                // ไปยังหน้าใหม่หลังจากปิด sidebar
                setTimeout(() => {
                    window.location.href = this.getAttribute('href');
                }, 150);
                
                sidebar.classList.add('collapsed');
                body.classList.add('sidebar-collapsed');
                sidebar.classList.remove('show-menu-text');
                return;
            }
            
            // ถ้า sidebar พับอยู่ในมอีขนา desktop
            if (!isMobile() && sidebar.classList.contains('collapsed')) {
                e.preventDefault();
                sidebar.classList.remove('collapsed');
                body.classList.remove('sidebar-collapsed');
                sidebar.classList.add('show-menu-text');
                localStorage.setItem('sidebarCollapsed', 'false');
                // ไปยังลิงก์หลัง sidebar ขยาย (รอ transition)
                setTimeout(() => {
                    window.location.href = this.getAttribute('href');
                }, 350); // ปรับเวลาให้ตรงกับ transition CSS
            }
            // ถ้า sidebar ไม่ได้พับ จะไปตามปกติ
        });
    });

    // ===== SHOW SUBMENU ON HOVER ONLY สำหรับ DESKTOP =====
    if (!isMobile()) {
        document.querySelectorAll('.menu .dropdown').forEach(function(dropdown) {
            dropdown.addEventListener('mouseenter', function() {
                this.classList.add('open');
            });
            dropdown.addEventListener('mouseleave', function() {
                this.classList.remove('open');
            });
        });
    }

    // สำหรับ mobile: ปิด sidebar เมื่อคลิก submenu item
    document.querySelectorAll('.menu .submenu a').forEach(link => {
        link.addEventListener('click', function() {
            if (isMobile()) {
                setTimeout(() => {
                    sidebar.classList.add('collapsed');
                    body.classList.add('sidebar-collapsed');
                    sidebar.classList.remove('show-menu-text');
                }, 100);
            }
        });
    });
});
