document.addEventListener('DOMContentLoaded', function() {
    const container = document.querySelector('.best-selling-container');
    if (container) {
        container.classList.add('animate-container');
        setTimeout(() => {
            container.classList.remove('animate-container');
        }, 500);
    }

    // ใส่ animation ให้ td ตอนแรก
    const tableBody = document.getElementById('best-selling-table-body');
    if (tableBody) {
        const tds = tableBody.querySelectorAll('td');
        tds.forEach(td => td.classList.add('animate-td'));
        setTimeout(() => {
            tds.forEach(td => td.classList.remove('animate-td'));
        }, 700); // ระยะเวลาเดียวกับ fadeSlideIn
    }

    // Load best selling products when page loads
    loadBestSellingProducts();
    
    // Toggle sidebar
    const toggleBtn = document.querySelector('.toggle-btn');
    const sidebar = document.querySelector('.sidebar');
    
    if (toggleBtn && sidebar) {
        toggleBtn.addEventListener('click', function() {
            sidebar.classList.toggle('active');
        });
    } 
});

function loadBestSellingProducts() {
    const dateRange = document.getElementById('date-range').value;
    const tableBody = document.getElementById('best-selling-table-body');
    const tbody = tableBody.parentElement;
    tbody.classList.remove('animate-tbody');
    void tbody.offsetWidth; // รีเซ็ต animation
    tbody.classList.add('animate-tbody');

    // Fade out effect
    tbody.classList.add('fade-out');

    setTimeout(() => {
        // Show loading message
        tableBody.innerHTML = '<tr><td colspan="8" class="loading-message">ກຳລັງໂຫຼດຂໍ້ມູນ...</td></tr>';

        fetch('get_best_selling?days=' + dateRange)
            .then(response => response.json())
            .then(data => {
                if (data.length === 0) {
                    tableBody.innerHTML = '<tr><td colspan="8" class="loading-message">ບໍ່ພົບຂໍ້ມູນການຂາຍ</td></tr>';
                } else {
                    // ถ้ามี row อยู่แล้ว ให้ update เฉพาะ td
                    const existingRows = tableBody.querySelectorAll('tr');
                    data.forEach((product, index) => {
                        let row;
                        if (existingRows[index]) {
                            row = existingRows[index];
                            row.innerHTML = ''; // ลบ td เก่า
                        } else {
                            row = document.createElement('tr');
                            tableBody.appendChild(row);
                        }
                        let rankClass = '';
                        if (index === 0) rankClass = 'rank-1';
                        else if (index === 1) rankClass = 'rank-2';
                        else if (index === 2) rankClass = 'rank-3';
                        const totalSales = parseFloat(product.total_sales) || 0;
                        const formattedTotalSales = totalSales.toLocaleString();
                        row.innerHTML = `
                            <td class="animate-td"><div class="rank-badge ${rankClass}">${index + 1}</div></td>
                            <td class="animate-td"><img src="img/products/${product.product_image}" alt="${product.product_name}" onerror="this.src='img/Logo.png'"></td>
                            <td class="animate-td">${product.pro_id}</td>
                            <td class="animate-td tooltip-custom" title="${product.product_name}">${product.product_name}</td>
                            <td class="animate-td">${product.category_name}</td>
                            <td class="animate-td">${product.quantity_sold}</td>
                            <td class="animate-td">₭${parseFloat(product.selling_price).toLocaleString()}</td>
                            <td class="animate-td">₭${formattedTotalSales}</td>
                        `;
                    });
                    // ลบ row ที่เกินออก
                    for (let i = data.length; i < existingRows.length; i++) {
                        tableBody.removeChild(existingRows[i]);
                    }
                }
                // Fade in effect
                tbody.classList.remove('fade-out');
                tbody.classList.add('fade-in');
                setTimeout(() => {
                    tbody.classList.remove('fade-in');
                }, 300);
            })
            .catch(error => {
                tableBody.innerHTML = '<tr><td colspan="8" class="loading-message">ເກີດຂໍ້ຜິດພາດໃນການໂຫຼດຂໍ້ມູນ</td></tr>';
                tbody.classList.remove('fade-out');
                tbody.classList.add('fade-in');
                setTimeout(() => {
                    tbody.classList.remove('fade-in');
                }, 300);
            });
    }, 200);
}