<div class="invoice">
    <div class="invoice-header">
        <h2>ໃບບິນສິນຄ້າ</h2>
        <div class="invoice-number">ເລກທີໃບບິນ: <?php echo htmlspecialchars($order['order_id']); ?></div>
        <div class="invoice-date">ວັນທີ: <?php echo date('d/m/Y', strtotime($order['order_date'])); ?></div>
    </div>
    
    <div class="customer-info">
        <h3>ຂໍ້ມູນລູກຄ້າ</h3>
        <p><strong>ຊື່:</strong> <?php echo htmlspecialchars($order['customer_name'] ?? 'N/A'); ?></p>
        <p><strong>ເບີໂທ:</strong> <?php echo htmlspecialchars($order['customer_phone'] ?? 'N/A'); ?></p>
        <p><strong>ທີ່ຢູ່:</strong> <?php echo htmlspecialchars($order['shipping_branch'] ?? 'N/A'); ?></p>
    </div>
    
    <div class="store-info">
        <h3>ຂໍ້ມູນຮ້ານຄ້າ</h3>
        <p><strong>ຮ້ານຄ້າ:</strong> <?php echo htmlspecialchars($order['store_name'] ?? 'N/A'); ?></p>
        <p><strong>ບໍລິສັດຂົນສົ່ງ:</strong> <?php echo htmlspecialchars($order['shipping_name'] ?? 'N/A'); ?></p>
    </div>
    
    <div class="items-table">
        <table>
            <thead>
                <tr>
                    <th>ລຳດັບ</th>
                    <th>ລະຫັດສິນຄ້າ</th>
                    <th>ລາຍການ</th>
                    <th>ຈຳນວນ</th>
                    <th>ລາຄາຕໍ່ຫນ່ວຍ</th>
                    <th>ລວມ</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $count = 1;
                foreach ($items as $item): 
                ?>
                <tr>
                    <td><?php echo $count++; ?></td>
                    <td><?php echo htmlspecialchars($item['pro_id'] ?? 'N/A'); ?></td>
                    <td><?php echo htmlspecialchars($item['product_name'] ?? 'N/A'); ?></td>
                    <td><?php echo htmlspecialchars($item['quantity']); ?></td>
                    <td>₭<?php echo number_format($item['price'], 0); ?></td>
                    <td>₭<?php echo number_format($item['quantity'] * $item['price'], 0); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
    <div class="invoice-summary">
        <div class="summary-row">
            <span>ລວມເງິນ:</span>
            <span>₭<?php echo number_format($order['subtotal'] ?? 0, 0); ?></span>
        </div>
        <div class="summary-row">
            <span>ສ່ວນຫຼຸດ:</span>
            <span>₭<?php echo number_format($order['discount'] ?? 0, 0); ?></span>
        </div>
        <div class="summary-row">
            <span>ຈຳນວນເງິນມັດຈຳ:</span>
            <span>₭<?php echo number_format($order['deposit_amount'] ?? 0, 0); ?></span>
        </div>
        <div class="summary-row total">
            <span>ຍອດເງິນທີ່ຕ້ອງຈ່າຍ:</span>
            <span>₭<?php echo number_format(($order['subtotal'] ?? 0) - ($order['discount'] ?? 0) - ($order['deposit_amount'] ?? 0), 0); ?></span>
        </div>
    </div>
    
    <div class="payment-status">
        <p><strong>ສະຖານະການຈ່າຍ:</strong> 
            <span class="status-<?php echo strtolower($order['payment_status'] ?? 'pending'); ?>">
                <?php echo htmlspecialchars($order['payment_status'] ?? 'ຍັງບໍ່ຈ່າຍ'); ?>
            </span>
        </p>
    </div>
</div>


