<?php
require_once("auth.php");
require_once("db_con.php");

// รับค่าจาก GET
$search_query = isset($_GET['search']) ? $_GET['search'] : "";
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : "";
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : "";
$page = (isset($_GET['page']) && is_numeric($_GET['page']) && $_GET['page'] > 0) ? intval($_GET['page']) : 1;
$per_page = 100;

// ตั้งค่าเริ่มต้นวันที่ถ้าไม่ได้รับจาก GET
if(empty($date_from)) { 
    $date_from = date('Y-m-01'); // วันแรกของเดือนนี้
}
if(empty($date_to)) {
    $date_to = date('Y-m-d'); // วันนี้
} 

// --- Query นับจำนวนแถว (ไม่จำเป็นต้องส่งกลับในไฟล์นี้) ---

// --- Query หลัก ---
$offset = ($page - 1) * $per_page;
if ($offset < 0) $offset = 0;

$sql = "SELECT o.*, c.name as customer_name, c.phone as customer_phone, sc.shipping_name, s.store_name 
        FROM orders o
        LEFT JOIN customers c ON o.customer_id = c.customer_id COLLATE utf8mb4_general_ci
        LEFT JOIN shipping_company sc ON o.shipping_company = sc.shipping_id COLLATE utf8mb4_general_ci
        LEFT JOIN stores s ON o.store_id = s.store_id COLLATE utf8mb4_general_ci
        WHERE 1=1";
$params = [];
$types = "";

// กรอง customer_id
if(isset($_GET['customer_id']) && !empty($_GET['customer_id'])) {
    $sql .= " AND o.customer_id = ?";
    $params[] = $_GET['customer_id'];
    $types .= "s";
}

// เงื่อนไขการค้นหาอื่นๆ (search)
if(!empty($search_query)) {
    $sql .= " AND ("
        . "o.order_id LIKE ? OR "
        . "c.name LIKE ? OR "
        . "sc.shipping_name LIKE ? OR "
        . "o.shipping_branch LIKE ? OR "
        . "o.sale_type LIKE ? OR "
        . "o.order_date LIKE ? OR "
        . "c.phone LIKE ? OR "
        . "s.store_name LIKE ? OR "
        . "o.payment_status LIKE ? OR "
        . "o.subtotal LIKE ?"
        . ")";
    $search_param = "%" . $search_query . "%";
    for($i=0;$i<10;$i++) $params[] = $search_param;
    $types .= str_repeat('s', 10);
}

// กรองวันที่
if (!empty($search_query)) {
    // มีการค้นหา: ไม่ต้องกรองวันที่
    $sql .= " AND ("
        . "o.order_id LIKE ? OR "
        . "c.name LIKE ? OR "
        . "sc.shipping_name LIKE ? OR "
        . "o.shipping_branch LIKE ? OR "
        . "o.sale_type LIKE ? OR "
        . "o.order_date LIKE ? OR "
        . "c.phone LIKE ? OR "
        . "s.store_name LIKE ? OR "
        . "o.payment_status LIKE ? OR "
        . "o.subtotal LIKE ?"
        . ")";
    $search_param = "%" . $search_query . "%";
    for($i=0;$i<10;$i++) $params[] = $search_param;
    $types .= str_repeat('s', 10);
} else {
    // ไม่มีการค้นหา: กรองตามวันที่
    if(!empty($date_from)) {
        $sql .= " AND o.order_date >= ?";
        $params[] = $date_from;
        $types .= "s"; 
    }
    if(!empty($date_to)) {
        $sql .= " AND o.order_date <= ?";
        $params[] = $date_to . " 23:59:59";
        $types .= "s";
    }
}

$sql .= " ORDER BY o.created_at ASC";
$sql .= " LIMIT ? OFFSET ?";
$params[] = $per_page;
$params[] = $offset;
$types .= "ii";
 
// เตรียมและประมวลผล query
$stmt = $conn->prepare($sql);
if(!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

// สร้าง <tbody>
echo '<tbody id="invoice-table-body">';
if ($result->num_rows > 0) {
    $count = $offset + 1;
    while($row = $result->fetch_assoc()) {
        echo "<tr data-order-id=\"" . htmlspecialchars($row['order_id']) . "\">";
echo "<td class='bulk-checkbox-cell'><input type='checkbox' class='order-checkbox' data-order-id='" . htmlspecialchars($row['order_id']) . "' data-sale-type='" . htmlspecialchars($row['sale_type'] ?? '-') . "'></td>";
        echo "<td>" . $count . "</td>";
        // ปรับสีตัวอักษรตามประเภทการขาย
        $sale_type = htmlspecialchars($row['sale_type'] ?? '-');
        $sale_type_style = '';
        if (trim($sale_type) === 'ຂາຍອອນລາຍ') {
            $sale_type_style = 'color:#4a90e2;font-weight:bold;';
        } elseif (trim($sale_type) === 'ຂາຍໜ້າຮ້ານ') {
            $sale_type_style = 'color:#ec8b51;font-weight:bold;';
        }
        echo "<td><span style='{$sale_type_style}'>" . $sale_type . "</span></td>";
        echo "<td>" . htmlspecialchars($row['order_id']) . "</td>";
        echo "<td>" . date('d/m/Y H:i', strtotime($row['order_date'])) . "</td>";

        $customer_name = htmlspecialchars($row['customer_name'] ?? '-');
        echo "<td title='$customer_name'>" . (mb_strlen($customer_name) > 18 ? mb_substr($customer_name,0,16).'…' : $customer_name) . "</td>";

        $customer_phone = htmlspecialchars($row['customer_phone'] ?? '-');
        echo "<td title='$customer_phone'>" . (mb_strlen($customer_phone) > 18 ? mb_substr($customer_phone,0,16).'…' : $customer_phone) . "</td>";

        $store_name = htmlspecialchars($row['store_name'] ?? '-');
        echo "<td title='$store_name'>" . (mb_strlen($store_name) > 18 ? mb_substr($store_name,0,16).'…' : $store_name) . "</td>";

        $shipping_name = htmlspecialchars($row['shipping_name'] ?? '-');
        echo "<td title='$shipping_name'>" . (mb_strlen($shipping_name) > 18 ? mb_substr($shipping_name,0,16).'…' : $shipping_name) . "</td>";

        $shipping_branch = htmlspecialchars($row['shipping_branch'] ?? '-');
        echo "<td title='$shipping_branch'>" . (mb_strlen($shipping_branch) > 18 ? mb_substr($shipping_branch,0,16).'…' : $shipping_branch) . "</td>";
        echo "<td>" . htmlspecialchars($row['shipping_code'] ?? '-') . "</td>";

        // สถานะการจ่าย 
        $status_class = '';
        $status_text = $row['payment_status'] ?? 'ບໍ່ມີຂໍ້ມູນ';
        if(strtolower($status_text) == 'paid' || strtolower($status_text) == 'ຈ່າຍແລ້ວ' || strtolower($status_text) == 'ຈ່າຍເເລ້ວ') {
            $status_class = 'status-paid';
        } elseif(strtolower($status_text) == 'pending' || strtolower($status_text) == 'ຍັງບໍ່ຈ່າຍ') {
            $status_class = 'status-pending';
        } elseif(strtolower($status_text) == 'deposit' || strtolower($status_text) == 'ມັດຈຳ') {
            $status_class = 'status-deposit';
        } elseif(strtolower($status_text) == 'cancelled' || strtolower($status_text) == 'ຍົກເລີກ') {
            $status_class = 'status-cancelled';
        }
        echo "<td><span class='status-badge " . $status_class . "'>" . htmlspecialchars($status_text) . "</span></td>";

        echo "<td>₭" . number_format($row['subtotal'] ?? 0, 0) . "</td>";
        echo "<td>";
        if (!empty($row['printed_shop'])) {
            echo "<span style='color:green;'><i class='fas fa-check-circle'></i></span><br>";
        }
        if (!empty($row['printed_online'])) {
            echo "<span style='color:green;'><i class='fas fa-check-circle'></i></span>";
        }
        echo "</td>";
        echo "<td class='action-buttons'>
            <button class='view-btn' onclick='viewInvoice(\"" . $row['order_id'] . "\")'><i class='fas fa-eye'></i></button>
            <button class='edit-btn' onclick='editInvoiceWithParams(\"" . $row['order_id'] . "\", " . $page . ")'><i class='fas fa-edit'></i></button>
            <button class='delete-btn' onclick='confirmDeleteInvoice(\"" . $row['order_id'] . "\")'><i class='fas fa-trash-alt'></i></button>
        </td>";
        echo "</tr>"; 
        $count++;
    }
} else {
    echo "<tr><td colspan='15' class='no-data'>ບໍ່ພົບຂໍ້ມູນໃບບິນ</td></tr>";
}
echo '</tbody>';

$stmt->close();