<?php
// filepath: c:\xampp\htdocs\touk\ep1_touk\invoice_history_pagination.php
require_once("auth.php");
require_once("db_con.php");

// รับค่าจาก GET
$search_query = isset($_GET['search']) ? $_GET['search'] : "";
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : "";
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : "";
$page = (isset($_GET['page']) && is_numeric($_GET['page']) && $_GET['page'] > 0) ? intval($_GET['page']) : 1;
$per_page = 100; 

// --- Query นับจำนวนแถว --- 
$count_sql = "SELECT COUNT(*) as total FROM orders o
    LEFT JOIN customers c ON o.customer_id = c.customer_id COLLATE utf8mb4_general_ci
    LEFT JOIN shipping_company sc ON o.shipping_company = sc.shipping_id COLLATE utf8mb4_general_ci
    LEFT JOIN stores s ON o.store_id = s.store_id COLLATE utf8mb4_general_ci
    WHERE 1=1";
$count_params = [];
$count_types = "";

if(isset($_GET['customer_id']) && !empty($_GET['customer_id'])) {
    $count_sql .= " AND o.customer_id = ?";
    $count_params[] = $_GET['customer_id'];
    $count_types .= "s";
}
if(!empty($search_query)) {
    $count_sql .= " AND ("
        . "o.order_id LIKE ? OR "
        . "c.name LIKE ? OR "
        . "sc.shipping_name LIKE ? OR "
        . "o.shipping_branch LIKE ? OR "
        . "o.sale_type LIKE ? OR "
        . "o.order_date LIKE ? OR "
        . "c.phone LIKE ? OR "
        . "s.store_name LIKE ? OR "
        . "o.payment_status LIKE ? OR "
        . "o.subtotal LIKE ?"
        . ")";
    $search_param = "%" . $search_query . "%";
    for($i=0;$i<10;$i++) $count_params[] = $search_param;
    $count_types .= str_repeat('s', 10);
}
if(!empty($date_from)) {
    $count_sql .= " AND o.order_date >= ?";
    $count_params[] = $date_from;
    $count_types .= "s";
}
if(!empty($date_to)) {
    $count_sql .= " AND o.order_date <= ?";
    $count_params[] = $date_to . " 23:59:59";
    $count_types .= "s";
}
$count_stmt = $conn->prepare($count_sql);
if(!empty($count_params)) {
    $count_stmt->bind_param($count_types, ...$count_params);
}
$count_stmt->execute();
$count_result = $count_stmt->get_result();
$total_rows = $count_result->fetch_assoc()['total'] ?? 0;
$count_stmt->close();

$total_pages = ceil($total_rows / $per_page);
if ($page > $total_pages && $total_pages > 0) $page = $total_pages;

echo '<div class="pagination">';
if($total_pages > 1) {
    if($page > 1) {
        echo '<button class="page-btn prev" onclick="loadTablePage(' . ($page-1) . ')">&laquo; ຫນ້າກ່ອນ</button>';
    }
    $start = max(1, $page-2);
    $end = min($total_pages, $page+2);
    if($start > 1) echo '<span class="page-ellipsis">...</span>';
    for($i=$start;$i<=$end;$i++) {
        $active = ($i==$page) ? ' active' : '';
        echo '<button class="page-btn' . $active . '" onclick="loadTablePage(' . $i . ')">' . $i . '</button>';
    }
    if($end < $total_pages) echo '<span class="page-ellipsis">...</span>';
    if($page < $total_pages) {
        echo '<button class="page-btn next" onclick="loadTablePage(' . ($page+1) . ')">ຫນ້າຖັດໄປ &raquo;</button>';
        echo '<button class="page-btn last" onclick="loadTablePage(' . $total_pages . ')">ໜ້າສຸດທ້າຍ</button>';
    }
}
echo '</div>'; 