<?php 
require_once("auth.php"); 
require_once("db_con.php");

// ตรวจสอบการค้นหา
$search_query = "";
if(isset($_GET['search']) && !empty($_GET['search'])) {
    $search_query = $_GET['search'];
}

// ตรวจสอบการกรองวันที่
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : "";
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : "";

// แปลงรูปแบบวันที่ถ้ามีค่าและเป็น d/m/Y
if (!empty($date_from) && preg_match('/^\d{2}\/\d{2}\/\d{4}$/', $date_from)) {
    $date_from = DateTime::createFromFormat('d/m/Y', $date_from)->format('Y-m-d');
}
if (!empty($date_to) && preg_match('/^\d{2}\/\d{2}\/\d{4}$/', $date_to)) {
    $date_to = DateTime::createFromFormat('d/m/Y', $date_to)->format('Y-m-d');
}

// ถ้าไม่ได้เลือก ให้ default เป็นวันนี้ (เฉพาะตอนเข้าใหม่)
if (empty($date_from) || empty($date_to)) {
    // เฉพาะตอนเข้าใหม่ (ไม่มี page, ไม่มี customer_id, ไม่มี order_id)
    if (count($_GET) === 0 || (!isset($_GET['date_from']) && !isset($_GET['date_to']))) {
        $params = $_GET;
        $params['date_from'] = date('Y-m-d');
        $params['date_to'] = date('Y-m-d');
        $query = http_build_query($params);
        header("Location: invoice_history?$query");
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/invoice_history.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <title>ປະຫວັດໃບບິນສິນຄ້າ - ຮ້ານ Jຕຸກຂາຍເຄື່ອງໃຊ້ໄຟຟ້າ</title>
    <link rel="icon" type="image/png" href="/test01/favicon.png">
</head> 
<style>
    *{
        font-family: 'Noto Sans Lao';
    }
</style>
<body>
    <?php include_once('home.php'); ?>

    <style>
        /* Ensure sidebar appears in front of other elements */
        .sidebar {
            z-index: 1100 !important; /* Higher than other elements */
        }
        
        .toggle-btn {
            z-index: 1101 !important; /* Even higher than sidebar */
        }
        
        /* Adjust content area to accommodate sidebar */
        .content-area {
            animation: fadeIn 0.5s ease;
            z-index: 900; /* Lower than sidebar */
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        /* Sticky header should be below sidebar but above content */
        .sticky-header-wrapper {
            z-index: 950; 
        }

        /* ปุ่มລົບ (Delete Button) */
        .delete-btn {
            background: #ff4d4f;
            color: #fff;
            border: none;
            border-radius: 6px;
            padding: 7px 13px;
            font-size: 1.1em;
            cursor: pointer;
            transition: background 0.2s, box-shadow 0.2s;
            margin: 0 2px;
            box-shadow: 0 2px 8px rgba(255,77,79,0.08);
            display: inline-flex;
            align-items: center;
        }
        .delete-btn i {
            font-size: 1.1em;
        }
        .delete-btn:hover, .delete-btn:focus {
            background: #d9363e;
            color: #fff;
            box-shadow: 0 4px 16px rgba(255,77,79,0.18);
        }

        /* Modal Delete Styling */
        #delete-modal.modal {
            display: none; /* default */
            position: fixed;
            z-index: 2000;
            left: 0;
            top: 0;
            width: 100vw;
            height: 100vh;
            overflow: auto;
            background: rgba(0,0,0,0.25);
            justify-content: center;
            align-items: center;
        }
        #delete-modal .modal-content {
            background: #fff;
            margin: 5% auto;
            border-radius: 12px;
            padding: 32px 28px 24px 28px;
            max-width: 350px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.18);
            position: relative;
            text-align: center;
        }
        #delete-modal h3 {
            color: #ff4d4f;
            margin-bottom: 12px;
            font-size: 1.3em;
        }
        #delete-modal p {
            margin-bottom: 16px;
            color: #333;
        }
        #delete-modal .input-pass {
            width: 80%;
            padding: 8px 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-bottom: 16px;
            font-size: 1em;
        }
        #delete-modal .modal-actions {
            display: flex;
            justify-content: center;
            gap: 12px;
            margin-top: 10px;
        }
        #delete-modal .btn.danger, #confirm-delete-btn {
            background: #ff4d4f;
            color: #fff;
            border: none;
            border-radius: 6px;
            padding: 7px 18px;
            font-size: 1em;
            cursor: pointer;
            transition: background 0.2s, box-shadow 0.2s;
        }
        #delete-modal .btn.danger:hover, #confirm-delete-btn:hover {
            background: #d9363e;
        }
        #delete-modal .btn {
            background: #f0f0f0;
            color: #333;
            border: none;
            border-radius: 6px;
            padding: 7px 18px;
            font-size: 1em;
            cursor: pointer;
            transition: background 0.2s;
        }
        #delete-modal .btn:hover {
            background: #e0e0e0;
        }
        #delete-modal .close-delete {
            position: absolute;
            top: 12px;
            right: 18px;
            font-size: 1.3em;
            color: #888;
            cursor: pointer;
            transition: color 0.2s;
        }
        #delete-modal .close-delete:hover {
            color: #ff4d4f;
        }
        #delete-error-msg {
            color: #ff4d4f;
            font-size: 0.98em;
            margin-top: 10px;
        }

        /* ปุ่มจัดการ (View/Edit/Delete) ขนาดเท่ากัน */
        .action-buttons button.view-btn,
        .action-buttons button.edit-btn,
        .action-buttons button.delete-btn {
            width: 28px;
            height: 28px;
            min-width: 28px;
            min-height: 28px;
            max-width: 28px;
            max-height: 28px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-size: 1.1em;
            padding: 0;
            margin: 0 2px;
        }
        .action-buttons button i {
            font-size: 1.1em;
        }
 @keyframes green-blink {
  0%   { background: #d4edda; }
  50%  { background: #b6f5c2; }
  100% { background: #d4edda; }
}
.tr-green-blink {
  animation: green-blink 0.5s alternate 6;
}



.bulk-checkbox-header,
.bulk-checkbox-cell {
    display: none;
}


.pagination {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 6px;
    margin-top: 20px;
    flex-wrap: wrap;
    font-family: 'Noto Sans Lao', sans-serif;
}

.page-btn {
    display: inline-block;
    padding: 7px 16px;
    margin: 0 2px;
    border: 1px solid #ee4035;
    border-radius: 4px;
    background: #fff;
    color: #ee4035;
    font-size: 15px;
    text-decoration: none;
    transition: background 0.2s, color 0.2s, box-shadow 0.2s;
    cursor: pointer;
    font-family: 'Noto Sans Lao', sans-serif;
}

.page-btn:hover,
.page-btn.active {
    background: #ee4035;
    color: #fff;
    box-shadow: 0 2px 8px rgba(238,64,53,0.08);
    border-color: #ee4035;
}

.page-ellipsis {
    padding: 0 8px;
    color: #888;
    font-size: 18px;
    user-select: none;
    font-family: 'Noto Sans Lao', sans-serif;
}

/* Modern Invoice Table Style */
.invoice-table {
  border-collapse: separate;
  border-spacing: 0;
  width: 100%;
  min-width: 1200px;
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 4px 24px rgba(0,0,0,0.07);
}

  
.invoice-table thead th {
  position: sticky;
  top: 0;
  /* background: linear-gradient(90deg, #e3f0ff 0%, #f7fafc 100%); */
  color: #222;
  font-weight: 700;
  font-size: 1.08em;
  padding: 12px 10px;
  border-bottom: 2px solid #ff4d4f;
  z-index: 2;
  text-align: left;
  white-space: nowrap;
}

.invoice-table tbody tr {
  transition: background 0.18s;
}

.invoice-table tbody tr:nth-child(even) {
  background:rgb(247, 247, 247);
}
.invoice-table tbody tr:nth-child(odd) {
  background: #fff;
}

.invoice-table tbody tr:hover {
  background:rgb(247, 247, 247);
}

.invoice-table th, .invoice-table td {
  padding: 10px 12px;
  border: none;
  text-overflow: ellipsis;
  overflow: hidden;
  white-space: nowrap;
  max-width: 180px;
  vertical-align: middle;
}

.invoice-table td {
  font-size: 1em;
  color: #333;
  border-bottom: 1px solid #e6e6e6;
}

.invoice-table th:first-child, .invoice-table td:first-child {
  border-top-left-radius: 12px;
}
.invoice-table th:last-child, .invoice-table td:last-child {
  border-top-right-radius: 12px;
}

.table-body-container {
  overflow-x: auto;
  max-width: 100vw;
  background: #f5f5f5;
  border-radius: 16px;
  padding: 0.5em 0;
}

/* Tooltip for long text */
.invoice-table td[title] {
  cursor: help;
  position: relative;
}
.invoice-table td[title]:hover::after {
  content: attr(title);
  position: absolute;
  left: 0;
  top: 120%;
  background: #222;
  color: #fff;
  padding: 4px 10px;
  border-radius: 6px;
  font-size: 0.98em;
  white-space: pre;
  z-index: 10;
  box-shadow: 0 2px 8px rgba(0,0,0,0.18);
}

/* Responsive font for small screens */
@media (max-width: 900px) {
  .invoice-table th, .invoice-table td {
    font-size: 0.95em;
    padding: 8px 6px;
    max-width: 100px;
  }
}
    </style>

    <div class="content-area">
        <div class="invoice-history-container">
            <div class="sticky-header-wrapper">
                <div class="table-header">
                    <h1 style="font-size: 2em;"><i class="fas fa-file-invoice" style="font-size: 28px;"></i> ປະຫວັດໃບບິນ</h1>
                    
                    <?php if (isset($_SESSION['alert_message'])): ?>
                        <div class="alert alert-<?php echo $_SESSION['alert_type']; ?> fade-in">
                            <i class="fas fa-<?php echo $_SESSION['alert_type'] == 'success' ? 'check-circle' : 'exclamation-circle'; ?>"></i>
                            <?php echo $_SESSION['alert_message']; ?>
                        </div>
                        <?php 
                        // ລົບข้อความ alert แสดงแล้ว
                        unset($_SESSION['alert_message']);
                        unset($_SESSION['alert_type']);
                        ?>
                    <?php endif; ?>
                    
                    <!-- ส่วนค้นหาและกรอง -->
                    <form method="GET" action="invoice_history" class="search-filter-form">
                        <div class="search-container">
                            <input type="text" name="search" id="invoice-search" placeholder="ຄົ້ນຫາໃບບິນ..." value="<?php echo htmlspecialchars($search_query); ?>">
                            <button type="submit" class="btn search-btn"><i class="fas fa-search"></i> ຄົ້ນຫາ</button>
                        </div>
                        
                        <div class="date-filter">
                            <label for="date-from">ຈາກວັນທີ:</label>
                            <input type="date" id="date-from" name="date_from" value="<?php echo $date_from; ?>">
                            <label for="date-to">ເຖິງວັນທີ:</label>
                            <input type="date" id="date-to" name="date_to" value="<?php echo $date_to; ?>">
                            <button type="submit" class="btn filter-btn"><i class="fas fa-filter"></i> ກັ່ນຕອງ</button>
                            <?php if(!empty($search_query) || !empty($date_from) || !empty($date_to)): ?>
                                <a href="invoice_history" class="btn reset-btn"><i class="fas fa-undo"></i> ລ້າງຕົວກອງ</a>
                            <?php endif; ?>
                        </div>
                    </form>
                </div> <!-- End of table-header -->

                <!-- Add a dedicated row for bulk actions -->
                <div class="bulk-controls-row">
                    <div class="left-side">
                        <h3><i class="fas fa-table"></i> ຕາຕະລາງໃບບິນ</h3>
                    </div>
                    <div class="right-side">
                        <button type="button" id="toggle-bulk-select" class="btn bulk-select-toggle-btn">
                            <i class="fas fa-check-square"></i> ເປີດການເລືອກຫຼາຍລາຍການ Print
                        </button>
                        <div class="bulk-actions" style="display: none;">
                            <button id="print-selected" class="btn action-btn" disabled><i class="fas fa-print"></i> ພິມໃບບິນທີ່ເລືອກ</button>
                            <button id="cancel-selection" class="btn cancel-btn"><i class="fas fa-times"></i> ຍົກເລີກການເລືອກ</button>
                        </div>
                    </div>
                </div>

                <!-- ตารางแสดง lemma></lemma>ใบ lemma></lemma> - ส่วน lemma></lemma>��ົວກອງ -->
                <div class="table-header-row">
                    <table class="invoice-table">
                        <thead> 
                            <tr>
                                 <th class="bulk-checkbox-header"><input type="checkbox" id="select-all"></th>
                                <th>ລຳດັບ</th>
                                <th>ປະເພດການຂາຍ</th> <!-- sale_type column added -->
                                <th>ເລກທີໃບບິນ</th>
                                <th>ວັນທີ</th>
                                <th>ລູກຄ້າ</th> 
                                <th>ເບີຕິດຕໍ່ລູກຄ້າ</th>
                                <th>ຮ້ານຄ້າ</th>
                                <th>ບໍລິສັດຂົນສົ່ງ</th>
                                <th>ສາຂາຂົນສົ່ງ</th>
                                <th>ໄອດີຂົນສົ່ງ</th>
                                <th>ສະຖານະການຈ່າຍ</th>
                                <th>ຍອດເງິນລວມ</th>
                                <th>Print ສຳເລັດ</th> <!-- เพิ่มคอลัมน์นี้ -->
                                <th>ຈັດການ</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
            
            <div class="table-body-container">
                <table class="invoice-table">
                    <thead style="visibility: hidden; position: absolute;">
                        <tr>
                            <th><input type="checkbox"></th>
                            <th>ລຳດັບ</th>
                            <th>ເລກທີໃບບິນ</th>
                            <th>ວັນທີ</th>
                            <th>ລູກຄ້າ</th>
                            <th>ເບີຕິດຕໍ່ລູກຄ້າ</th>
                            <th>ຮ້ານຄ້າ</th>
                            <th>ບໍລິສັດຂົນສົ່ງ</th>
                            <th>ສະຖານະການຈ່າຍ</th>
                            <th>ຍອດເງິນລວມ</th>
                            <th>ຈັດການ</th>
                        </tr>
                    </thead>
                    <tbody id="invoice-table-body">
                        <?php
                        // --- ก่อน query หลัก ---
                        // 1. นับจำนวนแถวทั้งหมด
                        $count_sql = "SELECT COUNT(*) as total FROM orders o
                            LEFT JOIN customers c ON o.customer_id = c.customer_id COLLATE utf8mb4_general_ci
                            LEFT JOIN shipping_company sc ON o.shipping_company = sc.shipping_id COLLATE utf8mb4_general_ci
                            LEFT JOIN stores s ON o.store_id = s.store_id COLLATE utf8mb4_general_ci
                            WHERE 1=1";
                        $count_params = [];
                        $count_types = "";

                        // เพิ่มเงื่อนไขเหมือน query หลัก (copy เงื่อนไข search/filter มาใส่)
                        if(isset($_GET['customer_id']) && !empty($_GET['customer_id'])) {
                            $count_sql .= " AND o.customer_id = ?";
                            $count_params[] = $_GET['customer_id'];
                            $count_types .= "s";
                        }
                        if(!empty($search_query)) {
                            $count_sql .= " AND ("
                                . "o.order_id LIKE ? OR "
                                . "c.name LIKE ? OR "
                                . "sc.shipping_name LIKE ? OR "
                                . "o.shipping_branch LIKE ? OR "
                                . "o.sale_type LIKE ? OR "
                                . "o.order_date LIKE ? OR "
                                . "c.phone LIKE ? OR "
                                . "s.store_name LIKE ? OR "
                                . "o.payment_status LIKE ? OR "
                                . "o.subtotal LIKE ?"
                                . ")";
                            $search_param = "%" . $search_query . "%";
                            for($i=0;$i<10;$i++) $count_params[] = $search_param;
                            $count_types .= str_repeat('s', 10);
                        }
                        if(!empty($date_from)) {
                            $count_sql .= " AND o.order_date >= ?";
                            $count_params[] = $date_from;
                            $count_types .= "s";
                        }
                        if(!empty($date_to)) {
                            $count_sql .= " AND o.order_date <= ?";
                            $count_params[] = $date_to . " 23:59:59";
                            $count_types .= "s";
                        }
                        $count_stmt = $conn->prepare($count_sql);
                        if(!empty($count_params)) {
                            $count_stmt->bind_param($count_types, ...$count_params);
                        }
                        $count_stmt->execute();
                        $count_result = $count_stmt->get_result();
                        $total_rows = $count_result->fetch_assoc()['total'] ?? 0;
                        $count_stmt->close();

                        // 2. คำนวณหน้าปัจจุบันและ offset
                        $per_page = 100;
                        $page = isset($_GET['page']) && is_numeric($_GET['page']) && $_GET['page'] > 0 ? intval($_GET['page']) : 1;
                        $total_pages = ceil($total_rows / $per_page);

                        // ป้องกัน page เกินขอบเขต
                        if ($page > $total_pages && $total_pages > 0) $page = $total_pages;

                        $offset = ($page - 1) * $per_page;
                        if ($offset < 0) $offset = 0; // ป้องกัน offset ติดลบ

                        // สร้าง query ้นฐาน
                        $sql = "SELECT o.*, c.name as customer_name, c.phone as customer_phone, sc.shipping_name, s.store_name 
                                FROM orders o
                                LEFT JOIN customers c ON o.customer_id = c.customer_id COLLATE utf8mb4_general_ci
                                LEFT JOIN shipping_company sc ON o.shipping_company = sc.shipping_id COLLATE utf8mb4_general_ci
                                LEFT JOIN stores s ON o.store_id = s.store_id COLLATE utf8mb4_general_ci
                                WHERE 1=1";
                        $params = []; 
                        $types = "";

                        // เecomeเงื่อนไขกรองตาม customer_id ถ้าส่งค่ามา
                        if(isset($_GET['customer_id']) && !empty($_GET['customer_id'])) {
                            $sql .= " AND o.customer_id = ?";
                            $params[] = $_GET['customer_id'];
                            $types .= "s";
                        }

                        // เsemicolonเงื่อนไขกรองตาม order_id ถ้าส่งค่ามา
                        // if(isset($_GET['order_id']) && !empty($_GET['order_id'])) {
                        //     $sql .= " AND o.order_id = ?";
                        //     $params[] = $_GET['order_id'];
                        //     $types .= "s";
                        // }

                        // เงื่อนไขการค้นหาอื่นๆ (search)
                        if(!empty($search_query)) {
                            $sql .= " AND ("
                                . "o.order_id LIKE ? OR "
                                . "c.name LIKE ? OR "
                                . "sc.shipping_name LIKE ? OR "
                                . "o.shipping_branch LIKE ? OR " // << เพิ่มตรงนี้
                                . "o.sale_type LIKE ? OR "
                                . "o.order_date LIKE ? OR "
                                . "c.phone LIKE ? OR "
                                . "s.store_name LIKE ? OR "
                                . "o.payment_status LIKE ? OR "
                                . "o.subtotal LIKE ?"
                                . ")";
                            $search_param = "%" . $search_query . "%";
                            $params[] = $search_param; // order_id
                            $params[] = $search_param; // customer_name
                            $params[] = $search_param; // shipping_name
                            $params[] = $search_param; // shipping_branch
                            $params[] = $search_param; // sale_type
                            $params[] = $search_param; // order_date
                            $params[] = $search_param; // customer_phone
                            $params[] = $search_param; // store_name
                            $params[] = $search_param; // payment_status
                            $params[] = $search_param; // subtotal
                            $types .= str_repeat('s', 10);
                        }

                        // เีย่่มเงื่อนไขกรองตาม Mayer
                        if(!empty($date_from)) {
                            $sql .= " AND o.order_date >= ?";
                            $params[] = $date_from;
                            $types .= "s";
                        }
                        if(!empty($date_to)) {
                            $sql .= " AND o.order_date <= ?";
                            $params[] = $date_to . " 23:59:59"; // เียมเวลา<|im_start|>ี่้ນ<|im_start|>ี่ของ<|im_start|>ี่
                            $types .= "s";
                        }

                        // เรียงลำ:่ให้รายการล่า:่
                        $sql .= " ORDER BY o.created_at ASC";

                        // เพิ่ม LIMIT และ OFFSET ใน query หลัก
                        $sql .= " LIMIT ? OFFSET ?";
                        $params[] = $per_page;
                        $params[] = $offset;
                        $types .= "ii";

                        // เตรียมและประมวลผล query
                        $stmt = $conn->prepare($sql);
                        if(!empty($params)) {
                            $stmt->bind_param($types, ...$params);
                        }
                        $stmt->execute();
                        $result = $stmt->get_result();
                        
                        if ($result->num_rows > 0) {
                            // ให้ $count เริ่มจากลำดับจริงของแต่ละหน้า
                            $count = $offset + 1;
                            while($row = $result->fetch_assoc()) {
                                echo "<tr data-order-id=\"" . htmlspecialchars($row['order_id']) . "\">";
                                echo "<td><input type='checkbox' class='order-checkbox' data-order-id='" . htmlspecialchars($row['order_id']) . "' data-sale-type='" . htmlspecialchars($row['sale_type'] ?? '-') . "'></td>";
                                echo "<td>" . $count . "</td>";
                                echo "<td>" . htmlspecialchars($row['sale_type'] ?? '-') . "</td>"; // sale_type column
                                echo "<td>" . htmlspecialchars($row['order_id']) . "</td>";
                                echo "<td>" . date('d/m/Y H:i', strtotime($row['order_date'])) . "</td>";

                                $customer_name = htmlspecialchars($row['customer_name'] ?? '-');
                                echo "<td title='$customer_name'>" . (mb_strlen($customer_name) > 18 ? mb_substr($customer_name,0,16).'…' : $customer_name) . "</td>";

                                // เพิ่มเบอร์ติดต่อ
                                $customer_phone = htmlspecialchars($row['customer_phone'] ?? '-');
                                echo "<td title='$customer_phone'>" . (mb_strlen($customer_phone) > 18 ? mb_substr($customer_phone,0,16).'…' : $customer_phone) . "</td>";

                                $store_name = htmlspecialchars($row['store_name'] ?? '-');
                                echo "<td title='$store_name'>" . (mb_strlen($store_name) > 18 ? mb_substr($store_name,0,16).'…' : $store_name) . "</td>";

                                $shipping_name = htmlspecialchars($row['shipping_name'] ?? '-');
                                echo "<td title='$shipping_name'>" . (mb_strlen($shipping_name) > 18 ? mb_substr($shipping_name,0,16).'…' : $shipping_name) . "</td>";

                                // เพิ่มสาขาขนส่ง
                                $shipping_branch = htmlspecialchars($row['shipping_branch'] ?? '-');
                                echo "<td title='$shipping_branch'>" . (mb_strlen($shipping_branch) > 18 ? mb_substr($shipping_branch,0,16).'…' : $shipping_branch) . "</td>";
                                echo "<td>" . htmlspecialchars($row['shipping_code'] ?? '-') . "</td>"; // <--- เพิ่มบรรทัดนี้
                                // สถานะการจ่าย
                                $status_class = '';
                                $status_text = $row['payment_status'] ?? 'ບໍ່ມີຂໍ້ມູນ';
                                if(strtolower($status_text) == 'paid' || strtolower($status_text) == 'ຈ່າຍແລ້ວ' || strtolower($status_text) == 'ຈ່າຍເເລ້ວ') {
                                    $status_class = 'status-paid';
                                } elseif(strtolower($status_text) == 'pending' || strtolower($status_text) == 'ຍັງບໍ່ຈ່າຍ') {
                                    $status_class = 'status-pending';
                                } elseif(strtolower($status_text) == 'deposit' || strtolower($status_text) == 'ມັດຈຳ') {
                                    $status_class = 'status-deposit';
                                } elseif(strtolower($status_text) == 'cancelled' || strtolower($status_text) == 'ຍົກເລີກ') {
                                    $status_class = 'status-cancelled';
                                }
                                echo "<td><span class='status-badge " . $status_class . "'>" . htmlspecialchars($status_text) . "</span></td>";

                                echo "<td>₭" . number_format($row['subtotal'] ?? 0, 0) . "</td>";
                                echo "<td>";
if (!empty($row['printed_shop'])) {
    echo "<span style='color:green;'><i class='fas fa-check-circle'></i></span><br>";
}
if (!empty($row['printed_online'])) {
    echo "<span style='color:green;'><i class='fas fa-check-circle'></i></span>";
}
// ถ้ายังไม่ print เลย จะไม่แสดงอะไร
echo "</td>";
                                echo "<td class='action-buttons'>
    <button class='view-btn' onclick='viewInvoice(\"" . $row['order_id'] . "\")'><i class='fas fa-eye'></i></button>
    <button class='edit-btn' onclick='editInvoiceWithParams(\"" . $row['order_id'] . "\", " . $page . ")'><i class='fas fa-edit'></i></button>
    <button class='delete-btn' onclick='confirmDeleteInvoice(\"" . $row['order_id'] . "\")'><i class='fas fa-trash-alt'></i></button>
</td>";
                                echo "</tr>";
                                $count++;
                            }
                        } else {
                            echo "<tr><td colspan='9' class='no-data'>ບໍ່ພົບຂໍ້ມູນໃບບິນ</td></tr>";
                        } 
                        
                        $stmt->close(); 
                        ?>
                    </tbody>
                </table>

            </div>
            <div class="pagination" id="pagination"></div>
        </div>

    </div>





    <!-- Modal lemma แสดง lemma lemma ล -->
    <div id="invoice-modal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <div id="invoice-details">
                <!-- <lemmaใบ lemma ลจะ lemma lemma มด้วย JavaScript -->
                <div class="loading">
                    <i class="fas fa-spinner fa-spin"></i> ກຳລັງໂຫຼດຂໍ້ມູນ...
                </div>
            </div>
        </div>
    </div>

    <!-- Modal สำหรับยืนยันการລົບ -->
    <div id="delete-modal" class="modal">
        <div class="modal-content">
            <span class="close-delete">&times;</span>
            <h3>ຢືນຢັນການລົບໃບບິນ</h3>
            <p>ກະລຸນາປ້ອນລະຫັດຜ່ານເພື່ອລົບ:</p>
            <input type="password" id="delete-pass" class="input-pass" placeholder="ລະຫັດຜ່ານ">
            <input type="hidden" id="delete-order-id">
            <div class="modal-actions">
                <button id="confirm-delete-btn" class="btn danger">ລົບ</button>
                <button id="cancel-delete-btn" class="btn">ຍົກເລີກ</button>
            </div>
            <div id="delete-error-msg" style="color:red;margin-top:10px;"></div>
        </div>
    </div>
 
    <script src="js/invoice_history.js"></script>
</body>
</html>
