<?php
require_once("auth.php");
require_once("db_con.php");

// Generate new expense ID
function generateExpenseID($conn) {
    $sql = "SELECT MAX(CAST(SUBSTRING(expense_id, 4) AS UNSIGNED)) as max_id FROM expenses WHERE expense_id LIKE 'EXP%'";
    $result = $conn->query($sql);
    $row = $result->fetch_assoc();
    
    $next_id = 1;
    if ($row['max_id']) { 
        $next_id = $row['max_id'] + 1;
    }
    
    return 'EXP' . str_pad($next_id, 4, '0', STR_PAD_LEFT);
}

$new_expense_id = generateExpenseID($conn);
$alert_message = '';
$alert_type = '';

// Handle form submission for adding/updating expense
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $expense_id = $_POST['expense_id'];
    $expense_date = $_POST['expense_date'];
    $details = $_POST['details'];
    $amount = $_POST['amount'];
    
    // Check if expense_id already exists
    $check_sql = "SELECT expense_id FROM expenses WHERE expense_id = ?";
    $check_stmt = $conn->prepare($check_sql);
    $check_stmt->bind_param("s", $expense_id);
    $check_stmt->execute();
    $check_result = $check_stmt->get_result();
    
    if ($check_result->num_rows > 0) {
        // Update existing record
        $sql = "UPDATE expenses SET expense_date = ?, details = ?, amount = ? WHERE expense_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssds", $expense_date, $details, $amount, $expense_id);
        
        if ($stmt->execute()) {
            $alert_message = '<div class="alert alert-success">ອັບເດດຂໍ້ມູນລາຍຈ່າຍສຳເລັດແລ້ວ</div>';
            $alert_type = 'success';
        } else {
            $alert_message = '<div class="alert alert-danger">ເກີດຂໍ້ຜິດພາດ: ' . $stmt->error . '</div>';
            $alert_type = 'danger';
        }
    } else {
        // Insert new record
        $sql = "INSERT INTO expenses (expense_id, expense_date, details, amount) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssd", $expense_id, $expense_date, $details, $amount);
        
        if ($stmt->execute()) {
            $alert_message = '<div class="alert alert-success">ບັນທຶກຂໍ້ມູນລາຍຈ່າຍສຳເລັດແລ້ວ</div>';
            $alert_type = 'success';
            $new_expense_id = generateExpenseID($conn);
        } else {
            $alert_message = '<div class="alert alert-danger">ເກີດຂໍ້ຜິດພາດ: ' . $stmt->error . '</div>';
            $alert_type = 'danger';
        }
    }
}

// Handle delete request
if (isset($_GET['delete']) && !empty($_GET['delete'])) {
    $delete_id = $_GET['delete'];
    
    $sql = "DELETE FROM expenses WHERE expense_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $delete_id);
    
    if ($stmt->execute()) {
        $alert_message = '<div class="alert alert-success">ລົບຂໍ້ມູນລາຍຈ່າຍສຳເລັດແລ້ວ</div>';
        $alert_type = 'success';
    } else {
        $alert_message = '<div class="alert alert-danger">ເກີດຂໍ້ຜິດພາດ: ' . $stmt->error . '</div>';
        $alert_type = 'danger';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/home.css">
 
    <link rel="stylesheet" href="css/input_expense.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <title>ປ້ອນຂໍ້ມູນລາຍຈ່າຍ - ຮ້ານ Jຕຸກຂາຍເຄື່ອງໃຊ້ໄຟຟ້າ</title>
    <link rel="icon" type="image/png" href="/test01/favicon.png">
    <style>
       

    </style>
</head>
<body>
    <?php include_once('home.php'); ?>

    <div class="content-area">
        <div class="expense-table-container">
            <div class="sticky-header-wrapper">
                <div class="table-header">
                    <h1 style="font-size: 2em;"><i class="fas fa-file-invoice" style="font-size: 28px;"></i> ຂໍ້ມູນລາຍຈ່າຍ</h1>
                    <div class="search-container">
                        <input type="text" id="expense-search" placeholder="ຄົ້ນຫາລາຍຈ່າຍ...">
                        <button class="btn primary-btn" id="add-expense-btn"><i class="fas fa-plus"></i> ເພີ່ມລາຍຈ່າຍໃໝ່</button>
                    </div>
                </div>
                
                <?php 
                if (!empty($alert_message)) {
                    echo $alert_message;
                }
                ?>
                
                <div class="table-header-row">
                    <table class="expense-table">
                        <thead>
                            <tr>
                                <th>ລຳດັບ</th>
                                <th>ລະຫັດໄອດີ</th>
                                <th>ວັນທີ</th>
                                <th>ລາຍລະອຽດ</th>
                                <th>ຈຳນວນເງິນ</th>
                                <th>ຈັດການ</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
            
            <div class="table-body-container">
                <table class="expense-table">
                    <thead style="visibility: hidden; position: absolute;">
                        <tr>
                            <th>ລຳດັບ</th>
                            <th>ລະຫັດໄອດີ</th>
                            <th>ວັນທີ</th>
                            <th>ລາຍລະອຽດ</th>
                            <th>ຈຳນວນເງິນ</th>
                            <th>ຈັດການ</th>
                        </tr>
                    </thead>
                    <tbody id="expense-table-body">
                        <?php
                        $sql = "SELECT * FROM expenses ORDER BY expense_id ASC";
                        $result = $conn->query($sql);
                        
                        if ($result->num_rows > 0) {
                            $i = 1;
                            while ($row = $result->fetch_assoc()) {
                                echo "<tr>";
                                echo "<td>" . $i++ . "</td>";
                                echo "<td>" . htmlspecialchars($row['expense_id']) . "</td>";
                                echo "<td>" . htmlspecialchars($row['expense_date']) . "</td>";
                                echo "<td>" . htmlspecialchars($row['details']) . "</td>";
                                echo "<td>" . number_format($row['amount'], 0) . "</td>";
                                echo "<td class='action-buttons'>";
                                echo "<button class='btn edit-btn' data-id='" . $row['expense_id'] . "'><i class='fas fa-edit'></i></button>";
                                echo "<button class='btn delete-btn' data-id='" . $row['expense_id'] . "'><i class='fas fa-trash'></i></button>";
                                echo "</td>";
                                echo "</tr>";
                            }
                        } else {
                            echo "<tr><td colspan='6' style='text-align:center'>ບໍ່ພົບຂໍ້ມູນລາຍຈ່າຍ</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Modal for adding/editing expense -->
    <input type="hidden" id="new_expense_id" value="<?php echo $new_expense_id; ?>">
    
    <div id="expenseModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2 class="modal-title"><i class="fas fa-money-bill-wave"></i> ເພີ່ມຂໍ້ມູນລາຍຈ່າຍ</h2>
            
            <form method="post" action="">
                <div class="form-grid">
                    <div class="form-group">
                        <label for="expense_id">ລະຫັດລາຍຈ່າຍ</label>
                        <input type="text" id="expense_id" name="expense_id" value="<?php echo $new_expense_id; ?>" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label for="expense_date">ວັນທີ</label>
                        <input type="date" id="expense_date" name="expense_date" value="<?php echo date('Y-m-d'); ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="amount">ຈຳນວນເງິນ</label>
                        <input type="number" id="amount" name="amount" step="1" required>
                    </div>
                    
                    <div class="form-group full-width">
                        <label for="details">ລາຍລະອຽດ</label>
                        <textarea id="details" name="details" rows="3" required></textarea>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="reset" class="btn secondary-btn"><i class="fas fa-undo"></i> ລ້າງຂໍ້ມູນ</button>
                    <button type="submit" class="btn primary-btn"><i class="fas fa-save"></i> ບັນທຶກຂໍ້ມູນ</button>
                </div>
            </form>
        </div>
    </div>


 
     <script>
     document.addEventListener('DOMContentLoaded', function() {
        const modal = document.getElementById("expenseModal");
        const addBtn = document.getElementById("add-expense-btn");
        const closeBtn = document.getElementsByClassName("close")[0];
        const newExpenseIdInput = document.getElementById('new_expense_id');
        const expenseIdField = document.getElementById('expense_id');
        const expenseDateField = document.getElementById('expense_date');
        const detailsField = document.getElementById('details');
        const amountField = document.getElementById('amount');
        const modalTitle = document.querySelector('#expenseModal .modal-title');
        const expenseForm = document.querySelector('#expenseModal form');
        
        // Modal show/hide with fade
function showModal() {
    modal.style.display = "block";
    setTimeout(() => {
        modal.classList.add("show");
    }, 10);
}
function hideModal() {
    modal.classList.remove("show");
    setTimeout(() => {
        modal.style.display = "none";
    }, 300);
}

// Open modal when add button is clicked
addBtn.onclick = function() {
    showModal();
    modalTitle.innerHTML = '<i class="fas fa-money-bill-wave"></i> ເພີ່ມຂໍ້ມູນລາຍຈ່າຍ';
    expenseForm.reset();
    expenseDateField.value = new Date().toISOString().split('T')[0];
    expenseIdField.value = newExpenseIdInput.value;
}

// Close modal when X is clicked
if (closeBtn) {
    closeBtn.onclick = function() {
        hideModal();
    }
}

// Close modal when clicking outside
window.onclick = function(event) {
    if (event.target == modal) {
        hideModal();
    }
}
        
        // Edit button functionality
        document.querySelectorAll('.edit-btn').forEach(button => {
            button.addEventListener('click', function() {
                const expenseId = this.getAttribute('data-id');
                
                // Fetch expense data via AJAX
                fetch('get_expense?id=' + expenseId)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('Network response was not ok');
                        }
                        return response.json();
                    })
                    .then(data => {
                        if (data.error) {
                            alert(data.error);
                            return;
                        }
                        expenseIdField.value = data.expense_id;
                        expenseDateField.value = data.expense_date;
                        detailsField.value = data.details;
                        amountField.value = parseFloat(data.amount);

                        modalTitle.innerHTML = '<i class="fas fa-edit"></i> ແກ້ໄຂຂໍ້ມູນລາຍຈ່າຍ';
                        showModal(); // ใช้ฟังก์ชันนี้แทน modal.style.display = "block";
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert('ເກີດຂໍ້ຜິດພາດໃນການດຶງຂໍ້ມູນ');
                    });
            });
        });
        
                        // Delete button functionality
                document.querySelectorAll('.delete-btn').forEach(button => {
                    button.addEventListener('click', function() {
                        const expenseId = this.getAttribute('data-id');
                        Swal.fire({
                            title: 'ຢືນຢັນການລົບຂໍ້ມູນ',
                            text: 'ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລົບຂໍ້ມູນລາຍຈ່າຍນີ້?',
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonText: 'ຕົກລົງ',
                            cancelButtonText: 'ຍົກເລີກ'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.location.href = 'input_expense?delete=' + expenseId;
                            }
                        });
                    });
                });
        
        // Search functionality
document.getElementById('expense-search').addEventListener('keyup', function() {
    const searchValue = this.value.toLowerCase();
    const tableRows = document.querySelectorAll('#expense-table-body tr');
    let anyVisible = false;

    tableRows.forEach(row => {
        let found = false;
        const cells = row.querySelectorAll('td');
        cells.forEach(cell => {
            if (cell.textContent.toLowerCase().includes(searchValue)) {
                found = true;
            }
        });
        row.style.display = found ? '' : 'none';
        if (found) anyVisible = true;
    });

    // ลบแถว "ບໍ່ພົບສິນຄ້າ" เดิมก่อน
    let noDataRow = document.getElementById('no-data-row');
    if (noDataRow) noDataRow.remove();

    // ถ้าไม่พบข้อมูลเลย ให้เพิ่มแถวใหม่
    if (!anyVisible) {
        const tbody = document.getElementById('expense-table-body');
        const tr = document.createElement('tr');
        tr.id = 'no-data-row';
        tr.innerHTML = `<td colspan="6" style="text-align:center;color:#888;">ບໍ່ພົບສິນຄ້າ</td>`;
        tbody.appendChild(tr);
    }
});
     });
     </script>
 </body>
 </html>




