<?php
require_once("auth.php");
require_once("db_con.php"); 
// ดึงชื่อร้านและโลโก้จาก employee (แถวแรก) 
$shop_name = 'EPGROUP';
$shop_logo = 'img/epgroup.png';
$sql = "SELECT em_shopname, em_logo FROM employee LIMIT 1";
$res = mysqli_query($conn, $sql);
if ($row = mysqli_fetch_assoc($res)) { 
    if (!empty($row['em_shopname'])) $shop_name = $row['em_shopname'];
    if (!empty($row['em_logo'])) $shop_logo = $row['em_logo'];
}

// ดึง theme จากฐานข้อมูล employee
$theme = 'default';
if (isset($_SESSION['id_em'])) {
    $sql = "SELECT theme FROM employee WHERE em_id = ? LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $_SESSION['id_em']);
    $stmt->execute();
    $stmt->bind_result($theme_db);
    if ($stmt->fetch()) {
        $theme = $theme_db;
    }
    $stmt->close();
}

// 1. ยอดขายวันนี้ (รวม orders ที่จ่ายแล้ว + other_income + เงินที่ได้รับจากการเปลี่ยนสถานะ)
$today_sales = 0;

// 1.1 รายรับจาก orders ที่สร้างวันนี้และจ่ายแล้ว
$sql = "SELECT SUM(
    CASE 
        WHEN payment_status = 'ຈ່າຍເເລ້ວ' OR payment_status = 'ຈ່າຍແລ້ວ' THEN 
            CASE 


                WHEN created_at = updated_at AND deposit_amount > 0 THEN deposit_amount
                WHEN created_at = updated_at THEN (subtotal - COALESCE(discount, 0))
                ELSE 0
            END
        WHEN payment_status = 'ມັດຈຳ' THEN deposit_amount
        ELSE 0
    END
) as total FROM orders WHERE DATE(order_date) = CURDATE()";
$res = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($res);
$today_sales += $row['total'] ?? 0;

// 1.2 รายรับจาก orders ที่เปลี่ยนสถานะเป็นจ่ายแล้ววันนี้ (เอายอดเต็ม)
$sql = "SELECT SUM(subtotal - COALESCE(discount, 0)) as total FROM orders 
WHERE (payment_status = 'ຈ່າຍເເລ້ວ' OR payment_status = 'ຈ່າຍແລ້ວ') 
AND DATE(updated_at) = CURDATE() 
AND created_at != updated_at";
$res = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($res);
$today_sales += $row['total'] ?? 0;

// 1.3 รายรับจาก other_income วันนี้
$sql = "SELECT SUM(amount) as total FROM other_income WHERE DATE(income_date) = CURDATE()";
$res = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($res);
$today_sales += $row['total'] ?? 0;

// 1.1 จำนวนสินค้าเข้าใหม่วันนี้
$sql = "SELECT COUNT(*) as count FROM products WHERE DATE(created_at) = CURDATE()";
$res = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($res); 
$today_new_products = $row['count'] ?? 0;

// 1.2 จำนวนรายจ่ายวันนี้ (รวม expenses + purchase_orders)
$today_expenses = 0;

// รายจ่ายจาก expenses table
$sql = "SELECT SUM(amount) as total FROM expenses WHERE DATE(expense_date) = CURDATE()";
$res = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($res);
$today_expenses += $row['total'] ?? 0;

// รายจ่ายจาก purchase_orders table  
$sql = "SELECT SUM(total_amount) as total FROM purchase_orders WHERE DATE(order_date) = CURDATE()";
$res = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($res);
$today_expenses += $row['total'] ?? 0;

// 2. คำสั่งซื้อใหม่วันนี้
$sql = "SELECT COUNT(*) as count FROM orders WHERE DATE(order_date) = CURDATE()";
$res = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($res);
$today_orders = $row['count'] ?? 0;

// 3. จำนวนสินค้าใกล้หมด (quantity <= 20)
$sql = "SELECT COUNT(*) as count FROM products WHERE quantity <= 20";
$res = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($res);
$low_stock_count = $row['count'] ?? 0;

// 4. ลูกค้าใหม่วันนี้
$sql = "SELECT COUNT(*) as count FROM customers WHERE DATE(created_at) = CURDATE()";
$res = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($res);
$new_customers_today = $row['count'] ?? 0;

// 5. รายการคำสั่งซื้อล่าสุด
$recent_orders = [];
$sql = "SELECT o.order_id, c.name as customer, o.total_amount, o.payment_status, o.order_date
        FROM orders o
        JOIN customers c ON o.customer_id = c.customer_id
        ORDER BY o.order_date DESC LIMIT 10";
$res = mysqli_query($conn, $sql);
while ($row = mysqli_fetch_assoc($res)) {
    $recent_orders[] = [
        'order_no' => $row['order_id'],
        'customer' => $row['customer'],
        'total' => $row['total_amount'],
        'status' => $row['payment_status'],
        'date' => $row['order_date']
    ];
}

// 6. สินค้าคงเหลือที่ต้องจัดการ
$low_stock_items = [];
$sql = "SELECT product_id, product_name, quantity FROM products WHERE quantity <= 20 ORDER BY quantity ASC LIMIT 10";
$res = mysqli_query($conn, $sql);
while ($row = mysqli_fetch_assoc($res)) {
    $status = 'ໃກ້ຈະໝົດ';
    if ($row['quantity'] <= 0) {
        $status = 'ໝົດ';
    }
    if ($row['quantity'] < 0) {
        $status = 'ຜິດປົກກະຕິ';
    }
    $low_stock_items[] = [
        'id' => $row['product_id'],
        'name' => $row['product_name'],
        'stock' => $row['quantity'],
        'status' => $status
    ];
}

// 7. การแจ้งเตือนล่าสุด (สมมติ)
$notifications = [
    ['message' => 'ລູກຄ້າແຈ້ງໂອນເງິນ', 'link' => '#', 'time' => '5 ນາທີທີ່ແລ້ວ'],
    ['message' => 'ມີອໍເດີ້ໃໝ່', 'link' => '#', 'time' => '10 ນາທີທີ່ແລ້ວ'],
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <title>ຮ້ານ Jຕຸກຂາຍເຄື່ອງໃຊ້ໄຟຟ້າ</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
     <link rel="icon" type="image/png" href="/test01/favicon.png">
    

</head>
<body class="<?php echo htmlspecialchars($theme); ?>-theme">
    <div class="sidebar shadow-lg">
        <div class="logo">
            <img id="sidebar-logo" src="<?php echo htmlspecialchars($shop_logo); ?>" alt="Logo">
            <h3 id="sidebar-shopname"><?php echo htmlspecialchars($shop_name); ?></h3>
        </div>
        <ul class="menu">
<?php 
$position = isset($_SESSION['position']) ? $_SESSION['position'] : '';

// เฉพาะ Boss, Admin, representative
if ($position === 'Boss') { 
?>
    <li>
        <a href="home">
            <i class="fas fa-home"></i>
            <span class="menu-text">ຫນ້າຫລັກ</span>
        </a>
    </li>
    <li class="dropdown dropend"> 
        <a href="#">
            <i class="fas fa-edit"></i>
            <span class="menu-text">ປ້ອນຂໍ້ມູນ</span>
            <i class="fas fa-chevron-right"></i>
        </a>
        <ul class="submenu">
            <li><a href="pos_system">ປ້ອນຂໍ້ມູນໃບບິນສິນຄ້າ</a></li>
            <li<?php echo (basename($_SERVER['PHP_SELF']) == 'invoice_history.php' || basename($_SERVER['PHP_SELF']) == 'edit_invoice.php') ? ' class="active"' : ''; ?>><a href="invoice_history">ປະຫວັດໃບບິນສິນຄ້າ</a></li>
            <li><a href="other_income">ລາຍຮັບອື່ນໆ</a></li>
            <li><a href="input_expense">ປ້ອນຂໍ້ມູນລາຍຈ່າຍ</a></li>
        </ul> 
    </li>
    <li class="dropdown dropend">
        <a href="#">
            <i class="fas fa-plus-circle"></i>
            <span class="menu-text">ເພີ່ມຂໍ້ມູນ</span>
            <i class="fas fa-chevron-right"></i>
        </a>
        <ul class="submenu">
            <li><a href="data_customer">ຂໍ້ມູນລູກຄ້າ</a></li>
            <li><a href="add_product">ຂໍ້ມູນສິນຄໍາ</a></li>
            <li><a href="add_category">ຂໍ້ມູນປະເພດສິນຄໍາ</a></li>
            <li><a href="add_shipping">ຂໍ້ມູນບໍລິສັດຂົນສົ່ງ</a></li>
            <li><a href="add_store">ຂໍ້ມູນຊື່ຮ້ານ</a></li>
        </ul>
    </li>
    <li class="dropdown dropend">
        <a href="#">
            <i class="fas fa-chart-bar"></i>
            <span class="menu-text">ສະຫຼຸບຂໍ້ມູນ</span>
            <i class="fas fa-chevron-right"></i>
        </a>
        <ul class="submenu">
            <li><a href="summary_income">ສະຫຼຸບລາຍຮັບ-ຈ່າຍ</a></li>
            <li><a href="best_selling">ສະຫຼຸບສິນຄ້າໄດ້ຂາຍດີ</a></li>
            <li><a href="reduce_products">ສະຫຼຸບຈຳນວນສິນຄໍາທີ່ຂາຍໄດ້</a></li>
            <li><a href="low_stock">ສະຫຼຸບສິນຄໍາທີ່ໃກ້ຈະຫມົດ</a></li>
            <li><a href="audit_history_clean">ປະຫວັດການປ່ຽນເເປງຂໍ້ມູນ</a></li>

            
            
        </ul>
    </li>
    <li class="dropdown dropend">
        <a href="#">
            <i class="fas fa-file-alt"></i>
            <span class="menu-text">ສ້າງລາຍງານສັ່ງຊື້</span>
            <i class="fas fa-chevron-right"></i>
        </a>
        <ul class="submenu">
            <li><a href="print_order">ພີມລາຍງານໃບສັ່ງຊື້ສິນຄໍາ</a></li>
            <li><a href="show_Ordering_Report">ສະເເດງລາຍງານໃບສັ່ງຊື້ສິນຄໍາ</a></li>
        </ul>
    </li>
    
<?php 
} elseif ($position === 'Admin') { 
?>
    <li>
        <a href="home">
            <i class="fas fa-home"></i>
            <span class="menu-text">ຫນ້າຫລັກ</span>
        </a>
    </li>
    <li class="dropdown dropend">
        <a href="#">
            <i class="fas fa-edit"></i>
            <span class="menu-text">ປ້ອນຂໍ້ມູນ</span>
            <i class="fas fa-chevron-right"></i>
        </a>
        <ul class="submenu">
            <li><a href="pos_system">ປ້ອນຂໍ້ມູນໃບບິນສິນຄ້າ</a></li>
            <li<?php echo (basename($_SERVER['PHP_SELF']) == 'invoice_history.php' || basename($_SERVER['PHP_SELF']) == 'edit_invoice.php') ? ' class="active"' : ''; ?>><a href="invoice_history">ປະຫວັດໃບບິນສິນຄ້າ</a></li>
        </ul>
    </li>
<?php 
} elseif ($position === 'representative') { 
?>
    <li>
        <a href="representative">
            <i class="fas fa-home"></i>
            <span class="menu-text">ຫນ້າຫລັກ</span>
        </a>
    </li>
    
    

    <!-- เมนูอื่นๆสำหรับ representative -->
    <!-- ...existing code... -->
<?php } ?>
<li>
    <!-- ย้าย theme-select และ logout ไปไว้ใน modal -->

    <!-- ปุ่ม Setting ด้านล่างสุดของเมนู -->
    <li class="sidebar-setting-btn">
        <a href="#" id="open-setting-modal" style="display:flex;align-items:center;">
            <i class="fas fa-cog"></i>
            <span class="menu-text">ການຕັ້ງຄ່າ</span>
        </a>
    </li>

</ul>

    </div>

    <div class="toggle-btn">
        <i class="fas fa-bars"></i> 
    </div>

    <?php
    $current_page = basename($_SERVER['PHP_SELF']);
    ?>
    <div class="content-area<?php echo ($current_page == 'home.php') ? ' dashboard' : ''; ?>">
    <?php if ($current_page == 'home.php'): ?>
        <!-- Dashboard ทั้งหมด (สถิติ, กราฟ, ตาราง ฯลฯ) -->
        <!-- 1) Statistics Cards -->
        <div class="stats-cards">
            <div class="card stat-sales">
                <div class="card-icon"><i class="fas fa-shopping-cart"></i></div>
                <div class="card-info">
                    <div class="card-title">ຍອດຂາຍມື້ນີ້</div>
                    <div class="card-value">₭<?php echo number_format($today_sales); ?></div>
                </div>
            </div>
            <div class="card stat-orders">
                <div class="card-icon"><i class="fas fa-box"></i></div>
                <div class="card-info">
                    <div class="card-title">ອໍເດີ້ໃໝ່ມື້ນີ້</div>
                    <div class="card-value"><?php echo $today_orders; ?> ອໍເດີ້</div>
                </div>
            </div>
            <div class="card stat-new-products">
                <div class="card-icon"><i class="fas fa-plus"></i></div>
                <div class="card-info">
                    <div class="card-title">ສິນຄ້າເຂົ້າໃໝ່ມື້ນີ້</div>
                    <div class="card-value"><?php echo $today_new_products; ?> ລາຍການ</div>
                </div>
            </div>
            <div class="card stat-expenses">
                <div class="card-icon"><i class="fas fa-money-bill-wave"></i></div>
                <div class="card-info">
                    <div class="card-title">ລາຍຈ່າຍມື້ນີ້</div>
                    <div class="card-value">₭<?php echo number_format($today_expenses); ?></div>
                </div>
            </div>
            <div class="card stat-lowstock">
                <div class="card-icon"><i class="fas fa-exclamation-triangle"></i></div>
                <div class="card-info">
                    <div class="card-title">ສິນຄໍາໃກ້ຫມົດ</div>
                    <div class="card-value"><?php echo $low_stock_count; ?> ລາຍການ</div>
                </div>
            </div>
            <div class="card stat-customers">
                <div class="card-icon"><i class="fas fa-users"></i></div>
                <div class="card-info">
                    <div class="card-title">ລູກຄ້າໃໝ່ມື້ນີ້</div>
                    <div class="card-value"><?php echo $new_customers_today; ?> ຄົນ</div>
                </div>
            </div>
        </div>

        <!-- 2) Sales Overview Graph -->
        <div class="dashboard-section">
            <div class="section-header">
                <span>ກຣາບຍອດຂາຍ/ລາຍຈ່າຍ</span>
                <div class="datee" >
                <input type="date" id="start-date">
                <input type="date" id="end-date">
                
                <button id="filter-date">ຄົ້ນຫາ</button>
                </div>
            </div>
            <canvas id="salesChart" height="80"></canvas>
        </div>

        <!-- 3) Recent Orders Table -->
        <div class="dashboard-section">
            <div class="section-header">
                <span>ລາຍການຄຳສັ່ງຊື້ລ່າສຸດ</span>
                <a href="invoice_history" class="btn-view-all">ເບິ່ງທັງໝົດ</a>
            </div>
            <table class="recent-orders">
                <thead>
                    <tr>
                        <th>ເລກອໍເດີ້</th>
                        <th>ລູກຄ້າ</th>
                        <th>ຍອດລວມ</th>
                        <th>ສະຖານະ</th>
                        <th>ວັນທີສັ່ງຊື້</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recent_orders as $order): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($order['order_no']); ?></td>
                        <td><?php echo htmlspecialchars($order['customer']); ?></td>
                        <td style="text-align: center;">₭<?php echo number_format($order['total']); ?></td>
                        <td><?php echo htmlspecialchars($order['status']); ?></td>
                        <td><?php echo date('d/m/Y H:i', strtotime($order['date'])); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <!-- 4) Low Stock Items -->
        <div class="dashboard-section">
            <div class="section-header">
                <span>ສິນຄໍາໃກ້ຫມົດ</span>
            </div>
            <table class="low-stock-table">
                <thead>
                    <tr>
                        <th>ຊື່ສິນຄໍາ</th>
                        <th>ຈຳນວນຄົງເຫຼືອ</th>
                        <th>ສະຖານະ</th>
                        <th>ຈັດການ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($low_stock_items as $item): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($item['name']); ?></td>
                        <td style="text-align:center;"><?php echo $item['stock']; ?></td>
                        <td><?php echo $item['status']; ?></td>
                        <td>
                            <a href="add_product?id=<?php echo $item['id']; ?>" class="btn-add-stock">ເພີ່ມສະຕ໋ອກ</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- 5) Notifications -->
         
        <!-- <div class="dashboard-section">
            <div class="section-header">
                <span>ການແຈ້ງເຕືອນລ່າສຸດ</span>
            </div>
            <ul class="notifications-list">
                <?php foreach ($notifications as $note): ?>
                <li style="display:flex;align-items:center;">
                    <a href="<?php echo $note['link']; ?>" style="display:flex;align-items:center;width:100%;">
                        <span class="notif-icon"><i class="fas fa-bell"></i></span>
                        <span class="notif-text"><?php echo htmlspecialchars($note['message']); ?></span>
                        <span class="notif-time" style="margin-left:auto;"><?php echo $note['time']; ?></span>
                    </a>
                </li>
                <?php endforeach; ?>
            </ul>
        </div> -->
    <?php else: ?>
        <!-- เนื้อหาสำหรับหน้าอื่น (ถ้ามี) -->
    <?php endif; ?>
    </div>

    <script src="js/home.js"></script>
    <script src="js/dashboard.js"></script>
        <!-- Modal Setting -->
        <div id="setting-modal" class="modern-modal-overlay">
            <div class="modern-modal-card">
                <button id="close-setting-modal" class="modern-modal-close">&times;</button>
                <h3 class="modern-modal-title"><i class="fas fa-cog"></i> ການຕັ້ງຄ່າ</h3>
                <form id="shop-setting-form" action="update_shop_setting.php" method="post" enctype="multipart/form-data" class="modern-modal-form">
                    <div class="modern-modal-form-group">
                        <label for="shop-logo">ໂລໂກ້ຮ້ານ:</label>
                        <div class="modern-modal-logo-row">
                            <img id="preview-logo" src="<?php echo htmlspecialchars($shop_logo); ?>" alt="Logo" class="modern-modal-logo">
                            <input type="file" id="shop-logo" name="shop_logo" accept="image/*">
                        </div>
                    </div>
                    <div class="modern-modal-form-group">
                        <label for="shop-name">ຊື່ຮ້ານ:</label>
                        <input type="text" id="shop-name" name="shop_name" value="Muan Jai" class="modern-modal-input">
                    </div>
                    <button type="submit"  class="modern-modal-save-btn">ບັນທຶກ</button>
                </form>
                <div class="modern-modal-form-group">
                    <label for="theme-select">ປ່ຽນໂທນສີລະບົບ:</label>
                    <div class="modern-modal-theme-select" id="modal_setting-theme-select">
                        <div class="modern-modal-selected-option" id="modal_setting-selected-theme">
                            <span class="modern-modal-theme-circle" style="background:#d32f2f;"></span> ໂທນເເດງ
                        </div>
                        <div class="modern-modal-theme-options" id="modal_setting-theme-options" style="display:none;">
                            <div class="modern-modal-theme-option" data-value="default">
                                <span class="modern-modal-theme-circle" style="background:#d32f2f;"></span> ໂທນເເດງ
                            </div>
                            <div class="modern-modal-theme-option" data-value="pink">
                                <span class="modern-modal-theme-circle" style="background:#e91e63;"></span> ໂທນບົວ
                            </div>
                            <div class="modern-modal-theme-option" data-value="blue">
                                <span class="modern-modal-theme-circle" style="background:#1976d2;"></span> ໂທນຟ້າ
                            </div>
                            <div class="modern-modal-theme-option" data-value="purple">
                                <span class="modern-modal-theme-circle" style="background:#5E3494;"></span> ໂທນມ້ວງ
                            </div>
                        </div>
                    </div>
                </div>
                <a href="logout" class="modern-modal-logout-btn">
                    <i class="fas fa-sign-out-alt"></i> ອອກຈາກລະບົບ
                </a>
            </div>
        </div>
    <script>
// Preview logo before upload
document.addEventListener('DOMContentLoaded', function() {
    var shopLogoInput = document.getElementById('shop-logo');
    if (shopLogoInput) {
        shopLogoInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(ev) {
                    document.getElementById('preview-logo').src = ev.target.result;
                };
                reader.readAsDataURL(file);
            }
        });
    }
});
document.addEventListener('DOMContentLoaded', function() {
        // Modal logic
        const settingModal = document.getElementById('setting-modal');
        const openSettingBtn = document.getElementById('open-setting-modal');
        const closeSettingBtn = document.getElementById('close-setting-modal');
        openSettingBtn.addEventListener('click', function(e) {
                e.preventDefault();
                settingModal.style.display = 'block';
        });
        closeSettingBtn.addEventListener('click', function() {
                settingModal.style.display = 'none';
        });
        window.addEventListener('click', function(e) {
                if (e.target === settingModal) settingModal.style.display = 'none';
        });

        // Custom theme dropdown logic (modal_setting)
        const customSelect = document.getElementById('modal_setting-theme-select');
        const selected = document.getElementById('modal_setting-selected-theme');
        const options = document.getElementById('modal_setting-theme-options');
        let currentTheme = '<?php echo htmlspecialchars($theme); ?>';
        function setSelected(theme) {
            let text = '';
            let color = '';
            if (theme === 'default') { text = 'ໂທນເເດງ'; color = '#d32f2f'; }
            else if (theme === 'pink') { text = 'ໂທນບົວ'; color = '#e91e63'; }
            else if (theme === 'blue') { text = 'ໂທນຟ້າ'; color = '#1976d2'; }
            else if (theme === 'purple') { text = 'ໂທນມ້ວງ'; color = '#5E3494'; }
            selected.innerHTML = `<span class="modern-modal-theme-circle" style="background:${color}"></span> ${text}`;
        }
        setSelected(currentTheme);
        selected.addEventListener('click', function() {
            options.style.display = options.style.display === 'none' ? 'block' : 'none';
        });
        options.querySelectorAll('.modern-modal-theme-option').forEach(function(opt) {
            opt.addEventListener('click', function() {
                let val = opt.getAttribute('data-value');
                setSelected(val);
                options.style.display = 'none';
                document.body.classList.remove('pink-theme', 'blue-theme', 'default-theme', 'purple-theme');
                document.body.classList.add(val + '-theme');
                // ส่ง AJAX ไปบันทึก theme
                var xhr = new XMLHttpRequest();
                xhr.open('POST', 'update_theme.php', true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function() {
                    if (xhr.readyState === 4) {
                        try {
                            var res = JSON.parse(xhr.responseText);
                            if (!res.success) {
                                alert('Theme save failed: ' + (res.message || 'Unknown error'));
                            }
                        } catch(e) {}
                    }
                };
                xhr.send('theme=' + encodeURIComponent(val));
            });
        });
        document.addEventListener('click', function(e) {
            if (!customSelect.contains(e.target)) options.style.display = 'none';
        });
});
document.addEventListener('DOMContentLoaded', function() {
    var shopForm = document.getElementById('shop-setting-form');
    if (shopForm) {
        shopForm.addEventListener('submit', function(e) {
            e.preventDefault();
            var formData = new FormData(shopForm);
            var xhr = new XMLHttpRequest();
            xhr.open('POST', 'update_shop_setting.php', true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4) {
                    try {
                        var res = JSON.parse(xhr.responseText);
                        if (res.success) {
                            let msg = document.createElement('div');
                            msg.textContent = 'ສຳເລັດການປ່ຽນເເປງ';
                            msg.style = 'color:green;font-weight:500;margin-bottom:10px;text-align:center;';
                            shopForm.parentNode.insertBefore(msg, shopForm);
                            setTimeout(function() { msg.remove(); }, 2000);
                            // อัปเดต sidebar logo และ shop name แบบ realtime
                            if (res.logo) {
                                var sidebarLogo = document.getElementById('sidebar-logo');
                                if (sidebarLogo) sidebarLogo.src = res.logo;
                                var previewLogo = document.getElementById('preview-logo');
                                if (previewLogo) previewLogo.src = res.logo;
                            }
                            if (res.shop_name) {
                                var sidebarName = document.getElementById('sidebar-shopname');
                                if (sidebarName) sidebarName.textContent = res.shop_name;
                                var shopNameInput = document.getElementById('shop-name');
                                if (shopNameInput) shopNameInput.value = res.shop_name;
                            }
                        } else {
                            alert('ເກີດຂໍ້ຜິດພາດ: ' + (res.message || 'ບໍ່ສາມາດບັນທຶກໄດ້'));
                        }
                    } catch(e) {
                        alert('ເກີດຂໍ້ຜິດພາດໃນການເຊື່ອມຕໍ່');
                    }
                }
            };
            xhr.send(formData);
        });
    }
});
</script>

</body>
</html>
