<?php
require_once("auth.php");
require_once("db_con.php");

// Set content type to JSON
header('Content-Type: application/json');

// Error handling function
function returnError($message) {
    echo json_encode(['error' => $message]);
    exit;
}

try {
    // Get parameters from request
    $dateRange = isset($_GET['date_range']) ? $_GET['date_range'] : '7';
    $category = isset($_GET['category']) ? $_GET['category'] : 'all';
    $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
    $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';

    // Prepare date filter
    $dateFilter = "";
    if ($dateRange === 'today') {
        $dateFilter = "AND DATE(o.order_date) = CURDATE()";
    } else if ($dateRange === 'yesterday') {
        $dateFilter = "AND DATE(o.order_date) = DATE_SUB(CURDATE(), INTERVAL 1 DAY)";
    } else if ($dateRange === 'custom' && !empty($startDate) && !empty($endDate)) {
        // Sanitize date inputs
        $startDate = $conn->real_escape_string($startDate);
        $endDate = $conn->real_escape_string($endDate);
        $dateFilter = "AND DATE(o.order_date) BETWEEN '$startDate' AND '$endDate'";
    } else if (is_numeric($dateRange)) {
        $dateFilter = "AND o.order_date >= DATE_SUB(CURDATE(), INTERVAL $dateRange DAY)";
    }

    // Prepare category filter
    $categoryFilter = "";
    if ($category !== 'all') {
        $category = $conn->real_escape_string($category);
        $categoryFilter = "AND p.category_id = '$category'";
    }

    // SQL query to get sold products using orders and order_items tables
    $sql = "SELECT 
                p.product_id as pro_id,
                p.product_name,
                p.product_type,
                p.product_image,
                oi.price as selling_price,
                pc.category_name,
                SUM(oi.quantity) as quantity_sold,
                DATE(o.order_date) as sale_date
            FROM 
                order_items oi
            JOIN 
                orders o ON oi.order_id = o.order_id
            JOIN 
                products p ON oi.product_id = p.product_id
            LEFT JOIN 
                product_category pc ON p.category_id = pc.category_id
            WHERE 
                1=1
                $dateFilter
                $categoryFilter
            GROUP BY 
                p.product_id, DATE(o.order_date)
            ORDER BY 
                sale_date DESC, quantity_sold DESC";

    $result = $conn->query($sql);
    
    if (!$result) {
        returnError("Database query error: " . $conn->error);
    }
    
    $products = [];

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $products[] = $row;
        }
    }

    // Return data as JSON
    echo json_encode($products);

} catch (Exception $e) {
    returnError("Server error: " . $e->getMessage());
}

$conn->close();
?>


