<?php
require_once("db_con.php");

// รับวันที่จาก GET ถ้ามี
$start = isset($_GET['start']) ? $_GET['start'] : null;
$end = isset($_GET['end']) ? $_GET['end'] : null;

if ($start && $end) {
    $startDate = date('Y-m-d', strtotime($start));
    $endDate = date('Y-m-d', strtotime($end)); 
} else {
    // ถ้าไม่ส่งมา ให้ default เป็น 7 วันล่าสุด (เพื่อให้เห็นเทรนด์ชัดเจน)
    $endDate = date('Y-m-d');
    $startDate = date('Y-m-d', strtotime('-6 days'));
}


$labels = [];
$sales = [];
$expenses = [];
$cost_of_sales_arr = [];

// ตรวจสอบว่าเป็นวันเดียวกันหรือไม่
if ($startDate === $endDate) {
    // ถ้าเป็นวันเดียวกัน แสดงข้อมูลตามชั่วโมง (0-23)
    for ($hour = 0; $hour <= 23; $hour++) {
        $labels[] = str_pad($hour, 2, '0', STR_PAD_LEFT) . ':00';
        
        // ยอดขายในชั่วโมงนั้น (ตรงกับ logic ใน home.php)
        // 1. รายรับจาก orders ที่สร้างในชั่วโมงนั้นและจ่ายแล้ว
        $sql = "SELECT SUM(
            CASE 
                WHEN payment_status = 'ຈ່າຍເເລ້ວ' OR payment_status = 'ຈ່າຍແລ້ວ' THEN 
                    CASE 
                        WHEN created_at = updated_at AND deposit_amount > 0 THEN deposit_amount
                        WHEN created_at = updated_at THEN (subtotal - COALESCE(discount, 0))
                        ELSE 0
                    END
                WHEN payment_status = 'ມັດຈຳ' THEN deposit_amount
                ELSE 0
            END
        ) as total FROM orders WHERE DATE(order_date) = '$startDate' AND HOUR(order_date) = $hour";
        $res = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($res);
        $orders_income = floatval($row['total'] ?? 0);
        
        // 2. รายรับจาก orders ที่เปลี่ยนสถานะเป็นจ่ายแล้วในชั่วโมงนั้น (เอายอดเต็ม)
        $sql = "SELECT SUM(subtotal - COALESCE(discount, 0)) as total FROM orders 
                WHERE (payment_status = 'ຈ່າຍເເລ້ວ' OR payment_status = 'ຈ່າຍແລ້ວ') 
                AND DATE(updated_at) = '$startDate' AND HOUR(updated_at) = $hour
                AND created_at != updated_at";
        $res = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($res);
        $remaining_payment = floatval($row['total'] ?? 0);
        
        $sales_only = $orders_income + $remaining_payment;
        
        // รายรับอื่นๆในชั่วโมงนั้น (ใช้เวลาที่สร้าง created_at)
        $sql_income = "SELECT SUM(amount) as total FROM other_income 
                       WHERE DATE(income_date) = '$startDate' 
                       AND HOUR(created_at) = $hour";
        $res_income = mysqli_query($conn, $sql_income);
        $row_income = mysqli_fetch_assoc($res_income);
        $other_income = floatval($row_income['total'] ?? 0);
        
        // รวมรายรับทั้งหมด
        $sales[] = $sales_only + $other_income;

        // รายจ่ายในชั่วโมงนั้น
        $sql_exp = "SELECT SUM(amount) as total FROM expenses 
                    WHERE DATE(expense_date) = '$startDate' 
                    AND HOUR(created_at) = $hour";
        $res_exp = mysqli_query($conn, $sql_exp);
        $row_exp = mysqli_fetch_assoc($res_exp);
        $expenses_only = floatval($row_exp['total'] ?? 0);
        
        // รายจ่ายจากการสั่งซื้อสินค้าในชั่วโมงนั้น
        $sql_purchase = "SELECT SUM(total_amount) as total FROM purchase_orders
                         WHERE DATE(order_date) = '$startDate' 
                         AND HOUR(order_date) = $hour";
        $res_purchase = mysqli_query($conn, $sql_purchase);
        $row_purchase = mysqli_fetch_assoc($res_purchase);
        $purchase_expenses = floatval($row_purchase['total'] ?? 0);
        
        // รวมรายจ่ายทั้งหมด
        $expenses[] = $expenses_only + $purchase_expenses;

        // --- คำนวณต้นทุนขาย (รายชั่วโมง) ---
        $sql_cost = "SELECT SUM(oi.quantity * p.cost_price) as total_cost
            FROM order_items oi
            JOIN products p ON oi.product_id = p.product_id
            JOIN orders o ON oi.order_id = o.order_id
            WHERE DATE(o.order_date) = '$startDate' AND HOUR(o.order_date) = $hour";
        $res_cost = mysqli_query($conn, $sql_cost);
        $row_cost = mysqli_fetch_assoc($res_cost);
        $cost_of_sales = floatval($row_cost['total_cost'] ?? 0);
        $cost_of_sales_arr[] = $cost_of_sales;
    }
} else {
    // ถ้าเป็นหลายวัน แสดงข้อมูลตามวัน
    $period = new DatePeriod(
        new DateTime($startDate),
        new DateInterval('P1D'),
        (new DateTime($endDate))->modify('+1 day')
    );

    foreach ($period as $date) {
        $d = $date->format('Y-m-d');
        // แสดงวันที่ในรูปแบบที่อ่านง่าย (วัน/เดือน)
        $labels[] = $date->format('d/m');

        // ยอดขาย (ตรงกับ logic ใน home.php)
        // 1. รายรับจาก orders ที่สร้างในวันนั้นและจ่ายแล้ว
        $sql = "SELECT SUM(
            CASE 
                WHEN payment_status = 'ຈ່າຍເເລ້ວ' OR payment_status = 'ຈ່າຍແລ້ວ' THEN 
                    CASE 
                        WHEN created_at = updated_at AND deposit_amount > 0 THEN deposit_amount
                        WHEN created_at = updated_at THEN (subtotal - COALESCE(discount, 0))
                        ELSE 0
                    END
                WHEN payment_status = 'ມັດຈຳ' THEN deposit_amount
                ELSE 0
            END
        ) as total FROM orders WHERE DATE(order_date) = '$d'";
        $res = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($res);
        $orders_income = floatval($row['total'] ?? 0);
        
        // 2. รายรับจาก orders ที่เปลี่ยนสถานะเป็นจ่ายแล้วในวันนั้น (เอายอดเต็ม)
        $sql = "SELECT SUM(subtotal - COALESCE(discount, 0)) as total FROM orders 
                WHERE (payment_status = 'ຈ່າຍເເລ້ວ' OR payment_status = 'ຈ່າຍແລ້ວ') 
                AND DATE(updated_at) = '$d'
                AND created_at != updated_at";
        $res = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($res);
        $remaining_payment = floatval($row['total'] ?? 0);
        
        $sales_only = $orders_income + $remaining_payment;
        
        // รายรับอื่นๆ
        $sql_income = "SELECT SUM(amount) as total FROM other_income WHERE DATE(income_date) = '$d'";
        $res_income = mysqli_query($conn, $sql_income);
        $row_income = mysqli_fetch_assoc($res_income);
        $other_income = floatval($row_income['total'] ?? 0);
        
        // รวมรายรับทั้งหมด
        $sales[] = $sales_only + $other_income;

        // รายจ่าย
        $sql2 = "SELECT SUM(amount) as total FROM expenses WHERE DATE(expense_date) = '$d'";
        $res2 = mysqli_query($conn, $sql2);
        $row2 = mysqli_fetch_assoc($res2);
        $expenses_only = floatval($row2['total'] ?? 0);
        
        // รายจ่ายจากการสั่งซื้อสินค้า
        $sql_purchase = "SELECT SUM(total_amount) as total FROM purchase_orders
                         WHERE DATE(order_date) = '$d'";
        $res_purchase = mysqli_query($conn, $sql_purchase);
        $row_purchase = mysqli_fetch_assoc($res_purchase);
        $purchase_expenses = floatval($row_purchase['total'] ?? 0);
        
        // รวมรายจ่ายทั้งหมด
        $expenses[] = $expenses_only + $purchase_expenses;

        // --- คำนวณต้นทุนขาย (รายวัน) ---
        $sql_cost = "SELECT SUM(oi.quantity * p.cost_price) as total_cost
            FROM order_items oi
            JOIN products p ON oi.product_id = p.product_id
            JOIN orders o ON oi.order_id = o.order_id
            WHERE DATE(o.order_date) = '$d'";
        $res_cost = mysqli_query($conn, $sql_cost);
        $row_cost = mysqli_fetch_assoc($res_cost);
        $cost_of_sales = floatval($row_cost['total_cost'] ?? 0);
        $cost_of_sales_arr[] = $cost_of_sales;
    }
}

// คำนวณสถิติรวม
$total_sales = array_sum($sales);
$total_expenses = array_sum($expenses);
$total_cost_of_sales = array_sum($cost_of_sales_arr);
$net_profit = $total_sales - $total_expenses;

// คำนวณเปอร์เซ็นต์
$total_amount = $total_sales + $total_expenses;
$sales_percentage = $total_amount > 0 ? round(($total_sales / $total_amount) * 100, 1) : 0;
$expenses_percentage = $total_amount > 0 ? round(($total_expenses / $total_amount) * 100, 1) : 0;

// จัดรูปแบบตัวเลข
$formatted_sales = number_format($total_sales, 0);
$formatted_expenses = number_format($total_expenses, 0);
$formatted_profit = number_format($net_profit, 0);

echo json_encode([
    'labels' => $labels, 
    'sales' => $sales, 
    'expenses' => $expenses,
    'summary' => [
        'total_sales' => $total_sales,
        'total_expenses' => $total_expenses,
        'net_profit' => $net_profit,
        'sales_percentage' => $sales_percentage,
        'expenses_percentage' => $expenses_percentage,
        'formatted' => [
            'sales' => $formatted_sales,
            'expenses' => $formatted_expenses,
            'profit' => $formatted_profit,
            'cost_of_sales' => number_format($total_cost_of_sales, 0),
        ]
    ]
]);
?>
