<?php
require_once("auth.php");
require_once("db_con.php");

// ดึงข้อมูลสินค้าทั้งหมดจากฐานข้อมูล
$sql = "SELECT p.*, c.category_name 
        FROM products p 
        LEFT JOIN product_category c ON p.category_id = c.category_id 
        ORDER BY p.product_name";

$result = $conn->query($sql);
$products = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $products[] = [
            'product_id' => $row['product_id'],
            'pro_id' => $row['pro_id'],
            'product_type' => $row['product_type'],
            'category_id' => $row['category_id'],
            'category_name' => $row['category_name'],
            'product_name' => $row['product_name'],
            'quantity' => $row['quantity'],
            'cost_price' => $row['cost_price'],
            'selling_price' => $row['selling_price'],
            'product_image' => $row['product_image'],
            'low_stock_status' => $row['low_stock_status'],
            'supplier_phone' => $row['supplier_phone']
        ];
    }
}

// ส่งข้อมูลกลับในรูปแบบ JSON
header('Content-Type: application/json');
echo json_encode($products);

$conn->close();
?>