<?php
require_once("auth.php");
require_once("db_con.php");

// ตรวจสอบว่าส่ง ID มาหรือไม่
if(isset($_GET['id'])) {
    $product_id = $_GET['id'];
    
    // ดึงข้อมูลสินค้าจาก ID พร้อมข้อมูลหมวด
    $sql = "SELECT p.*, pc.category_name 
            FROM products p 
            LEFT JOIN product_category pc ON p.category_id = pc.category_id 
            WHERE p.pro_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows > 0) {
        // ส่งข้อมูลเป็น JSON
        $product = $result->fetch_assoc();
        echo json_encode($product);
    } else {
        // ไม่พบสินค้า
        echo json_encode(["error" => "ບໍ່ພົບຂໍ້ມູນສິນຄ້າ"]);
    }
    
    $stmt->close();
} else {
    // ไม่ส่ง ID มา
    echo json_encode(["error" => "ກະລຸນາລະບຸລະຫັດສິນຄ້າ"]);
}

$conn->close();
?>
