<?php
require_once("auth.php");
require_once("db_con.php");

// Get parameters from request
$category = isset($_GET['category']) ? $_GET['category'] : 'all';
$threshold = isset($_GET['threshold']) ? intval($_GET['threshold']) : 20;

// SQL query to get low stock products
$sql = "SELECT 
            p.product_id,
            p.pro_id,
            p.product_name,
            p.product_image,
            p.quantity,
            p.selling_price,
            pc.category_name,
            pc.category_id
        FROM 
            products p
        LEFT JOIN 
            product_category pc ON p.category_id = pc.category_id
        WHERE 
            p.quantity <= ?";

// Add category filter if not 'all'
if ($category !== 'all') {
    $sql .= " AND p.category_id = ?";
}

// Order by quantity ascending (lowest first)
$sql .= " ORDER BY p.quantity ASC";

$stmt = $conn->prepare($sql);

// Bind parameters
if ($category !== 'all') {
    $stmt->bind_param("is", $threshold, $category);
} else {
    $stmt->bind_param("i", $threshold);
}

$stmt->execute();
$result = $stmt->get_result();

$products = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $products[] = $row;
    }
}

// Return data as JSON
header('Content-Type: application/json');
echo json_encode($products);

$stmt->close();
$conn->close();
?>