<?php
require_once("auth.php");
require_once("db_con.php");

// Query to get all invoices
$sql = "SELECT o.*, c.customer_name 
        FROM orders o
        LEFT JOIN customers c ON o.customer_id = c.customer_id
        ORDER BY o.order_date DESC";

$result = $conn->query($sql);
$invoices = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $invoices[] = [
            'order_id' => $row['order_id'],
            'customer_id' => $row['customer_id'],
            'customer_name' => $row['customer_name'] ?? $row['customer_name_manual'],
            'customer_phone' => $row['customer_phone'],
            'shipping_id' => $row['shipping_id'],
            'shipping_branch' => $row['shipping_branch'],
            'cod_type' => $row['cod_type'],
            'payment_status' => $row['payment_status'],
            'payment_method' => $row['payment_method'],
            'store_id' => $row['store_id'],
            'discount_amount' => $row['discount_amount'],
            'total_amount' => $row['total_amount'],
            'order_date' => $row['order_date'],
            'deposit_amount' => $row['deposit_amount']
        ];
    }
}

// Send data as JSON
header('Content-Type: application/json');
echo json_encode($invoices);

$conn->close();
?>