<?php
require_once("auth.php");
require_once("db_con.php");
header('Content-Type: application/json');

if (!isset($_GET['order_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'ບໍ່ພົບລະຫັດໃບບິນ']);
    exit;
}

$order_id = $_GET['order_id'];

try {
    // ດຶງຂໍ້ມູນໃບບິນ
    $sql = "SELECT o.*, c.name as customer_name, c.phone as customer_phone, sc.shipping_name, s.store_name 
            FROM orders o
            LEFT JOIN customers c ON o.customer_id = c.customer_id COLLATE utf8mb4_general_ci
            LEFT JOIN shipping_company sc ON o.shipping_company = sc.shipping_id COLLATE utf8mb4_general_ci
            LEFT JOIN stores s ON o.store_id = s.store_id COLLATE utf8mb4_general_ci
            WHERE o.order_id = ?";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $order_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        echo json_encode(['status' => 'error', 'message' => 'ບໍ່ພົບຂໍ້ມູນໃບບິນ']);
        exit;
    }
    
    $order = $result->fetch_assoc();
    
    // ດຶງຂໍ້ມູນລາຍການສິນຄ້າໃນໃບບິນ
    $sql = "SELECT oi.*, p.product_name 
            FROM order_items oi 
            LEFT JOIN products p ON oi.product_id = p.product_id 
            WHERE oi.order_id = ?";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $order_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $items = [];
    while ($row = $result->fetch_assoc()) {
        $items[] = $row;
    }
    
    // แปลง
    $order['order_date'] = date('d/m/Y H:i', strtotime($order['order_date']));
    
    echo json_encode([
        'status' => 'success',
        'order' => $order,
        'items' => $items
    ]);
    
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}

$conn->close();
?>
