<?php
require_once("auth.php");
require_once("db_con.php");

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(['error' => 'No ID provided']);
    exit;
}

$income_id = $_GET['id'];

$sql = "SELECT * FROM other_income WHERE income_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $income_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $income = $result->fetch_assoc();
    echo json_encode($income);
} else {
    echo json_encode(['error' => 'Income not found']);
}
